/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input to <a>RestoreDBClusterToPointInTime</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreDbClusterToPointInTimeRequest extends DocDbRequest implements
        ToCopyableBuilder<RestoreDbClusterToPointInTimeRequest.Builder, RestoreDbClusterToPointInTimeRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(RestoreDbClusterToPointInTimeRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> RESTORE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreType").getter(getter(RestoreDbClusterToPointInTimeRequest::restoreType))
            .setter(setter(Builder::restoreType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreType").build()).build();

    private static final SdkField<String> SOURCE_DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDBClusterIdentifier")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::sourceDBClusterIdentifier))
            .setter(setter(Builder::sourceDBClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterIdentifier").build())
            .build();

    private static final SdkField<Instant> RESTORE_TO_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RestoreToTime").getter(getter(RestoreDbClusterToPointInTimeRequest::restoreToTime))
            .setter(setter(Builder::restoreToTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreToTime").build()).build();

    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_TIME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseLatestRestorableTime").getter(getter(RestoreDbClusterToPointInTimeRequest::useLatestRestorableTime))
            .setter(setter(Builder::useLatestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLatestRestorableTime").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(RestoreDbClusterToPointInTimeRequest::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(RestoreDbClusterToPointInTimeRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableCloudwatchLogsExports")
            .getter(getter(RestoreDbClusterToPointInTimeRequest::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(RestoreDbClusterToPointInTimeRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(RestoreDbClusterToPointInTimeRequest::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            RESTORE_TYPE_FIELD, SOURCE_DB_CLUSTER_IDENTIFIER_FIELD, RESTORE_TO_TIME_FIELD, USE_LATEST_RESTORABLE_TIME_FIELD,
            PORT_FIELD, DB_SUBNET_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD,
            ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, DELETION_PROTECTION_FIELD, STORAGE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbClusterIdentifier;

    private final String restoreType;

    private final String sourceDBClusterIdentifier;

    private final Instant restoreToTime;

    private final Boolean useLatestRestorableTime;

    private final Integer port;

    private final String dbSubnetGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final List<Tag> tags;

    private final String kmsKeyId;

    private final List<String> enableCloudwatchLogsExports;

    private final Boolean deletionProtection;

    private final String storageType;

    private RestoreDbClusterToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.restoreType = builder.restoreType;
        this.sourceDBClusterIdentifier = builder.sourceDBClusterIdentifier;
        this.restoreToTime = builder.restoreToTime;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.deletionProtection = builder.deletionProtection;
        this.storageType = builder.storageType;
    }

    /**
     * <p>
     * The name of the new cluster to be created.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the new cluster to be created.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The type of restore to be performed. You can specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is
     * earlier than 1.11.
     * </p>
     * <p>
     * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the
     * source DB cluster.
     * </p>
     * 
     * @return The type of restore to be performed. You can specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster
     *         is earlier than 1.11.
     *         </p>
     *         <p>
     *         If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy
     *         of the source DB cluster.
     */
    public final String restoreType() {
        return restoreType;
    }

    /**
     * <p>
     * The identifier of the source cluster from which to restore.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing <code>DBCluster</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the source cluster from which to restore.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing <code>DBCluster</code>.
     *         </p>
     *         </li>
     */
    public final String sourceDBClusterIdentifier() {
        return sourceDBClusterIdentifier;
    }

    /**
     * <p>
     * The date and time to restore the cluster to.
     * </p>
     * <p>
     * Valid values: A time in Universal Coordinated Time (UTC) format.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be before the latest restorable time for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be specified if the <code>UseLatestRestorableTime</code> parameter is not provided.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot be specified if the <code>UseLatestRestorableTime</code> parameter is <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>2015-03-07T23:45:00Z</code>
     * </p>
     * 
     * @return The date and time to restore the cluster to.</p>
     *         <p>
     *         Valid values: A time in Universal Coordinated Time (UTC) format.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be before the latest restorable time for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be specified if the <code>UseLatestRestorableTime</code> parameter is not provided.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot be specified if the <code>UseLatestRestorableTime</code> parameter is <code>true</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>2015-03-07T23:45:00Z</code>
     */
    public final Instant restoreToTime() {
        return restoreToTime;
    }

    /**
     * <p>
     * A value that is set to <code>true</code> to restore the cluster to the latest restorable backup time, and
     * <code>false</code> otherwise.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * <p>
     * Constraints: Cannot be specified if the <code>RestoreToTime</code> parameter is provided.
     * </p>
     * 
     * @return A value that is set to <code>true</code> to restore the cluster to the latest restorable backup time, and
     *         <code>false</code> otherwise. </p>
     *         <p>
     *         Default: <code>false</code>
     *         </p>
     *         <p>
     *         Constraints: Cannot be specified if the <code>RestoreToTime</code> parameter is provided.
     */
    public final Boolean useLatestRestorableTime() {
        return useLatestRestorableTime;
    }

    /**
     * <p>
     * The port number on which the new cluster accepts connections.
     * </p>
     * <p>
     * Constraints: Must be a value from <code>1150</code> to <code>65535</code>.
     * </p>
     * <p>
     * Default: The default port for the engine.
     * </p>
     * 
     * @return The port number on which the new cluster accepts connections.</p>
     *         <p>
     *         Constraints: Must be a value from <code>1150</code> to <code>65535</code>.
     *         </p>
     *         <p>
     *         Default: The default port for the engine.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The subnet group name to use for the new cluster.
     * </p>
     * <p>
     * Constraints: If provided, must match the name of an existing <code>DBSubnetGroup</code>.
     * </p>
     * <p>
     * Example: <code>mySubnetgroup</code>
     * </p>
     * 
     * @return The subnet group name to use for the new cluster.</p>
     *         <p>
     *         Constraints: If provided, must match the name of an existing <code>DBSubnetGroup</code>.
     *         </p>
     *         <p>
     *         Example: <code>mySubnetgroup</code>
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security groups that the new cluster belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of VPC security groups that the new cluster belongs to.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be assigned to the restored cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be assigned to the restored cluster.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.
     * </p>
     * <p>
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a
     * cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the new
     * cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     * </p>
     * <p>
     * You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key
     * used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the
     * <code>KmsKeyId</code> parameter.
     * </p>
     * <p>
     * If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt
     * the source cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the cluster is not encrypted, then the restored cluster is not encrypted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>DBClusterIdentifier</code> refers to a cluster that is not encrypted, then the restore request is
     * rejected.
     * </p>
     * 
     * @return The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.</p>
     *         <p>
     *         The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring
     *         a cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the
     *         new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     *         </p>
     *         <p>
     *         You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the
     *         KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified
     *         by the <code>KmsKeyId</code> parameter.
     *         </p>
     *         <p>
     *         If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to
     *         encrypt the source cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the cluster is not encrypted, then the restored cluster is not encrypted.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>DBClusterIdentifier</code> refers to a cluster that is not encrypted, then the restore request
     *         is rejected.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableCloudwatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableCloudwatchLogsExports} method.
     * </p>
     * 
     * @return A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
     */
    public final List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * <p>
     * Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot
     * be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
     * protects clusters from being accidentally deleted.
     * </p>
     * 
     * @return Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster
     *         cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
     *         <code>DeletionProtection</code> protects clusters from being accidentally deleted.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The storage type to associate with the DB cluster.
     * </p>
     * <p>
     * For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in the
     * <i>Amazon DocumentDB Developer Guide</i>.
     * </p>
     * <p>
     * Valid values for storage type - <code>standard | iopt1</code>
     * </p>
     * <p>
     * Default value is <code>standard </code>
     * </p>
     * 
     * @return The storage type to associate with the DB cluster.</p>
     *         <p>
     *         For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in
     *         the <i>Amazon DocumentDB Developer Guide</i>.
     *         </p>
     *         <p>
     *         Valid values for storage type - <code>standard | iopt1</code>
     *         </p>
     *         <p>
     *         Default value is <code>standard </code>
     */
    public final String storageType() {
        return storageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(restoreType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(restoreToTime());
        hashCode = 31 * hashCode + Objects.hashCode(useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbClusterToPointInTimeRequest)) {
            return false;
        }
        RestoreDbClusterToPointInTimeRequest other = (RestoreDbClusterToPointInTimeRequest) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(restoreType(), other.restoreType())
                && Objects.equals(sourceDBClusterIdentifier(), other.sourceDBClusterIdentifier())
                && Objects.equals(restoreToTime(), other.restoreToTime())
                && Objects.equals(useLatestRestorableTime(), other.useLatestRestorableTime())
                && Objects.equals(port(), other.port()) && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports()
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(storageType(), other.storageType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreDbClusterToPointInTimeRequest").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("RestoreType", restoreType()).add("SourceDBClusterIdentifier", sourceDBClusterIdentifier())
                .add("RestoreToTime", restoreToTime()).add("UseLatestRestorableTime", useLatestRestorableTime())
                .add("Port", port()).add("DBSubnetGroupName", dbSubnetGroupName())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("Tags", hasTags() ? tags() : null).add("KmsKeyId", kmsKeyId())
                .add("EnableCloudwatchLogsExports", hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null)
                .add("DeletionProtection", deletionProtection()).add("StorageType", storageType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "RestoreType":
            return Optional.ofNullable(clazz.cast(restoreType()));
        case "SourceDBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(sourceDBClusterIdentifier()));
        case "RestoreToTime":
            return Optional.ofNullable(clazz.cast(restoreToTime()));
        case "UseLatestRestorableTime":
            return Optional.ofNullable(clazz.cast(useLatestRestorableTime()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("RestoreType", RESTORE_TYPE_FIELD);
        map.put("SourceDBClusterIdentifier", SOURCE_DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("RestoreToTime", RESTORE_TO_TIME_FIELD);
        map.put("UseLatestRestorableTime", USE_LATEST_RESTORABLE_TIME_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("DBSubnetGroupName", DB_SUBNET_GROUP_NAME_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("EnableCloudwatchLogsExports", ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbClusterToPointInTimeRequest, T> g) {
        return obj -> g.apply((RestoreDbClusterToPointInTimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreDbClusterToPointInTimeRequest> {
        /**
         * <p>
         * The name of the new cluster to be created.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbClusterIdentifier
         *        The name of the new cluster to be created.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The type of restore to be performed. You can specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is
         * earlier than 1.11.
         * </p>
         * <p>
         * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of
         * the source DB cluster.
         * </p>
         * 
         * @param restoreType
         *        The type of restore to be performed. You can specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB
         *        cluster is earlier than 1.11.
         *        </p>
         *        <p>
         *        If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full
         *        copy of the source DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreType(String restoreType);

        /**
         * <p>
         * The identifier of the source cluster from which to restore.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing <code>DBCluster</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceDBClusterIdentifier
         *        The identifier of the source cluster from which to restore.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing <code>DBCluster</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier);

        /**
         * <p>
         * The date and time to restore the cluster to.
         * </p>
         * <p>
         * Valid values: A time in Universal Coordinated Time (UTC) format.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be before the latest restorable time for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be specified if the <code>UseLatestRestorableTime</code> parameter is not provided.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be specified if the <code>UseLatestRestorableTime</code> parameter is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>2015-03-07T23:45:00Z</code>
         * </p>
         * 
         * @param restoreToTime
         *        The date and time to restore the cluster to.</p>
         *        <p>
         *        Valid values: A time in Universal Coordinated Time (UTC) format.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be before the latest restorable time for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be specified if the <code>UseLatestRestorableTime</code> parameter is not provided.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot be specified if the <code>UseLatestRestorableTime</code> parameter is <code>true</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>2015-03-07T23:45:00Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreToTime(Instant restoreToTime);

        /**
         * <p>
         * A value that is set to <code>true</code> to restore the cluster to the latest restorable backup time, and
         * <code>false</code> otherwise.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * <p>
         * Constraints: Cannot be specified if the <code>RestoreToTime</code> parameter is provided.
         * </p>
         * 
         * @param useLatestRestorableTime
         *        A value that is set to <code>true</code> to restore the cluster to the latest restorable backup time,
         *        and <code>false</code> otherwise. </p>
         *        <p>
         *        Default: <code>false</code>
         *        </p>
         *        <p>
         *        Constraints: Cannot be specified if the <code>RestoreToTime</code> parameter is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLatestRestorableTime(Boolean useLatestRestorableTime);

        /**
         * <p>
         * The port number on which the new cluster accepts connections.
         * </p>
         * <p>
         * Constraints: Must be a value from <code>1150</code> to <code>65535</code>.
         * </p>
         * <p>
         * Default: The default port for the engine.
         * </p>
         * 
         * @param port
         *        The port number on which the new cluster accepts connections.</p>
         *        <p>
         *        Constraints: Must be a value from <code>1150</code> to <code>65535</code>.
         *        </p>
         *        <p>
         *        Default: The default port for the engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The subnet group name to use for the new cluster.
         * </p>
         * <p>
         * Constraints: If provided, must match the name of an existing <code>DBSubnetGroup</code>.
         * </p>
         * <p>
         * Example: <code>mySubnetgroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        The subnet group name to use for the new cluster.</p>
         *        <p>
         *        Constraints: If provided, must match the name of an existing <code>DBSubnetGroup</code>.
         *        </p>
         *        <p>
         *        Example: <code>mySubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * A list of VPC security groups that the new cluster belongs to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the new cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of VPC security groups that the new cluster belongs to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of VPC security groups that the new cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The tags to be assigned to the restored cluster.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the restored cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be assigned to the restored cluster.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the restored cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be assigned to the restored cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.docdb.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.docdb.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.docdb.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.docdb.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.
         * </p>
         * <p>
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a
         * cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the new
         * cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         * </p>
         * <p>
         * You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS
         * key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the
         * <code>KmsKeyId</code> parameter.
         * </p>
         * <p>
         * If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to
         * encrypt the source cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the cluster is not encrypted, then the restored cluster is not encrypted.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>DBClusterIdentifier</code> refers to a cluster that is not encrypted, then the restore request is
         * rejected.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.</p>
         *        <p>
         *        The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are
         *        restoring a cluster with the same Amazon Web Services account that owns the KMS encryption key used to
         *        encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption
         *        key.
         *        </p>
         *        <p>
         *        You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from
         *        the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key
         *        identified by the <code>KmsKeyId</code> parameter.
         *        </p>
         *        <p>
         *        If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to
         *        encrypt the source cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the cluster is not encrypted, then the restored cluster is not encrypted.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>DBClusterIdentifier</code> refers to a cluster that is not encrypted, then the restore
         *        request is rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster
         * cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
         * <code>DeletionProtection</code> protects clusters from being accidentally deleted.
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the
         *        cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
         *        <code>DeletionProtection</code> protects clusters from being accidentally deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The storage type to associate with the DB cluster.
         * </p>
         * <p>
         * For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in the
         * <i>Amazon DocumentDB Developer Guide</i>.
         * </p>
         * <p>
         * Valid values for storage type - <code>standard | iopt1</code>
         * </p>
         * <p>
         * Default value is <code>standard </code>
         * </p>
         * 
         * @param storageType
         *        The storage type to associate with the DB cluster.</p>
         *        <p>
         *        For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in
         *        the <i>Amazon DocumentDB Developer Guide</i>.
         *        </p>
         *        <p>
         *        Valid values for storage type - <code>standard | iopt1</code>
         *        </p>
         *        <p>
         *        Default value is <code>standard </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbRequest.BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private String restoreType;

        private String sourceDBClusterIdentifier;

        private Instant restoreToTime;

        private Boolean useLatestRestorableTime;

        private Integer port;

        private String dbSubnetGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private Boolean deletionProtection;

        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbClusterToPointInTimeRequest model) {
            super(model);
            dbClusterIdentifier(model.dbClusterIdentifier);
            restoreType(model.restoreType);
            sourceDBClusterIdentifier(model.sourceDBClusterIdentifier);
            restoreToTime(model.restoreToTime);
            useLatestRestorableTime(model.useLatestRestorableTime);
            port(model.port);
            dbSubnetGroupName(model.dbSubnetGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            deletionProtection(model.deletionProtection);
            storageType(model.storageType);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getRestoreType() {
            return restoreType;
        }

        public final void setRestoreType(String restoreType) {
            this.restoreType = restoreType;
        }

        @Override
        public final Builder restoreType(String restoreType) {
            this.restoreType = restoreType;
            return this;
        }

        public final String getSourceDBClusterIdentifier() {
            return sourceDBClusterIdentifier;
        }

        public final void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        }

        @Override
        public final Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
            return this;
        }

        public final Instant getRestoreToTime() {
            return restoreToTime;
        }

        public final void setRestoreToTime(Instant restoreToTime) {
            this.restoreToTime = restoreToTime;
        }

        @Override
        public final Builder restoreToTime(Instant restoreToTime) {
            this.restoreToTime = restoreToTime;
            return this;
        }

        public final Boolean getUseLatestRestorableTime() {
            return useLatestRestorableTime;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbClusterToPointInTimeRequest build() {
            return new RestoreDbClusterToPointInTimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
