/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of <a>DescribeOrderableDBInstanceOptions</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrderableDbInstanceOptionsResponse extends DocDbResponse implements
        ToCopyableBuilder<DescribeOrderableDbInstanceOptionsResponse.Builder, DescribeOrderableDbInstanceOptionsResponse> {
    private static final SdkField<List<OrderableDBInstanceOption>> ORDERABLE_DB_INSTANCE_OPTIONS_FIELD = SdkField
            .<List<OrderableDBInstanceOption>> builder(MarshallingType.LIST)
            .memberName("OrderableDBInstanceOptions")
            .getter(getter(DescribeOrderableDbInstanceOptionsResponse::orderableDBInstanceOptions))
            .setter(setter(Builder::orderableDBInstanceOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderableDBInstanceOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OrderableDBInstanceOption")
                            .memberFieldInfo(
                                    SdkField.<OrderableDBInstanceOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrderableDBInstanceOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OrderableDBInstanceOption").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeOrderableDbInstanceOptionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORDERABLE_DB_INSTANCE_OPTIONS_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<OrderableDBInstanceOption> orderableDBInstanceOptions;

    private final String marker;

    private DescribeOrderableDbInstanceOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.orderableDBInstanceOptions = builder.orderableDBInstanceOptions;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrderableDBInstanceOptions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrderableDBInstanceOptions() {
        return orderableDBInstanceOptions != null && !(orderableDBInstanceOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The options that are available for a particular orderable instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrderableDBInstanceOptions} method.
     * </p>
     * 
     * @return The options that are available for a particular orderable instance.
     */
    public final List<OrderableDBInstanceOption> orderableDBInstanceOptions() {
        return orderableDBInstanceOptions;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOrderableDBInstanceOptions() ? orderableDBInstanceOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableDbInstanceOptionsResponse)) {
            return false;
        }
        DescribeOrderableDbInstanceOptionsResponse other = (DescribeOrderableDbInstanceOptionsResponse) obj;
        return hasOrderableDBInstanceOptions() == other.hasOrderableDBInstanceOptions()
                && Objects.equals(orderableDBInstanceOptions(), other.orderableDBInstanceOptions())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrderableDbInstanceOptionsResponse")
                .add("OrderableDBInstanceOptions", hasOrderableDBInstanceOptions() ? orderableDBInstanceOptions() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrderableDBInstanceOptions":
            return Optional.ofNullable(clazz.cast(orderableDBInstanceOptions()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrderableDBInstanceOptions", ORDERABLE_DB_INSTANCE_OPTIONS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrderableDbInstanceOptionsResponse, T> g) {
        return obj -> g.apply((DescribeOrderableDbInstanceOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DocDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrderableDbInstanceOptionsResponse> {
        /**
         * <p>
         * The options that are available for a particular orderable instance.
         * </p>
         * 
         * @param orderableDBInstanceOptions
         *        The options that are available for a particular orderable instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderableDBInstanceOptions(Collection<OrderableDBInstanceOption> orderableDBInstanceOptions);

        /**
         * <p>
         * The options that are available for a particular orderable instance.
         * </p>
         * 
         * @param orderableDBInstanceOptions
         *        The options that are available for a particular orderable instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderableDBInstanceOptions(OrderableDBInstanceOption... orderableDBInstanceOptions);

        /**
         * <p>
         * The options that are available for a particular orderable instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption.Builder#build()} is called
         * immediately and its result is passed to {@link #orderableDBInstanceOptions(List<OrderableDBInstanceOption>)}.
         * 
         * @param orderableDBInstanceOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderableDBInstanceOptions(java.util.Collection<OrderableDBInstanceOption>)
         */
        Builder orderableDBInstanceOptions(Consumer<OrderableDBInstanceOption.Builder>... orderableDBInstanceOptions);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends DocDbResponse.BuilderImpl implements Builder {
        private List<OrderableDBInstanceOption> orderableDBInstanceOptions = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableDbInstanceOptionsResponse model) {
            super(model);
            orderableDBInstanceOptions(model.orderableDBInstanceOptions);
            marker(model.marker);
        }

        public final List<OrderableDBInstanceOption.Builder> getOrderableDBInstanceOptions() {
            List<OrderableDBInstanceOption.Builder> result = OrderableDBInstanceOptionsListCopier
                    .copyToBuilder(this.orderableDBInstanceOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderableDBInstanceOptions(
                Collection<OrderableDBInstanceOption.BuilderImpl> orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions = OrderableDBInstanceOptionsListCopier.copyFromBuilder(orderableDBInstanceOptions);
        }

        @Override
        public final Builder orderableDBInstanceOptions(Collection<OrderableDBInstanceOption> orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions = OrderableDBInstanceOptionsListCopier.copy(orderableDBInstanceOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableDBInstanceOptions(OrderableDBInstanceOption... orderableDBInstanceOptions) {
            orderableDBInstanceOptions(Arrays.asList(orderableDBInstanceOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableDBInstanceOptions(Consumer<OrderableDBInstanceOption.Builder>... orderableDBInstanceOptions) {
            orderableDBInstanceOptions(Stream.of(orderableDBInstanceOptions)
                    .map(c -> OrderableDBInstanceOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeOrderableDbInstanceOptionsResponse build() {
            return new DescribeOrderableDbInstanceOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
