/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the state of scheduled or in-process operations on an Amazon DocumentDB global cluster. This data type is
 * empty unless a switchover or failover operation is scheduled or is in progress on the global cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailoverState implements SdkPojo, Serializable, ToCopyableBuilder<FailoverState.Builder, FailoverState> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(FailoverState::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FROM_DB_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromDbClusterArn").getter(getter(FailoverState::fromDbClusterArn))
            .setter(setter(Builder::fromDbClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromDbClusterArn").build()).build();

    private static final SdkField<String> TO_DB_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ToDbClusterArn").getter(getter(FailoverState::toDbClusterArn)).setter(setter(Builder::toDbClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToDbClusterArn").build()).build();

    private static final SdkField<Boolean> IS_DATA_LOSS_ALLOWED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDataLossAllowed").getter(getter(FailoverState::isDataLossAllowed))
            .setter(setter(Builder::isDataLossAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDataLossAllowed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            FROM_DB_CLUSTER_ARN_FIELD, TO_DB_CLUSTER_ARN_FIELD, IS_DATA_LOSS_ALLOWED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String fromDbClusterArn;

    private final String toDbClusterArn;

    private final Boolean isDataLossAllowed;

    private FailoverState(BuilderImpl builder) {
        this.status = builder.status;
        this.fromDbClusterArn = builder.fromDbClusterArn;
        this.toDbClusterArn = builder.toDbClusterArn;
        this.isDataLossAllowed = builder.isDataLossAllowed;
    }

    /**
     * <p>
     * The current status of the global cluster. Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>pending</b> – The service received a request to switch over or fail over the global cluster. The global
     * cluster's primary cluster and the specified secondary cluster are being verified before the operation starts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>failing-over</b> – The chosen secondary cluster is being promoted to become the new primary cluster to fail
     * over the global cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>cancelling</b> – The request to switch over or fail over the global cluster was cancelled and the primary
     * cluster and the selected secondary cluster are returning to their previous states.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FailoverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the global cluster. Possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>pending</b> – The service received a request to switch over or fail over the global cluster. The
     *         global cluster's primary cluster and the specified secondary cluster are being verified before the
     *         operation starts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>failing-over</b> – The chosen secondary cluster is being promoted to become the new primary cluster to
     *         fail over the global cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>cancelling</b> – The request to switch over or fail over the global cluster was cancelled and the
     *         primary cluster and the selected secondary cluster are returning to their previous states.
     *         </p>
     *         </li>
     * @see FailoverStatus
     */
    public final FailoverStatus status() {
        return FailoverStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the global cluster. Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>pending</b> – The service received a request to switch over or fail over the global cluster. The global
     * cluster's primary cluster and the specified secondary cluster are being verified before the operation starts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>failing-over</b> – The chosen secondary cluster is being promoted to become the new primary cluster to fail
     * over the global cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>cancelling</b> – The request to switch over or fail over the global cluster was cancelled and the primary
     * cluster and the selected secondary cluster are returning to their previous states.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FailoverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the global cluster. Possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>pending</b> – The service received a request to switch over or fail over the global cluster. The
     *         global cluster's primary cluster and the specified secondary cluster are being verified before the
     *         operation starts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>failing-over</b> – The chosen secondary cluster is being promoted to become the new primary cluster to
     *         fail over the global cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>cancelling</b> – The request to switch over or fail over the global cluster was cancelled and the
     *         primary cluster and the selected secondary cluster are returning to their previous states.
     *         </p>
     *         </li>
     * @see FailoverStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon DocumentDB cluster that is currently being demoted, and which is
     * associated with this state.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon DocumentDB cluster that is currently being demoted, and
     *         which is associated with this state.
     */
    public final String fromDbClusterArn() {
        return fromDbClusterArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon DocumentDB cluster that is currently being promoted, and which is
     * associated with this state.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon DocumentDB cluster that is currently being promoted, and
     *         which is associated with this state.
     */
    public final String toDbClusterArn() {
        return toDbClusterArn;
    }

    /**
     * <p>
     * Indicates whether the operation is a global switchover or a global failover. If data loss is allowed, then the
     * operation is a global failover. Otherwise, it's a switchover.
     * </p>
     * 
     * @return Indicates whether the operation is a global switchover or a global failover. If data loss is allowed,
     *         then the operation is a global failover. Otherwise, it's a switchover.
     */
    public final Boolean isDataLossAllowed() {
        return isDataLossAllowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fromDbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(toDbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(isDataLossAllowed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverState)) {
            return false;
        }
        FailoverState other = (FailoverState) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(fromDbClusterArn(), other.fromDbClusterArn())
                && Objects.equals(toDbClusterArn(), other.toDbClusterArn())
                && Objects.equals(isDataLossAllowed(), other.isDataLossAllowed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailoverState").add("Status", statusAsString()).add("FromDbClusterArn", fromDbClusterArn())
                .add("ToDbClusterArn", toDbClusterArn()).add("IsDataLossAllowed", isDataLossAllowed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FromDbClusterArn":
            return Optional.ofNullable(clazz.cast(fromDbClusterArn()));
        case "ToDbClusterArn":
            return Optional.ofNullable(clazz.cast(toDbClusterArn()));
        case "IsDataLossAllowed":
            return Optional.ofNullable(clazz.cast(isDataLossAllowed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("FromDbClusterArn", FROM_DB_CLUSTER_ARN_FIELD);
        map.put("ToDbClusterArn", TO_DB_CLUSTER_ARN_FIELD);
        map.put("IsDataLossAllowed", IS_DATA_LOSS_ALLOWED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailoverState, T> g) {
        return obj -> g.apply((FailoverState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailoverState> {
        /**
         * <p>
         * The current status of the global cluster. Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>pending</b> – The service received a request to switch over or fail over the global cluster. The global
         * cluster's primary cluster and the specified secondary cluster are being verified before the operation starts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>failing-over</b> – The chosen secondary cluster is being promoted to become the new primary cluster to
         * fail over the global cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>cancelling</b> – The request to switch over or fail over the global cluster was cancelled and the primary
         * cluster and the selected secondary cluster are returning to their previous states.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the global cluster. Possible values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>pending</b> – The service received a request to switch over or fail over the global cluster. The
         *        global cluster's primary cluster and the specified secondary cluster are being verified before the
         *        operation starts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>failing-over</b> – The chosen secondary cluster is being promoted to become the new primary cluster
         *        to fail over the global cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>cancelling</b> – The request to switch over or fail over the global cluster was cancelled and the
         *        primary cluster and the selected secondary cluster are returning to their previous states.
         *        </p>
         *        </li>
         * @see FailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the global cluster. Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>pending</b> – The service received a request to switch over or fail over the global cluster. The global
         * cluster's primary cluster and the specified secondary cluster are being verified before the operation starts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>failing-over</b> – The chosen secondary cluster is being promoted to become the new primary cluster to
         * fail over the global cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>cancelling</b> – The request to switch over or fail over the global cluster was cancelled and the primary
         * cluster and the selected secondary cluster are returning to their previous states.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the global cluster. Possible values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>pending</b> – The service received a request to switch over or fail over the global cluster. The
         *        global cluster's primary cluster and the specified secondary cluster are being verified before the
         *        operation starts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>failing-over</b> – The chosen secondary cluster is being promoted to become the new primary cluster
         *        to fail over the global cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>cancelling</b> – The request to switch over or fail over the global cluster was cancelled and the
         *        primary cluster and the selected secondary cluster are returning to their previous states.
         *        </p>
         *        </li>
         * @see FailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverStatus
         */
        Builder status(FailoverStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon DocumentDB cluster that is currently being demoted, and which is
         * associated with this state.
         * </p>
         * 
         * @param fromDbClusterArn
         *        The Amazon Resource Name (ARN) of the Amazon DocumentDB cluster that is currently being demoted, and
         *        which is associated with this state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDbClusterArn(String fromDbClusterArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon DocumentDB cluster that is currently being promoted, and which
         * is associated with this state.
         * </p>
         * 
         * @param toDbClusterArn
         *        The Amazon Resource Name (ARN) of the Amazon DocumentDB cluster that is currently being promoted, and
         *        which is associated with this state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toDbClusterArn(String toDbClusterArn);

        /**
         * <p>
         * Indicates whether the operation is a global switchover or a global failover. If data loss is allowed, then
         * the operation is a global failover. Otherwise, it's a switchover.
         * </p>
         * 
         * @param isDataLossAllowed
         *        Indicates whether the operation is a global switchover or a global failover. If data loss is allowed,
         *        then the operation is a global failover. Otherwise, it's a switchover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDataLossAllowed(Boolean isDataLossAllowed);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String fromDbClusterArn;

        private String toDbClusterArn;

        private Boolean isDataLossAllowed;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverState model) {
            status(model.status);
            fromDbClusterArn(model.fromDbClusterArn);
            toDbClusterArn(model.toDbClusterArn);
            isDataLossAllowed(model.isDataLossAllowed);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FailoverStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFromDbClusterArn() {
            return fromDbClusterArn;
        }

        public final void setFromDbClusterArn(String fromDbClusterArn) {
            this.fromDbClusterArn = fromDbClusterArn;
        }

        @Override
        public final Builder fromDbClusterArn(String fromDbClusterArn) {
            this.fromDbClusterArn = fromDbClusterArn;
            return this;
        }

        public final String getToDbClusterArn() {
            return toDbClusterArn;
        }

        public final void setToDbClusterArn(String toDbClusterArn) {
            this.toDbClusterArn = toDbClusterArn;
        }

        @Override
        public final Builder toDbClusterArn(String toDbClusterArn) {
            this.toDbClusterArn = toDbClusterArn;
            return this;
        }

        public final Boolean getIsDataLossAllowed() {
            return isDataLossAllowed;
        }

        public final void setIsDataLossAllowed(Boolean isDataLossAllowed) {
            this.isDataLossAllowed = isDataLossAllowed;
        }

        @Override
        public final Builder isDataLossAllowed(Boolean isDataLossAllowed) {
            this.isDataLossAllowed = isDataLossAllowed;
            return this;
        }

        @Override
        public FailoverState build() {
            return new FailoverState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
