/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a specific elastic cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cluster implements SdkPojo, Serializable, ToCopyableBuilder<Cluster.Builder, Cluster> {
    private static final SdkField<String> ADMIN_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminUserName").getter(getter(Cluster::adminUserName)).setter(setter(Builder::adminUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUserName").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(Cluster::authTypeAsString)).setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("backupRetentionPeriod").getter(getter(Cluster::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupRetentionPeriod").build())
            .build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(Cluster::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> CLUSTER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterEndpoint").getter(getter(Cluster::clusterEndpoint)).setter(setter(Builder::clusterEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterEndpoint").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(Cluster::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createTime").getter(getter(Cluster::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(Cluster::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("preferredBackupWindow").getter(getter(Cluster::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("preferredMaintenanceWindow")
            .getter(getter(Cluster::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Integer> SHARD_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shardCapacity").getter(getter(Cluster::shardCapacity)).setter(setter(Builder::shardCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardCapacity").build()).build();

    private static final SdkField<Integer> SHARD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shardCount").getter(getter(Cluster::shardCount)).setter(setter(Builder::shardCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardCount").build()).build();

    private static final SdkField<Integer> SHARD_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shardInstanceCount").getter(getter(Cluster::shardInstanceCount))
            .setter(setter(Builder::shardInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardInstanceCount").build())
            .build();

    private static final SdkField<List<Shard>> SHARDS_FIELD = SdkField
            .<List<Shard>> builder(MarshallingType.LIST)
            .memberName("shards")
            .getter(getter(Cluster::shards))
            .setter(setter(Builder::shards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Shard> builder(MarshallingType.SDK_POJO)
                                            .constructor(Shard::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Cluster::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(Cluster::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcSecurityGroupIds")
            .getter(getter(Cluster::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USER_NAME_FIELD,
            AUTH_TYPE_FIELD, BACKUP_RETENTION_PERIOD_FIELD, CLUSTER_ARN_FIELD, CLUSTER_ENDPOINT_FIELD, CLUSTER_NAME_FIELD,
            CREATE_TIME_FIELD, KMS_KEY_ID_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            SHARD_CAPACITY_FIELD, SHARD_COUNT_FIELD, SHARD_INSTANCE_COUNT_FIELD, SHARDS_FIELD, STATUS_FIELD, SUBNET_IDS_FIELD,
            VPC_SECURITY_GROUP_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adminUserName;

    private final String authType;

    private final Integer backupRetentionPeriod;

    private final String clusterArn;

    private final String clusterEndpoint;

    private final String clusterName;

    private final String createTime;

    private final String kmsKeyId;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Integer shardCapacity;

    private final Integer shardCount;

    private final Integer shardInstanceCount;

    private final List<Shard> shards;

    private final String status;

    private final List<String> subnetIds;

    private final List<String> vpcSecurityGroupIds;

    private Cluster(BuilderImpl builder) {
        this.adminUserName = builder.adminUserName;
        this.authType = builder.authType;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.clusterArn = builder.clusterArn;
        this.clusterEndpoint = builder.clusterEndpoint;
        this.clusterName = builder.clusterName;
        this.createTime = builder.createTime;
        this.kmsKeyId = builder.kmsKeyId;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.shardCapacity = builder.shardCapacity;
        this.shardCount = builder.shardCount;
        this.shardInstanceCount = builder.shardInstanceCount;
        this.shards = builder.shards;
        this.status = builder.status;
        this.subnetIds = builder.subnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The name of the elastic cluster administrator.
     * </p>
     * 
     * @return The name of the elastic cluster administrator.
     */
    public final String adminUserName() {
        return adminUserName;
    }

    /**
     * <p>
     * The authentication type for the elastic cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link Auth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the elastic cluster.
     * @see Auth
     */
    public final Auth authType() {
        return Auth.fromValue(authType);
    }

    /**
     * <p>
     * The authentication type for the elastic cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link Auth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the elastic cluster.
     * @see Auth
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The number of days for which automatic snapshots are retained.
     * </p>
     * 
     * @return The number of days for which automatic snapshots are retained.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The ARN identifier of the elastic cluster.
     * </p>
     * 
     * @return The ARN identifier of the elastic cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The URL used to connect to the elastic cluster.
     * </p>
     * 
     * @return The URL used to connect to the elastic cluster.
     */
    public final String clusterEndpoint() {
        return clusterEndpoint;
    }

    /**
     * <p>
     * The name of the elastic cluster.
     * </p>
     * 
     * @return The name of the elastic cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The time when the elastic cluster was created in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return The time when the elastic cluster was created in Universal Coordinated Time (UTC).
     */
    public final String createTime() {
        return createTime;
    }

    /**
     * <p>
     * The KMS key identifier to use to encrypt the elastic cluster.
     * </p>
     * 
     * @return The KMS key identifier to use to encrypt the elastic cluster.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled, as determined
     * by <code>backupRetentionPeriod</code>.
     * </p>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled, as
     *         determined by <code>backupRetentionPeriod</code>.
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * </p>
     * 
     * @return The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
     *         <p>
     *         <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32,
     * 64.
     * </p>
     * 
     * @return The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8,
     *         16, 32, 64.
     */
    public final Integer shardCapacity() {
        return shardCapacity;
    }

    /**
     * <p>
     * The number of shards assigned to the elastic cluster. Maximum is 32.
     * </p>
     * 
     * @return The number of shards assigned to the elastic cluster. Maximum is 32.
     */
    public final Integer shardCount() {
        return shardCount;
    }

    /**
     * <p>
     * The number of replica instances applying to all shards in the cluster. A <code>shardInstanceCount</code> value of
     * 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to
     * improve availability.
     * </p>
     * 
     * @return The number of replica instances applying to all shards in the cluster. A <code>shardInstanceCount</code>
     *         value of 1 means there is one writer instance, and any additional instances are replicas that can be used
     *         for reads and to improve availability.
     */
    public final Integer shardInstanceCount() {
        return shardInstanceCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Shards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasShards() {
        return shards != null && !(shards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The total number of shards in the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShards} method.
     * </p>
     * 
     * @return The total number of shards in the cluster.
     */
    public final List<Shard> shards() {
        return shards;
    }

    /**
     * <p>
     * The status of the elastic cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the elastic cluster.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the elastic cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the elastic cluster.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 subnet IDs for the elastic cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The Amazon EC2 subnet IDs for the elastic cluster.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 VPC security groups associated with thie elastic cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of EC2 VPC security groups associated with thie elastic cluster.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adminUserName());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(shardCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(shardCount());
        hashCode = 31 * hashCode + Objects.hashCode(shardInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasShards() ? shards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster) obj;
        return Objects.equals(adminUserName(), other.adminUserName())
                && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(clusterEndpoint(), other.clusterEndpoint())
                && Objects.equals(clusterName(), other.clusterName()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(shardCapacity(), other.shardCapacity()) && Objects.equals(shardCount(), other.shardCount())
                && Objects.equals(shardInstanceCount(), other.shardInstanceCount()) && hasShards() == other.hasShards()
                && Objects.equals(shards(), other.shards()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Cluster").add("AdminUserName", adminUserName()).add("AuthType", authTypeAsString())
                .add("BackupRetentionPeriod", backupRetentionPeriod()).add("ClusterArn", clusterArn())
                .add("ClusterEndpoint", clusterEndpoint()).add("ClusterName", clusterName()).add("CreateTime", createTime())
                .add("KmsKeyId", kmsKeyId()).add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("ShardCapacity", shardCapacity())
                .add("ShardCount", shardCount()).add("ShardInstanceCount", shardInstanceCount())
                .add("Shards", hasShards() ? shards() : null).add("Status", statusAsString())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adminUserName":
            return Optional.ofNullable(clazz.cast(adminUserName()));
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "backupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "clusterEndpoint":
            return Optional.ofNullable(clazz.cast(clusterEndpoint()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "preferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "preferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "shardCapacity":
            return Optional.ofNullable(clazz.cast(shardCapacity()));
        case "shardCount":
            return Optional.ofNullable(clazz.cast(shardCount()));
        case "shardInstanceCount":
            return Optional.ofNullable(clazz.cast(shardInstanceCount()));
        case "shards":
            return Optional.ofNullable(clazz.cast(shards()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "vpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cluster> {
        /**
         * <p>
         * The name of the elastic cluster administrator.
         * </p>
         * 
         * @param adminUserName
         *        The name of the elastic cluster administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUserName(String adminUserName);

        /**
         * <p>
         * The authentication type for the elastic cluster.
         * </p>
         * 
         * @param authType
         *        The authentication type for the elastic cluster.
         * @see Auth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Auth
         */
        Builder authType(String authType);

        /**
         * <p>
         * The authentication type for the elastic cluster.
         * </p>
         * 
         * @param authType
         *        The authentication type for the elastic cluster.
         * @see Auth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Auth
         */
        Builder authType(Auth authType);

        /**
         * <p>
         * The number of days for which automatic snapshots are retained.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automatic snapshots are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The ARN identifier of the elastic cluster.
         * </p>
         * 
         * @param clusterArn
         *        The ARN identifier of the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The URL used to connect to the elastic cluster.
         * </p>
         * 
         * @param clusterEndpoint
         *        The URL used to connect to the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterEndpoint(String clusterEndpoint);

        /**
         * <p>
         * The name of the elastic cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The time when the elastic cluster was created in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param createTime
         *        The time when the elastic cluster was created in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(String createTime);

        /**
         * <p>
         * The KMS key identifier to use to encrypt the elastic cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key identifier to use to encrypt the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled, as
         * determined by <code>backupRetentionPeriod</code>.
         * </p>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled, as
         *        determined by <code>backupRetentionPeriod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * </p>
         * <p>
         * <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur, in Universal Coordinated Time
         *        (UTC).</p>
         *        <p>
         *        <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16,
         * 32, 64.
         * </p>
         * 
         * @param shardCapacity
         *        The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8,
         *        16, 32, 64.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardCapacity(Integer shardCapacity);

        /**
         * <p>
         * The number of shards assigned to the elastic cluster. Maximum is 32.
         * </p>
         * 
         * @param shardCount
         *        The number of shards assigned to the elastic cluster. Maximum is 32.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardCount(Integer shardCount);

        /**
         * <p>
         * The number of replica instances applying to all shards in the cluster. A <code>shardInstanceCount</code>
         * value of 1 means there is one writer instance, and any additional instances are replicas that can be used for
         * reads and to improve availability.
         * </p>
         * 
         * @param shardInstanceCount
         *        The number of replica instances applying to all shards in the cluster. A
         *        <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional
         *        instances are replicas that can be used for reads and to improve availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardInstanceCount(Integer shardInstanceCount);

        /**
         * <p>
         * The total number of shards in the cluster.
         * </p>
         * 
         * @param shards
         *        The total number of shards in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Collection<Shard> shards);

        /**
         * <p>
         * The total number of shards in the cluster.
         * </p>
         * 
         * @param shards
         *        The total number of shards in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Shard... shards);

        /**
         * <p>
         * The total number of shards in the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.docdbelastic.model.Shard.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.docdbelastic.model.Shard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.docdbelastic.model.Shard.Builder#build()} is called immediately and
         * its result is passed to {@link #shards(List<Shard>)}.
         * 
         * @param shards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.docdbelastic.model.Shard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shards(java.util.Collection<Shard>)
         */
        Builder shards(Consumer<Shard.Builder>... shards);

        /**
         * <p>
         * The status of the elastic cluster.
         * </p>
         * 
         * @param status
         *        The status of the elastic cluster.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the elastic cluster.
         * </p>
         * 
         * @param status
         *        The status of the elastic cluster.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The Amazon EC2 subnet IDs for the elastic cluster.
         * </p>
         * 
         * @param subnetIds
         *        The Amazon EC2 subnet IDs for the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The Amazon EC2 subnet IDs for the elastic cluster.
         * </p>
         * 
         * @param subnetIds
         *        The Amazon EC2 subnet IDs for the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of EC2 VPC security groups associated with thie elastic cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups associated with thie elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of EC2 VPC security groups associated with thie elastic cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups associated with thie elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);
    }

    static final class BuilderImpl implements Builder {
        private String adminUserName;

        private String authType;

        private Integer backupRetentionPeriod;

        private String clusterArn;

        private String clusterEndpoint;

        private String clusterName;

        private String createTime;

        private String kmsKeyId;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Integer shardCapacity;

        private Integer shardCount;

        private Integer shardInstanceCount;

        private List<Shard> shards = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            adminUserName(model.adminUserName);
            authType(model.authType);
            backupRetentionPeriod(model.backupRetentionPeriod);
            clusterArn(model.clusterArn);
            clusterEndpoint(model.clusterEndpoint);
            clusterName(model.clusterName);
            createTime(model.createTime);
            kmsKeyId(model.kmsKeyId);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            shardCapacity(model.shardCapacity);
            shardCount(model.shardCount);
            shardInstanceCount(model.shardInstanceCount);
            shards(model.shards);
            status(model.status);
            subnetIds(model.subnetIds);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getAdminUserName() {
            return adminUserName;
        }

        public final void setAdminUserName(String adminUserName) {
            this.adminUserName = adminUserName;
        }

        @Override
        public final Builder adminUserName(String adminUserName) {
            this.adminUserName = adminUserName;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(Auth authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterEndpoint() {
            return clusterEndpoint;
        }

        public final void setClusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
        }

        @Override
        public final Builder clusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Integer getShardCapacity() {
            return shardCapacity;
        }

        public final void setShardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
        }

        @Override
        public final Builder shardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
            return this;
        }

        public final Integer getShardCount() {
            return shardCount;
        }

        public final void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        @Override
        public final Builder shardCount(Integer shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public final Integer getShardInstanceCount() {
            return shardInstanceCount;
        }

        public final void setShardInstanceCount(Integer shardInstanceCount) {
            this.shardInstanceCount = shardInstanceCount;
        }

        @Override
        public final Builder shardInstanceCount(Integer shardInstanceCount) {
            this.shardInstanceCount = shardInstanceCount;
            return this;
        }

        public final List<Shard.Builder> getShards() {
            List<Shard.Builder> result = ShardListCopier.copyToBuilder(this.shards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShards(Collection<Shard.BuilderImpl> shards) {
            this.shards = ShardListCopier.copyFromBuilder(shards);
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard... shards) {
            shards(Arrays.asList(shards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Consumer<Shard.Builder>... shards) {
            shards(Stream.of(shards).map(c -> Shard.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        @Override
        public Cluster build() {
            return new Cluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
