/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a specific elastic cluster snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterSnapshot implements SdkPojo, Serializable, ToCopyableBuilder<ClusterSnapshot.Builder, ClusterSnapshot> {
    private static final SdkField<String> ADMIN_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminUserName").getter(getter(ClusterSnapshot::adminUserName)).setter(setter(Builder::adminUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUserName").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(ClusterSnapshot::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> CLUSTER_CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterCreationTime").getter(getter(ClusterSnapshot::clusterCreationTime))
            .setter(setter(Builder::clusterCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterCreationTime").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(ClusterSnapshot::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotArn").getter(getter(ClusterSnapshot::snapshotArn)).setter(setter(Builder::snapshotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotArn").build()).build();

    private static final SdkField<String> SNAPSHOT_CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotCreationTime").getter(getter(ClusterSnapshot::snapshotCreationTime))
            .setter(setter(Builder::snapshotCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCreationTime").build())
            .build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotName").getter(getter(ClusterSnapshot::snapshotName)).setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()).build();

    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotType").getter(getter(ClusterSnapshot::snapshotTypeAsString))
            .setter(setter(Builder::snapshotType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ClusterSnapshot::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(ClusterSnapshot::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcSecurityGroupIds")
            .getter(getter(ClusterSnapshot::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USER_NAME_FIELD,
            CLUSTER_ARN_FIELD, CLUSTER_CREATION_TIME_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_ARN_FIELD, SNAPSHOT_CREATION_TIME_FIELD,
            SNAPSHOT_NAME_FIELD, SNAPSHOT_TYPE_FIELD, STATUS_FIELD, SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adminUserName;

    private final String clusterArn;

    private final String clusterCreationTime;

    private final String kmsKeyId;

    private final String snapshotArn;

    private final String snapshotCreationTime;

    private final String snapshotName;

    private final String snapshotType;

    private final String status;

    private final List<String> subnetIds;

    private final List<String> vpcSecurityGroupIds;

    private ClusterSnapshot(BuilderImpl builder) {
        this.adminUserName = builder.adminUserName;
        this.clusterArn = builder.clusterArn;
        this.clusterCreationTime = builder.clusterCreationTime;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotCreationTime = builder.snapshotCreationTime;
        this.snapshotName = builder.snapshotName;
        this.snapshotType = builder.snapshotType;
        this.status = builder.status;
        this.subnetIds = builder.subnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The name of the elastic cluster administrator.
     * </p>
     * 
     * @return The name of the elastic cluster administrator.
     */
    public final String adminUserName() {
        return adminUserName;
    }

    /**
     * <p>
     * The ARN identifier of the elastic cluster.
     * </p>
     * 
     * @return The ARN identifier of the elastic cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The time when the elastic cluster was created in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return The time when the elastic cluster was created in Universal Coordinated Time (UTC).
     */
    public final String clusterCreationTime() {
        return clusterCreationTime;
    }

    /**
     * <p>
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a
     * cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of
     * the ARN as the KMS encryption key. If an encryption key is not specified here, Amazon DocumentDB uses the default
     * encryption key that KMS creates for your account. Your account has a different default encryption key for each
     * Amazon Region.
     * </p>
     * 
     * @return The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating
     *         a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias
     *         instead of the ARN as the KMS encryption key. If an encryption key is not specified here, Amazon
     *         DocumentDB uses the default encryption key that KMS creates for your account. Your account has a
     *         different default encryption key for each Amazon Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The ARN identifier of the elastic cluster snapshot.
     * </p>
     * 
     * @return The ARN identifier of the elastic cluster snapshot.
     */
    public final String snapshotArn() {
        return snapshotArn;
    }

    /**
     * <p>
     * The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).
     */
    public final String snapshotCreationTime() {
        return snapshotCreationTime;
    }

    /**
     * <p>
     * The name of the elastic cluster snapshot.
     * </p>
     * 
     * @return The name of the elastic cluster snapshot.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * The type of cluster snapshots to be returned. You can specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your
     * Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web Services
     * account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snapshotType} will
     * return {@link SnapshotType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snapshotTypeAsString}.
     * </p>
     * 
     * @return The type of cluster snapshots to be returned. You can specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created
     *         for your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     * @see SnapshotType
     */
    public final SnapshotType snapshotType() {
        return SnapshotType.fromValue(snapshotType);
    }

    /**
     * <p>
     * The type of cluster snapshots to be returned. You can specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your
     * Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web Services
     * account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #snapshotType} will
     * return {@link SnapshotType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #snapshotTypeAsString}.
     * </p>
     * 
     * @return The type of cluster snapshots to be returned. You can specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created
     *         for your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     * @see SnapshotType
     */
    public final String snapshotTypeAsString() {
        return snapshotType;
    }

    /**
     * <p>
     * The status of the elastic cluster snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the elastic cluster snapshot.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the elastic cluster snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the elastic cluster snapshot.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 subnet IDs for the elastic cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The Amazon EC2 subnet IDs for the elastic cluster.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 VPC security groups to associate with the elastic cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of EC2 VPC security groups to associate with the elastic cluster.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adminUserName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSnapshot)) {
            return false;
        }
        ClusterSnapshot other = (ClusterSnapshot) obj;
        return Objects.equals(adminUserName(), other.adminUserName()) && Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(clusterCreationTime(), other.clusterCreationTime())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(snapshotArn(), other.snapshotArn())
                && Objects.equals(snapshotCreationTime(), other.snapshotCreationTime())
                && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(snapshotTypeAsString(), other.snapshotTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterSnapshot").add("AdminUserName", adminUserName()).add("ClusterArn", clusterArn())
                .add("ClusterCreationTime", clusterCreationTime()).add("KmsKeyId", kmsKeyId()).add("SnapshotArn", snapshotArn())
                .add("SnapshotCreationTime", snapshotCreationTime()).add("SnapshotName", snapshotName())
                .add("SnapshotType", snapshotTypeAsString()).add("Status", statusAsString())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adminUserName":
            return Optional.ofNullable(clazz.cast(adminUserName()));
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "clusterCreationTime":
            return Optional.ofNullable(clazz.cast(clusterCreationTime()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "snapshotArn":
            return Optional.ofNullable(clazz.cast(snapshotArn()));
        case "snapshotCreationTime":
            return Optional.ofNullable(clazz.cast(snapshotCreationTime()));
        case "snapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "snapshotType":
            return Optional.ofNullable(clazz.cast(snapshotTypeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "vpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterSnapshot, T> g) {
        return obj -> g.apply((ClusterSnapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterSnapshot> {
        /**
         * <p>
         * The name of the elastic cluster administrator.
         * </p>
         * 
         * @param adminUserName
         *        The name of the elastic cluster administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUserName(String adminUserName);

        /**
         * <p>
         * The ARN identifier of the elastic cluster.
         * </p>
         * 
         * @param clusterArn
         *        The ARN identifier of the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The time when the elastic cluster was created in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param clusterCreationTime
         *        The time when the elastic cluster was created in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCreationTime(String clusterCreationTime);

        /**
         * <p>
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a
         * cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias
         * instead of the ARN as the KMS encryption key. If an encryption key is not specified here, Amazon DocumentDB
         * uses the default encryption key that KMS creates for your account. Your account has a different default
         * encryption key for each Amazon Region.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are
         *        creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the
         *        KMS key alias instead of the ARN as the KMS encryption key. If an encryption key is not specified
         *        here, Amazon DocumentDB uses the default encryption key that KMS creates for your account. Your
         *        account has a different default encryption key for each Amazon Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The ARN identifier of the elastic cluster snapshot.
         * </p>
         * 
         * @param snapshotArn
         *        The ARN identifier of the elastic cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArn(String snapshotArn);

        /**
         * <p>
         * The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param snapshotCreationTime
         *        The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCreationTime(String snapshotCreationTime);

        /**
         * <p>
         * The name of the elastic cluster snapshot.
         * </p>
         * 
         * @param snapshotName
         *        The name of the elastic cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * The type of cluster snapshots to be returned. You can specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for
         * your Amazon Web Services account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web
         * Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param snapshotType
         *        The type of cluster snapshots to be returned. You can specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created
         *        for your Amazon Web Services account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web
         *        Services account.
         *        </p>
         *        </li>
         * @see SnapshotType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotType
         */
        Builder snapshotType(String snapshotType);

        /**
         * <p>
         * The type of cluster snapshots to be returned. You can specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for
         * your Amazon Web Services account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web
         * Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param snapshotType
         *        The type of cluster snapshots to be returned. You can specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created
         *        for your Amazon Web Services account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web
         *        Services account.
         *        </p>
         *        </li>
         * @see SnapshotType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotType
         */
        Builder snapshotType(SnapshotType snapshotType);

        /**
         * <p>
         * The status of the elastic cluster snapshot.
         * </p>
         * 
         * @param status
         *        The status of the elastic cluster snapshot.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the elastic cluster snapshot.
         * </p>
         * 
         * @param status
         *        The status of the elastic cluster snapshot.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The Amazon EC2 subnet IDs for the elastic cluster.
         * </p>
         * 
         * @param subnetIds
         *        The Amazon EC2 subnet IDs for the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The Amazon EC2 subnet IDs for the elastic cluster.
         * </p>
         * 
         * @param subnetIds
         *        The Amazon EC2 subnet IDs for the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with the elastic cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with the elastic cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);
    }

    static final class BuilderImpl implements Builder {
        private String adminUserName;

        private String clusterArn;

        private String clusterCreationTime;

        private String kmsKeyId;

        private String snapshotArn;

        private String snapshotCreationTime;

        private String snapshotName;

        private String snapshotType;

        private String status;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSnapshot model) {
            adminUserName(model.adminUserName);
            clusterArn(model.clusterArn);
            clusterCreationTime(model.clusterCreationTime);
            kmsKeyId(model.kmsKeyId);
            snapshotArn(model.snapshotArn);
            snapshotCreationTime(model.snapshotCreationTime);
            snapshotName(model.snapshotName);
            snapshotType(model.snapshotType);
            status(model.status);
            subnetIds(model.subnetIds);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getAdminUserName() {
            return adminUserName;
        }

        public final void setAdminUserName(String adminUserName) {
            this.adminUserName = adminUserName;
        }

        @Override
        public final Builder adminUserName(String adminUserName) {
            this.adminUserName = adminUserName;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterCreationTime() {
            return clusterCreationTime;
        }

        public final void setClusterCreationTime(String clusterCreationTime) {
            this.clusterCreationTime = clusterCreationTime;
        }

        @Override
        public final Builder clusterCreationTime(String clusterCreationTime) {
            this.clusterCreationTime = clusterCreationTime;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSnapshotArn() {
            return snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getSnapshotCreationTime() {
            return snapshotCreationTime;
        }

        public final void setSnapshotCreationTime(String snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
        }

        @Override
        public final Builder snapshotCreationTime(String snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getSnapshotType() {
            return snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        @Override
        public final Builder snapshotType(SnapshotType snapshotType) {
            this.snapshotType(snapshotType == null ? null : snapshotType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        @Override
        public ClusterSnapshot build() {
            return new ClusterSnapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
