/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClusterSnapshotsRequest extends DocDbElasticRequest implements
        ToCopyableBuilder<ListClusterSnapshotsRequest.Builder, ListClusterSnapshotsRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(ListClusterSnapshotsRequest::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListClusterSnapshotsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListClusterSnapshotsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotType").getter(getter(ListClusterSnapshotsRequest::snapshotType))
            .setter(setter(Builder::snapshotType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("snapshotType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SNAPSHOT_TYPE_FIELD));

    private final String clusterArn;

    private final Integer maxResults;

    private final String nextToken;

    private final String snapshotType;

    private ListClusterSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.snapshotType = builder.snapshotType;
    }

    /**
     * <p>
     * The ARN identifier of the elastic cluster.
     * </p>
     * 
     * @return The ARN identifier of the elastic cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The maximum number of elastic cluster snapshot results to receive in the response.
     * </p>
     * 
     * @return The maximum number of elastic cluster snapshot results to receive in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token provided by a previous request. If this parameter is specified, the response includes only
     * records beyond this token, up to the value specified by <code>max-results</code>.
     * </p>
     * <p>
     * If there is no more data in the responce, the <code>nextToken</code> will not be returned.
     * </p>
     * 
     * @return A pagination token provided by a previous request. If this parameter is specified, the response includes
     *         only records beyond this token, up to the value specified by <code>max-results</code>.</p>
     *         <p>
     *         If there is no more data in the responce, the <code>nextToken</code> will not be returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The type of cluster snapshots to be returned. You can specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for your
     * Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web Services
     * account.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of cluster snapshots to be returned. You can specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created
     *         for your Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web
     *         Services account.
     *         </p>
     *         </li>
     */
    public final String snapshotType() {
        return snapshotType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterSnapshotsRequest)) {
            return false;
        }
        ListClusterSnapshotsRequest other = (ListClusterSnapshotsRequest) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(snapshotType(), other.snapshotType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClusterSnapshotsRequest").add("ClusterArn", clusterArn()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("SnapshotType", snapshotType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "snapshotType":
            return Optional.ofNullable(clazz.cast(snapshotType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClusterSnapshotsRequest, T> g) {
        return obj -> g.apply((ListClusterSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbElasticRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListClusterSnapshotsRequest> {
        /**
         * <p>
         * The ARN identifier of the elastic cluster.
         * </p>
         * 
         * @param clusterArn
         *        The ARN identifier of the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The maximum number of elastic cluster snapshot results to receive in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of elastic cluster snapshot results to receive in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token provided by a previous request. If this parameter is specified, the response includes only
         * records beyond this token, up to the value specified by <code>max-results</code>.
         * </p>
         * <p>
         * If there is no more data in the responce, the <code>nextToken</code> will not be returned.
         * </p>
         * 
         * @param nextToken
         *        A pagination token provided by a previous request. If this parameter is specified, the response
         *        includes only records beyond this token, up to the value specified by <code>max-results</code>.</p>
         *        <p>
         *        If there is no more data in the responce, the <code>nextToken</code> will not be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The type of cluster snapshots to be returned. You can specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created for
         * your Amazon Web Services account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web
         * Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param snapshotType
         *        The type of cluster snapshots to be returned. You can specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>automated</code> - Return all cluster snapshots that Amazon DocumentDB has automatically created
         *        for your Amazon Web Services account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>manual</code> - Return all cluster snapshots that you have manually created for your Amazon Web
         *        Services account.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotType(String snapshotType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbElasticRequest.BuilderImpl implements Builder {
        private String clusterArn;

        private Integer maxResults;

        private String nextToken;

        private String snapshotType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterSnapshotsRequest model) {
            super(model);
            clusterArn(model.clusterArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            snapshotType(model.snapshotType);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSnapshotType() {
            return snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClusterSnapshotsRequest build() {
            return new ListClusterSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
