/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.docdbelastic.model.CopyClusterSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.CopyClusterSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsResponse;
import software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListClustersResponse;
import software.amazon.awssdk.services.docdbelastic.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.docdbelastic.model.RestoreClusterFromSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.RestoreClusterFromSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.StartClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.StartClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.StopClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.StopClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.TagResourceRequest;
import software.amazon.awssdk.services.docdbelastic.model.TagResourceResponse;
import software.amazon.awssdk.services.docdbelastic.model.UntagResourceRequest;
import software.amazon.awssdk.services.docdbelastic.model.UntagResourceResponse;
import software.amazon.awssdk.services.docdbelastic.model.UpdateClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.UpdateClusterResponse;
import software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsPublisher;
import software.amazon.awssdk.services.docdbelastic.paginators.ListClustersPublisher;

/**
 * Service client for accessing DocDB Elastic asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * <fullname>Amazon DocumentDB elastic clusters</fullname>
 * <p>
 * Amazon DocumentDB elastic-clusters support workloads with millions of reads/writes per second and petabytes of
 * storage capacity. Amazon DocumentDB elastic clusters also simplify how developers interact with Amazon DocumentDB
 * elastic-clusters by eliminating the need to choose, manage or upgrade instances.
 * </p>
 * <p>
 * Amazon DocumentDB elastic-clusters were created to:
 * </p>
 * <ul>
 * <li>
 * <p>
 * provide a solution for customers looking for a database that provides virtually limitless scale with rich query
 * capabilities and MongoDB API compatibility.
 * </p>
 * </li>
 * <li>
 * <p>
 * give customers higher connection limits, and to reduce downtime from patching.
 * </p>
 * </li>
 * <li>
 * <p>
 * continue investing in a cloud-native, elastic, and class leading architecture for JSON workloads.
 * </p>
 * </li>
 * </ul>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DocDbElasticAsyncClient extends AwsClient {
    String SERVICE_NAME = "docdb-elastic";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "docdb-elastic";

    /**
     * <p>
     * Copies a snapshot of an elastic cluster.
     * </p>
     *
     * @param copyClusterSnapshotRequest
     * @return A Java Future containing the result of the CopyClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ServiceQuotaExceededException The service quota for the action was exceeded.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.CopyClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CopyClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CopyClusterSnapshotResponse> copyClusterSnapshot(
            CopyClusterSnapshotRequest copyClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a snapshot of an elastic cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CopyClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param copyClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.CopyClusterSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CopyClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ServiceQuotaExceededException The service quota for the action was exceeded.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.CopyClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CopyClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CopyClusterSnapshotResponse> copyClusterSnapshot(
            Consumer<CopyClusterSnapshotRequest.Builder> copyClusterSnapshotRequest) {
        return copyClusterSnapshot(CopyClusterSnapshotRequest.builder().applyMutation(copyClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon DocumentDB elastic cluster and returns its cluster structure.
     * </p>
     *
     * @param createClusterRequest
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ServiceQuotaExceededException The service quota for the action was exceeded.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon DocumentDB elastic cluster and returns its cluster structure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.CreateClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ServiceQuotaExceededException The service quota for the action was exceeded.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of an elastic cluster.
     * </p>
     *
     * @param createClusterSnapshotRequest
     * @return A Java Future containing the result of the CreateClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ServiceQuotaExceededException The service quota for the action was exceeded.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.CreateClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterSnapshotResponse> createClusterSnapshot(
            CreateClusterSnapshotRequest createClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of an elastic cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param createClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.CreateClusterSnapshotRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ServiceQuotaExceededException The service quota for the action was exceeded.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.CreateClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterSnapshotResponse> createClusterSnapshot(
            Consumer<CreateClusterSnapshotRequest.Builder> createClusterSnapshotRequest) {
        return createClusterSnapshot(CreateClusterSnapshotRequest.builder().applyMutation(createClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Delete an elastic cluster.
     * </p>
     *
     * @param deleteClusterRequest
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an elastic cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.DeleteClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Delete an elastic cluster snapshot.
     * </p>
     *
     * @param deleteClusterSnapshotRequest
     * @return A Java Future containing the result of the DeleteClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.DeleteClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterSnapshotResponse> deleteClusterSnapshot(
            DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an elastic cluster snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.DeleteClusterSnapshotRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.DeleteClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterSnapshotResponse> deleteClusterSnapshot(
            Consumer<DeleteClusterSnapshotRequest.Builder> deleteClusterSnapshotRequest) {
        return deleteClusterSnapshot(DeleteClusterSnapshotRequest.builder().applyMutation(deleteClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific elastic cluster.
     * </p>
     *
     * @param getClusterRequest
     * @return A Java Future containing the result of the GetCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.GetCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetClusterResponse> getCluster(GetClusterRequest getClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific elastic cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClusterRequest.Builder} avoiding the need to
     * create one manually via {@link GetClusterRequest#builder()}
     * </p>
     *
     * @param getClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.GetClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.GetCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetClusterResponse> getCluster(Consumer<GetClusterRequest.Builder> getClusterRequest) {
        return getCluster(GetClusterRequest.builder().applyMutation(getClusterRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific elastic cluster snapshot
     * </p>
     *
     * @param getClusterSnapshotRequest
     * @return A Java Future containing the result of the GetClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.GetClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetClusterSnapshotResponse> getClusterSnapshot(GetClusterSnapshotRequest getClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific elastic cluster snapshot
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link GetClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param getClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.GetClusterSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.GetClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetClusterSnapshotResponse> getClusterSnapshot(
            Consumer<GetClusterSnapshotRequest.Builder> getClusterSnapshotRequest) {
        return getClusterSnapshot(GetClusterSnapshotRequest.builder().applyMutation(getClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns information about snapshots for a specified elastic cluster.
     * </p>
     *
     * @param listClusterSnapshotsRequest
     * @return A Java Future containing the result of the ListClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.ListClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListClusterSnapshotsResponse> listClusterSnapshots(
            ListClusterSnapshotsRequest listClusterSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about snapshots for a specified elastic cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link ListClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param listClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.ListClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListClusterSnapshotsResponse> listClusterSnapshots(
            Consumer<ListClusterSnapshotsRequest.Builder> listClusterSnapshotsRequest) {
        return listClusterSnapshots(ListClusterSnapshotsRequest.builder().applyMutation(listClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterSnapshots(software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsPublisher publisher = client.listClusterSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsPublisher publisher = client.listClusterSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterSnapshots(software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClusterSnapshotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.ListClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClusterSnapshotsPublisher listClusterSnapshotsPaginator(ListClusterSnapshotsRequest listClusterSnapshotsRequest) {
        return new ListClusterSnapshotsPublisher(this, listClusterSnapshotsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterSnapshots(software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsPublisher publisher = client.listClusterSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsPublisher publisher = client.listClusterSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterSnapshots(software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link ListClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param listClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.ListClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClusterSnapshotsPublisher listClusterSnapshotsPaginator(
            Consumer<ListClusterSnapshotsRequest.Builder> listClusterSnapshotsRequest) {
        return listClusterSnapshotsPaginator(ListClusterSnapshotsRequest.builder().applyMutation(listClusterSnapshotsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB elastic clusters.
     * </p>
     *
     * @param listClustersRequest
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters(ListClustersRequest listClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB elastic clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusters(software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.docdbelastic.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.docdbelastic.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @param listClustersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator(ListClustersRequest listClustersRequest) {
        return new ListClustersPublisher(this, listClustersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusters(software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.docdbelastic.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.docdbelastic.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Lists all tags on a elastic cluster resource
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on a elastic cluster resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Restores an elastic cluster from a snapshot.
     * </p>
     *
     * @param restoreClusterFromSnapshotRequest
     * @return A Java Future containing the result of the RestoreClusterFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ServiceQuotaExceededException The service quota for the action was exceeded.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.RestoreClusterFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/RestoreClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreClusterFromSnapshotResponse> restoreClusterFromSnapshot(
            RestoreClusterFromSnapshotRequest restoreClusterFromSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores an elastic cluster from a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreClusterFromSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreClusterFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreClusterFromSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.RestoreClusterFromSnapshotRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RestoreClusterFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ServiceQuotaExceededException The service quota for the action was exceeded.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.RestoreClusterFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/RestoreClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreClusterFromSnapshotResponse> restoreClusterFromSnapshot(
            Consumer<RestoreClusterFromSnapshotRequest.Builder> restoreClusterFromSnapshotRequest) {
        return restoreClusterFromSnapshot(RestoreClusterFromSnapshotRequest.builder()
                .applyMutation(restoreClusterFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Restarts the stopped elastic cluster that is specified by <code>clusterARN</code>.
     * </p>
     *
     * @param startClusterRequest
     * @return A Java Future containing the result of the StartCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.StartCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/StartCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartClusterResponse> startCluster(StartClusterRequest startClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts the stopped elastic cluster that is specified by <code>clusterARN</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartClusterRequest.Builder} avoiding the need to
     * create one manually via {@link StartClusterRequest#builder()}
     * </p>
     *
     * @param startClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.StartClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.StartCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/StartCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartClusterResponse> startCluster(Consumer<StartClusterRequest.Builder> startClusterRequest) {
        return startCluster(StartClusterRequest.builder().applyMutation(startClusterRequest).build());
    }

    /**
     * <p>
     * Stops the running elastic cluster that is specified by <code>clusterArn</code>. The elastic cluster must be in
     * the <i>available</i> state.
     * </p>
     *
     * @param stopClusterRequest
     * @return A Java Future containing the result of the StopCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.StopCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/StopCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopClusterResponse> stopCluster(StopClusterRequest stopClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the running elastic cluster that is specified by <code>clusterArn</code>. The elastic cluster must be in
     * the <i>available</i> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopClusterRequest.Builder} avoiding the need to
     * create one manually via {@link StopClusterRequest#builder()}
     * </p>
     *
     * @param stopClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.StopClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.StopCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/StopCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopClusterResponse> stopCluster(Consumer<StopClusterRequest.Builder> stopClusterRequest) {
        return stopCluster(StopClusterRequest.builder().applyMutation(stopClusterRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to an elastic cluster resource
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to an elastic cluster resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from an elastic cluster resource
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from an elastic cluster resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies an elastic cluster. This includes updating admin-username/password, upgrading the API version, and
     * setting up a backup window and maintenance window
     * </p>
     *
     * @param updateClusterRequest
     * @return A Java Future containing the result of the UpdateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UpdateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateClusterResponse> updateCluster(UpdateClusterRequest updateClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an elastic cluster. This includes updating admin-username/password, upgrading the API version, and
     * setting up a backup window and maintenance window
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateClusterRequest#builder()}
     * </p>
     *
     * @param updateClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.UpdateClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException ThrottlingException will be thrown when request was denied due to request
     *         throttling.</li>
     *         <li>ValidationException A structure defining a validation exception.</li>
     *         <li>ConflictException There was an access conflict.</li>
     *         <li>InternalServerException There was an internal server error.</li>
     *         <li>ResourceNotFoundException The specified resource could not be located.</li>
     *         <li>AccessDeniedException An exception that occurs when there are not sufficient permissions to perform
     *         an action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DocDbElasticException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DocDbElasticAsyncClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UpdateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateClusterResponse> updateCluster(Consumer<UpdateClusterRequest.Builder> updateClusterRequest) {
        return updateCluster(UpdateClusterRequest.builder().applyMutation(updateClusterRequest).build());
    }

    @Override
    default DocDbElasticServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DocDbElasticAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DocDbElasticAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DocDbElasticAsyncClient}.
     */
    static DocDbElasticAsyncClientBuilder builder() {
        return new DefaultDocDbElasticAsyncClientBuilder();
    }
}
