/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteClusterSnapshotResponse extends DocDbElasticResponse implements
        ToCopyableBuilder<DeleteClusterSnapshotResponse.Builder, DeleteClusterSnapshotResponse> {
    private static final SdkField<ClusterSnapshot> SNAPSHOT_FIELD = SdkField.<ClusterSnapshot> builder(MarshallingType.SDK_POJO)
            .memberName("snapshot").getter(getter(DeleteClusterSnapshotResponse::snapshot)).setter(setter(Builder::snapshot))
            .constructor(ClusterSnapshot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_FIELD));

    private final ClusterSnapshot snapshot;

    private DeleteClusterSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.snapshot = builder.snapshot;
    }

    /**
     * <p>
     * Returns information about the newly deleted elastic cluster snapshot.
     * </p>
     * 
     * @return Returns information about the newly deleted elastic cluster snapshot.
     */
    public final ClusterSnapshot snapshot() {
        return snapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClusterSnapshotResponse)) {
            return false;
        }
        DeleteClusterSnapshotResponse other = (DeleteClusterSnapshotResponse) obj;
        return Objects.equals(snapshot(), other.snapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteClusterSnapshotResponse").add("Snapshot", snapshot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "snapshot":
            return Optional.ofNullable(clazz.cast(snapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteClusterSnapshotResponse, T> g) {
        return obj -> g.apply((DeleteClusterSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbElasticResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteClusterSnapshotResponse> {
        /**
         * <p>
         * Returns information about the newly deleted elastic cluster snapshot.
         * </p>
         * 
         * @param snapshot
         *        Returns information about the newly deleted elastic cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshot(ClusterSnapshot snapshot);

        /**
         * <p>
         * Returns information about the newly deleted elastic cluster snapshot.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterSnapshot.Builder} avoiding the
         * need to create one manually via {@link ClusterSnapshot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterSnapshot.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshot(ClusterSnapshot)}.
         * 
         * @param snapshot
         *        a consumer that will call methods on {@link ClusterSnapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshot(ClusterSnapshot)
         */
        default Builder snapshot(Consumer<ClusterSnapshot.Builder> snapshot) {
            return snapshot(ClusterSnapshot.builder().applyMutation(snapshot).build());
        }
    }

    static final class BuilderImpl extends DocDbElasticResponse.BuilderImpl implements Builder {
        private ClusterSnapshot snapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClusterSnapshotResponse model) {
            super(model);
            snapshot(model.snapshot);
        }

        public final ClusterSnapshot.Builder getSnapshot() {
            return snapshot != null ? snapshot.toBuilder() : null;
        }

        public final void setSnapshot(ClusterSnapshot.BuilderImpl snapshot) {
            this.snapshot = snapshot != null ? snapshot.build() : null;
        }

        @Override
        public final Builder snapshot(ClusterSnapshot snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        @Override
        public DeleteClusterSnapshotResponse build() {
            return new DeleteClusterSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
