/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.docdbelastic.model.DocDbElasticRequest;
import software.amazon.awssdk.services.docdbelastic.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyClusterSnapshotRequest
extends DocDbElasticRequest
implements ToCopyableBuilder<Builder, CopyClusterSnapshotRequest> {
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("copyTags").getter(CopyClusterSnapshotRequest.getter(CopyClusterSnapshotRequest::copyTags)).setter(CopyClusterSnapshotRequest.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(CopyClusterSnapshotRequest.getter(CopyClusterSnapshotRequest::kmsKeyId)).setter(CopyClusterSnapshotRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotArn").getter(CopyClusterSnapshotRequest.getter(CopyClusterSnapshotRequest::snapshotArn)).setter(CopyClusterSnapshotRequest.setter(Builder::snapshotArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CopyClusterSnapshotRequest.getter(CopyClusterSnapshotRequest::tags)).setter(CopyClusterSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetSnapshotName").getter(CopyClusterSnapshotRequest.getter(CopyClusterSnapshotRequest::targetSnapshotName)).setter(CopyClusterSnapshotRequest.setter(Builder::targetSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSnapshotName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_TAGS_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_ARN_FIELD, TAGS_FIELD, TARGET_SNAPSHOT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("copyTags", COPY_TAGS_FIELD);
            this.put("kmsKeyId", KMS_KEY_ID_FIELD);
            this.put("snapshotArn", SNAPSHOT_ARN_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("targetSnapshotName", TARGET_SNAPSHOT_NAME_FIELD);
        }
    });
    private final Boolean copyTags;
    private final String kmsKeyId;
    private final String snapshotArn;
    private final Map<String, String> tags;
    private final String targetSnapshotName;

    private CopyClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.copyTags = builder.copyTags;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotArn = builder.snapshotArn;
        this.tags = builder.tags;
        this.targetSnapshotName = builder.targetSnapshotName;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String snapshotArn() {
        return this.snapshotArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String targetSnapshotName() {
        return this.targetSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSnapshotName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyClusterSnapshotRequest)) {
            return false;
        }
        CopyClusterSnapshotRequest other = (CopyClusterSnapshotRequest)((Object)obj);
        return Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.snapshotArn(), other.snapshotArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.targetSnapshotName(), other.targetSnapshotName());
    }

    public final String toString() {
        return ToString.builder((String)"CopyClusterSnapshotRequest").add("CopyTags", (Object)this.copyTags()).add("KmsKeyId", (Object)this.kmsKeyId()).add("SnapshotArn", (Object)this.snapshotArn()).add("Tags", this.hasTags() ? this.tags() : null).add("TargetSnapshotName", (Object)this.targetSnapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "copyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "snapshotArn": {
                return Optional.ofNullable(clazz.cast(this.snapshotArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "targetSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.targetSnapshotName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CopyClusterSnapshotRequest, T> g) {
        return obj -> g.apply((CopyClusterSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbElasticRequest.BuilderImpl
    implements Builder {
        private Boolean copyTags;
        private String kmsKeyId;
        private String snapshotArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String targetSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyClusterSnapshotRequest model) {
            super(model);
            this.copyTags(model.copyTags);
            this.kmsKeyId(model.kmsKeyId);
            this.snapshotArn(model.snapshotArn);
            this.tags(model.tags);
            this.targetSnapshotName(model.targetSnapshotName);
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSnapshotArn() {
            return this.snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTargetSnapshotName() {
            return this.targetSnapshotName;
        }

        public final void setTargetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
        }

        @Override
        public final Builder targetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyClusterSnapshotRequest build() {
            return new CopyClusterSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DocDbElasticRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyClusterSnapshotRequest> {
        public Builder copyTags(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder snapshotArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder targetSnapshotName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

