/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of elastic cluster snapshots.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterSnapshotInList implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterSnapshotInList.Builder, ClusterSnapshotInList> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(ClusterSnapshotInList::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotArn").getter(getter(ClusterSnapshotInList::snapshotArn)).setter(setter(Builder::snapshotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotArn").build()).build();

    private static final SdkField<String> SNAPSHOT_CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotCreationTime").getter(getter(ClusterSnapshotInList::snapshotCreationTime))
            .setter(setter(Builder::snapshotCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCreationTime").build())
            .build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotName").getter(getter(ClusterSnapshotInList::snapshotName)).setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ClusterSnapshotInList::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            SNAPSHOT_ARN_FIELD, SNAPSHOT_CREATION_TIME_FIELD, SNAPSHOT_NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterArn;

    private final String snapshotArn;

    private final String snapshotCreationTime;

    private final String snapshotName;

    private final String status;

    private ClusterSnapshotInList(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotCreationTime = builder.snapshotCreationTime;
        this.snapshotName = builder.snapshotName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN identifier of the elastic cluster.
     * </p>
     * 
     * @return The ARN identifier of the elastic cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The ARN identifier of the elastic cluster snapshot.
     * </p>
     * 
     * @return The ARN identifier of the elastic cluster snapshot.
     */
    public final String snapshotArn() {
        return snapshotArn;
    }

    /**
     * <p>
     * The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).
     */
    public final String snapshotCreationTime() {
        return snapshotCreationTime;
    }

    /**
     * <p>
     * The name of the elastic cluster snapshot.
     * </p>
     * 
     * @return The name of the elastic cluster snapshot.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * The status of the elastic cluster snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the elastic cluster snapshot.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the elastic cluster snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the elastic cluster snapshot.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSnapshotInList)) {
            return false;
        }
        ClusterSnapshotInList other = (ClusterSnapshotInList) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(snapshotArn(), other.snapshotArn())
                && Objects.equals(snapshotCreationTime(), other.snapshotCreationTime())
                && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterSnapshotInList").add("ClusterArn", clusterArn()).add("SnapshotArn", snapshotArn())
                .add("SnapshotCreationTime", snapshotCreationTime()).add("SnapshotName", snapshotName())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "snapshotArn":
            return Optional.ofNullable(clazz.cast(snapshotArn()));
        case "snapshotCreationTime":
            return Optional.ofNullable(clazz.cast(snapshotCreationTime()));
        case "snapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("snapshotArn", SNAPSHOT_ARN_FIELD);
        map.put("snapshotCreationTime", SNAPSHOT_CREATION_TIME_FIELD);
        map.put("snapshotName", SNAPSHOT_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterSnapshotInList, T> g) {
        return obj -> g.apply((ClusterSnapshotInList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterSnapshotInList> {
        /**
         * <p>
         * The ARN identifier of the elastic cluster.
         * </p>
         * 
         * @param clusterArn
         *        The ARN identifier of the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The ARN identifier of the elastic cluster snapshot.
         * </p>
         * 
         * @param snapshotArn
         *        The ARN identifier of the elastic cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArn(String snapshotArn);

        /**
         * <p>
         * The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param snapshotCreationTime
         *        The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCreationTime(String snapshotCreationTime);

        /**
         * <p>
         * The name of the elastic cluster snapshot.
         * </p>
         * 
         * @param snapshotName
         *        The name of the elastic cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * The status of the elastic cluster snapshot.
         * </p>
         * 
         * @param status
         *        The status of the elastic cluster snapshot.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the elastic cluster snapshot.
         * </p>
         * 
         * @param status
         *        The status of the elastic cluster snapshot.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl implements Builder {
        private String clusterArn;

        private String snapshotArn;

        private String snapshotCreationTime;

        private String snapshotName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSnapshotInList model) {
            clusterArn(model.clusterArn);
            snapshotArn(model.snapshotArn);
            snapshotCreationTime(model.snapshotCreationTime);
            snapshotName(model.snapshotName);
            status(model.status);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getSnapshotArn() {
            return snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getSnapshotCreationTime() {
            return snapshotCreationTime;
        }

        public final void setSnapshotCreationTime(String snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
        }

        @Override
        public final Builder snapshotCreationTime(String snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ClusterSnapshotInList build() {
            return new ClusterSnapshotInList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
