/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyClusterSnapshotRequest extends DocDbElasticRequest implements
        ToCopyableBuilder<CopyClusterSnapshotRequest.Builder, CopyClusterSnapshotRequest> {
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyTags").getter(getter(CopyClusterSnapshotRequest::copyTags)).setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(CopyClusterSnapshotRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotArn").getter(getter(CopyClusterSnapshotRequest::snapshotArn))
            .setter(setter(Builder::snapshotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CopyClusterSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TARGET_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetSnapshotName").getter(getter(CopyClusterSnapshotRequest::targetSnapshotName))
            .setter(setter(Builder::targetSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSnapshotName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_TAGS_FIELD,
            KMS_KEY_ID_FIELD, SNAPSHOT_ARN_FIELD, TAGS_FIELD, TARGET_SNAPSHOT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean copyTags;

    private final String kmsKeyId;

    private final String snapshotArn;

    private final Map<String, String> tags;

    private final String targetSnapshotName;

    private CopyClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.copyTags = builder.copyTags;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotArn = builder.snapshotArn;
        this.tags = builder.tags;
        this.targetSnapshotName = builder.targetSnapshotName;
    }

    /**
     * <p>
     * Set to <code>true</code> to copy all tags from the source cluster snapshot to the target elastic cluster
     * snapshot. The default is <code>false</code>.
     * </p>
     * 
     * @return Set to <code>true</code> to copy all tags from the source cluster snapshot to the target elastic cluster
     *         snapshot. The default is <code>false</code>.
     */
    public final Boolean copyTags() {
        return copyTags;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key ID for an encrypted elastic cluster snapshot. The Amazon Web Services KMS key ID
     * is the Amazon Resource Name (ARN), Amazon Web Services KMS key identifier, or the Amazon Web Services KMS key
     * alias for the Amazon Web Services KMS encryption key.
     * </p>
     * <p>
     * If you copy an encrypted elastic cluster snapshot from your Amazon Web Services account, you can specify a value
     * for <code>KmsKeyId</code> to encrypt the copy with a new Amazon Web ServicesS KMS encryption key. If you don't
     * specify a value for <code>KmsKeyId</code>, then the copy of the elastic cluster snapshot is encrypted with the
     * same <code>AWS</code> KMS key as the source elastic cluster snapshot.
     * </p>
     * <p>
     * To copy an encrypted elastic cluster snapshot to another Amazon Web Services region, set <code>KmsKeyId</code> to
     * the Amazon Web Services KMS key ID that you want to use to encrypt the copy of the elastic cluster snapshot in
     * the destination region. Amazon Web Services KMS encryption keys are specific to the Amazon Web Services region
     * that they are created in, and you can't use encryption keys from one Amazon Web Services region in another Amazon
     * Web Services region.
     * </p>
     * <p>
     * If you copy an unencrypted elastic cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter,
     * an error is returned.
     * </p>
     * 
     * @return The Amazon Web Services KMS key ID for an encrypted elastic cluster snapshot. The Amazon Web Services KMS
     *         key ID is the Amazon Resource Name (ARN), Amazon Web Services KMS key identifier, or the Amazon Web
     *         Services KMS key alias for the Amazon Web Services KMS encryption key.</p>
     *         <p>
     *         If you copy an encrypted elastic cluster snapshot from your Amazon Web Services account, you can specify
     *         a value for <code>KmsKeyId</code> to encrypt the copy with a new Amazon Web ServicesS KMS encryption key.
     *         If you don't specify a value for <code>KmsKeyId</code>, then the copy of the elastic cluster snapshot is
     *         encrypted with the same <code>AWS</code> KMS key as the source elastic cluster snapshot.
     *         </p>
     *         <p>
     *         To copy an encrypted elastic cluster snapshot to another Amazon Web Services region, set
     *         <code>KmsKeyId</code> to the Amazon Web Services KMS key ID that you want to use to encrypt the copy of
     *         the elastic cluster snapshot in the destination region. Amazon Web Services KMS encryption keys are
     *         specific to the Amazon Web Services region that they are created in, and you can't use encryption keys
     *         from one Amazon Web Services region in another Amazon Web Services region.
     *         </p>
     *         <p>
     *         If you copy an unencrypted elastic cluster snapshot and specify a value for the <code>KmsKeyId</code>
     *         parameter, an error is returned.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) identifier of the elastic cluster snapshot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) identifier of the elastic cluster snapshot.
     */
    public final String snapshotArn() {
        return snapshotArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to be assigned to the elastic cluster snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be assigned to the elastic cluster snapshot.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The identifier of the new elastic cluster snapshot to create from the source cluster snapshot. This parameter is
     * not case sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>elastic-cluster-snapshot-5</code>
     * </p>
     * 
     * @return The identifier of the new elastic cluster snapshot to create from the source cluster snapshot. This
     *         parameter is not case sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>elastic-cluster-snapshot-5</code>
     */
    public final String targetSnapshotName() {
        return targetSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetSnapshotName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyClusterSnapshotRequest)) {
            return false;
        }
        CopyClusterSnapshotRequest other = (CopyClusterSnapshotRequest) obj;
        return Objects.equals(copyTags(), other.copyTags()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(snapshotArn(), other.snapshotArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(targetSnapshotName(), other.targetSnapshotName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyClusterSnapshotRequest").add("CopyTags", copyTags()).add("KmsKeyId", kmsKeyId())
                .add("SnapshotArn", snapshotArn()).add("Tags", hasTags() ? tags() : null)
                .add("TargetSnapshotName", targetSnapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "copyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "snapshotArn":
            return Optional.ofNullable(clazz.cast(snapshotArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "targetSnapshotName":
            return Optional.ofNullable(clazz.cast(targetSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("copyTags", COPY_TAGS_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("snapshotArn", SNAPSHOT_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("targetSnapshotName", TARGET_SNAPSHOT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyClusterSnapshotRequest, T> g) {
        return obj -> g.apply((CopyClusterSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbElasticRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyClusterSnapshotRequest> {
        /**
         * <p>
         * Set to <code>true</code> to copy all tags from the source cluster snapshot to the target elastic cluster
         * snapshot. The default is <code>false</code>.
         * </p>
         * 
         * @param copyTags
         *        Set to <code>true</code> to copy all tags from the source cluster snapshot to the target elastic
         *        cluster snapshot. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * The Amazon Web Services KMS key ID for an encrypted elastic cluster snapshot. The Amazon Web Services KMS key
         * ID is the Amazon Resource Name (ARN), Amazon Web Services KMS key identifier, or the Amazon Web Services KMS
         * key alias for the Amazon Web Services KMS encryption key.
         * </p>
         * <p>
         * If you copy an encrypted elastic cluster snapshot from your Amazon Web Services account, you can specify a
         * value for <code>KmsKeyId</code> to encrypt the copy with a new Amazon Web ServicesS KMS encryption key. If
         * you don't specify a value for <code>KmsKeyId</code>, then the copy of the elastic cluster snapshot is
         * encrypted with the same <code>AWS</code> KMS key as the source elastic cluster snapshot.
         * </p>
         * <p>
         * To copy an encrypted elastic cluster snapshot to another Amazon Web Services region, set
         * <code>KmsKeyId</code> to the Amazon Web Services KMS key ID that you want to use to encrypt the copy of the
         * elastic cluster snapshot in the destination region. Amazon Web Services KMS encryption keys are specific to
         * the Amazon Web Services region that they are created in, and you can't use encryption keys from one Amazon
         * Web Services region in another Amazon Web Services region.
         * </p>
         * <p>
         * If you copy an unencrypted elastic cluster snapshot and specify a value for the <code>KmsKeyId</code>
         * parameter, an error is returned.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key ID for an encrypted elastic cluster snapshot. The Amazon Web Services
         *        KMS key ID is the Amazon Resource Name (ARN), Amazon Web Services KMS key identifier, or the Amazon
         *        Web Services KMS key alias for the Amazon Web Services KMS encryption key.</p>
         *        <p>
         *        If you copy an encrypted elastic cluster snapshot from your Amazon Web Services account, you can
         *        specify a value for <code>KmsKeyId</code> to encrypt the copy with a new Amazon Web ServicesS KMS
         *        encryption key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the elastic
         *        cluster snapshot is encrypted with the same <code>AWS</code> KMS key as the source elastic cluster
         *        snapshot.
         *        </p>
         *        <p>
         *        To copy an encrypted elastic cluster snapshot to another Amazon Web Services region, set
         *        <code>KmsKeyId</code> to the Amazon Web Services KMS key ID that you want to use to encrypt the copy
         *        of the elastic cluster snapshot in the destination region. Amazon Web Services KMS encryption keys are
         *        specific to the Amazon Web Services region that they are created in, and you can't use encryption keys
         *        from one Amazon Web Services region in another Amazon Web Services region.
         *        </p>
         *        <p>
         *        If you copy an unencrypted elastic cluster snapshot and specify a value for the <code>KmsKeyId</code>
         *        parameter, an error is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) identifier of the elastic cluster snapshot.
         * </p>
         * 
         * @param snapshotArn
         *        The Amazon Resource Name (ARN) identifier of the elastic cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArn(String snapshotArn);

        /**
         * <p>
         * The tags to be assigned to the elastic cluster snapshot.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the elastic cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The identifier of the new elastic cluster snapshot to create from the source cluster snapshot. This parameter
         * is not case sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>elastic-cluster-snapshot-5</code>
         * </p>
         * 
         * @param targetSnapshotName
         *        The identifier of the new elastic cluster snapshot to create from the source cluster snapshot. This
         *        parameter is not case sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>elastic-cluster-snapshot-5</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSnapshotName(String targetSnapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbElasticRequest.BuilderImpl implements Builder {
        private Boolean copyTags;

        private String kmsKeyId;

        private String snapshotArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String targetSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyClusterSnapshotRequest model) {
            super(model);
            copyTags(model.copyTags);
            kmsKeyId(model.kmsKeyId);
            snapshotArn(model.snapshotArn);
            tags(model.tags);
            targetSnapshotName(model.targetSnapshotName);
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSnapshotArn() {
            return snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTargetSnapshotName() {
            return targetSnapshotName;
        }

        public final void setTargetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
        }

        @Override
        public final Builder targetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyClusterSnapshotRequest build() {
            return new CopyClusterSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
