/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends DocDbElasticRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<String> ADMIN_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminUserName").getter(getter(CreateClusterRequest::adminUserName))
            .setter(setter(Builder::adminUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUserName").build()).build();

    private static final SdkField<String> ADMIN_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminUserPassword").getter(getter(CreateClusterRequest::adminUserPassword))
            .setter(setter(Builder::adminUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUserPassword").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(CreateClusterRequest::authTypeAsString)).setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("backupRetentionPeriod").getter(getter(CreateClusterRequest::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupRetentionPeriod").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateClusterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(CreateClusterRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(CreateClusterRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("preferredBackupWindow").getter(getter(CreateClusterRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("preferredMaintenanceWindow")
            .getter(getter(CreateClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Integer> SHARD_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shardCapacity").getter(getter(CreateClusterRequest::shardCapacity))
            .setter(setter(Builder::shardCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardCapacity").build()).build();

    private static final SdkField<Integer> SHARD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shardCount").getter(getter(CreateClusterRequest::shardCount)).setter(setter(Builder::shardCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardCount").build()).build();

    private static final SdkField<Integer> SHARD_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shardInstanceCount").getter(getter(CreateClusterRequest::shardInstanceCount))
            .setter(setter(Builder::shardInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardInstanceCount").build())
            .build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(CreateClusterRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcSecurityGroupIds")
            .getter(getter(CreateClusterRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USER_NAME_FIELD,
            ADMIN_USER_PASSWORD_FIELD, AUTH_TYPE_FIELD, BACKUP_RETENTION_PERIOD_FIELD, CLIENT_TOKEN_FIELD, CLUSTER_NAME_FIELD,
            KMS_KEY_ID_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, SHARD_CAPACITY_FIELD,
            SHARD_COUNT_FIELD, SHARD_INSTANCE_COUNT_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String adminUserName;

    private final String adminUserPassword;

    private final String authType;

    private final Integer backupRetentionPeriod;

    private final String clientToken;

    private final String clusterName;

    private final String kmsKeyId;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Integer shardCapacity;

    private final Integer shardCount;

    private final Integer shardInstanceCount;

    private final List<String> subnetIds;

    private final Map<String, String> tags;

    private final List<String> vpcSecurityGroupIds;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.adminUserName = builder.adminUserName;
        this.adminUserPassword = builder.adminUserPassword;
        this.authType = builder.authType;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.clientToken = builder.clientToken;
        this.clusterName = builder.clusterName;
        this.kmsKeyId = builder.kmsKeyId;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.shardCapacity = builder.shardCapacity;
        this.shardCount = builder.shardCount;
        this.shardInstanceCount = builder.shardInstanceCount;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The name of the Amazon DocumentDB elastic clusters administrator.
     * </p>
     * <p>
     * <i>Constraints</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be from 1 to 63 letters or numbers.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot be a reserved word.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the Amazon DocumentDB elastic clusters administrator.</p>
     *         <p>
     *         <i>Constraints</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be from 1 to 63 letters or numbers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot be a reserved word.
     *         </p>
     *         </li>
     */
    public final String adminUserName() {
        return adminUserName;
    }

    /**
     * <p>
     * The password for the Amazon DocumentDB elastic clusters administrator. The password can contain any printable
     * ASCII characters.
     * </p>
     * <p>
     * <i>Constraints</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 8 to 100 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot contain a forward slash (/), double quote ("), or the "at" symbol (@).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The password for the Amazon DocumentDB elastic clusters administrator. The password can contain any
     *         printable ASCII characters.</p>
     *         <p>
     *         <i>Constraints</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 8 to 100 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot contain a forward slash (/), double quote ("), or the "at" symbol (@).
     *         </p>
     *         </li>
     */
    public final String adminUserPassword() {
        return adminUserPassword;
    }

    /**
     * <p>
     * The authentication type used to determine where to fetch the password used for accessing the elastic cluster.
     * Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link Auth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type used to determine where to fetch the password used for accessing the elastic
     *         cluster. Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
     * @see Auth
     */
    public final Auth authType() {
        return Auth.fromValue(authType);
    }

    /**
     * <p>
     * The authentication type used to determine where to fetch the password used for accessing the elastic cluster.
     * Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link Auth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type used to determine where to fetch the password used for accessing the elastic
     *         cluster. Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
     * @see Auth
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The number of days for which automatic snapshots are retained.
     * </p>
     * 
     * @return The number of days for which automatic snapshots are retained.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The client token for the elastic cluster.
     * </p>
     * 
     * @return The client token for the elastic cluster.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the new elastic cluster. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * <i>Constraints</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <i>Example</i>: <code>my-cluster</code>
     * </p>
     * 
     * @return The name of the new elastic cluster. This parameter is stored as a lowercase string.</p>
     *         <p>
     *         <i>Constraints</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <i>Example</i>: <code>my-cluster</code>
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The KMS key identifier to use to encrypt the new elastic cluster.
     * </p>
     * <p>
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a
     * cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of
     * the ARN as the KMS encryption key.
     * </p>
     * <p>
     * If an encryption key is not specified, Amazon DocumentDB uses the default encryption key that KMS creates for
     * your account. Your account has a different default encryption key for each Amazon Region.
     * </p>
     * 
     * @return The KMS key identifier to use to encrypt the new elastic cluster.</p>
     *         <p>
     *         The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating
     *         a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias
     *         instead of the ARN as the KMS encryption key.
     *         </p>
     *         <p>
     *         If an encryption key is not specified, Amazon DocumentDB uses the default encryption key that KMS creates
     *         for your account. Your account has a different default encryption key for each Amazon Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled, as determined
     * by the <code>backupRetentionPeriod</code>.
     * </p>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled, as
     *         determined by the <code>backupRetentionPeriod</code>.
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * </p>
     * <p>
     * <i>Default</i>: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services
     * Region, occurring on a random day of the week.
     * </p>
     * <p>
     * <i>Valid days</i>: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * </p>
     * <p>
     * <i>Constraints</i>: Minimum 30-minute window.
     * </p>
     * 
     * @return The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
     *         <p>
     *         <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     *         </p>
     *         <p>
     *         <i>Default</i>: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
     *         Services Region, occurring on a random day of the week.
     *         </p>
     *         <p>
     *         <i>Valid days</i>: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     *         </p>
     *         <p>
     *         <i>Constraints</i>: Minimum 30-minute window.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32,
     * 64.
     * </p>
     * 
     * @return The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8,
     *         16, 32, 64.
     */
    public final Integer shardCapacity() {
        return shardCapacity;
    }

    /**
     * <p>
     * The number of shards assigned to the elastic cluster. Maximum is 32.
     * </p>
     * 
     * @return The number of shards assigned to the elastic cluster. Maximum is 32.
     */
    public final Integer shardCount() {
        return shardCount;
    }

    /**
     * <p>
     * The number of replica instances applying to all shards in the elastic cluster. A <code>shardInstanceCount</code>
     * value of 1 means there is one writer instance, and any additional instances are replicas that can be used for
     * reads and to improve availability.
     * </p>
     * 
     * @return The number of replica instances applying to all shards in the elastic cluster. A
     *         <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional
     *         instances are replicas that can be used for reads and to improve availability.
     */
    public final Integer shardInstanceCount() {
        return shardInstanceCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 subnet IDs for the new elastic cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The Amazon EC2 subnet IDs for the new elastic cluster.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to be assigned to the new elastic cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be assigned to the new elastic cluster.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 VPC security groups to associate with the new elastic cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of EC2 VPC security groups to associate with the new elastic cluster.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adminUserName());
        hashCode = 31 * hashCode + Objects.hashCode(adminUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(shardCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(shardCount());
        hashCode = 31 * hashCode + Objects.hashCode(shardInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(adminUserName(), other.adminUserName())
                && Objects.equals(adminUserPassword(), other.adminUserPassword())
                && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(shardCapacity(), other.shardCapacity()) && Objects.equals(shardCount(), other.shardCount())
                && Objects.equals(shardInstanceCount(), other.shardInstanceCount()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterRequest").add("AdminUserName", adminUserName())
                .add("AdminUserPassword", adminUserPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AuthType", authTypeAsString()).add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("ClientToken", clientToken()).add("ClusterName", clusterName()).add("KmsKeyId", kmsKeyId())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("ShardCapacity", shardCapacity())
                .add("ShardCount", shardCount()).add("ShardInstanceCount", shardInstanceCount())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("Tags", hasTags() ? tags() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adminUserName":
            return Optional.ofNullable(clazz.cast(adminUserName()));
        case "adminUserPassword":
            return Optional.ofNullable(clazz.cast(adminUserPassword()));
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "backupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "preferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "preferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "shardCapacity":
            return Optional.ofNullable(clazz.cast(shardCapacity()));
        case "shardCount":
            return Optional.ofNullable(clazz.cast(shardCount()));
        case "shardInstanceCount":
            return Optional.ofNullable(clazz.cast(shardInstanceCount()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("adminUserName", ADMIN_USER_NAME_FIELD);
        map.put("adminUserPassword", ADMIN_USER_PASSWORD_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("backupRetentionPeriod", BACKUP_RETENTION_PERIOD_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("preferredBackupWindow", PREFERRED_BACKUP_WINDOW_FIELD);
        map.put("preferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("shardCapacity", SHARD_CAPACITY_FIELD);
        map.put("shardCount", SHARD_COUNT_FIELD);
        map.put("shardInstanceCount", SHARD_INSTANCE_COUNT_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbElasticRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * <p>
         * The name of the Amazon DocumentDB elastic clusters administrator.
         * </p>
         * <p>
         * <i>Constraints</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be from 1 to 63 letters or numbers.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be a reserved word.
         * </p>
         * </li>
         * </ul>
         * 
         * @param adminUserName
         *        The name of the Amazon DocumentDB elastic clusters administrator.</p>
         *        <p>
         *        <i>Constraints</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be from 1 to 63 letters or numbers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot be a reserved word.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUserName(String adminUserName);

        /**
         * <p>
         * The password for the Amazon DocumentDB elastic clusters administrator. The password can contain any printable
         * ASCII characters.
         * </p>
         * <p>
         * <i>Constraints</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 8 to 100 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot contain a forward slash (/), double quote ("), or the "at" symbol (@).
         * </p>
         * </li>
         * </ul>
         * 
         * @param adminUserPassword
         *        The password for the Amazon DocumentDB elastic clusters administrator. The password can contain any
         *        printable ASCII characters.</p>
         *        <p>
         *        <i>Constraints</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 8 to 100 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot contain a forward slash (/), double quote ("), or the "at" symbol (@).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUserPassword(String adminUserPassword);

        /**
         * <p>
         * The authentication type used to determine where to fetch the password used for accessing the elastic cluster.
         * Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
         * </p>
         * 
         * @param authType
         *        The authentication type used to determine where to fetch the password used for accessing the elastic
         *        cluster. Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
         * @see Auth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Auth
         */
        Builder authType(String authType);

        /**
         * <p>
         * The authentication type used to determine where to fetch the password used for accessing the elastic cluster.
         * Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
         * </p>
         * 
         * @param authType
         *        The authentication type used to determine where to fetch the password used for accessing the elastic
         *        cluster. Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
         * @see Auth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Auth
         */
        Builder authType(Auth authType);

        /**
         * <p>
         * The number of days for which automatic snapshots are retained.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automatic snapshots are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The client token for the elastic cluster.
         * </p>
         * 
         * @param clientToken
         *        The client token for the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the new elastic cluster. This parameter is stored as a lowercase string.
         * </p>
         * <p>
         * <i>Constraints</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <i>Example</i>: <code>my-cluster</code>
         * </p>
         * 
         * @param clusterName
         *        The name of the new elastic cluster. This parameter is stored as a lowercase string.</p>
         *        <p>
         *        <i>Constraints</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <i>Example</i>: <code>my-cluster</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The KMS key identifier to use to encrypt the new elastic cluster.
         * </p>
         * <p>
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a
         * cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias
         * instead of the ARN as the KMS encryption key.
         * </p>
         * <p>
         * If an encryption key is not specified, Amazon DocumentDB uses the default encryption key that KMS creates for
         * your account. Your account has a different default encryption key for each Amazon Region.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key identifier to use to encrypt the new elastic cluster.</p>
         *        <p>
         *        The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are
         *        creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the
         *        KMS key alias instead of the ARN as the KMS encryption key.
         *        </p>
         *        <p>
         *        If an encryption key is not specified, Amazon DocumentDB uses the default encryption key that KMS
         *        creates for your account. Your account has a different default encryption key for each Amazon Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled, as
         * determined by the <code>backupRetentionPeriod</code>.
         * </p>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled, as
         *        determined by the <code>backupRetentionPeriod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * </p>
         * <p>
         * <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * </p>
         * <p>
         * <i>Default</i>: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         * Services Region, occurring on a random day of the week.
         * </p>
         * <p>
         * <i>Valid days</i>: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * </p>
         * <p>
         * <i>Constraints</i>: Minimum 30-minute window.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur, in Universal Coordinated Time
         *        (UTC).</p>
         *        <p>
         *        <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *        </p>
         *        <p>
         *        <i>Default</i>: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         *        Services Region, occurring on a random day of the week.
         *        </p>
         *        <p>
         *        <i>Valid days</i>: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         *        </p>
         *        <p>
         *        <i>Constraints</i>: Minimum 30-minute window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16,
         * 32, 64.
         * </p>
         * 
         * @param shardCapacity
         *        The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8,
         *        16, 32, 64.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardCapacity(Integer shardCapacity);

        /**
         * <p>
         * The number of shards assigned to the elastic cluster. Maximum is 32.
         * </p>
         * 
         * @param shardCount
         *        The number of shards assigned to the elastic cluster. Maximum is 32.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardCount(Integer shardCount);

        /**
         * <p>
         * The number of replica instances applying to all shards in the elastic cluster. A
         * <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional instances
         * are replicas that can be used for reads and to improve availability.
         * </p>
         * 
         * @param shardInstanceCount
         *        The number of replica instances applying to all shards in the elastic cluster. A
         *        <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional
         *        instances are replicas that can be used for reads and to improve availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardInstanceCount(Integer shardInstanceCount);

        /**
         * <p>
         * The Amazon EC2 subnet IDs for the new elastic cluster.
         * </p>
         * 
         * @param subnetIds
         *        The Amazon EC2 subnet IDs for the new elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The Amazon EC2 subnet IDs for the new elastic cluster.
         * </p>
         * 
         * @param subnetIds
         *        The Amazon EC2 subnet IDs for the new elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The tags to be assigned to the new elastic cluster.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the new elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with the new elastic cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with the new elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with the new elastic cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with the new elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbElasticRequest.BuilderImpl implements Builder {
        private String adminUserName;

        private String adminUserPassword;

        private String authType;

        private Integer backupRetentionPeriod;

        private String clientToken;

        private String clusterName;

        private String kmsKeyId;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Integer shardCapacity;

        private Integer shardCount;

        private Integer shardInstanceCount;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            adminUserName(model.adminUserName);
            adminUserPassword(model.adminUserPassword);
            authType(model.authType);
            backupRetentionPeriod(model.backupRetentionPeriod);
            clientToken(model.clientToken);
            clusterName(model.clusterName);
            kmsKeyId(model.kmsKeyId);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            shardCapacity(model.shardCapacity);
            shardCount(model.shardCount);
            shardInstanceCount(model.shardInstanceCount);
            subnetIds(model.subnetIds);
            tags(model.tags);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getAdminUserName() {
            return adminUserName;
        }

        public final void setAdminUserName(String adminUserName) {
            this.adminUserName = adminUserName;
        }

        @Override
        public final Builder adminUserName(String adminUserName) {
            this.adminUserName = adminUserName;
            return this;
        }

        public final String getAdminUserPassword() {
            return adminUserPassword;
        }

        public final void setAdminUserPassword(String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
        }

        @Override
        public final Builder adminUserPassword(String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(Auth authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Integer getShardCapacity() {
            return shardCapacity;
        }

        public final void setShardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
        }

        @Override
        public final Builder shardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
            return this;
        }

        public final Integer getShardCount() {
            return shardCount;
        }

        public final void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        @Override
        public final Builder shardCount(Integer shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public final Integer getShardInstanceCount() {
            return shardInstanceCount;
        }

        public final void setShardInstanceCount(Integer shardInstanceCount) {
            this.shardInstanceCount = shardInstanceCount;
        }

        @Override
        public final Builder shardInstanceCount(Integer shardInstanceCount) {
            this.shardInstanceCount = shardInstanceCount;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
