/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPendingMaintenanceActionResponse extends DocDbElasticResponse implements
        ToCopyableBuilder<GetPendingMaintenanceActionResponse.Builder, GetPendingMaintenanceActionResponse> {
    private static final SdkField<ResourcePendingMaintenanceAction> RESOURCE_PENDING_MAINTENANCE_ACTION_FIELD = SdkField
            .<ResourcePendingMaintenanceAction> builder(MarshallingType.SDK_POJO)
            .memberName("resourcePendingMaintenanceAction")
            .getter(getter(GetPendingMaintenanceActionResponse::resourcePendingMaintenanceAction))
            .setter(setter(Builder::resourcePendingMaintenanceAction))
            .constructor(ResourcePendingMaintenanceAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcePendingMaintenanceAction")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESOURCE_PENDING_MAINTENANCE_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ResourcePendingMaintenanceAction resourcePendingMaintenanceAction;

    private GetPendingMaintenanceActionResponse(BuilderImpl builder) {
        super(builder);
        this.resourcePendingMaintenanceAction = builder.resourcePendingMaintenanceAction;
    }

    /**
     * <p>
     * Provides information about a pending maintenance action for a resource.
     * </p>
     * 
     * @return Provides information about a pending maintenance action for a resource.
     */
    public final ResourcePendingMaintenanceAction resourcePendingMaintenanceAction() {
        return resourcePendingMaintenanceAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourcePendingMaintenanceAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPendingMaintenanceActionResponse)) {
            return false;
        }
        GetPendingMaintenanceActionResponse other = (GetPendingMaintenanceActionResponse) obj;
        return Objects.equals(resourcePendingMaintenanceAction(), other.resourcePendingMaintenanceAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPendingMaintenanceActionResponse")
                .add("ResourcePendingMaintenanceAction", resourcePendingMaintenanceAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourcePendingMaintenanceAction":
            return Optional.ofNullable(clazz.cast(resourcePendingMaintenanceAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourcePendingMaintenanceAction", RESOURCE_PENDING_MAINTENANCE_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPendingMaintenanceActionResponse, T> g) {
        return obj -> g.apply((GetPendingMaintenanceActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbElasticResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPendingMaintenanceActionResponse> {
        /**
         * <p>
         * Provides information about a pending maintenance action for a resource.
         * </p>
         * 
         * @param resourcePendingMaintenanceAction
         *        Provides information about a pending maintenance action for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePendingMaintenanceAction(ResourcePendingMaintenanceAction resourcePendingMaintenanceAction);

        /**
         * <p>
         * Provides information about a pending maintenance action for a resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourcePendingMaintenanceAction.Builder}
         * avoiding the need to create one manually via {@link ResourcePendingMaintenanceAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourcePendingMaintenanceAction.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #resourcePendingMaintenanceAction(ResourcePendingMaintenanceAction)}.
         * 
         * @param resourcePendingMaintenanceAction
         *        a consumer that will call methods on {@link ResourcePendingMaintenanceAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcePendingMaintenanceAction(ResourcePendingMaintenanceAction)
         */
        default Builder resourcePendingMaintenanceAction(
                Consumer<ResourcePendingMaintenanceAction.Builder> resourcePendingMaintenanceAction) {
            return resourcePendingMaintenanceAction(ResourcePendingMaintenanceAction.builder()
                    .applyMutation(resourcePendingMaintenanceAction).build());
        }
    }

    static final class BuilderImpl extends DocDbElasticResponse.BuilderImpl implements Builder {
        private ResourcePendingMaintenanceAction resourcePendingMaintenanceAction;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPendingMaintenanceActionResponse model) {
            super(model);
            resourcePendingMaintenanceAction(model.resourcePendingMaintenanceAction);
        }

        public final ResourcePendingMaintenanceAction.Builder getResourcePendingMaintenanceAction() {
            return resourcePendingMaintenanceAction != null ? resourcePendingMaintenanceAction.toBuilder() : null;
        }

        public final void setResourcePendingMaintenanceAction(
                ResourcePendingMaintenanceAction.BuilderImpl resourcePendingMaintenanceAction) {
            this.resourcePendingMaintenanceAction = resourcePendingMaintenanceAction != null ? resourcePendingMaintenanceAction
                    .build() : null;
        }

        @Override
        public final Builder resourcePendingMaintenanceAction(ResourcePendingMaintenanceAction resourcePendingMaintenanceAction) {
            this.resourcePendingMaintenanceAction = resourcePendingMaintenanceAction;
            return this;
        }

        @Override
        public GetPendingMaintenanceActionResponse build() {
            return new GetPendingMaintenanceActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
