/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPendingMaintenanceActionsResponse extends DocDbElasticResponse implements
        ToCopyableBuilder<ListPendingMaintenanceActionsResponse.Builder, ListPendingMaintenanceActionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPendingMaintenanceActionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ResourcePendingMaintenanceAction>> RESOURCE_PENDING_MAINTENANCE_ACTIONS_FIELD = SdkField
            .<List<ResourcePendingMaintenanceAction>> builder(MarshallingType.LIST)
            .memberName("resourcePendingMaintenanceActions")
            .getter(getter(ListPendingMaintenanceActionsResponse::resourcePendingMaintenanceActions))
            .setter(setter(Builder::resourcePendingMaintenanceActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcePendingMaintenanceActions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePendingMaintenanceAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePendingMaintenanceAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESOURCE_PENDING_MAINTENANCE_ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ResourcePendingMaintenanceAction> resourcePendingMaintenanceActions;

    private ListPendingMaintenanceActionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resourcePendingMaintenanceActions = builder.resourcePendingMaintenanceActions;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is displayed, the responses will
     * include only records beyond the marker, up to the value specified by <code>maxResults</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is displayed, the
     *         responses will include only records beyond the marker, up to the value specified by
     *         <code>maxResults</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourcePendingMaintenanceActions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasResourcePendingMaintenanceActions() {
        return resourcePendingMaintenanceActions != null && !(resourcePendingMaintenanceActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information about a pending maintenance action for a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourcePendingMaintenanceActions}
     * method.
     * </p>
     * 
     * @return Provides information about a pending maintenance action for a resource.
     */
    public final List<ResourcePendingMaintenanceAction> resourcePendingMaintenanceActions() {
        return resourcePendingMaintenanceActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasResourcePendingMaintenanceActions() ? resourcePendingMaintenanceActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPendingMaintenanceActionsResponse)) {
            return false;
        }
        ListPendingMaintenanceActionsResponse other = (ListPendingMaintenanceActionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasResourcePendingMaintenanceActions() == other.hasResourcePendingMaintenanceActions()
                && Objects.equals(resourcePendingMaintenanceActions(), other.resourcePendingMaintenanceActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListPendingMaintenanceActionsResponse")
                .add("NextToken", nextToken())
                .add("ResourcePendingMaintenanceActions",
                        hasResourcePendingMaintenanceActions() ? resourcePendingMaintenanceActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "resourcePendingMaintenanceActions":
            return Optional.ofNullable(clazz.cast(resourcePendingMaintenanceActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("resourcePendingMaintenanceActions", RESOURCE_PENDING_MAINTENANCE_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPendingMaintenanceActionsResponse, T> g) {
        return obj -> g.apply((ListPendingMaintenanceActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbElasticResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPendingMaintenanceActionsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is displayed, the responses
         * will include only records beyond the marker, up to the value specified by <code>maxResults</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous request. If this parameter is displayed, the
         *        responses will include only records beyond the marker, up to the value specified by
         *        <code>maxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Provides information about a pending maintenance action for a resource.
         * </p>
         * 
         * @param resourcePendingMaintenanceActions
         *        Provides information about a pending maintenance action for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePendingMaintenanceActions(Collection<ResourcePendingMaintenanceAction> resourcePendingMaintenanceActions);

        /**
         * <p>
         * Provides information about a pending maintenance action for a resource.
         * </p>
         * 
         * @param resourcePendingMaintenanceActions
         *        Provides information about a pending maintenance action for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePendingMaintenanceActions(ResourcePendingMaintenanceAction... resourcePendingMaintenanceActions);

        /**
         * <p>
         * Provides information about a pending maintenance action for a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.docdbelastic.model.ResourcePendingMaintenanceAction.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.docdbelastic.model.ResourcePendingMaintenanceAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.docdbelastic.model.ResourcePendingMaintenanceAction.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #resourcePendingMaintenanceActions(List<ResourcePendingMaintenanceAction>)}.
         * 
         * @param resourcePendingMaintenanceActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.docdbelastic.model.ResourcePendingMaintenanceAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcePendingMaintenanceActions(java.util.Collection<ResourcePendingMaintenanceAction>)
         */
        Builder resourcePendingMaintenanceActions(
                Consumer<ResourcePendingMaintenanceAction.Builder>... resourcePendingMaintenanceActions);
    }

    static final class BuilderImpl extends DocDbElasticResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ResourcePendingMaintenanceAction> resourcePendingMaintenanceActions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPendingMaintenanceActionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            resourcePendingMaintenanceActions(model.resourcePendingMaintenanceActions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResourcePendingMaintenanceAction.Builder> getResourcePendingMaintenanceActions() {
            List<ResourcePendingMaintenanceAction.Builder> result = ResourcePendingMaintenanceActionListCopier
                    .copyToBuilder(this.resourcePendingMaintenanceActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcePendingMaintenanceActions(
                Collection<ResourcePendingMaintenanceAction.BuilderImpl> resourcePendingMaintenanceActions) {
            this.resourcePendingMaintenanceActions = ResourcePendingMaintenanceActionListCopier
                    .copyFromBuilder(resourcePendingMaintenanceActions);
        }

        @Override
        public final Builder resourcePendingMaintenanceActions(
                Collection<ResourcePendingMaintenanceAction> resourcePendingMaintenanceActions) {
            this.resourcePendingMaintenanceActions = ResourcePendingMaintenanceActionListCopier
                    .copy(resourcePendingMaintenanceActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePendingMaintenanceActions(
                ResourcePendingMaintenanceAction... resourcePendingMaintenanceActions) {
            resourcePendingMaintenanceActions(Arrays.asList(resourcePendingMaintenanceActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePendingMaintenanceActions(
                Consumer<ResourcePendingMaintenanceAction.Builder>... resourcePendingMaintenanceActions) {
            resourcePendingMaintenanceActions(Stream.of(resourcePendingMaintenanceActions)
                    .map(c -> ResourcePendingMaintenanceAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPendingMaintenanceActionsResponse build() {
            return new ListPendingMaintenanceActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
