/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieves the details of maintenance actions that are pending.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingMaintenanceActionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingMaintenanceActionDetails.Builder, PendingMaintenanceActionDetails> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(PendingMaintenanceActionDetails::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> AUTO_APPLIED_AFTER_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autoAppliedAfterDate").getter(getter(PendingMaintenanceActionDetails::autoAppliedAfterDate))
            .setter(setter(Builder::autoAppliedAfterDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoAppliedAfterDate").build())
            .build();

    private static final SdkField<String> CURRENT_APPLY_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentApplyDate").getter(getter(PendingMaintenanceActionDetails::currentApplyDate))
            .setter(setter(Builder::currentApplyDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentApplyDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PendingMaintenanceActionDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FORCED_APPLY_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("forcedApplyDate").getter(getter(PendingMaintenanceActionDetails::forcedApplyDate))
            .setter(setter(Builder::forcedApplyDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forcedApplyDate").build()).build();

    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("optInStatus").getter(getter(PendingMaintenanceActionDetails::optInStatus))
            .setter(setter(Builder::optInStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optInStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            AUTO_APPLIED_AFTER_DATE_FIELD, CURRENT_APPLY_DATE_FIELD, DESCRIPTION_FIELD, FORCED_APPLY_DATE_FIELD,
            OPT_IN_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String autoAppliedAfterDate;

    private final String currentApplyDate;

    private final String description;

    private final String forcedApplyDate;

    private final String optInStatus;

    private PendingMaintenanceActionDetails(BuilderImpl builder) {
        this.action = builder.action;
        this.autoAppliedAfterDate = builder.autoAppliedAfterDate;
        this.currentApplyDate = builder.currentApplyDate;
        this.description = builder.description;
        this.forcedApplyDate = builder.forcedApplyDate;
        this.optInStatus = builder.optInStatus;
    }

    /**
     * <p>
     * Displays the specific action of a pending maintenance action.
     * </p>
     * 
     * @return Displays the specific action of a pending maintenance action.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * Displays the date of the maintenance window when the action is applied. The maintenance action is applied to the
     * resource during its first maintenance window after this date. If this date is specified, any
     * <code>NEXT_MAINTENANCE</code> <code>optInType</code> requests are ignored.
     * </p>
     * 
     * @return Displays the date of the maintenance window when the action is applied. The maintenance action is applied
     *         to the resource during its first maintenance window after this date. If this date is specified, any
     *         <code>NEXT_MAINTENANCE</code> <code>optInType</code> requests are ignored.
     */
    public final String autoAppliedAfterDate() {
        return autoAppliedAfterDate;
    }

    /**
     * <p>
     * Displays the effective date when the pending maintenance action is applied to the resource.
     * </p>
     * 
     * @return Displays the effective date when the pending maintenance action is applied to the resource.
     */
    public final String currentApplyDate() {
        return currentApplyDate;
    }

    /**
     * <p>
     * Displays a description providing more detail about the maintenance action.
     * </p>
     * 
     * @return Displays a description providing more detail about the maintenance action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Displays the date when the maintenance action is automatically applied. The maintenance action is applied to the
     * resource on this date regardless of the maintenance window for the resource. If this date is specified, any
     * <code>IMMEDIATE</code> <code>optInType</code> requests are ignored.
     * </p>
     * 
     * @return Displays the date when the maintenance action is automatically applied. The maintenance action is applied
     *         to the resource on this date regardless of the maintenance window for the resource. If this date is
     *         specified, any <code>IMMEDIATE</code> <code>optInType</code> requests are ignored.
     */
    public final String forcedApplyDate() {
        return forcedApplyDate;
    }

    /**
     * <p>
     * Displays the type of <code>optInType</code> request that has been received for the resource.
     * </p>
     * 
     * @return Displays the type of <code>optInType</code> request that has been received for the resource.
     */
    public final String optInStatus() {
        return optInStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(autoAppliedAfterDate());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplyDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(forcedApplyDate());
        hashCode = 31 * hashCode + Objects.hashCode(optInStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingMaintenanceActionDetails)) {
            return false;
        }
        PendingMaintenanceActionDetails other = (PendingMaintenanceActionDetails) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(autoAppliedAfterDate(), other.autoAppliedAfterDate())
                && Objects.equals(currentApplyDate(), other.currentApplyDate())
                && Objects.equals(description(), other.description())
                && Objects.equals(forcedApplyDate(), other.forcedApplyDate())
                && Objects.equals(optInStatus(), other.optInStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingMaintenanceActionDetails").add("Action", action())
                .add("AutoAppliedAfterDate", autoAppliedAfterDate()).add("CurrentApplyDate", currentApplyDate())
                .add("Description", description()).add("ForcedApplyDate", forcedApplyDate()).add("OptInStatus", optInStatus())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "autoAppliedAfterDate":
            return Optional.ofNullable(clazz.cast(autoAppliedAfterDate()));
        case "currentApplyDate":
            return Optional.ofNullable(clazz.cast(currentApplyDate()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "forcedApplyDate":
            return Optional.ofNullable(clazz.cast(forcedApplyDate()));
        case "optInStatus":
            return Optional.ofNullable(clazz.cast(optInStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("autoAppliedAfterDate", AUTO_APPLIED_AFTER_DATE_FIELD);
        map.put("currentApplyDate", CURRENT_APPLY_DATE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("forcedApplyDate", FORCED_APPLY_DATE_FIELD);
        map.put("optInStatus", OPT_IN_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PendingMaintenanceActionDetails, T> g) {
        return obj -> g.apply((PendingMaintenanceActionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingMaintenanceActionDetails> {
        /**
         * <p>
         * Displays the specific action of a pending maintenance action.
         * </p>
         * 
         * @param action
         *        Displays the specific action of a pending maintenance action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * Displays the date of the maintenance window when the action is applied. The maintenance action is applied to
         * the resource during its first maintenance window after this date. If this date is specified, any
         * <code>NEXT_MAINTENANCE</code> <code>optInType</code> requests are ignored.
         * </p>
         * 
         * @param autoAppliedAfterDate
         *        Displays the date of the maintenance window when the action is applied. The maintenance action is
         *        applied to the resource during its first maintenance window after this date. If this date is
         *        specified, any <code>NEXT_MAINTENANCE</code> <code>optInType</code> requests are ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAppliedAfterDate(String autoAppliedAfterDate);

        /**
         * <p>
         * Displays the effective date when the pending maintenance action is applied to the resource.
         * </p>
         * 
         * @param currentApplyDate
         *        Displays the effective date when the pending maintenance action is applied to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplyDate(String currentApplyDate);

        /**
         * <p>
         * Displays a description providing more detail about the maintenance action.
         * </p>
         * 
         * @param description
         *        Displays a description providing more detail about the maintenance action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Displays the date when the maintenance action is automatically applied. The maintenance action is applied to
         * the resource on this date regardless of the maintenance window for the resource. If this date is specified,
         * any <code>IMMEDIATE</code> <code>optInType</code> requests are ignored.
         * </p>
         * 
         * @param forcedApplyDate
         *        Displays the date when the maintenance action is automatically applied. The maintenance action is
         *        applied to the resource on this date regardless of the maintenance window for the resource. If this
         *        date is specified, any <code>IMMEDIATE</code> <code>optInType</code> requests are ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forcedApplyDate(String forcedApplyDate);

        /**
         * <p>
         * Displays the type of <code>optInType</code> request that has been received for the resource.
         * </p>
         * 
         * @param optInStatus
         *        Displays the type of <code>optInType</code> request that has been received for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optInStatus(String optInStatus);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String autoAppliedAfterDate;

        private String currentApplyDate;

        private String description;

        private String forcedApplyDate;

        private String optInStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingMaintenanceActionDetails model) {
            action(model.action);
            autoAppliedAfterDate(model.autoAppliedAfterDate);
            currentApplyDate(model.currentApplyDate);
            description(model.description);
            forcedApplyDate(model.forcedApplyDate);
            optInStatus(model.optInStatus);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getAutoAppliedAfterDate() {
            return autoAppliedAfterDate;
        }

        public final void setAutoAppliedAfterDate(String autoAppliedAfterDate) {
            this.autoAppliedAfterDate = autoAppliedAfterDate;
        }

        @Override
        public final Builder autoAppliedAfterDate(String autoAppliedAfterDate) {
            this.autoAppliedAfterDate = autoAppliedAfterDate;
            return this;
        }

        public final String getCurrentApplyDate() {
            return currentApplyDate;
        }

        public final void setCurrentApplyDate(String currentApplyDate) {
            this.currentApplyDate = currentApplyDate;
        }

        @Override
        public final Builder currentApplyDate(String currentApplyDate) {
            this.currentApplyDate = currentApplyDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getForcedApplyDate() {
            return forcedApplyDate;
        }

        public final void setForcedApplyDate(String forcedApplyDate) {
            this.forcedApplyDate = forcedApplyDate;
        }

        @Override
        public final Builder forcedApplyDate(String forcedApplyDate) {
            this.forcedApplyDate = forcedApplyDate;
            return this;
        }

        public final String getOptInStatus() {
            return optInStatus;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        @Override
        public PendingMaintenanceActionDetails build() {
            return new PendingMaintenanceActionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
