/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterRequest extends DocDbElasticRequest implements
        ToCopyableBuilder<UpdateClusterRequest.Builder, UpdateClusterRequest> {
    private static final SdkField<String> ADMIN_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminUserPassword").getter(getter(UpdateClusterRequest::adminUserPassword))
            .setter(setter(Builder::adminUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUserPassword").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(UpdateClusterRequest::authTypeAsString)).setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("backupRetentionPeriod").getter(getter(UpdateClusterRequest::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupRetentionPeriod").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateClusterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(UpdateClusterRequest::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("preferredBackupWindow").getter(getter(UpdateClusterRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("preferredMaintenanceWindow")
            .getter(getter(UpdateClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Integer> SHARD_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shardCapacity").getter(getter(UpdateClusterRequest::shardCapacity))
            .setter(setter(Builder::shardCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardCapacity").build()).build();

    private static final SdkField<Integer> SHARD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shardCount").getter(getter(UpdateClusterRequest::shardCount)).setter(setter(Builder::shardCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardCount").build()).build();

    private static final SdkField<Integer> SHARD_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shardInstanceCount").getter(getter(UpdateClusterRequest::shardInstanceCount))
            .setter(setter(Builder::shardInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardInstanceCount").build())
            .build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(UpdateClusterRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcSecurityGroupIds")
            .getter(getter(UpdateClusterRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USER_PASSWORD_FIELD,
            AUTH_TYPE_FIELD, BACKUP_RETENTION_PERIOD_FIELD, CLIENT_TOKEN_FIELD, CLUSTER_ARN_FIELD, PREFERRED_BACKUP_WINDOW_FIELD,
            PREFERRED_MAINTENANCE_WINDOW_FIELD, SHARD_CAPACITY_FIELD, SHARD_COUNT_FIELD, SHARD_INSTANCE_COUNT_FIELD,
            SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String adminUserPassword;

    private final String authType;

    private final Integer backupRetentionPeriod;

    private final String clientToken;

    private final String clusterArn;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Integer shardCapacity;

    private final Integer shardCount;

    private final Integer shardInstanceCount;

    private final List<String> subnetIds;

    private final List<String> vpcSecurityGroupIds;

    private UpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.adminUserPassword = builder.adminUserPassword;
        this.authType = builder.authType;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.clientToken = builder.clientToken;
        this.clusterArn = builder.clusterArn;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.shardCapacity = builder.shardCapacity;
        this.shardCount = builder.shardCount;
        this.shardInstanceCount = builder.shardInstanceCount;
        this.subnetIds = builder.subnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The password associated with the elastic cluster administrator. This password can contain any printable ASCII
     * character except forward slash (/), double quote ("), or the "at" symbol (@).
     * </p>
     * <p>
     * <i>Constraints</i>: Must contain from 8 to 100 characters.
     * </p>
     * 
     * @return The password associated with the elastic cluster administrator. This password can contain any printable
     *         ASCII character except forward slash (/), double quote ("), or the "at" symbol (@).</p>
     *         <p>
     *         <i>Constraints</i>: Must contain from 8 to 100 characters.
     */
    public final String adminUserPassword() {
        return adminUserPassword;
    }

    /**
     * <p>
     * The authentication type used to determine where to fetch the password used for accessing the elastic cluster.
     * Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link Auth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type used to determine where to fetch the password used for accessing the elastic
     *         cluster. Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
     * @see Auth
     */
    public final Auth authType() {
        return Auth.fromValue(authType);
    }

    /**
     * <p>
     * The authentication type used to determine where to fetch the password used for accessing the elastic cluster.
     * Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link Auth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type used to determine where to fetch the password used for accessing the elastic
     *         cluster. Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
     * @see Auth
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The number of days for which automatic snapshots are retained.
     * </p>
     * 
     * @return The number of days for which automatic snapshots are retained.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The client token for the elastic cluster.
     * </p>
     * 
     * @return The client token for the elastic cluster.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ARN identifier of the elastic cluster.
     * </p>
     * 
     * @return The ARN identifier of the elastic cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created if automated backups are enabled, as determined
     * by the <code>backupRetentionPeriod</code>.
     * </p>
     * 
     * @return The daily time range during which automated backups are created if automated backups are enabled, as
     *         determined by the <code>backupRetentionPeriod</code>.
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * </p>
     * <p>
     * <i>Default</i>: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services
     * Region, occurring on a random day of the week.
     * </p>
     * <p>
     * <i>Valid days</i>: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * </p>
     * <p>
     * <i>Constraints</i>: Minimum 30-minute window.
     * </p>
     * 
     * @return The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
     *         <p>
     *         <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     *         </p>
     *         <p>
     *         <i>Default</i>: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
     *         Services Region, occurring on a random day of the week.
     *         </p>
     *         <p>
     *         <i>Valid days</i>: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     *         </p>
     *         <p>
     *         <i>Constraints</i>: Minimum 30-minute window.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32,
     * 64.
     * </p>
     * 
     * @return The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8,
     *         16, 32, 64.
     */
    public final Integer shardCapacity() {
        return shardCapacity;
    }

    /**
     * <p>
     * The number of shards assigned to the elastic cluster. Maximum is 32.
     * </p>
     * 
     * @return The number of shards assigned to the elastic cluster. Maximum is 32.
     */
    public final Integer shardCount() {
        return shardCount;
    }

    /**
     * <p>
     * The number of replica instances applying to all shards in the elastic cluster. A <code>shardInstanceCount</code>
     * value of 1 means there is one writer instance, and any additional instances are replicas that can be used for
     * reads and to improve availability.
     * </p>
     * 
     * @return The number of replica instances applying to all shards in the elastic cluster. A
     *         <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional
     *         instances are replicas that can be used for reads and to improve availability.
     */
    public final Integer shardInstanceCount() {
        return shardInstanceCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 subnet IDs for the elastic cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The Amazon EC2 subnet IDs for the elastic cluster.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 VPC security groups to associate with the elastic cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of EC2 VPC security groups to associate with the elastic cluster.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adminUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(shardCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(shardCount());
        hashCode = 31 * hashCode + Objects.hashCode(shardInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest) obj;
        return Objects.equals(adminUserPassword(), other.adminUserPassword())
                && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(shardCapacity(), other.shardCapacity()) && Objects.equals(shardCount(), other.shardCount())
                && Objects.equals(shardInstanceCount(), other.shardInstanceCount()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterRequest")
                .add("AdminUserPassword", adminUserPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AuthType", authTypeAsString()).add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("ClientToken", clientToken()).add("ClusterArn", clusterArn())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("ShardCapacity", shardCapacity())
                .add("ShardCount", shardCount()).add("ShardInstanceCount", shardInstanceCount())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adminUserPassword":
            return Optional.ofNullable(clazz.cast(adminUserPassword()));
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "backupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "preferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "preferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "shardCapacity":
            return Optional.ofNullable(clazz.cast(shardCapacity()));
        case "shardCount":
            return Optional.ofNullable(clazz.cast(shardCount()));
        case "shardInstanceCount":
            return Optional.ofNullable(clazz.cast(shardInstanceCount()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "vpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("adminUserPassword", ADMIN_USER_PASSWORD_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("backupRetentionPeriod", BACKUP_RETENTION_PERIOD_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("preferredBackupWindow", PREFERRED_BACKUP_WINDOW_FIELD);
        map.put("preferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("shardCapacity", SHARD_CAPACITY_FIELD);
        map.put("shardCount", SHARD_COUNT_FIELD);
        map.put("shardInstanceCount", SHARD_INSTANCE_COUNT_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("vpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterRequest, T> g) {
        return obj -> g.apply((UpdateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbElasticRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterRequest> {
        /**
         * <p>
         * The password associated with the elastic cluster administrator. This password can contain any printable ASCII
         * character except forward slash (/), double quote ("), or the "at" symbol (@).
         * </p>
         * <p>
         * <i>Constraints</i>: Must contain from 8 to 100 characters.
         * </p>
         * 
         * @param adminUserPassword
         *        The password associated with the elastic cluster administrator. This password can contain any
         *        printable ASCII character except forward slash (/), double quote ("), or the "at" symbol (@).</p>
         *        <p>
         *        <i>Constraints</i>: Must contain from 8 to 100 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUserPassword(String adminUserPassword);

        /**
         * <p>
         * The authentication type used to determine where to fetch the password used for accessing the elastic cluster.
         * Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
         * </p>
         * 
         * @param authType
         *        The authentication type used to determine where to fetch the password used for accessing the elastic
         *        cluster. Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
         * @see Auth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Auth
         */
        Builder authType(String authType);

        /**
         * <p>
         * The authentication type used to determine where to fetch the password used for accessing the elastic cluster.
         * Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
         * </p>
         * 
         * @param authType
         *        The authentication type used to determine where to fetch the password used for accessing the elastic
         *        cluster. Valid types are <code>PLAIN_TEXT</code> or <code>SECRET_ARN</code>.
         * @see Auth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Auth
         */
        Builder authType(Auth authType);

        /**
         * <p>
         * The number of days for which automatic snapshots are retained.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which automatic snapshots are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The client token for the elastic cluster.
         * </p>
         * 
         * @param clientToken
         *        The client token for the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ARN identifier of the elastic cluster.
         * </p>
         * 
         * @param clusterArn
         *        The ARN identifier of the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The daily time range during which automated backups are created if automated backups are enabled, as
         * determined by the <code>backupRetentionPeriod</code>.
         * </p>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created if automated backups are enabled, as
         *        determined by the <code>backupRetentionPeriod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * </p>
         * <p>
         * <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * </p>
         * <p>
         * <i>Default</i>: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         * Services Region, occurring on a random day of the week.
         * </p>
         * <p>
         * <i>Valid days</i>: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * </p>
         * <p>
         * <i>Constraints</i>: Minimum 30-minute window.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur, in Universal Coordinated Time
         *        (UTC).</p>
         *        <p>
         *        <i>Format</i>: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *        </p>
         *        <p>
         *        <i>Default</i>: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
         *        Services Region, occurring on a random day of the week.
         *        </p>
         *        <p>
         *        <i>Valid days</i>: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         *        </p>
         *        <p>
         *        <i>Constraints</i>: Minimum 30-minute window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16,
         * 32, 64.
         * </p>
         * 
         * @param shardCapacity
         *        The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8,
         *        16, 32, 64.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardCapacity(Integer shardCapacity);

        /**
         * <p>
         * The number of shards assigned to the elastic cluster. Maximum is 32.
         * </p>
         * 
         * @param shardCount
         *        The number of shards assigned to the elastic cluster. Maximum is 32.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardCount(Integer shardCount);

        /**
         * <p>
         * The number of replica instances applying to all shards in the elastic cluster. A
         * <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional instances
         * are replicas that can be used for reads and to improve availability.
         * </p>
         * 
         * @param shardInstanceCount
         *        The number of replica instances applying to all shards in the elastic cluster. A
         *        <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional
         *        instances are replicas that can be used for reads and to improve availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardInstanceCount(Integer shardInstanceCount);

        /**
         * <p>
         * The Amazon EC2 subnet IDs for the elastic cluster.
         * </p>
         * 
         * @param subnetIds
         *        The Amazon EC2 subnet IDs for the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The Amazon EC2 subnet IDs for the elastic cluster.
         * </p>
         * 
         * @param subnetIds
         *        The Amazon EC2 subnet IDs for the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with the elastic cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with the elastic cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbElasticRequest.BuilderImpl implements Builder {
        private String adminUserPassword;

        private String authType;

        private Integer backupRetentionPeriod;

        private String clientToken;

        private String clusterArn;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Integer shardCapacity;

        private Integer shardCount;

        private Integer shardInstanceCount;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            super(model);
            adminUserPassword(model.adminUserPassword);
            authType(model.authType);
            backupRetentionPeriod(model.backupRetentionPeriod);
            clientToken(model.clientToken);
            clusterArn(model.clusterArn);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            shardCapacity(model.shardCapacity);
            shardCount(model.shardCount);
            shardInstanceCount(model.shardInstanceCount);
            subnetIds(model.subnetIds);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getAdminUserPassword() {
            return adminUserPassword;
        }

        public final void setAdminUserPassword(String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
        }

        @Override
        public final Builder adminUserPassword(String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(Auth authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Integer getShardCapacity() {
            return shardCapacity;
        }

        public final void setShardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
        }

        @Override
        public final Builder shardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
            return this;
        }

        public final Integer getShardCount() {
            return shardCount;
        }

        public final void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        @Override
        public final Builder shardCount(Integer shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public final Integer getShardInstanceCount() {
            return shardInstanceCount;
        }

        public final void setShardInstanceCount(Integer shardInstanceCount) {
            this.shardInstanceCount = shardInstanceCount;
        }

        @Override
        public final Builder shardInstanceCount(Integer shardInstanceCount) {
            this.shardInstanceCount = shardInstanceCount;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
