/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.docdbelastic.model.AccessDeniedException;
import software.amazon.awssdk.services.docdbelastic.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.docdbelastic.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.docdbelastic.model.ConflictException;
import software.amazon.awssdk.services.docdbelastic.model.CopyClusterSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.CopyClusterSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.DocDbElasticException;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.GetPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.docdbelastic.model.GetPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.docdbelastic.model.InternalServerException;
import software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsResponse;
import software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListClustersResponse;
import software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.docdbelastic.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.docdbelastic.model.ResourceNotFoundException;
import software.amazon.awssdk.services.docdbelastic.model.RestoreClusterFromSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.RestoreClusterFromSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.docdbelastic.model.StartClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.StartClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.StopClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.StopClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.TagResourceRequest;
import software.amazon.awssdk.services.docdbelastic.model.TagResourceResponse;
import software.amazon.awssdk.services.docdbelastic.model.ThrottlingException;
import software.amazon.awssdk.services.docdbelastic.model.UntagResourceRequest;
import software.amazon.awssdk.services.docdbelastic.model.UntagResourceResponse;
import software.amazon.awssdk.services.docdbelastic.model.UpdateClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.UpdateClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.ValidationException;
import software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsIterable;
import software.amazon.awssdk.services.docdbelastic.paginators.ListClustersIterable;
import software.amazon.awssdk.services.docdbelastic.paginators.ListPendingMaintenanceActionsIterable;

/**
 * Service client for accessing DocDB Elastic. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * <fullname>Amazon DocumentDB elastic clusters</fullname>
 * <p>
 * Amazon DocumentDB elastic-clusters support workloads with millions of reads/writes per second and petabytes of
 * storage capacity. Amazon DocumentDB elastic clusters also simplify how developers interact with Amazon DocumentDB
 * elastic-clusters by eliminating the need to choose, manage or upgrade instances.
 * </p>
 * <p>
 * Amazon DocumentDB elastic-clusters were created to:
 * </p>
 * <ul>
 * <li>
 * <p>
 * provide a solution for customers looking for a database that provides virtually limitless scale with rich query
 * capabilities and MongoDB API compatibility.
 * </p>
 * </li>
 * <li>
 * <p>
 * give customers higher connection limits, and to reduce downtime from patching.
 * </p>
 * </li>
 * <li>
 * <p>
 * continue investing in a cloud-native, elastic, and class leading architecture for JSON workloads.
 * </p>
 * </li>
 * </ul>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DocDbElasticClient extends AwsClient {
    String SERVICE_NAME = "docdb-elastic";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "docdb-elastic";

    /**
     * <p>
     * The type of pending maintenance action to be applied to the resource.
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The type of pending maintenance action to be applied to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyPendingMaintenanceActionRequest.Builder}
     * avoiding the need to create one manually via {@link ApplyPendingMaintenanceActionRequest#builder()}
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ApplyPendingMaintenanceActionRequest.Builder} to
     *        create a request.
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            Consumer<ApplyPendingMaintenanceActionRequest.Builder> applyPendingMaintenanceActionRequest)
            throws ThrottlingException, ValidationException, ConflictException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        return applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.builder()
                .applyMutation(applyPendingMaintenanceActionRequest).build());
    }

    /**
     * <p>
     * Copies a snapshot of an elastic cluster.
     * </p>
     *
     * @param copyClusterSnapshotRequest
     * @return Result of the CopyClusterSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ServiceQuotaExceededException
     *         The service quota for the action was exceeded.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.CopyClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CopyClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CopyClusterSnapshotResponse copyClusterSnapshot(CopyClusterSnapshotRequest copyClusterSnapshotRequest)
            throws ThrottlingException, ValidationException, ServiceQuotaExceededException, ConflictException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a snapshot of an elastic cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CopyClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param copyClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.CopyClusterSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the CopyClusterSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ServiceQuotaExceededException
     *         The service quota for the action was exceeded.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.CopyClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CopyClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CopyClusterSnapshotResponse copyClusterSnapshot(
            Consumer<CopyClusterSnapshotRequest.Builder> copyClusterSnapshotRequest) throws ThrottlingException,
            ValidationException, ServiceQuotaExceededException, ConflictException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        return copyClusterSnapshot(CopyClusterSnapshotRequest.builder().applyMutation(copyClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon DocumentDB elastic cluster and returns its cluster structure.
     * </p>
     *
     * @param createClusterRequest
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ServiceQuotaExceededException
     *         The service quota for the action was exceeded.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ThrottlingException,
            ValidationException, ServiceQuotaExceededException, ConflictException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon DocumentDB elastic cluster and returns its cluster structure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.CreateClusterRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ServiceQuotaExceededException
     *         The service quota for the action was exceeded.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest)
            throws ThrottlingException, ValidationException, ServiceQuotaExceededException, ConflictException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of an elastic cluster.
     * </p>
     *
     * @param createClusterSnapshotRequest
     * @return Result of the CreateClusterSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ServiceQuotaExceededException
     *         The service quota for the action was exceeded.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.CreateClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterSnapshotResponse createClusterSnapshot(CreateClusterSnapshotRequest createClusterSnapshotRequest)
            throws ThrottlingException, ValidationException, ServiceQuotaExceededException, ConflictException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of an elastic cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param createClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.CreateClusterSnapshotRequest.Builder} to create
     *        a request.
     * @return Result of the CreateClusterSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ServiceQuotaExceededException
     *         The service quota for the action was exceeded.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.CreateClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterSnapshotResponse createClusterSnapshot(
            Consumer<CreateClusterSnapshotRequest.Builder> createClusterSnapshotRequest) throws ThrottlingException,
            ValidationException, ServiceQuotaExceededException, ConflictException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        return createClusterSnapshot(CreateClusterSnapshotRequest.builder().applyMutation(createClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Delete an elastic cluster.
     * </p>
     *
     * @param deleteClusterRequest
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an elastic cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.DeleteClusterRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest)
            throws ThrottlingException, ValidationException, ConflictException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Delete an elastic cluster snapshot.
     * </p>
     *
     * @param deleteClusterSnapshotRequest
     * @return Result of the DeleteClusterSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.DeleteClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterSnapshotResponse deleteClusterSnapshot(DeleteClusterSnapshotRequest deleteClusterSnapshotRequest)
            throws ThrottlingException, ValidationException, ConflictException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an elastic cluster snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.DeleteClusterSnapshotRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteClusterSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.DeleteClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterSnapshotResponse deleteClusterSnapshot(
            Consumer<DeleteClusterSnapshotRequest.Builder> deleteClusterSnapshotRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, DocDbElasticException {
        return deleteClusterSnapshot(DeleteClusterSnapshotRequest.builder().applyMutation(deleteClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific elastic cluster.
     * </p>
     *
     * @param getClusterRequest
     * @return Result of the GetCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.GetCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClusterResponse getCluster(GetClusterRequest getClusterRequest) throws ThrottlingException, ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific elastic cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClusterRequest.Builder} avoiding the need to
     * create one manually via {@link GetClusterRequest#builder()}
     * </p>
     *
     * @param getClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.GetClusterRequest.Builder} to create a request.
     * @return Result of the GetCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.GetCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClusterResponse getCluster(Consumer<GetClusterRequest.Builder> getClusterRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, DocDbElasticException {
        return getCluster(GetClusterRequest.builder().applyMutation(getClusterRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific elastic cluster snapshot
     * </p>
     *
     * @param getClusterSnapshotRequest
     * @return Result of the GetClusterSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.GetClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetClusterSnapshotResponse getClusterSnapshot(GetClusterSnapshotRequest getClusterSnapshotRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific elastic cluster snapshot
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link GetClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param getClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.GetClusterSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the GetClusterSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.GetClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetClusterSnapshotResponse getClusterSnapshot(Consumer<GetClusterSnapshotRequest.Builder> getClusterSnapshotRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        return getClusterSnapshot(GetClusterSnapshotRequest.builder().applyMutation(getClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Retrieves all maintenance actions that are pending.
     * </p>
     *
     * @param getPendingMaintenanceActionRequest
     * @return Result of the GetPendingMaintenanceAction operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.GetPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPendingMaintenanceActionResponse getPendingMaintenanceAction(
            GetPendingMaintenanceActionRequest getPendingMaintenanceActionRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all maintenance actions that are pending.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPendingMaintenanceActionRequest.Builder}
     * avoiding the need to create one manually via {@link GetPendingMaintenanceActionRequest#builder()}
     * </p>
     *
     * @param getPendingMaintenanceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.GetPendingMaintenanceActionRequest.Builder} to
     *        create a request.
     * @return Result of the GetPendingMaintenanceAction operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.GetPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPendingMaintenanceActionResponse getPendingMaintenanceAction(
            Consumer<GetPendingMaintenanceActionRequest.Builder> getPendingMaintenanceActionRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, DocDbElasticException {
        return getPendingMaintenanceAction(GetPendingMaintenanceActionRequest.builder()
                .applyMutation(getPendingMaintenanceActionRequest).build());
    }

    /**
     * <p>
     * Returns information about snapshots for a specified elastic cluster.
     * </p>
     *
     * @param listClusterSnapshotsRequest
     * @return Result of the ListClusterSnapshots operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClusterSnapshotsResponse listClusterSnapshots(ListClusterSnapshotsRequest listClusterSnapshotsRequest)
            throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about snapshots for a specified elastic cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link ListClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param listClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest.Builder} to create a
     *        request.
     * @return Result of the ListClusterSnapshots operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClusterSnapshotsResponse listClusterSnapshots(
            Consumer<ListClusterSnapshotsRequest.Builder> listClusterSnapshotsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        return listClusterSnapshots(ListClusterSnapshotsRequest.builder().applyMutation(listClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterSnapshots(software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsIterable responses = client.listClusterSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsIterable responses = client
     *             .listClusterSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsIterable responses = client.listClusterSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterSnapshots(software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClusterSnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClusterSnapshotsIterable listClusterSnapshotsPaginator(ListClusterSnapshotsRequest listClusterSnapshotsRequest)
            throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, DocDbElasticException {
        return new ListClusterSnapshotsIterable(this, listClusterSnapshotsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterSnapshots(software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsIterable responses = client.listClusterSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsIterable responses = client
     *             .listClusterSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsIterable responses = client.listClusterSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterSnapshots(software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link ListClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param listClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClusterSnapshotsIterable listClusterSnapshotsPaginator(
            Consumer<ListClusterSnapshotsRequest.Builder> listClusterSnapshotsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        return listClusterSnapshotsPaginator(ListClusterSnapshotsRequest.builder().applyMutation(listClusterSnapshotsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB elastic clusters.
     * </p>
     *
     * @param listClustersRequest
     * @return Result of the ListClusters operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB elastic clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest.Builder} to create a
     *        request.
     * @return Result of the ListClusters operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, DocDbElasticException {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusters(software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdbelastic.paginators.ListClustersIterable responses = client
     *             .listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.docdbelastic.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @param listClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(ListClustersRequest listClustersRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        return new ListClustersIterable(this, listClustersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusters(software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdbelastic.paginators.ListClustersIterable responses = client
     *             .listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.docdbelastic.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, DocDbElasticException {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all maintenance actions that are pending.
     * </p>
     *
     * @param listPendingMaintenanceActionsRequest
     * @return Result of the ListPendingMaintenanceActions operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListPendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListPendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPendingMaintenanceActionsResponse listPendingMaintenanceActions(
            ListPendingMaintenanceActionsRequest listPendingMaintenanceActionsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all maintenance actions that are pending.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param listPendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListPendingMaintenanceActions operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListPendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListPendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPendingMaintenanceActionsResponse listPendingMaintenanceActions(
            Consumer<ListPendingMaintenanceActionsRequest.Builder> listPendingMaintenanceActionsRequest)
            throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, DocDbElasticException {
        return listPendingMaintenanceActions(ListPendingMaintenanceActionsRequest.builder()
                .applyMutation(listPendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPendingMaintenanceActions(software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListPendingMaintenanceActionsIterable responses = client.listPendingMaintenanceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdbelastic.paginators.ListPendingMaintenanceActionsIterable responses = client
     *             .listPendingMaintenanceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListPendingMaintenanceActionsIterable responses = client.listPendingMaintenanceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPendingMaintenanceActions(software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPendingMaintenanceActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListPendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListPendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPendingMaintenanceActionsIterable listPendingMaintenanceActionsPaginator(
            ListPendingMaintenanceActionsRequest listPendingMaintenanceActionsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        return new ListPendingMaintenanceActionsIterable(this, listPendingMaintenanceActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPendingMaintenanceActions(software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListPendingMaintenanceActionsIterable responses = client.listPendingMaintenanceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdbelastic.paginators.ListPendingMaintenanceActionsIterable responses = client
     *             .listPendingMaintenanceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdbelastic.paginators.ListPendingMaintenanceActionsIterable responses = client.listPendingMaintenanceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPendingMaintenanceActions(software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param listPendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListPendingMaintenanceActionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListPendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListPendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPendingMaintenanceActionsIterable listPendingMaintenanceActionsPaginator(
            Consumer<ListPendingMaintenanceActionsRequest.Builder> listPendingMaintenanceActionsRequest)
            throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, DocDbElasticException {
        return listPendingMaintenanceActionsPaginator(ListPendingMaintenanceActionsRequest.builder()
                .applyMutation(listPendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * Lists all tags on a elastic cluster resource
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on a elastic cluster resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Restores an elastic cluster from a snapshot.
     * </p>
     *
     * @param restoreClusterFromSnapshotRequest
     * @return Result of the RestoreClusterFromSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ServiceQuotaExceededException
     *         The service quota for the action was exceeded.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.RestoreClusterFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/RestoreClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreClusterFromSnapshotResponse restoreClusterFromSnapshot(
            RestoreClusterFromSnapshotRequest restoreClusterFromSnapshotRequest) throws ThrottlingException, ValidationException,
            ServiceQuotaExceededException, ConflictException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores an elastic cluster from a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreClusterFromSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreClusterFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreClusterFromSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.RestoreClusterFromSnapshotRequest.Builder} to
     *        create a request.
     * @return Result of the RestoreClusterFromSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ServiceQuotaExceededException
     *         The service quota for the action was exceeded.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.RestoreClusterFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/RestoreClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreClusterFromSnapshotResponse restoreClusterFromSnapshot(
            Consumer<RestoreClusterFromSnapshotRequest.Builder> restoreClusterFromSnapshotRequest) throws ThrottlingException,
            ValidationException, ServiceQuotaExceededException, ConflictException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        return restoreClusterFromSnapshot(RestoreClusterFromSnapshotRequest.builder()
                .applyMutation(restoreClusterFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Restarts the stopped elastic cluster that is specified by <code>clusterARN</code>.
     * </p>
     *
     * @param startClusterRequest
     * @return Result of the StartCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.StartCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/StartCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default StartClusterResponse startCluster(StartClusterRequest startClusterRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts the stopped elastic cluster that is specified by <code>clusterARN</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartClusterRequest.Builder} avoiding the need to
     * create one manually via {@link StartClusterRequest#builder()}
     * </p>
     *
     * @param startClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.StartClusterRequest.Builder} to create a
     *        request.
     * @return Result of the StartCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.StartCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/StartCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default StartClusterResponse startCluster(Consumer<StartClusterRequest.Builder> startClusterRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        return startCluster(StartClusterRequest.builder().applyMutation(startClusterRequest).build());
    }

    /**
     * <p>
     * Stops the running elastic cluster that is specified by <code>clusterArn</code>. The elastic cluster must be in
     * the <i>available</i> state.
     * </p>
     *
     * @param stopClusterRequest
     * @return Result of the StopCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.StopCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/StopCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default StopClusterResponse stopCluster(StopClusterRequest stopClusterRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the running elastic cluster that is specified by <code>clusterArn</code>. The elastic cluster must be in
     * the <i>available</i> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopClusterRequest.Builder} avoiding the need to
     * create one manually via {@link StopClusterRequest#builder()}
     * </p>
     *
     * @param stopClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.StopClusterRequest.Builder} to create a request.
     * @return Result of the StopCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.StopCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/StopCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default StopClusterResponse stopCluster(Consumer<StopClusterRequest.Builder> stopClusterRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, DocDbElasticException {
        return stopCluster(StopClusterRequest.builder().applyMutation(stopClusterRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to an elastic cluster resource
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to an elastic cluster resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from an elastic cluster resource
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from an elastic cluster resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, DocDbElasticException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies an elastic cluster. This includes updating admin-username/password, upgrading the API version, and
     * setting up a backup window and maintenance window
     * </p>
     *
     * @param updateClusterRequest
     * @return Result of the UpdateCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UpdateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, DocDbElasticException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an elastic cluster. This includes updating admin-username/password, upgrading the API version, and
     * setting up a backup window and maintenance window
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateClusterRequest#builder()}
     * </p>
     *
     * @param updateClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.docdbelastic.model.UpdateClusterRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateCluster operation returned by the service.
     * @throws ThrottlingException
     *         ThrottlingException will be thrown when request was denied due to request throttling.
     * @throws ValidationException
     *         A structure defining a validation exception.
     * @throws ConflictException
     *         There was an access conflict.
     * @throws InternalServerException
     *         There was an internal server error.
     * @throws ResourceNotFoundException
     *         The specified resource could not be located.
     * @throws AccessDeniedException
     *         An exception that occurs when there are not sufficient permissions to perform an action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbElasticException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbElasticClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UpdateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateClusterResponse updateCluster(Consumer<UpdateClusterRequest.Builder> updateClusterRequest)
            throws ThrottlingException, ValidationException, ConflictException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        return updateCluster(UpdateClusterRequest.builder().applyMutation(updateClusterRequest).build());
    }

    /**
     * Create a {@link DocDbElasticClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DocDbElasticClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DocDbElasticClient}.
     */
    static DocDbElasticClientBuilder builder() {
        return new DefaultDocDbElasticClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default DocDbElasticServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
