/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplyPendingMaintenanceActionRequest extends DocDbElasticRequest implements
        ToCopyableBuilder<ApplyPendingMaintenanceActionRequest.Builder, ApplyPendingMaintenanceActionRequest> {
    private static final SdkField<String> APPLY_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applyAction").getter(getter(ApplyPendingMaintenanceActionRequest::applyAction))
            .setter(setter(Builder::applyAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyAction").build()).build();

    private static final SdkField<String> APPLY_ON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applyOn").getter(getter(ApplyPendingMaintenanceActionRequest::applyOn)).setter(setter(Builder::applyOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyOn").build()).build();

    private static final SdkField<String> OPT_IN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("optInType").getter(getter(ApplyPendingMaintenanceActionRequest::optInTypeAsString))
            .setter(setter(Builder::optInType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optInType").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(ApplyPendingMaintenanceActionRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLY_ACTION_FIELD,
            APPLY_ON_FIELD, OPT_IN_TYPE_FIELD, RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applyAction;

    private final String applyOn;

    private final String optInType;

    private final String resourceArn;

    private ApplyPendingMaintenanceActionRequest(BuilderImpl builder) {
        super(builder);
        this.applyAction = builder.applyAction;
        this.applyOn = builder.applyOn;
        this.optInType = builder.optInType;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The pending maintenance action to apply to the resource.
     * </p>
     * <p>
     * Valid actions are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENGINE_UPDATE<i/> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENGINE_UPGRADE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SECURITY_UPDATE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OS_UPDATE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MASTER_USER_PASSWORD_UPDATE</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The pending maintenance action to apply to the resource.</p>
     *         <p>
     *         Valid actions are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENGINE_UPDATE<i/> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENGINE_UPGRADE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SECURITY_UPDATE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OS_UPDATE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MASTER_USER_PASSWORD_UPDATE</code>
     *         </p>
     *         </li>
     */
    public final String applyAction() {
        return applyAction;
    }

    /**
     * <p>
     * A specific date to apply the pending maintenance action. Required if opt-in-type is <code>APPLY_ON</code>.
     * Format: <code>yyyy/MM/dd HH:mm-yyyy/MM/dd HH:mm</code>
     * </p>
     * 
     * @return A specific date to apply the pending maintenance action. Required if opt-in-type is <code>APPLY_ON</code>
     *         . Format: <code>yyyy/MM/dd HH:mm-yyyy/MM/dd HH:mm</code>
     */
    public final String applyOn() {
        return applyOn;
    }

    /**
     * <p>
     * A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type
     * <code>IMMEDIATE</code> can't be undone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInType} will
     * return {@link OptInType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #optInTypeAsString}.
     * </p>
     * 
     * @return A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type
     *         <code>IMMEDIATE</code> can't be undone.
     * @see OptInType
     */
    public final OptInType optInType() {
        return OptInType.fromValue(optInType);
    }

    /**
     * <p>
     * A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type
     * <code>IMMEDIATE</code> can't be undone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInType} will
     * return {@link OptInType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #optInTypeAsString}.
     * </p>
     * 
     * @return A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type
     *         <code>IMMEDIATE</code> can't be undone.
     * @see OptInType
     */
    public final String optInTypeAsString() {
        return optInType;
    }

    /**
     * <p>
     * The Amazon DocumentDB Amazon Resource Name (ARN) of the resource to which the pending maintenance action applies.
     * </p>
     * 
     * @return The Amazon DocumentDB Amazon Resource Name (ARN) of the resource to which the pending maintenance action
     *         applies.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applyAction());
        hashCode = 31 * hashCode + Objects.hashCode(applyOn());
        hashCode = 31 * hashCode + Objects.hashCode(optInTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyPendingMaintenanceActionRequest)) {
            return false;
        }
        ApplyPendingMaintenanceActionRequest other = (ApplyPendingMaintenanceActionRequest) obj;
        return Objects.equals(applyAction(), other.applyAction()) && Objects.equals(applyOn(), other.applyOn())
                && Objects.equals(optInTypeAsString(), other.optInTypeAsString())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplyPendingMaintenanceActionRequest").add("ApplyAction", applyAction())
                .add("ApplyOn", applyOn()).add("OptInType", optInTypeAsString()).add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applyAction":
            return Optional.ofNullable(clazz.cast(applyAction()));
        case "applyOn":
            return Optional.ofNullable(clazz.cast(applyOn()));
        case "optInType":
            return Optional.ofNullable(clazz.cast(optInTypeAsString()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applyAction", APPLY_ACTION_FIELD);
        map.put("applyOn", APPLY_ON_FIELD);
        map.put("optInType", OPT_IN_TYPE_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplyPendingMaintenanceActionRequest, T> g) {
        return obj -> g.apply((ApplyPendingMaintenanceActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DocDbElasticRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ApplyPendingMaintenanceActionRequest> {
        /**
         * <p>
         * The pending maintenance action to apply to the resource.
         * </p>
         * <p>
         * Valid actions are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENGINE_UPDATE<i/> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENGINE_UPGRADE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SECURITY_UPDATE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OS_UPDATE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MASTER_USER_PASSWORD_UPDATE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param applyAction
         *        The pending maintenance action to apply to the resource.</p>
         *        <p>
         *        Valid actions are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENGINE_UPDATE<i/> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENGINE_UPGRADE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SECURITY_UPDATE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OS_UPDATE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MASTER_USER_PASSWORD_UPDATE</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyAction(String applyAction);

        /**
         * <p>
         * A specific date to apply the pending maintenance action. Required if opt-in-type is <code>APPLY_ON</code>.
         * Format: <code>yyyy/MM/dd HH:mm-yyyy/MM/dd HH:mm</code>
         * </p>
         * 
         * @param applyOn
         *        A specific date to apply the pending maintenance action. Required if opt-in-type is
         *        <code>APPLY_ON</code>. Format: <code>yyyy/MM/dd HH:mm-yyyy/MM/dd HH:mm</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyOn(String applyOn);

        /**
         * <p>
         * A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type
         * <code>IMMEDIATE</code> can't be undone.
         * </p>
         * 
         * @param optInType
         *        A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of
         *        type <code>IMMEDIATE</code> can't be undone.
         * @see OptInType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptInType
         */
        Builder optInType(String optInType);

        /**
         * <p>
         * A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type
         * <code>IMMEDIATE</code> can't be undone.
         * </p>
         * 
         * @param optInType
         *        A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of
         *        type <code>IMMEDIATE</code> can't be undone.
         * @see OptInType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptInType
         */
        Builder optInType(OptInType optInType);

        /**
         * <p>
         * The Amazon DocumentDB Amazon Resource Name (ARN) of the resource to which the pending maintenance action
         * applies.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon DocumentDB Amazon Resource Name (ARN) of the resource to which the pending maintenance
         *        action applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbElasticRequest.BuilderImpl implements Builder {
        private String applyAction;

        private String applyOn;

        private String optInType;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyPendingMaintenanceActionRequest model) {
            super(model);
            applyAction(model.applyAction);
            applyOn(model.applyOn);
            optInType(model.optInType);
            resourceArn(model.resourceArn);
        }

        public final String getApplyAction() {
            return applyAction;
        }

        public final void setApplyAction(String applyAction) {
            this.applyAction = applyAction;
        }

        @Override
        public final Builder applyAction(String applyAction) {
            this.applyAction = applyAction;
            return this;
        }

        public final String getApplyOn() {
            return applyOn;
        }

        public final void setApplyOn(String applyOn) {
            this.applyOn = applyOn;
        }

        @Override
        public final Builder applyOn(String applyOn) {
            this.applyOn = applyOn;
            return this;
        }

        public final String getOptInType() {
            return optInType;
        }

        public final void setOptInType(String optInType) {
            this.optInType = optInType;
        }

        @Override
        public final Builder optInType(String optInType) {
            this.optInType = optInType;
            return this;
        }

        @Override
        public final Builder optInType(OptInType optInType) {
            this.optInType(optInType == null ? null : optInType.toString());
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApplyPendingMaintenanceActionRequest build() {
            return new ApplyPendingMaintenanceActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
