/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreClusterFromSnapshotRequest extends DocDbElasticRequest implements
        ToCopyableBuilder<RestoreClusterFromSnapshotRequest.Builder, RestoreClusterFromSnapshotRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(RestoreClusterFromSnapshotRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(RestoreClusterFromSnapshotRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Integer> SHARD_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shardCapacity").getter(getter(RestoreClusterFromSnapshotRequest::shardCapacity))
            .setter(setter(Builder::shardCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardCapacity").build()).build();

    private static final SdkField<Integer> SHARD_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shardInstanceCount").getter(getter(RestoreClusterFromSnapshotRequest::shardInstanceCount))
            .setter(setter(Builder::shardInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardInstanceCount").build())
            .build();

    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotArn").getter(getter(RestoreClusterFromSnapshotRequest::snapshotArn))
            .setter(setter(Builder::snapshotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotArn").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(RestoreClusterFromSnapshotRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(RestoreClusterFromSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcSecurityGroupIds")
            .getter(getter(RestoreClusterFromSnapshotRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            KMS_KEY_ID_FIELD, SHARD_CAPACITY_FIELD, SHARD_INSTANCE_COUNT_FIELD, SNAPSHOT_ARN_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD,
            VPC_SECURITY_GROUP_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final String kmsKeyId;

    private final Integer shardCapacity;

    private final Integer shardInstanceCount;

    private final String snapshotArn;

    private final List<String> subnetIds;

    private final Map<String, String> tags;

    private final List<String> vpcSecurityGroupIds;

    private RestoreClusterFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.kmsKeyId = builder.kmsKeyId;
        this.shardCapacity = builder.shardCapacity;
        this.shardInstanceCount = builder.shardInstanceCount;
        this.snapshotArn = builder.snapshotArn;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The name of the elastic cluster.
     * </p>
     * 
     * @return The name of the elastic cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The KMS key identifier to use to encrypt the new Amazon DocumentDB elastic clusters cluster.
     * </p>
     * <p>
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a
     * cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of
     * the ARN as the KMS encryption key.
     * </p>
     * <p>
     * If an encryption key is not specified here, Amazon DocumentDB uses the default encryption key that KMS creates
     * for your account. Your account has a different default encryption key for each Amazon Region.
     * </p>
     * 
     * @return The KMS key identifier to use to encrypt the new Amazon DocumentDB elastic clusters cluster.</p>
     *         <p>
     *         The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating
     *         a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias
     *         instead of the ARN as the KMS encryption key.
     *         </p>
     *         <p>
     *         If an encryption key is not specified here, Amazon DocumentDB uses the default encryption key that KMS
     *         creates for your account. Your account has a different default encryption key for each Amazon Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The capacity of each shard in the new restored elastic cluster.
     * </p>
     * 
     * @return The capacity of each shard in the new restored elastic cluster.
     */
    public final Integer shardCapacity() {
        return shardCapacity;
    }

    /**
     * <p>
     * The number of replica instances applying to all shards in the elastic cluster. A <code>shardInstanceCount</code>
     * value of 1 means there is one writer instance, and any additional instances are replicas that can be used for
     * reads and to improve availability.
     * </p>
     * 
     * @return The number of replica instances applying to all shards in the elastic cluster. A
     *         <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional
     *         instances are replicas that can be used for reads and to improve availability.
     */
    public final Integer shardInstanceCount() {
        return shardInstanceCount;
    }

    /**
     * <p>
     * The ARN identifier of the elastic cluster snapshot.
     * </p>
     * 
     * @return The ARN identifier of the elastic cluster snapshot.
     */
    public final String snapshotArn() {
        return snapshotArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 subnet IDs for the elastic cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The Amazon EC2 subnet IDs for the elastic cluster.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the tag names to be assigned to the restored elastic cluster, in the form of an array of key-value
     * pairs in which the key is the tag name and the value is the key value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of the tag names to be assigned to the restored elastic cluster, in the form of an array of
     *         key-value pairs in which the key is the tag name and the value is the key value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 VPC security groups to associate with the elastic cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of EC2 VPC security groups to associate with the elastic cluster.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(shardCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(shardInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreClusterFromSnapshotRequest)) {
            return false;
        }
        RestoreClusterFromSnapshotRequest other = (RestoreClusterFromSnapshotRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(shardCapacity(), other.shardCapacity())
                && Objects.equals(shardInstanceCount(), other.shardInstanceCount())
                && Objects.equals(snapshotArn(), other.snapshotArn()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreClusterFromSnapshotRequest").add("ClusterName", clusterName())
                .add("KmsKeyId", kmsKeyId()).add("ShardCapacity", shardCapacity())
                .add("ShardInstanceCount", shardInstanceCount()).add("SnapshotArn", snapshotArn())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("Tags", hasTags() ? tags() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "shardCapacity":
            return Optional.ofNullable(clazz.cast(shardCapacity()));
        case "shardInstanceCount":
            return Optional.ofNullable(clazz.cast(shardInstanceCount()));
        case "snapshotArn":
            return Optional.ofNullable(clazz.cast(snapshotArn()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("shardCapacity", SHARD_CAPACITY_FIELD);
        map.put("shardInstanceCount", SHARD_INSTANCE_COUNT_FIELD);
        map.put("snapshotArn", SNAPSHOT_ARN_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreClusterFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreClusterFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DocDbElasticRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreClusterFromSnapshotRequest> {
        /**
         * <p>
         * The name of the elastic cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The KMS key identifier to use to encrypt the new Amazon DocumentDB elastic clusters cluster.
         * </p>
         * <p>
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a
         * cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias
         * instead of the ARN as the KMS encryption key.
         * </p>
         * <p>
         * If an encryption key is not specified here, Amazon DocumentDB uses the default encryption key that KMS
         * creates for your account. Your account has a different default encryption key for each Amazon Region.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key identifier to use to encrypt the new Amazon DocumentDB elastic clusters cluster.</p>
         *        <p>
         *        The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are
         *        creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the
         *        KMS key alias instead of the ARN as the KMS encryption key.
         *        </p>
         *        <p>
         *        If an encryption key is not specified here, Amazon DocumentDB uses the default encryption key that KMS
         *        creates for your account. Your account has a different default encryption key for each Amazon Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The capacity of each shard in the new restored elastic cluster.
         * </p>
         * 
         * @param shardCapacity
         *        The capacity of each shard in the new restored elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardCapacity(Integer shardCapacity);

        /**
         * <p>
         * The number of replica instances applying to all shards in the elastic cluster. A
         * <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional instances
         * are replicas that can be used for reads and to improve availability.
         * </p>
         * 
         * @param shardInstanceCount
         *        The number of replica instances applying to all shards in the elastic cluster. A
         *        <code>shardInstanceCount</code> value of 1 means there is one writer instance, and any additional
         *        instances are replicas that can be used for reads and to improve availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardInstanceCount(Integer shardInstanceCount);

        /**
         * <p>
         * The ARN identifier of the elastic cluster snapshot.
         * </p>
         * 
         * @param snapshotArn
         *        The ARN identifier of the elastic cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArn(String snapshotArn);

        /**
         * <p>
         * The Amazon EC2 subnet IDs for the elastic cluster.
         * </p>
         * 
         * @param subnetIds
         *        The Amazon EC2 subnet IDs for the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The Amazon EC2 subnet IDs for the elastic cluster.
         * </p>
         * 
         * @param subnetIds
         *        The Amazon EC2 subnet IDs for the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of the tag names to be assigned to the restored elastic cluster, in the form of an array of key-value
         * pairs in which the key is the tag name and the value is the key value.
         * </p>
         * 
         * @param tags
         *        A list of the tag names to be assigned to the restored elastic cluster, in the form of an array of
         *        key-value pairs in which the key is the tag name and the value is the key value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with the elastic cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of EC2 VPC security groups to associate with the elastic cluster.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of EC2 VPC security groups to associate with the elastic cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbElasticRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String kmsKeyId;

        private Integer shardCapacity;

        private Integer shardInstanceCount;

        private String snapshotArn;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreClusterFromSnapshotRequest model) {
            super(model);
            clusterName(model.clusterName);
            kmsKeyId(model.kmsKeyId);
            shardCapacity(model.shardCapacity);
            shardInstanceCount(model.shardInstanceCount);
            snapshotArn(model.snapshotArn);
            subnetIds(model.subnetIds);
            tags(model.tags);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Integer getShardCapacity() {
            return shardCapacity;
        }

        public final void setShardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
        }

        @Override
        public final Builder shardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
            return this;
        }

        public final Integer getShardInstanceCount() {
            return shardInstanceCount;
        }

        public final void setShardInstanceCount(Integer shardInstanceCount) {
            this.shardInstanceCount = shardInstanceCount;
        }

        @Override
        public final Builder shardInstanceCount(Integer shardInstanceCount) {
            this.shardInstanceCount = shardInstanceCount;
            return this;
        }

        public final String getSnapshotArn() {
            return snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreClusterFromSnapshotRequest build() {
            return new RestoreClusterFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
