/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdbelastic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a pending maintenance action for a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcePendingMaintenanceAction implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourcePendingMaintenanceAction.Builder, ResourcePendingMaintenanceAction> {
    private static final SdkField<List<PendingMaintenanceActionDetails>> PENDING_MAINTENANCE_ACTION_DETAILS_FIELD = SdkField
            .<List<PendingMaintenanceActionDetails>> builder(MarshallingType.LIST)
            .memberName("pendingMaintenanceActionDetails")
            .getter(getter(ResourcePendingMaintenanceAction::pendingMaintenanceActionDetails))
            .setter(setter(Builder::pendingMaintenanceActionDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingMaintenanceActionDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PendingMaintenanceActionDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(PendingMaintenanceActionDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(ResourcePendingMaintenanceAction::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PENDING_MAINTENANCE_ACTION_DETAILS_FIELD, RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PendingMaintenanceActionDetails> pendingMaintenanceActionDetails;

    private final String resourceArn;

    private ResourcePendingMaintenanceAction(BuilderImpl builder) {
        this.pendingMaintenanceActionDetails = builder.pendingMaintenanceActionDetails;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the PendingMaintenanceActionDetails
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasPendingMaintenanceActionDetails() {
        return pendingMaintenanceActionDetails != null && !(pendingMaintenanceActionDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information about a pending maintenance action for a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPendingMaintenanceActionDetails}
     * method.
     * </p>
     * 
     * @return Provides information about a pending maintenance action for a resource.
     */
    public final List<PendingMaintenanceActionDetails> pendingMaintenanceActionDetails() {
        return pendingMaintenanceActionDetails;
    }

    /**
     * <p>
     * The Amazon DocumentDB Amazon Resource Name (ARN) of the resource to which the pending maintenance action applies.
     * </p>
     * 
     * @return The Amazon DocumentDB Amazon Resource Name (ARN) of the resource to which the pending maintenance action
     *         applies.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPendingMaintenanceActionDetails() ? pendingMaintenanceActionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePendingMaintenanceAction)) {
            return false;
        }
        ResourcePendingMaintenanceAction other = (ResourcePendingMaintenanceAction) obj;
        return hasPendingMaintenanceActionDetails() == other.hasPendingMaintenanceActionDetails()
                && Objects.equals(pendingMaintenanceActionDetails(), other.pendingMaintenanceActionDetails())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ResourcePendingMaintenanceAction")
                .add("PendingMaintenanceActionDetails",
                        hasPendingMaintenanceActionDetails() ? pendingMaintenanceActionDetails() : null)
                .add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pendingMaintenanceActionDetails":
            return Optional.ofNullable(clazz.cast(pendingMaintenanceActionDetails()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pendingMaintenanceActionDetails", PENDING_MAINTENANCE_ACTION_DETAILS_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcePendingMaintenanceAction, T> g) {
        return obj -> g.apply((ResourcePendingMaintenanceAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcePendingMaintenanceAction> {
        /**
         * <p>
         * Provides information about a pending maintenance action for a resource.
         * </p>
         * 
         * @param pendingMaintenanceActionDetails
         *        Provides information about a pending maintenance action for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingMaintenanceActionDetails(Collection<PendingMaintenanceActionDetails> pendingMaintenanceActionDetails);

        /**
         * <p>
         * Provides information about a pending maintenance action for a resource.
         * </p>
         * 
         * @param pendingMaintenanceActionDetails
         *        Provides information about a pending maintenance action for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingMaintenanceActionDetails(PendingMaintenanceActionDetails... pendingMaintenanceActionDetails);

        /**
         * <p>
         * Provides information about a pending maintenance action for a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.docdbelastic.model.PendingMaintenanceActionDetails.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.docdbelastic.model.PendingMaintenanceActionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.docdbelastic.model.PendingMaintenanceActionDetails.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #pendingMaintenanceActionDetails(List<PendingMaintenanceActionDetails>)}.
         * 
         * @param pendingMaintenanceActionDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.docdbelastic.model.PendingMaintenanceActionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingMaintenanceActionDetails(java.util.Collection<PendingMaintenanceActionDetails>)
         */
        Builder pendingMaintenanceActionDetails(
                Consumer<PendingMaintenanceActionDetails.Builder>... pendingMaintenanceActionDetails);

        /**
         * <p>
         * The Amazon DocumentDB Amazon Resource Name (ARN) of the resource to which the pending maintenance action
         * applies.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon DocumentDB Amazon Resource Name (ARN) of the resource to which the pending maintenance
         *        action applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl implements Builder {
        private List<PendingMaintenanceActionDetails> pendingMaintenanceActionDetails = DefaultSdkAutoConstructList.getInstance();

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePendingMaintenanceAction model) {
            pendingMaintenanceActionDetails(model.pendingMaintenanceActionDetails);
            resourceArn(model.resourceArn);
        }

        public final List<PendingMaintenanceActionDetails.Builder> getPendingMaintenanceActionDetails() {
            List<PendingMaintenanceActionDetails.Builder> result = PendingMaintenanceActionDetailsListCopier
                    .copyToBuilder(this.pendingMaintenanceActionDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPendingMaintenanceActionDetails(
                Collection<PendingMaintenanceActionDetails.BuilderImpl> pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails = PendingMaintenanceActionDetailsListCopier
                    .copyFromBuilder(pendingMaintenanceActionDetails);
        }

        @Override
        public final Builder pendingMaintenanceActionDetails(
                Collection<PendingMaintenanceActionDetails> pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails = PendingMaintenanceActionDetailsListCopier
                    .copy(pendingMaintenanceActionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActionDetails(PendingMaintenanceActionDetails... pendingMaintenanceActionDetails) {
            pendingMaintenanceActionDetails(Arrays.asList(pendingMaintenanceActionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActionDetails(
                Consumer<PendingMaintenanceActionDetails.Builder>... pendingMaintenanceActionDetails) {
            pendingMaintenanceActionDetails(Stream.of(pendingMaintenanceActionDetails)
                    .map(c -> PendingMaintenanceActionDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public ResourcePendingMaintenanceAction build() {
            return new ResourcePendingMaintenanceAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
