/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing information regarding the initiation of the last launch of a Source Server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifeCycleLastLaunchInitiated implements SdkPojo, Serializable,
        ToCopyableBuilder<LifeCycleLastLaunchInitiated.Builder, LifeCycleLastLaunchInitiated> {
    private static final SdkField<String> API_CALL_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiCallDateTime").getter(getter(LifeCycleLastLaunchInitiated::apiCallDateTime))
            .setter(setter(Builder::apiCallDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiCallDateTime").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobID")
            .getter(getter(LifeCycleLastLaunchInitiated::jobID)).setter(setter(Builder::jobID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(LifeCycleLastLaunchInitiated::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_CALL_DATE_TIME_FIELD,
            JOB_ID_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiCallDateTime;

    private final String jobID;

    private final String type;

    private LifeCycleLastLaunchInitiated(BuilderImpl builder) {
        this.apiCallDateTime = builder.apiCallDateTime;
        this.jobID = builder.jobID;
        this.type = builder.type;
    }

    /**
     * <p>
     * The date and time the last Source Server launch was initiated.
     * </p>
     * 
     * @return The date and time the last Source Server launch was initiated.
     */
    public final String apiCallDateTime() {
        return apiCallDateTime;
    }

    /**
     * <p>
     * The ID of the Job that was used to last launch the Source Server.
     * </p>
     * 
     * @return The ID of the Job that was used to last launch the Source Server.
     */
    public final String jobID() {
        return jobID;
    }

    /**
     * <p>
     * The Job type that was used to last launch the Source Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LastLaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The Job type that was used to last launch the Source Server.
     * @see LastLaunchType
     */
    public final LastLaunchType type() {
        return LastLaunchType.fromValue(type);
    }

    /**
     * <p>
     * The Job type that was used to last launch the Source Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LastLaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The Job type that was used to last launch the Source Server.
     * @see LastLaunchType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiCallDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobID());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifeCycleLastLaunchInitiated)) {
            return false;
        }
        LifeCycleLastLaunchInitiated other = (LifeCycleLastLaunchInitiated) obj;
        return Objects.equals(apiCallDateTime(), other.apiCallDateTime()) && Objects.equals(jobID(), other.jobID())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifeCycleLastLaunchInitiated").add("ApiCallDateTime", apiCallDateTime()).add("JobID", jobID())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiCallDateTime":
            return Optional.ofNullable(clazz.cast(apiCallDateTime()));
        case "jobID":
            return Optional.ofNullable(clazz.cast(jobID()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifeCycleLastLaunchInitiated, T> g) {
        return obj -> g.apply((LifeCycleLastLaunchInitiated) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifeCycleLastLaunchInitiated> {
        /**
         * <p>
         * The date and time the last Source Server launch was initiated.
         * </p>
         * 
         * @param apiCallDateTime
         *        The date and time the last Source Server launch was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiCallDateTime(String apiCallDateTime);

        /**
         * <p>
         * The ID of the Job that was used to last launch the Source Server.
         * </p>
         * 
         * @param jobID
         *        The ID of the Job that was used to last launch the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobID(String jobID);

        /**
         * <p>
         * The Job type that was used to last launch the Source Server.
         * </p>
         * 
         * @param type
         *        The Job type that was used to last launch the Source Server.
         * @see LastLaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastLaunchType
         */
        Builder type(String type);

        /**
         * <p>
         * The Job type that was used to last launch the Source Server.
         * </p>
         * 
         * @param type
         *        The Job type that was used to last launch the Source Server.
         * @see LastLaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastLaunchType
         */
        Builder type(LastLaunchType type);
    }

    static final class BuilderImpl implements Builder {
        private String apiCallDateTime;

        private String jobID;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(LifeCycleLastLaunchInitiated model) {
            apiCallDateTime(model.apiCallDateTime);
            jobID(model.jobID);
            type(model.type);
        }

        public final String getApiCallDateTime() {
            return apiCallDateTime;
        }

        public final void setApiCallDateTime(String apiCallDateTime) {
            this.apiCallDateTime = apiCallDateTime;
        }

        @Override
        @Transient
        public final Builder apiCallDateTime(String apiCallDateTime) {
            this.apiCallDateTime = apiCallDateTime;
            return this;
        }

        public final String getJobID() {
            return jobID;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @Override
        @Transient
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(LastLaunchType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public LifeCycleLastLaunchInitiated build() {
            return new LifeCycleLastLaunchInitiated(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
