/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class PITPolicyCopier {
    static List<PITPolicyRule> copy(Collection<? extends PITPolicyRule> pitPolicyParam) {
        List<PITPolicyRule> list;
        if (pitPolicyParam == null || pitPolicyParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PITPolicyRule> modifiableList = new ArrayList<>();
            pitPolicyParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PITPolicyRule> copyFromBuilder(Collection<? extends PITPolicyRule.Builder> pitPolicyParam) {
        List<PITPolicyRule> list;
        if (pitPolicyParam == null || pitPolicyParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PITPolicyRule> modifiableList = new ArrayList<>();
            pitPolicyParam.forEach(entry -> {
                PITPolicyRule member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PITPolicyRule.Builder> copyToBuilder(Collection<? extends PITPolicyRule> pitPolicyParam) {
        List<PITPolicyRule.Builder> list;
        if (pitPolicyParam == null || pitPolicyParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PITPolicyRule.Builder> modifiableList = new ArrayList<>();
            pitPolicyParam.forEach(entry -> {
                PITPolicyRule.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
