/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing information regarding the last launch of a Source Server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifeCycleLastLaunch implements SdkPojo, Serializable,
        ToCopyableBuilder<LifeCycleLastLaunch.Builder, LifeCycleLastLaunch> {
    private static final SdkField<LifeCycleLastLaunchInitiated> INITIATED_FIELD = SdkField
            .<LifeCycleLastLaunchInitiated> builder(MarshallingType.SDK_POJO).memberName("initiated")
            .getter(getter(LifeCycleLastLaunch::initiated)).setter(setter(Builder::initiated))
            .constructor(LifeCycleLastLaunchInitiated::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final LifeCycleLastLaunchInitiated initiated;

    private LifeCycleLastLaunch(BuilderImpl builder) {
        this.initiated = builder.initiated;
    }

    /**
     * <p>
     * An object containing information regarding the initiation of the last launch of a Source Server.
     * </p>
     * 
     * @return An object containing information regarding the initiation of the last launch of a Source Server.
     */
    public final LifeCycleLastLaunchInitiated initiated() {
        return initiated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initiated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifeCycleLastLaunch)) {
            return false;
        }
        LifeCycleLastLaunch other = (LifeCycleLastLaunch) obj;
        return Objects.equals(initiated(), other.initiated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifeCycleLastLaunch").add("Initiated", initiated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "initiated":
            return Optional.ofNullable(clazz.cast(initiated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifeCycleLastLaunch, T> g) {
        return obj -> g.apply((LifeCycleLastLaunch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifeCycleLastLaunch> {
        /**
         * <p>
         * An object containing information regarding the initiation of the last launch of a Source Server.
         * </p>
         * 
         * @param initiated
         *        An object containing information regarding the initiation of the last launch of a Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiated(LifeCycleLastLaunchInitiated initiated);

        /**
         * <p>
         * An object containing information regarding the initiation of the last launch of a Source Server.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycleLastLaunchInitiated.Builder}
         * avoiding the need to create one manually via {@link LifeCycleLastLaunchInitiated#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifeCycleLastLaunchInitiated.Builder#build()} is called
         * immediately and its result is passed to {@link #initiated(LifeCycleLastLaunchInitiated)}.
         * 
         * @param initiated
         *        a consumer that will call methods on {@link LifeCycleLastLaunchInitiated.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initiated(LifeCycleLastLaunchInitiated)
         */
        default Builder initiated(Consumer<LifeCycleLastLaunchInitiated.Builder> initiated) {
            return initiated(LifeCycleLastLaunchInitiated.builder().applyMutation(initiated).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LifeCycleLastLaunchInitiated initiated;

        private BuilderImpl() {
        }

        private BuilderImpl(LifeCycleLastLaunch model) {
            initiated(model.initiated);
        }

        public final LifeCycleLastLaunchInitiated.Builder getInitiated() {
            return initiated != null ? initiated.toBuilder() : null;
        }

        public final void setInitiated(LifeCycleLastLaunchInitiated.BuilderImpl initiated) {
            this.initiated = initiated != null ? initiated.build() : null;
        }

        @Override
        public final Builder initiated(LifeCycleLastLaunchInitiated initiated) {
            this.initiated = initiated;
            return this;
        }

        @Override
        public LifeCycleLastLaunch build() {
            return new LifeCycleLastLaunch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
