/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data replication initiation step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryInstanceDataReplicationInitiationStep implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryInstanceDataReplicationInitiationStep.Builder, RecoveryInstanceDataReplicationInitiationStep> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RecoveryInstanceDataReplicationInitiationStep::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RecoveryInstanceDataReplicationInitiationStep::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private RecoveryInstanceDataReplicationInitiationStep(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RecoveryInstanceDataReplicationInitiationStepName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the step.
     * @see RecoveryInstanceDataReplicationInitiationStepName
     */
    public final RecoveryInstanceDataReplicationInitiationStepName name() {
        return RecoveryInstanceDataReplicationInitiationStepName.fromValue(name);
    }

    /**
     * <p>
     * The name of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RecoveryInstanceDataReplicationInitiationStepName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the step.
     * @see RecoveryInstanceDataReplicationInitiationStepName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecoveryInstanceDataReplicationInitiationStepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the step.
     * @see RecoveryInstanceDataReplicationInitiationStepStatus
     */
    public final RecoveryInstanceDataReplicationInitiationStepStatus status() {
        return RecoveryInstanceDataReplicationInitiationStepStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecoveryInstanceDataReplicationInitiationStepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the step.
     * @see RecoveryInstanceDataReplicationInitiationStepStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryInstanceDataReplicationInitiationStep)) {
            return false;
        }
        RecoveryInstanceDataReplicationInitiationStep other = (RecoveryInstanceDataReplicationInitiationStep) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryInstanceDataReplicationInitiationStep").add("Name", nameAsString())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryInstanceDataReplicationInitiationStep, T> g) {
        return obj -> g.apply((RecoveryInstanceDataReplicationInitiationStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryInstanceDataReplicationInitiationStep> {
        /**
         * <p>
         * The name of the step.
         * </p>
         * 
         * @param name
         *        The name of the step.
         * @see RecoveryInstanceDataReplicationInitiationStepName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryInstanceDataReplicationInitiationStepName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the step.
         * </p>
         * 
         * @param name
         *        The name of the step.
         * @see RecoveryInstanceDataReplicationInitiationStepName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryInstanceDataReplicationInitiationStepName
         */
        Builder name(RecoveryInstanceDataReplicationInitiationStepName name);

        /**
         * <p>
         * The status of the step.
         * </p>
         * 
         * @param status
         *        The status of the step.
         * @see RecoveryInstanceDataReplicationInitiationStepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryInstanceDataReplicationInitiationStepStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the step.
         * </p>
         * 
         * @param status
         *        The status of the step.
         * @see RecoveryInstanceDataReplicationInitiationStepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryInstanceDataReplicationInitiationStepStatus
         */
        Builder status(RecoveryInstanceDataReplicationInitiationStepStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryInstanceDataReplicationInitiationStep model) {
            name(model.name);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Transient
        public final Builder name(RecoveryInstanceDataReplicationInitiationStepName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(RecoveryInstanceDataReplicationInitiationStepStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RecoveryInstanceDataReplicationInitiationStep build() {
            return new RecoveryInstanceDataReplicationInitiationStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
