/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.drs.model.RecoveryInstanceDataReplicationError;
import software.amazon.awssdk.services.drs.model.RecoveryInstanceDataReplicationInfoReplicatedDisk;
import software.amazon.awssdk.services.drs.model.RecoveryInstanceDataReplicationInfoReplicatedDisksCopier;
import software.amazon.awssdk.services.drs.model.RecoveryInstanceDataReplicationInitiation;
import software.amazon.awssdk.services.drs.model.RecoveryInstanceDataReplicationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecoveryInstanceDataReplicationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecoveryInstanceDataReplicationInfo> {
    private static final SdkField<RecoveryInstanceDataReplicationError> DATA_REPLICATION_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataReplicationError").getter(RecoveryInstanceDataReplicationInfo.getter(RecoveryInstanceDataReplicationInfo::dataReplicationError)).setter(RecoveryInstanceDataReplicationInfo.setter(Builder::dataReplicationError)).constructor(RecoveryInstanceDataReplicationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationError").build()}).build();
    private static final SdkField<RecoveryInstanceDataReplicationInitiation> DATA_REPLICATION_INITIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataReplicationInitiation").getter(RecoveryInstanceDataReplicationInfo.getter(RecoveryInstanceDataReplicationInfo::dataReplicationInitiation)).setter(RecoveryInstanceDataReplicationInfo.setter(Builder::dataReplicationInitiation)).constructor(RecoveryInstanceDataReplicationInitiation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInitiation").build()}).build();
    private static final SdkField<String> DATA_REPLICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataReplicationState").getter(RecoveryInstanceDataReplicationInfo.getter(RecoveryInstanceDataReplicationInfo::dataReplicationStateAsString)).setter(RecoveryInstanceDataReplicationInfo.setter(Builder::dataReplicationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationState").build()}).build();
    private static final SdkField<String> ETA_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("etaDateTime").getter(RecoveryInstanceDataReplicationInfo.getter(RecoveryInstanceDataReplicationInfo::etaDateTime)).setter(RecoveryInstanceDataReplicationInfo.setter(Builder::etaDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etaDateTime").build()}).build();
    private static final SdkField<String> LAG_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lagDuration").getter(RecoveryInstanceDataReplicationInfo.getter(RecoveryInstanceDataReplicationInfo::lagDuration)).setter(RecoveryInstanceDataReplicationInfo.setter(Builder::lagDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagDuration").build()}).build();
    private static final SdkField<List<RecoveryInstanceDataReplicationInfoReplicatedDisk>> REPLICATED_DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicatedDisks").getter(RecoveryInstanceDataReplicationInfo.getter(RecoveryInstanceDataReplicationInfo::replicatedDisks)).setter(RecoveryInstanceDataReplicationInfo.setter(Builder::replicatedDisks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatedDisks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecoveryInstanceDataReplicationInfoReplicatedDisk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_REPLICATION_ERROR_FIELD, DATA_REPLICATION_INITIATION_FIELD, DATA_REPLICATION_STATE_FIELD, ETA_DATE_TIME_FIELD, LAG_DURATION_FIELD, REPLICATED_DISKS_FIELD));
    private static final long serialVersionUID = 1L;
    private final RecoveryInstanceDataReplicationError dataReplicationError;
    private final RecoveryInstanceDataReplicationInitiation dataReplicationInitiation;
    private final String dataReplicationState;
    private final String etaDateTime;
    private final String lagDuration;
    private final List<RecoveryInstanceDataReplicationInfoReplicatedDisk> replicatedDisks;

    private RecoveryInstanceDataReplicationInfo(BuilderImpl builder) {
        this.dataReplicationError = builder.dataReplicationError;
        this.dataReplicationInitiation = builder.dataReplicationInitiation;
        this.dataReplicationState = builder.dataReplicationState;
        this.etaDateTime = builder.etaDateTime;
        this.lagDuration = builder.lagDuration;
        this.replicatedDisks = builder.replicatedDisks;
    }

    public final RecoveryInstanceDataReplicationError dataReplicationError() {
        return this.dataReplicationError;
    }

    public final RecoveryInstanceDataReplicationInitiation dataReplicationInitiation() {
        return this.dataReplicationInitiation;
    }

    public final RecoveryInstanceDataReplicationState dataReplicationState() {
        return RecoveryInstanceDataReplicationState.fromValue(this.dataReplicationState);
    }

    public final String dataReplicationStateAsString() {
        return this.dataReplicationState;
    }

    public final String etaDateTime() {
        return this.etaDateTime;
    }

    public final String lagDuration() {
        return this.lagDuration;
    }

    public final boolean hasReplicatedDisks() {
        return this.replicatedDisks != null && !(this.replicatedDisks instanceof SdkAutoConstructList);
    }

    public final List<RecoveryInstanceDataReplicationInfoReplicatedDisk> replicatedDisks() {
        return this.replicatedDisks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationError());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationInitiation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.etaDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicatedDisks() ? this.replicatedDisks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryInstanceDataReplicationInfo)) {
            return false;
        }
        RecoveryInstanceDataReplicationInfo other = (RecoveryInstanceDataReplicationInfo)obj;
        return Objects.equals(this.dataReplicationError(), other.dataReplicationError()) && Objects.equals(this.dataReplicationInitiation(), other.dataReplicationInitiation()) && Objects.equals(this.dataReplicationStateAsString(), other.dataReplicationStateAsString()) && Objects.equals(this.etaDateTime(), other.etaDateTime()) && Objects.equals(this.lagDuration(), other.lagDuration()) && this.hasReplicatedDisks() == other.hasReplicatedDisks() && Objects.equals(this.replicatedDisks(), other.replicatedDisks());
    }

    public final String toString() {
        return ToString.builder((String)"RecoveryInstanceDataReplicationInfo").add("DataReplicationError", (Object)this.dataReplicationError()).add("DataReplicationInitiation", (Object)this.dataReplicationInitiation()).add("DataReplicationState", (Object)this.dataReplicationStateAsString()).add("EtaDateTime", (Object)this.etaDateTime()).add("LagDuration", (Object)this.lagDuration()).add("ReplicatedDisks", this.hasReplicatedDisks() ? this.replicatedDisks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataReplicationError": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationError()));
            }
            case "dataReplicationInitiation": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationInitiation()));
            }
            case "dataReplicationState": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationStateAsString()));
            }
            case "etaDateTime": {
                return Optional.ofNullable(clazz.cast(this.etaDateTime()));
            }
            case "lagDuration": {
                return Optional.ofNullable(clazz.cast(this.lagDuration()));
            }
            case "replicatedDisks": {
                return Optional.ofNullable(clazz.cast(this.replicatedDisks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryInstanceDataReplicationInfo, T> g) {
        return obj -> g.apply((RecoveryInstanceDataReplicationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RecoveryInstanceDataReplicationError dataReplicationError;
        private RecoveryInstanceDataReplicationInitiation dataReplicationInitiation;
        private String dataReplicationState;
        private String etaDateTime;
        private String lagDuration;
        private List<RecoveryInstanceDataReplicationInfoReplicatedDisk> replicatedDisks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryInstanceDataReplicationInfo model) {
            this.dataReplicationError(model.dataReplicationError);
            this.dataReplicationInitiation(model.dataReplicationInitiation);
            this.dataReplicationState(model.dataReplicationState);
            this.etaDateTime(model.etaDateTime);
            this.lagDuration(model.lagDuration);
            this.replicatedDisks(model.replicatedDisks);
        }

        public final RecoveryInstanceDataReplicationError.Builder getDataReplicationError() {
            return this.dataReplicationError != null ? this.dataReplicationError.toBuilder() : null;
        }

        public final void setDataReplicationError(RecoveryInstanceDataReplicationError.BuilderImpl dataReplicationError) {
            this.dataReplicationError = dataReplicationError != null ? dataReplicationError.build() : null;
        }

        @Override
        @Transient
        public final Builder dataReplicationError(RecoveryInstanceDataReplicationError dataReplicationError) {
            this.dataReplicationError = dataReplicationError;
            return this;
        }

        public final RecoveryInstanceDataReplicationInitiation.Builder getDataReplicationInitiation() {
            return this.dataReplicationInitiation != null ? this.dataReplicationInitiation.toBuilder() : null;
        }

        public final void setDataReplicationInitiation(RecoveryInstanceDataReplicationInitiation.BuilderImpl dataReplicationInitiation) {
            this.dataReplicationInitiation = dataReplicationInitiation != null ? dataReplicationInitiation.build() : null;
        }

        @Override
        @Transient
        public final Builder dataReplicationInitiation(RecoveryInstanceDataReplicationInitiation dataReplicationInitiation) {
            this.dataReplicationInitiation = dataReplicationInitiation;
            return this;
        }

        public final String getDataReplicationState() {
            return this.dataReplicationState;
        }

        public final void setDataReplicationState(String dataReplicationState) {
            this.dataReplicationState = dataReplicationState;
        }

        @Override
        @Transient
        public final Builder dataReplicationState(String dataReplicationState) {
            this.dataReplicationState = dataReplicationState;
            return this;
        }

        @Override
        @Transient
        public final Builder dataReplicationState(RecoveryInstanceDataReplicationState dataReplicationState) {
            this.dataReplicationState(dataReplicationState == null ? null : dataReplicationState.toString());
            return this;
        }

        public final String getEtaDateTime() {
            return this.etaDateTime;
        }

        public final void setEtaDateTime(String etaDateTime) {
            this.etaDateTime = etaDateTime;
        }

        @Override
        @Transient
        public final Builder etaDateTime(String etaDateTime) {
            this.etaDateTime = etaDateTime;
            return this;
        }

        public final String getLagDuration() {
            return this.lagDuration;
        }

        public final void setLagDuration(String lagDuration) {
            this.lagDuration = lagDuration;
        }

        @Override
        @Transient
        public final Builder lagDuration(String lagDuration) {
            this.lagDuration = lagDuration;
            return this;
        }

        public final List<RecoveryInstanceDataReplicationInfoReplicatedDisk.Builder> getReplicatedDisks() {
            List<RecoveryInstanceDataReplicationInfoReplicatedDisk.Builder> result = RecoveryInstanceDataReplicationInfoReplicatedDisksCopier.copyToBuilder(this.replicatedDisks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicatedDisks(Collection<RecoveryInstanceDataReplicationInfoReplicatedDisk.BuilderImpl> replicatedDisks) {
            this.replicatedDisks = RecoveryInstanceDataReplicationInfoReplicatedDisksCopier.copyFromBuilder(replicatedDisks);
        }

        @Override
        @Transient
        public final Builder replicatedDisks(Collection<RecoveryInstanceDataReplicationInfoReplicatedDisk> replicatedDisks) {
            this.replicatedDisks = RecoveryInstanceDataReplicationInfoReplicatedDisksCopier.copy(replicatedDisks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicatedDisks(RecoveryInstanceDataReplicationInfoReplicatedDisk ... replicatedDisks) {
            this.replicatedDisks(Arrays.asList(replicatedDisks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicatedDisks(Consumer<RecoveryInstanceDataReplicationInfoReplicatedDisk.Builder> ... replicatedDisks) {
            this.replicatedDisks(Stream.of(replicatedDisks).map(c -> (RecoveryInstanceDataReplicationInfoReplicatedDisk)((RecoveryInstanceDataReplicationInfoReplicatedDisk.Builder)RecoveryInstanceDataReplicationInfoReplicatedDisk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RecoveryInstanceDataReplicationInfo build() {
            return new RecoveryInstanceDataReplicationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecoveryInstanceDataReplicationInfo> {
        public Builder dataReplicationError(RecoveryInstanceDataReplicationError var1);

        default public Builder dataReplicationError(Consumer<RecoveryInstanceDataReplicationError.Builder> dataReplicationError) {
            return this.dataReplicationError((RecoveryInstanceDataReplicationError)((RecoveryInstanceDataReplicationError.Builder)RecoveryInstanceDataReplicationError.builder().applyMutation(dataReplicationError)).build());
        }

        public Builder dataReplicationInitiation(RecoveryInstanceDataReplicationInitiation var1);

        default public Builder dataReplicationInitiation(Consumer<RecoveryInstanceDataReplicationInitiation.Builder> dataReplicationInitiation) {
            return this.dataReplicationInitiation((RecoveryInstanceDataReplicationInitiation)((RecoveryInstanceDataReplicationInitiation.Builder)RecoveryInstanceDataReplicationInitiation.builder().applyMutation(dataReplicationInitiation)).build());
        }

        public Builder dataReplicationState(String var1);

        public Builder dataReplicationState(RecoveryInstanceDataReplicationState var1);

        public Builder etaDateTime(String var1);

        public Builder lagDuration(String var1);

        public Builder replicatedDisks(Collection<RecoveryInstanceDataReplicationInfoReplicatedDisk> var1);

        public Builder replicatedDisks(RecoveryInstanceDataReplicationInfoReplicatedDisk ... var1);

        public Builder replicatedDisks(Consumer<RecoveryInstanceDataReplicationInfoReplicatedDisk.Builder> ... var1);
    }
}

