/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecoveryInstancesRequest extends DrsRequest implements
        ToCopyableBuilder<DescribeRecoveryInstancesRequest.Builder, DescribeRecoveryInstancesRequest> {
    private static final SdkField<DescribeRecoveryInstancesRequestFilters> FILTERS_FIELD = SdkField
            .<DescribeRecoveryInstancesRequestFilters> builder(MarshallingType.SDK_POJO).memberName("filters")
            .getter(getter(DescribeRecoveryInstancesRequest::filters)).setter(setter(Builder::filters))
            .constructor(DescribeRecoveryInstancesRequestFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeRecoveryInstancesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeRecoveryInstancesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final DescribeRecoveryInstancesRequestFilters filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeRecoveryInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A set of filters by which to return Recovery Instances.
     * </p>
     * 
     * @return A set of filters by which to return Recovery Instances.
     */
    public final DescribeRecoveryInstancesRequestFilters filters() {
        return filters;
    }

    /**
     * <p>
     * Maximum number of Recovery Instances to retrieve.
     * </p>
     * 
     * @return Maximum number of Recovery Instances to retrieve.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token of the next Recovery Instance to retrieve.
     * </p>
     * 
     * @return The token of the next Recovery Instance to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecoveryInstancesRequest)) {
            return false;
        }
        DescribeRecoveryInstancesRequest other = (DescribeRecoveryInstancesRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecoveryInstancesRequest").add("Filters", filters()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecoveryInstancesRequest, T> g) {
        return obj -> g.apply((DescribeRecoveryInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRecoveryInstancesRequest> {
        /**
         * <p>
         * A set of filters by which to return Recovery Instances.
         * </p>
         * 
         * @param filters
         *        A set of filters by which to return Recovery Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DescribeRecoveryInstancesRequestFilters filters);

        /**
         * <p>
         * A set of filters by which to return Recovery Instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DescribeRecoveryInstancesRequestFilters.Builder} avoiding the need to create one manually via
         * {@link DescribeRecoveryInstancesRequestFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribeRecoveryInstancesRequestFilters.Builder#build()} is
         * called immediately and its result is passed to {@link #filters(DescribeRecoveryInstancesRequestFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link DescribeRecoveryInstancesRequestFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(DescribeRecoveryInstancesRequestFilters)
         */
        default Builder filters(Consumer<DescribeRecoveryInstancesRequestFilters.Builder> filters) {
            return filters(DescribeRecoveryInstancesRequestFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Maximum number of Recovery Instances to retrieve.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of Recovery Instances to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token of the next Recovery Instance to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The token of the next Recovery Instance to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DrsRequest.BuilderImpl implements Builder {
        private DescribeRecoveryInstancesRequestFilters filters;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecoveryInstancesRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final DescribeRecoveryInstancesRequestFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(DescribeRecoveryInstancesRequestFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(DescribeRecoveryInstancesRequestFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRecoveryInstancesRequest build() {
            return new DescribeRecoveryInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
