/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties of the cloud environment where this Source Server originated from.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceCloudProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceCloudProperties.Builder, SourceCloudProperties> {
    private static final SdkField<String> ORIGIN_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originAccountID").getter(getter(SourceCloudProperties::originAccountID))
            .setter(setter(Builder::originAccountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originAccountID").build()).build();

    private static final SdkField<String> ORIGIN_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originAvailabilityZone").getter(getter(SourceCloudProperties::originAvailabilityZone))
            .setter(setter(Builder::originAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originAvailabilityZone").build())
            .build();

    private static final SdkField<String> ORIGIN_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originRegion").getter(getter(SourceCloudProperties::originRegion)).setter(setter(Builder::originRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCOUNT_ID_FIELD,
            ORIGIN_AVAILABILITY_ZONE_FIELD, ORIGIN_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String originAccountID;

    private final String originAvailabilityZone;

    private final String originRegion;

    private SourceCloudProperties(BuilderImpl builder) {
        this.originAccountID = builder.originAccountID;
        this.originAvailabilityZone = builder.originAvailabilityZone;
        this.originRegion = builder.originRegion;
    }

    /**
     * <p>
     * AWS Account ID for an EC2-originated Source Server.
     * </p>
     * 
     * @return AWS Account ID for an EC2-originated Source Server.
     */
    public final String originAccountID() {
        return originAccountID;
    }

    /**
     * <p>
     * AWS Availability Zone for an EC2-originated Source Server.
     * </p>
     * 
     * @return AWS Availability Zone for an EC2-originated Source Server.
     */
    public final String originAvailabilityZone() {
        return originAvailabilityZone;
    }

    /**
     * <p>
     * AWS Region for an EC2-originated Source Server.
     * </p>
     * 
     * @return AWS Region for an EC2-originated Source Server.
     */
    public final String originRegion() {
        return originRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(originAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(originAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(originRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCloudProperties)) {
            return false;
        }
        SourceCloudProperties other = (SourceCloudProperties) obj;
        return Objects.equals(originAccountID(), other.originAccountID())
                && Objects.equals(originAvailabilityZone(), other.originAvailabilityZone())
                && Objects.equals(originRegion(), other.originRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceCloudProperties").add("OriginAccountID", originAccountID())
                .add("OriginAvailabilityZone", originAvailabilityZone()).add("OriginRegion", originRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "originAccountID":
            return Optional.ofNullable(clazz.cast(originAccountID()));
        case "originAvailabilityZone":
            return Optional.ofNullable(clazz.cast(originAvailabilityZone()));
        case "originRegion":
            return Optional.ofNullable(clazz.cast(originRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceCloudProperties, T> g) {
        return obj -> g.apply((SourceCloudProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceCloudProperties> {
        /**
         * <p>
         * AWS Account ID for an EC2-originated Source Server.
         * </p>
         * 
         * @param originAccountID
         *        AWS Account ID for an EC2-originated Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originAccountID(String originAccountID);

        /**
         * <p>
         * AWS Availability Zone for an EC2-originated Source Server.
         * </p>
         * 
         * @param originAvailabilityZone
         *        AWS Availability Zone for an EC2-originated Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originAvailabilityZone(String originAvailabilityZone);

        /**
         * <p>
         * AWS Region for an EC2-originated Source Server.
         * </p>
         * 
         * @param originRegion
         *        AWS Region for an EC2-originated Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originRegion(String originRegion);
    }

    static final class BuilderImpl implements Builder {
        private String originAccountID;

        private String originAvailabilityZone;

        private String originRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCloudProperties model) {
            originAccountID(model.originAccountID);
            originAvailabilityZone(model.originAvailabilityZone);
            originRegion(model.originRegion);
        }

        public final String getOriginAccountID() {
            return originAccountID;
        }

        public final void setOriginAccountID(String originAccountID) {
            this.originAccountID = originAccountID;
        }

        @Override
        public final Builder originAccountID(String originAccountID) {
            this.originAccountID = originAccountID;
            return this;
        }

        public final String getOriginAvailabilityZone() {
            return originAvailabilityZone;
        }

        public final void setOriginAvailabilityZone(String originAvailabilityZone) {
            this.originAvailabilityZone = originAvailabilityZone;
        }

        @Override
        public final Builder originAvailabilityZone(String originAvailabilityZone) {
            this.originAvailabilityZone = originAvailabilityZone;
            return this;
        }

        public final String getOriginRegion() {
            return originRegion;
        }

        public final void setOriginRegion(String originRegion) {
            this.originRegion = originRegion;
        }

        @Override
        public final Builder originRegion(String originRegion) {
            this.originRegion = originRegion;
            return this;
        }

        @Override
        public SourceCloudProperties build() {
            return new SourceCloudProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
