/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.drs.model.AccessDeniedException;
import software.amazon.awssdk.services.drs.model.ConflictException;
import software.amazon.awssdk.services.drs.model.CreateExtendedSourceServerRequest;
import software.amazon.awssdk.services.drs.model.CreateExtendedSourceServerResponse;
import software.amazon.awssdk.services.drs.model.CreateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.CreateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.CreateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.CreateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.DeleteJobRequest;
import software.amazon.awssdk.services.drs.model.DeleteJobResponse;
import software.amazon.awssdk.services.drs.model.DeleteLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.DeleteLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.DeleteRecoveryInstanceRequest;
import software.amazon.awssdk.services.drs.model.DeleteRecoveryInstanceResponse;
import software.amazon.awssdk.services.drs.model.DeleteReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.DeleteReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.DeleteSourceServerRequest;
import software.amazon.awssdk.services.drs.model.DeleteSourceServerResponse;
import software.amazon.awssdk.services.drs.model.DescribeJobLogItemsRequest;
import software.amazon.awssdk.services.drs.model.DescribeJobLogItemsResponse;
import software.amazon.awssdk.services.drs.model.DescribeJobsRequest;
import software.amazon.awssdk.services.drs.model.DescribeJobsResponse;
import software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesRequest;
import software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesResponse;
import software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesRequest;
import software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesResponse;
import software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsRequest;
import software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsResponse;
import software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesRequest;
import software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesResponse;
import software.amazon.awssdk.services.drs.model.DescribeSourceServersRequest;
import software.amazon.awssdk.services.drs.model.DescribeSourceServersResponse;
import software.amazon.awssdk.services.drs.model.DisconnectRecoveryInstanceRequest;
import software.amazon.awssdk.services.drs.model.DisconnectRecoveryInstanceResponse;
import software.amazon.awssdk.services.drs.model.DisconnectSourceServerRequest;
import software.amazon.awssdk.services.drs.model.DisconnectSourceServerResponse;
import software.amazon.awssdk.services.drs.model.DrsException;
import software.amazon.awssdk.services.drs.model.GetFailbackReplicationConfigurationRequest;
import software.amazon.awssdk.services.drs.model.GetFailbackReplicationConfigurationResponse;
import software.amazon.awssdk.services.drs.model.GetLaunchConfigurationRequest;
import software.amazon.awssdk.services.drs.model.GetLaunchConfigurationResponse;
import software.amazon.awssdk.services.drs.model.GetReplicationConfigurationRequest;
import software.amazon.awssdk.services.drs.model.GetReplicationConfigurationResponse;
import software.amazon.awssdk.services.drs.model.InitializeServiceRequest;
import software.amazon.awssdk.services.drs.model.InitializeServiceResponse;
import software.amazon.awssdk.services.drs.model.InternalServerException;
import software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersRequest;
import software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersResponse;
import software.amazon.awssdk.services.drs.model.ListStagingAccountsRequest;
import software.amazon.awssdk.services.drs.model.ListStagingAccountsResponse;
import software.amazon.awssdk.services.drs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.drs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.drs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.drs.model.RetryDataReplicationRequest;
import software.amazon.awssdk.services.drs.model.RetryDataReplicationResponse;
import software.amazon.awssdk.services.drs.model.ReverseReplicationRequest;
import software.amazon.awssdk.services.drs.model.ReverseReplicationResponse;
import software.amazon.awssdk.services.drs.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.drs.model.StartFailbackLaunchRequest;
import software.amazon.awssdk.services.drs.model.StartFailbackLaunchResponse;
import software.amazon.awssdk.services.drs.model.StartRecoveryRequest;
import software.amazon.awssdk.services.drs.model.StartRecoveryResponse;
import software.amazon.awssdk.services.drs.model.StartReplicationRequest;
import software.amazon.awssdk.services.drs.model.StartReplicationResponse;
import software.amazon.awssdk.services.drs.model.StopFailbackRequest;
import software.amazon.awssdk.services.drs.model.StopFailbackResponse;
import software.amazon.awssdk.services.drs.model.StopReplicationRequest;
import software.amazon.awssdk.services.drs.model.StopReplicationResponse;
import software.amazon.awssdk.services.drs.model.TagResourceRequest;
import software.amazon.awssdk.services.drs.model.TagResourceResponse;
import software.amazon.awssdk.services.drs.model.TerminateRecoveryInstancesRequest;
import software.amazon.awssdk.services.drs.model.TerminateRecoveryInstancesResponse;
import software.amazon.awssdk.services.drs.model.ThrottlingException;
import software.amazon.awssdk.services.drs.model.UninitializedAccountException;
import software.amazon.awssdk.services.drs.model.UntagResourceRequest;
import software.amazon.awssdk.services.drs.model.UntagResourceResponse;
import software.amazon.awssdk.services.drs.model.UpdateFailbackReplicationConfigurationRequest;
import software.amazon.awssdk.services.drs.model.UpdateFailbackReplicationConfigurationResponse;
import software.amazon.awssdk.services.drs.model.UpdateLaunchConfigurationRequest;
import software.amazon.awssdk.services.drs.model.UpdateLaunchConfigurationResponse;
import software.amazon.awssdk.services.drs.model.UpdateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.UpdateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.UpdateReplicationConfigurationRequest;
import software.amazon.awssdk.services.drs.model.UpdateReplicationConfigurationResponse;
import software.amazon.awssdk.services.drs.model.UpdateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.drs.model.UpdateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.drs.model.ValidationException;
import software.amazon.awssdk.services.drs.paginators.DescribeJobLogItemsIterable;
import software.amazon.awssdk.services.drs.paginators.DescribeJobsIterable;
import software.amazon.awssdk.services.drs.paginators.DescribeLaunchConfigurationTemplatesIterable;
import software.amazon.awssdk.services.drs.paginators.DescribeRecoveryInstancesIterable;
import software.amazon.awssdk.services.drs.paginators.DescribeRecoverySnapshotsIterable;
import software.amazon.awssdk.services.drs.paginators.DescribeReplicationConfigurationTemplatesIterable;
import software.amazon.awssdk.services.drs.paginators.DescribeSourceServersIterable;
import software.amazon.awssdk.services.drs.paginators.ListExtensibleSourceServersIterable;
import software.amazon.awssdk.services.drs.paginators.ListStagingAccountsIterable;

/**
 * Service client for accessing drs. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Elastic Disaster Recovery Service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DrsClient extends AwsClient {
    String SERVICE_NAME = "drs";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "drs";

    /**
     * <p>
     * Create an extended source server in the target Account based on the source server in staging account.
     * </p>
     *
     * @param createExtendedSourceServerRequest
     * @return Result of the CreateExtendedSourceServer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.CreateExtendedSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateExtendedSourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateExtendedSourceServerResponse createExtendedSourceServer(
            CreateExtendedSourceServerRequest createExtendedSourceServerRequest) throws ResourceNotFoundException,
            InternalServerException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException,
            ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an extended source server in the target Account based on the source server in staging account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExtendedSourceServerRequest.Builder} avoiding
     * the need to create one manually via {@link CreateExtendedSourceServerRequest#builder()}
     * </p>
     *
     * @param createExtendedSourceServerRequest
     *        A {@link Consumer} that will call methods on {@link CreateExtendedSourceServerRequest.Builder} to create a
     *        request.
     * @return Result of the CreateExtendedSourceServer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.CreateExtendedSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateExtendedSourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateExtendedSourceServerResponse createExtendedSourceServer(
            Consumer<CreateExtendedSourceServerRequest.Builder> createExtendedSourceServerRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        return createExtendedSourceServer(CreateExtendedSourceServerRequest.builder()
                .applyMutation(createExtendedSourceServerRequest).build());
    }

    /**
     * <p>
     * Creates a new Launch Configuration Template.
     * </p>
     *
     * @param createLaunchConfigurationTemplateRequest
     * @return Result of the CreateLaunchConfigurationTemplate operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.CreateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLaunchConfigurationTemplateResponse createLaunchConfigurationTemplate(
            CreateLaunchConfigurationTemplateRequest createLaunchConfigurationTemplateRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Launch Configuration Template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLaunchConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLaunchConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param createLaunchConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateLaunchConfigurationTemplateRequest.Builder} to
     *        create a request.
     * @return Result of the CreateLaunchConfigurationTemplate operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.CreateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLaunchConfigurationTemplateResponse createLaunchConfigurationTemplate(
            Consumer<CreateLaunchConfigurationTemplateRequest.Builder> createLaunchConfigurationTemplateRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException,
            ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return createLaunchConfigurationTemplate(CreateLaunchConfigurationTemplateRequest.builder()
                .applyMutation(createLaunchConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a new ReplicationConfigurationTemplate.
     * </p>
     *
     * @param createReplicationConfigurationTemplateRequest
     * @return Result of the CreateReplicationConfigurationTemplate operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.CreateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationConfigurationTemplateResponse createReplicationConfigurationTemplate(
            CreateReplicationConfigurationTemplateRequest createReplicationConfigurationTemplateRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException,
            ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new ReplicationConfigurationTemplate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link CreateReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param createReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the CreateReplicationConfigurationTemplate operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.CreateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/CreateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationConfigurationTemplateResponse createReplicationConfigurationTemplate(
            Consumer<CreateReplicationConfigurationTemplateRequest.Builder> createReplicationConfigurationTemplateRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException,
            ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return createReplicationConfigurationTemplate(CreateReplicationConfigurationTemplateRequest.builder()
                .applyMutation(createReplicationConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a single Job by ID.
     * </p>
     *
     * @param deleteJobRequest
     * @return Result of the DeleteJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Job by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJobRequest#builder()}
     * </p>
     *
     * @param deleteJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteJobRequest.Builder} to create a request.
     * @return Result of the DeleteJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteJobResponse deleteJob(Consumer<DeleteJobRequest.Builder> deleteJobRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        return deleteJob(DeleteJobRequest.builder().applyMutation(deleteJobRequest).build());
    }

    /**
     * <p>
     * Deletes a single Launch Configuration Template by ID.
     * </p>
     *
     * @param deleteLaunchConfigurationTemplateRequest
     * @return Result of the DeleteLaunchConfigurationTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DeleteLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLaunchConfigurationTemplateResponse deleteLaunchConfigurationTemplate(
            DeleteLaunchConfigurationTemplateRequest deleteLaunchConfigurationTemplateRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Launch Configuration Template by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteLaunchConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param deleteLaunchConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLaunchConfigurationTemplateRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteLaunchConfigurationTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DeleteLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLaunchConfigurationTemplateResponse deleteLaunchConfigurationTemplate(
            Consumer<DeleteLaunchConfigurationTemplateRequest.Builder> deleteLaunchConfigurationTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return deleteLaunchConfigurationTemplate(DeleteLaunchConfigurationTemplateRequest.builder()
                .applyMutation(deleteLaunchConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a single Recovery Instance by ID. This deletes the Recovery Instance resource from Elastic Disaster
     * Recovery. The Recovery Instance must be disconnected first in order to delete it.
     * </p>
     *
     * @param deleteRecoveryInstanceRequest
     * @return Result of the DeleteRecoveryInstance operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DeleteRecoveryInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteRecoveryInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRecoveryInstanceResponse deleteRecoveryInstance(DeleteRecoveryInstanceRequest deleteRecoveryInstanceRequest)
            throws InternalServerException, ConflictException, ThrottlingException, AccessDeniedException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Recovery Instance by ID. This deletes the Recovery Instance resource from Elastic Disaster
     * Recovery. The Recovery Instance must be disconnected first in order to delete it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecoveryInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRecoveryInstanceRequest#builder()}
     * </p>
     *
     * @param deleteRecoveryInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRecoveryInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRecoveryInstance operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DeleteRecoveryInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteRecoveryInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRecoveryInstanceResponse deleteRecoveryInstance(
            Consumer<DeleteRecoveryInstanceRequest.Builder> deleteRecoveryInstanceRequest) throws InternalServerException,
            ConflictException, ThrottlingException, AccessDeniedException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        return deleteRecoveryInstance(DeleteRecoveryInstanceRequest.builder().applyMutation(deleteRecoveryInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a single Replication Configuration Template by ID
     * </p>
     *
     * @param deleteReplicationConfigurationTemplateRequest
     * @return Result of the DeleteReplicationConfigurationTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DeleteReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationConfigurationTemplateResponse deleteReplicationConfigurationTemplate(
            DeleteReplicationConfigurationTemplateRequest deleteReplicationConfigurationTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Replication Configuration Template by ID
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param deleteReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteReplicationConfigurationTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DeleteReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationConfigurationTemplateResponse deleteReplicationConfigurationTemplate(
            Consumer<DeleteReplicationConfigurationTemplateRequest.Builder> deleteReplicationConfigurationTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return deleteReplicationConfigurationTemplate(DeleteReplicationConfigurationTemplateRequest.builder()
                .applyMutation(deleteReplicationConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a single Source Server by ID. The Source Server must be disconnected first.
     * </p>
     *
     * @param deleteSourceServerRequest
     * @return Result of the DeleteSourceServer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DeleteSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteSourceServer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSourceServerResponse deleteSourceServer(DeleteSourceServerRequest deleteSourceServerRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Source Server by ID. The Source Server must be disconnected first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSourceServerRequest#builder()}
     * </p>
     *
     * @param deleteSourceServerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSourceServerRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSourceServer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DeleteSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DeleteSourceServer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSourceServerResponse deleteSourceServer(Consumer<DeleteSourceServerRequest.Builder> deleteSourceServerRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return deleteSourceServer(DeleteSourceServerRequest.builder().applyMutation(deleteSourceServerRequest).build());
    }

    /**
     * <p>
     * Retrieves a detailed Job log with pagination.
     * </p>
     *
     * @param describeJobLogItemsRequest
     * @return Result of the DescribeJobLogItems operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsResponse describeJobLogItems(DescribeJobLogItemsRequest describeJobLogItemsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a detailed Job log with pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobLogItemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobLogItemsRequest#builder()}
     * </p>
     *
     * @param describeJobLogItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobLogItemsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeJobLogItems operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsResponse describeJobLogItems(
            Consumer<DescribeJobLogItemsRequest.Builder> describeJobLogItemsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        return describeJobLogItems(DescribeJobLogItemsRequest.builder().applyMutation(describeJobLogItemsRequest).build());
    }

    /**
     * <p>
     * Retrieves a detailed Job log with pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeJobLogItems(software.amazon.awssdk.services.drs.model.DescribeJobLogItemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeJobLogItemsIterable responses = client.describeJobLogItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeJobLogItemsIterable responses = client
     *             .describeJobLogItemsPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeJobLogItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeJobLogItemsIterable responses = client.describeJobLogItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobLogItems(software.amazon.awssdk.services.drs.model.DescribeJobLogItemsRequest)} operation.</b>
     * </p>
     *
     * @param describeJobLogItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsIterable describeJobLogItemsPaginator(DescribeJobLogItemsRequest describeJobLogItemsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a detailed Job log with pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeJobLogItems(software.amazon.awssdk.services.drs.model.DescribeJobLogItemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeJobLogItemsIterable responses = client.describeJobLogItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeJobLogItemsIterable responses = client
     *             .describeJobLogItemsPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeJobLogItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeJobLogItemsIterable responses = client.describeJobLogItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobLogItems(software.amazon.awssdk.services.drs.model.DescribeJobLogItemsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobLogItemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobLogItemsRequest#builder()}
     * </p>
     *
     * @param describeJobLogItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobLogItemsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsIterable describeJobLogItemsPaginator(
            Consumer<DescribeJobLogItemsRequest.Builder> describeJobLogItemsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        return describeJobLogItemsPaginator(DescribeJobLogItemsRequest.builder().applyMutation(describeJobLogItemsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toDate filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are created by the StartRecovery,
     * TerminateRecoveryInstances and StartFailbackLaunch APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     *
     * @param describeJobsRequest
     * @return Result of the DescribeJobs operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsResponse describeJobs(DescribeJobsRequest describeJobsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toDate filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are created by the StartRecovery,
     * TerminateRecoveryInstances and StartFailbackLaunch APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobsRequest#builder()}
     * </p>
     *
     * @param describeJobsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobsRequest.Builder} to create a request.
     * @return Result of the DescribeJobs operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsResponse describeJobs(Consumer<DescribeJobsRequest.Builder> describeJobsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        return describeJobs(DescribeJobsRequest.builder().applyMutation(describeJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toDate filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are created by the StartRecovery,
     * TerminateRecoveryInstances and StartFailbackLaunch APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeJobs(software.amazon.awssdk.services.drs.model.DescribeJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobs(software.amazon.awssdk.services.drs.model.DescribeJobsRequest)} operation.</b>
     * </p>
     *
     * @param describeJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsIterable describeJobsPaginator(DescribeJobsRequest describeJobsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toDate filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are created by the StartRecovery,
     * TerminateRecoveryInstances and StartFailbackLaunch APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeJobs(software.amazon.awssdk.services.drs.model.DescribeJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobs(software.amazon.awssdk.services.drs.model.DescribeJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobsRequest#builder()}
     * </p>
     *
     * @param describeJobsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsIterable describeJobsPaginator(Consumer<DescribeJobsRequest.Builder> describeJobsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        return describeJobsPaginator(DescribeJobsRequest.builder().applyMutation(describeJobsRequest).build());
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     * @return Result of the DescribeLaunchConfigurationTemplates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationTemplatesResponse describeLaunchConfigurationTemplates(
            DescribeLaunchConfigurationTemplatesRequest describeLaunchConfigurationTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeLaunchConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeLaunchConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLaunchConfigurationTemplatesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeLaunchConfigurationTemplates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationTemplatesResponse describeLaunchConfigurationTemplates(
            Consumer<DescribeLaunchConfigurationTemplatesRequest.Builder> describeLaunchConfigurationTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return describeLaunchConfigurationTemplates(DescribeLaunchConfigurationTemplatesRequest.builder()
                .applyMutation(describeLaunchConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client.describeLaunchConfigurationTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client
     *             .describeLaunchConfigurationTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client.describeLaunchConfigurationTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationTemplatesIterable describeLaunchConfigurationTemplatesPaginator(
            DescribeLaunchConfigurationTemplatesRequest describeLaunchConfigurationTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client.describeLaunchConfigurationTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client
     *             .describeLaunchConfigurationTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client.describeLaunchConfigurationTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.drs.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeLaunchConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeLaunchConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLaunchConfigurationTemplatesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationTemplatesIterable describeLaunchConfigurationTemplatesPaginator(
            Consumer<DescribeLaunchConfigurationTemplatesRequest.Builder> describeLaunchConfigurationTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return describeLaunchConfigurationTemplatesPaginator(DescribeLaunchConfigurationTemplatesRequest.builder()
                .applyMutation(describeLaunchConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all Recovery Instances or multiple Recovery Instances by ID.
     * </p>
     *
     * @param describeRecoveryInstancesRequest
     * @return Result of the DescribeRecoveryInstances operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeRecoveryInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoveryInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoveryInstancesResponse describeRecoveryInstances(
            DescribeRecoveryInstancesRequest describeRecoveryInstancesRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Recovery Instances or multiple Recovery Instances by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecoveryInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRecoveryInstancesRequest#builder()}
     * </p>
     *
     * @param describeRecoveryInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRecoveryInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRecoveryInstances operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeRecoveryInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoveryInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoveryInstancesResponse describeRecoveryInstances(
            Consumer<DescribeRecoveryInstancesRequest.Builder> describeRecoveryInstancesRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        return describeRecoveryInstances(DescribeRecoveryInstancesRequest.builder()
                .applyMutation(describeRecoveryInstancesRequest).build());
    }

    /**
     * <p>
     * Lists all Recovery Instances or multiple Recovery Instances by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRecoveryInstances(software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeRecoveryInstancesIterable responses = client.describeRecoveryInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeRecoveryInstancesIterable responses = client
     *             .describeRecoveryInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeRecoveryInstancesIterable responses = client.describeRecoveryInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecoveryInstances(software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRecoveryInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeRecoveryInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoveryInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoveryInstancesIterable describeRecoveryInstancesPaginator(
            DescribeRecoveryInstancesRequest describeRecoveryInstancesRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Recovery Instances or multiple Recovery Instances by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRecoveryInstances(software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeRecoveryInstancesIterable responses = client.describeRecoveryInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeRecoveryInstancesIterable responses = client
     *             .describeRecoveryInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeRecoveryInstancesIterable responses = client.describeRecoveryInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecoveryInstances(software.amazon.awssdk.services.drs.model.DescribeRecoveryInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecoveryInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRecoveryInstancesRequest#builder()}
     * </p>
     *
     * @param describeRecoveryInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRecoveryInstancesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeRecoveryInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoveryInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoveryInstancesIterable describeRecoveryInstancesPaginator(
            Consumer<DescribeRecoveryInstancesRequest.Builder> describeRecoveryInstancesRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        return describeRecoveryInstancesPaginator(DescribeRecoveryInstancesRequest.builder()
                .applyMutation(describeRecoveryInstancesRequest).build());
    }

    /**
     * <p>
     * Lists all Recovery Snapshots for a single Source Server.
     * </p>
     *
     * @param describeRecoverySnapshotsRequest
     * @return Result of the DescribeRecoverySnapshots operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeRecoverySnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoverySnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoverySnapshotsResponse describeRecoverySnapshots(
            DescribeRecoverySnapshotsRequest describeRecoverySnapshotsRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Recovery Snapshots for a single Source Server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecoverySnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRecoverySnapshotsRequest#builder()}
     * </p>
     *
     * @param describeRecoverySnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRecoverySnapshotsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRecoverySnapshots operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeRecoverySnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoverySnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoverySnapshotsResponse describeRecoverySnapshots(
            Consumer<DescribeRecoverySnapshotsRequest.Builder> describeRecoverySnapshotsRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        return describeRecoverySnapshots(DescribeRecoverySnapshotsRequest.builder()
                .applyMutation(describeRecoverySnapshotsRequest).build());
    }

    /**
     * <p>
     * Lists all Recovery Snapshots for a single Source Server.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRecoverySnapshots(software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeRecoverySnapshotsIterable responses = client.describeRecoverySnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeRecoverySnapshotsIterable responses = client
     *             .describeRecoverySnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeRecoverySnapshotsIterable responses = client.describeRecoverySnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecoverySnapshots(software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRecoverySnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeRecoverySnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoverySnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoverySnapshotsIterable describeRecoverySnapshotsPaginator(
            DescribeRecoverySnapshotsRequest describeRecoverySnapshotsRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Recovery Snapshots for a single Source Server.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRecoverySnapshots(software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeRecoverySnapshotsIterable responses = client.describeRecoverySnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeRecoverySnapshotsIterable responses = client
     *             .describeRecoverySnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeRecoverySnapshotsIterable responses = client.describeRecoverySnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecoverySnapshots(software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecoverySnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRecoverySnapshotsRequest#builder()}
     * </p>
     *
     * @param describeRecoverySnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRecoverySnapshotsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeRecoverySnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeRecoverySnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoverySnapshotsIterable describeRecoverySnapshotsPaginator(
            Consumer<DescribeRecoverySnapshotsRequest.Builder> describeRecoverySnapshotsRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        return describeRecoverySnapshotsPaginator(DescribeRecoverySnapshotsRequest.builder()
                .applyMutation(describeRecoverySnapshotsRequest).build());
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     * @return Result of the DescribeReplicationConfigurationTemplates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesResponse describeReplicationConfigurationTemplates(
            DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationConfigurationTemplatesRequest.Builder} to create a request.
     * @return Result of the DescribeReplicationConfigurationTemplates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesResponse describeReplicationConfigurationTemplates(
            Consumer<DescribeReplicationConfigurationTemplatesRequest.Builder> describeReplicationConfigurationTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return describeReplicationConfigurationTemplates(DescribeReplicationConfigurationTemplatesRequest.builder()
                .applyMutation(describeReplicationConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client.describeReplicationConfigurationTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client
     *             .describeReplicationConfigurationTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client.describeReplicationConfigurationTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesIterable describeReplicationConfigurationTemplatesPaginator(
            DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client.describeReplicationConfigurationTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client
     *             .describeReplicationConfigurationTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client.describeReplicationConfigurationTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.drs.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationConfigurationTemplatesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesIterable describeReplicationConfigurationTemplatesPaginator(
            Consumer<DescribeReplicationConfigurationTemplatesRequest.Builder> describeReplicationConfigurationTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return describeReplicationConfigurationTemplatesPaginator(DescribeReplicationConfigurationTemplatesRequest.builder()
                .applyMutation(describeReplicationConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all Source Servers or multiple Source Servers filtered by ID.
     * </p>
     *
     * @param describeSourceServersRequest
     * @return Result of the DescribeSourceServers operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersResponse describeSourceServers(DescribeSourceServersRequest describeSourceServersRequest)
            throws InternalServerException, ThrottlingException, ValidationException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Source Servers or multiple Source Servers filtered by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceServersRequest#builder()}
     * </p>
     *
     * @param describeSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSourceServersRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSourceServers operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersResponse describeSourceServers(
            Consumer<DescribeSourceServersRequest.Builder> describeSourceServersRequest) throws InternalServerException,
            ThrottlingException, ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        return describeSourceServers(DescribeSourceServersRequest.builder().applyMutation(describeSourceServersRequest).build());
    }

    /**
     * <p>
     * Lists all Source Servers or multiple Source Servers filtered by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSourceServers(software.amazon.awssdk.services.drs.model.DescribeSourceServersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeSourceServersIterable responses = client.describeSourceServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeSourceServersIterable responses = client
     *             .describeSourceServersPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeSourceServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeSourceServersIterable responses = client.describeSourceServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSourceServers(software.amazon.awssdk.services.drs.model.DescribeSourceServersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSourceServersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersIterable describeSourceServersPaginator(DescribeSourceServersRequest describeSourceServersRequest)
            throws InternalServerException, ThrottlingException, ValidationException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Source Servers or multiple Source Servers filtered by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSourceServers(software.amazon.awssdk.services.drs.model.DescribeSourceServersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeSourceServersIterable responses = client.describeSourceServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.DescribeSourceServersIterable responses = client
     *             .describeSourceServersPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.DescribeSourceServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.DescribeSourceServersIterable responses = client.describeSourceServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSourceServers(software.amazon.awssdk.services.drs.model.DescribeSourceServersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceServersRequest#builder()}
     * </p>
     *
     * @param describeSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSourceServersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersIterable describeSourceServersPaginator(
            Consumer<DescribeSourceServersRequest.Builder> describeSourceServersRequest) throws InternalServerException,
            ThrottlingException, ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        return describeSourceServersPaginator(DescribeSourceServersRequest.builder().applyMutation(describeSourceServersRequest)
                .build());
    }

    /**
     * <p>
     * Disconnect a Recovery Instance from Elastic Disaster Recovery. Data replication is stopped immediately. All AWS
     * resources created by Elastic Disaster Recovery for enabling the replication of the Recovery Instance will be
     * terminated / deleted within 90 minutes. If the agent on the Recovery Instance has not been prevented from
     * communicating with the Elastic Disaster Recovery service, then it will receive a command to uninstall itself
     * (within approximately 10 minutes). The following properties of the Recovery Instance will be changed immediately:
     * dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of
     * dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and
     * dataReplicationInfo.lagDuration will be nullified.
     * </p>
     *
     * @param disconnectRecoveryInstanceRequest
     * @return Result of the DisconnectRecoveryInstance operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DisconnectRecoveryInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DisconnectRecoveryInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DisconnectRecoveryInstanceResponse disconnectRecoveryInstance(
            DisconnectRecoveryInstanceRequest disconnectRecoveryInstanceRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, AccessDeniedException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disconnect a Recovery Instance from Elastic Disaster Recovery. Data replication is stopped immediately. All AWS
     * resources created by Elastic Disaster Recovery for enabling the replication of the Recovery Instance will be
     * terminated / deleted within 90 minutes. If the agent on the Recovery Instance has not been prevented from
     * communicating with the Elastic Disaster Recovery service, then it will receive a command to uninstall itself
     * (within approximately 10 minutes). The following properties of the Recovery Instance will be changed immediately:
     * dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of
     * dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and
     * dataReplicationInfo.lagDuration will be nullified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisconnectRecoveryInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DisconnectRecoveryInstanceRequest#builder()}
     * </p>
     *
     * @param disconnectRecoveryInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DisconnectRecoveryInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the DisconnectRecoveryInstance operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DisconnectRecoveryInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DisconnectRecoveryInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DisconnectRecoveryInstanceResponse disconnectRecoveryInstance(
            Consumer<DisconnectRecoveryInstanceRequest.Builder> disconnectRecoveryInstanceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AccessDeniedException, UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return disconnectRecoveryInstance(DisconnectRecoveryInstanceRequest.builder()
                .applyMutation(disconnectRecoveryInstanceRequest).build());
    }

    /**
     * <p>
     * Disconnects a specific Source Server from Elastic Disaster Recovery. Data replication is stopped immediately. All
     * AWS resources created by Elastic Disaster Recovery for enabling the replication of the Source Server will be
     * terminated / deleted within 90 minutes. You cannot disconnect a Source Server if it has a Recovery Instance. If
     * the agent on the Source Server has not been prevented from communicating with the Elastic Disaster Recovery
     * service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following
     * properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set
     * to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to
     * zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     *
     * @param disconnectSourceServerRequest
     * @return Result of the DisconnectSourceServer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DisconnectSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DisconnectSourceServer" target="_top">AWS
     *      API Documentation</a>
     */
    default DisconnectSourceServerResponse disconnectSourceServer(DisconnectSourceServerRequest disconnectSourceServerRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disconnects a specific Source Server from Elastic Disaster Recovery. Data replication is stopped immediately. All
     * AWS resources created by Elastic Disaster Recovery for enabling the replication of the Source Server will be
     * terminated / deleted within 90 minutes. You cannot disconnect a Source Server if it has a Recovery Instance. If
     * the agent on the Source Server has not been prevented from communicating with the Elastic Disaster Recovery
     * service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following
     * properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set
     * to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to
     * zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisconnectSourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link DisconnectSourceServerRequest#builder()}
     * </p>
     *
     * @param disconnectSourceServerRequest
     *        A {@link Consumer} that will call methods on {@link DisconnectSourceServerRequest.Builder} to create a
     *        request.
     * @return Result of the DisconnectSourceServer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.DisconnectSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/DisconnectSourceServer" target="_top">AWS
     *      API Documentation</a>
     */
    default DisconnectSourceServerResponse disconnectSourceServer(
            Consumer<DisconnectSourceServerRequest.Builder> disconnectSourceServerRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        return disconnectSourceServer(DisconnectSourceServerRequest.builder().applyMutation(disconnectSourceServerRequest)
                .build());
    }

    /**
     * <p>
     * Lists all Failback ReplicationConfigurations, filtered by Recovery Instance ID.
     * </p>
     *
     * @param getFailbackReplicationConfigurationRequest
     * @return Result of the GetFailbackReplicationConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.GetFailbackReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetFailbackReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFailbackReplicationConfigurationResponse getFailbackReplicationConfiguration(
            GetFailbackReplicationConfigurationRequest getFailbackReplicationConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Failback ReplicationConfigurations, filtered by Recovery Instance ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFailbackReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetFailbackReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param getFailbackReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetFailbackReplicationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetFailbackReplicationConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.GetFailbackReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetFailbackReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFailbackReplicationConfigurationResponse getFailbackReplicationConfiguration(
            Consumer<GetFailbackReplicationConfigurationRequest.Builder> getFailbackReplicationConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        return getFailbackReplicationConfiguration(GetFailbackReplicationConfigurationRequest.builder()
                .applyMutation(getFailbackReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets a LaunchConfiguration, filtered by Source Server IDs.
     * </p>
     *
     * @param getLaunchConfigurationRequest
     * @return Result of the GetLaunchConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.GetLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLaunchConfigurationResponse getLaunchConfiguration(GetLaunchConfigurationRequest getLaunchConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a LaunchConfiguration, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLaunchConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param getLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetLaunchConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetLaunchConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.GetLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLaunchConfigurationResponse getLaunchConfiguration(
            Consumer<GetLaunchConfigurationRequest.Builder> getLaunchConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        return getLaunchConfiguration(GetLaunchConfigurationRequest.builder().applyMutation(getLaunchConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Gets a ReplicationConfiguration, filtered by Source Server ID.
     * </p>
     *
     * @param getReplicationConfigurationRequest
     * @return Result of the GetReplicationConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.GetReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReplicationConfigurationResponse getReplicationConfiguration(
            GetReplicationConfigurationRequest getReplicationConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a ReplicationConfiguration, filtered by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param getReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetReplicationConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the GetReplicationConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.GetReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/GetReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReplicationConfigurationResponse getReplicationConfiguration(
            Consumer<GetReplicationConfigurationRequest.Builder> getReplicationConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return getReplicationConfiguration(GetReplicationConfigurationRequest.builder()
                .applyMutation(getReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Initialize Elastic Disaster Recovery.
     * </p>
     *
     * @param initializeServiceRequest
     * @return Result of the InitializeService operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default InitializeServiceResponse initializeService(InitializeServiceRequest initializeServiceRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initialize Elastic Disaster Recovery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitializeServiceRequest.Builder} avoiding the need
     * to create one manually via {@link InitializeServiceRequest#builder()}
     * </p>
     *
     * @param initializeServiceRequest
     *        A {@link Consumer} that will call methods on {@link InitializeServiceRequest.Builder} to create a request.
     * @return Result of the InitializeService operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default InitializeServiceResponse initializeService(Consumer<InitializeServiceRequest.Builder> initializeServiceRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, DrsException {
        return initializeService(InitializeServiceRequest.builder().applyMutation(initializeServiceRequest).build());
    }

    /**
     * <p>
     * Returns a list of source servers on a staging account that are extensible, which means that: a. The source server
     * is not already extended into this Account. b. The source server on the Account we’re reading from is not an
     * extension of another source server.
     * </p>
     *
     * @param listExtensibleSourceServersRequest
     * @return Result of the ListExtensibleSourceServers operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ListExtensibleSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListExtensibleSourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensibleSourceServersResponse listExtensibleSourceServers(
            ListExtensibleSourceServersRequest listExtensibleSourceServersRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of source servers on a staging account that are extensible, which means that: a. The source server
     * is not already extended into this Account. b. The source server on the Account we’re reading from is not an
     * extension of another source server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensibleSourceServersRequest.Builder}
     * avoiding the need to create one manually via {@link ListExtensibleSourceServersRequest#builder()}
     * </p>
     *
     * @param listExtensibleSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link ListExtensibleSourceServersRequest.Builder} to create
     *        a request.
     * @return Result of the ListExtensibleSourceServers operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ListExtensibleSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListExtensibleSourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensibleSourceServersResponse listExtensibleSourceServers(
            Consumer<ListExtensibleSourceServersRequest.Builder> listExtensibleSourceServersRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return listExtensibleSourceServers(ListExtensibleSourceServersRequest.builder()
                .applyMutation(listExtensibleSourceServersRequest).build());
    }

    /**
     * <p>
     * Returns a list of source servers on a staging account that are extensible, which means that: a. The source server
     * is not already extended into this Account. b. The source server on the Account we’re reading from is not an
     * extension of another source server.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExtensibleSourceServers(software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.ListExtensibleSourceServersIterable responses = client.listExtensibleSourceServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.ListExtensibleSourceServersIterable responses = client
     *             .listExtensibleSourceServersPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.ListExtensibleSourceServersIterable responses = client.listExtensibleSourceServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensibleSourceServers(software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExtensibleSourceServersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ListExtensibleSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListExtensibleSourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensibleSourceServersIterable listExtensibleSourceServersPaginator(
            ListExtensibleSourceServersRequest listExtensibleSourceServersRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of source servers on a staging account that are extensible, which means that: a. The source server
     * is not already extended into this Account. b. The source server on the Account we’re reading from is not an
     * extension of another source server.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExtensibleSourceServers(software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.ListExtensibleSourceServersIterable responses = client.listExtensibleSourceServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.ListExtensibleSourceServersIterable responses = client
     *             .listExtensibleSourceServersPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.ListExtensibleSourceServersIterable responses = client.listExtensibleSourceServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensibleSourceServers(software.amazon.awssdk.services.drs.model.ListExtensibleSourceServersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensibleSourceServersRequest.Builder}
     * avoiding the need to create one manually via {@link ListExtensibleSourceServersRequest#builder()}
     * </p>
     *
     * @param listExtensibleSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link ListExtensibleSourceServersRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ListExtensibleSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListExtensibleSourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensibleSourceServersIterable listExtensibleSourceServersPaginator(
            Consumer<ListExtensibleSourceServersRequest.Builder> listExtensibleSourceServersRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return listExtensibleSourceServersPaginator(ListExtensibleSourceServersRequest.builder()
                .applyMutation(listExtensibleSourceServersRequest).build());
    }

    /**
     * <p>
     * Returns an array of staging accounts for existing extended source servers.
     * </p>
     *
     * @param listStagingAccountsRequest
     * @return Result of the ListStagingAccounts operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ListStagingAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListStagingAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagingAccountsResponse listStagingAccounts(ListStagingAccountsRequest listStagingAccountsRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of staging accounts for existing extended source servers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStagingAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStagingAccountsRequest#builder()}
     * </p>
     *
     * @param listStagingAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListStagingAccountsRequest.Builder} to create a
     *        request.
     * @return Result of the ListStagingAccounts operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ListStagingAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListStagingAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagingAccountsResponse listStagingAccounts(
            Consumer<ListStagingAccountsRequest.Builder> listStagingAccountsRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        return listStagingAccounts(ListStagingAccountsRequest.builder().applyMutation(listStagingAccountsRequest).build());
    }

    /**
     * <p>
     * Returns an array of staging accounts for existing extended source servers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStagingAccounts(software.amazon.awssdk.services.drs.model.ListStagingAccountsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.ListStagingAccountsIterable responses = client.listStagingAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.ListStagingAccountsIterable responses = client
     *             .listStagingAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.ListStagingAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.ListStagingAccountsIterable responses = client.listStagingAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStagingAccounts(software.amazon.awssdk.services.drs.model.ListStagingAccountsRequest)} operation.</b>
     * </p>
     *
     * @param listStagingAccountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ListStagingAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListStagingAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagingAccountsIterable listStagingAccountsPaginator(ListStagingAccountsRequest listStagingAccountsRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of staging accounts for existing extended source servers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStagingAccounts(software.amazon.awssdk.services.drs.model.ListStagingAccountsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.ListStagingAccountsIterable responses = client.listStagingAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.drs.paginators.ListStagingAccountsIterable responses = client
     *             .listStagingAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.drs.model.ListStagingAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.drs.paginators.ListStagingAccountsIterable responses = client.listStagingAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStagingAccounts(software.amazon.awssdk.services.drs.model.ListStagingAccountsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStagingAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStagingAccountsRequest#builder()}
     * </p>
     *
     * @param listStagingAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListStagingAccountsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ListStagingAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListStagingAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagingAccountsIterable listStagingAccountsPaginator(
            Consumer<ListStagingAccountsRequest.Builder> listStagingAccountsRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException,
            SdkClientException, DrsException {
        return listStagingAccountsPaginator(ListStagingAccountsRequest.builder().applyMutation(listStagingAccountsRequest)
                .build());
    }

    /**
     * <p>
     * List all tags for your Elastic Disaster Recovery resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags for your Elastic Disaster Recovery resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, DrsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * WARNING: RetryDataReplication is deprecated. Causes the data replication initiation sequence to begin immediately
     * upon next Handshake for the specified Source Server ID, regardless of when the previous initiation started. This
     * command will work only if the Source Server is stalled or is in a DISCONNECTED or STOPPED state.
     * </p>
     *
     * @param retryDataReplicationRequest
     * @return Result of the RetryDataReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.RetryDataReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/RetryDataReplication" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated WARNING: RetryDataReplication is deprecated
     */
    @Deprecated
    default RetryDataReplicationResponse retryDataReplication(RetryDataReplicationRequest retryDataReplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * WARNING: RetryDataReplication is deprecated. Causes the data replication initiation sequence to begin immediately
     * upon next Handshake for the specified Source Server ID, regardless of when the previous initiation started. This
     * command will work only if the Source Server is stalled or is in a DISCONNECTED or STOPPED state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetryDataReplicationRequest.Builder} avoiding the
     * need to create one manually via {@link RetryDataReplicationRequest#builder()}
     * </p>
     *
     * @param retryDataReplicationRequest
     *        A {@link Consumer} that will call methods on {@link RetryDataReplicationRequest.Builder} to create a
     *        request.
     * @return Result of the RetryDataReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.RetryDataReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/RetryDataReplication" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated WARNING: RetryDataReplication is deprecated
     */
    @Deprecated
    default RetryDataReplicationResponse retryDataReplication(
            Consumer<RetryDataReplicationRequest.Builder> retryDataReplicationRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        return retryDataReplication(RetryDataReplicationRequest.builder().applyMutation(retryDataReplicationRequest).build());
    }

    /**
     * <p>
     * Start replication to origin / target region - applies only to protected instances that originated in EC2. For
     * recovery instances on target region - starts replication back to origin region. For failback instances on origin
     * region - starts replication to target region to re-protect them.
     * </p>
     *
     * @param reverseReplicationRequest
     * @return Result of the ReverseReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ReverseReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ReverseReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default ReverseReplicationResponse reverseReplication(ReverseReplicationRequest reverseReplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start replication to origin / target region - applies only to protected instances that originated in EC2. For
     * recovery instances on target region - starts replication back to origin region. For failback instances on origin
     * region - starts replication to target region to re-protect them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReverseReplicationRequest.Builder} avoiding the
     * need to create one manually via {@link ReverseReplicationRequest#builder()}
     * </p>
     *
     * @param reverseReplicationRequest
     *        A {@link Consumer} that will call methods on {@link ReverseReplicationRequest.Builder} to create a
     *        request.
     * @return Result of the ReverseReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.ReverseReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/ReverseReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default ReverseReplicationResponse reverseReplication(Consumer<ReverseReplicationRequest.Builder> reverseReplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        return reverseReplication(ReverseReplicationRequest.builder().applyMutation(reverseReplicationRequest).build());
    }

    /**
     * <p>
     * Initiates a Job for launching the machine that is being failed back to from the specified Recovery Instance. This
     * will run conversion on the failback client and will reboot your machine, thus completing the failback process.
     * </p>
     *
     * @param startFailbackLaunchRequest
     * @return Result of the StartFailbackLaunch operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.StartFailbackLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartFailbackLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default StartFailbackLaunchResponse startFailbackLaunch(StartFailbackLaunchRequest startFailbackLaunchRequest)
            throws InternalServerException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a Job for launching the machine that is being failed back to from the specified Recovery Instance. This
     * will run conversion on the failback client and will reboot your machine, thus completing the failback process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFailbackLaunchRequest.Builder} avoiding the
     * need to create one manually via {@link StartFailbackLaunchRequest#builder()}
     * </p>
     *
     * @param startFailbackLaunchRequest
     *        A {@link Consumer} that will call methods on {@link StartFailbackLaunchRequest.Builder} to create a
     *        request.
     * @return Result of the StartFailbackLaunch operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.StartFailbackLaunch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartFailbackLaunch" target="_top">AWS API
     *      Documentation</a>
     */
    default StartFailbackLaunchResponse startFailbackLaunch(
            Consumer<StartFailbackLaunchRequest.Builder> startFailbackLaunchRequest) throws InternalServerException,
            ConflictException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return startFailbackLaunch(StartFailbackLaunchRequest.builder().applyMutation(startFailbackLaunchRequest).build());
    }

    /**
     * <p>
     * Launches Recovery Instances for the specified Source Servers. For each Source Server you may choose a point in
     * time snapshot to launch from, or use an on demand snapshot.
     * </p>
     *
     * @param startRecoveryRequest
     * @return Result of the StartRecovery operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.StartRecovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartRecovery" target="_top">AWS API
     *      Documentation</a>
     */
    default StartRecoveryResponse startRecovery(StartRecoveryRequest startRecoveryRequest) throws InternalServerException,
            ConflictException, ServiceQuotaExceededException, ThrottlingException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches Recovery Instances for the specified Source Servers. For each Source Server you may choose a point in
     * time snapshot to launch from, or use an on demand snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRecoveryRequest.Builder} avoiding the need to
     * create one manually via {@link StartRecoveryRequest#builder()}
     * </p>
     *
     * @param startRecoveryRequest
     *        A {@link Consumer} that will call methods on {@link StartRecoveryRequest.Builder} to create a request.
     * @return Result of the StartRecovery operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.StartRecovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartRecovery" target="_top">AWS API
     *      Documentation</a>
     */
    default StartRecoveryResponse startRecovery(Consumer<StartRecoveryRequest.Builder> startRecoveryRequest)
            throws InternalServerException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return startRecovery(StartRecoveryRequest.builder().applyMutation(startRecoveryRequest).build());
    }

    /**
     * <p>
     * Starts replication for a stopped Source Server. This action would make the Source Server protected again and
     * restart billing for it.
     * </p>
     *
     * @param startReplicationRequest
     * @return Result of the StartReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReplicationResponse startReplication(StartReplicationRequest startReplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts replication for a stopped Source Server. This action would make the Source Server protected again and
     * restart billing for it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StartReplicationRequest#builder()}
     * </p>
     *
     * @param startReplicationRequest
     *        A {@link Consumer} that will call methods on {@link StartReplicationRequest.Builder} to create a request.
     * @return Result of the StartReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReplicationResponse startReplication(Consumer<StartReplicationRequest.Builder> startReplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return startReplication(StartReplicationRequest.builder().applyMutation(startReplicationRequest).build());
    }

    /**
     * <p>
     * Stops the failback process for a specified Recovery Instance. This changes the Failback State of the Recovery
     * Instance back to FAILBACK_NOT_STARTED.
     * </p>
     *
     * @param stopFailbackRequest
     * @return Result of the StopFailback operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.StopFailback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StopFailback" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFailbackResponse stopFailback(StopFailbackRequest stopFailbackRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the failback process for a specified Recovery Instance. This changes the Failback State of the Recovery
     * Instance back to FAILBACK_NOT_STARTED.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopFailbackRequest.Builder} avoiding the need to
     * create one manually via {@link StopFailbackRequest#builder()}
     * </p>
     *
     * @param stopFailbackRequest
     *        A {@link Consumer} that will call methods on {@link StopFailbackRequest.Builder} to create a request.
     * @return Result of the StopFailback operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.StopFailback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StopFailback" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFailbackResponse stopFailback(Consumer<StopFailbackRequest.Builder> stopFailbackRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        return stopFailback(StopFailbackRequest.builder().applyMutation(stopFailbackRequest).build());
    }

    /**
     * <p>
     * Stops replication for a Source Server. This action would make the Source Server unprotected, delete its existing
     * snapshots and stop billing for it.
     * </p>
     *
     * @param stopReplicationRequest
     * @return Result of the StopReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.StopReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StopReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StopReplicationResponse stopReplication(StopReplicationRequest stopReplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops replication for a Source Server. This action would make the Source Server unprotected, delete its existing
     * snapshots and stop billing for it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StopReplicationRequest#builder()}
     * </p>
     *
     * @param stopReplicationRequest
     *        A {@link Consumer} that will call methods on {@link StopReplicationRequest.Builder} to create a request.
     * @return Result of the StopReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.StopReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/StopReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StopReplicationResponse stopReplication(Consumer<StopReplicationRequest.Builder> stopReplicationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return stopReplication(StopReplicationRequest.builder().applyMutation(stopReplicationRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Elastic Disaster Recovery resource or resources.
     * When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a
     * maximum of 50 tags. Each tag consists of a key and optional value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Elastic Disaster Recovery resource or resources.
     * When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a
     * maximum of 50 tags. Each tag consists of a key and optional value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, DrsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Initiates a Job for terminating the EC2 resources associated with the specified Recovery Instances, and then will
     * delete the Recovery Instances from the Elastic Disaster Recovery service.
     * </p>
     *
     * @param terminateRecoveryInstancesRequest
     * @return Result of the TerminateRecoveryInstances operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.TerminateRecoveryInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/TerminateRecoveryInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateRecoveryInstancesResponse terminateRecoveryInstances(
            TerminateRecoveryInstancesRequest terminateRecoveryInstancesRequest) throws InternalServerException,
            ConflictException, ServiceQuotaExceededException, ThrottlingException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a Job for terminating the EC2 resources associated with the specified Recovery Instances, and then will
     * delete the Recovery Instances from the Elastic Disaster Recovery service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateRecoveryInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link TerminateRecoveryInstancesRequest#builder()}
     * </p>
     *
     * @param terminateRecoveryInstancesRequest
     *        A {@link Consumer} that will call methods on {@link TerminateRecoveryInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the TerminateRecoveryInstances operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.TerminateRecoveryInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/TerminateRecoveryInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateRecoveryInstancesResponse terminateRecoveryInstances(
            Consumer<TerminateRecoveryInstancesRequest.Builder> terminateRecoveryInstancesRequest)
            throws InternalServerException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return terminateRecoveryInstances(TerminateRecoveryInstancesRequest.builder()
                .applyMutation(terminateRecoveryInstancesRequest).build());
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of Elastic Disaster Recovery resources.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of Elastic Disaster Recovery resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, DrsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Allows you to update the failback replication configuration of a Recovery Instance by ID.
     * </p>
     *
     * @param updateFailbackReplicationConfigurationRequest
     * @return Result of the UpdateFailbackReplicationConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UpdateFailbackReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateFailbackReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFailbackReplicationConfigurationResponse updateFailbackReplicationConfiguration(
            UpdateFailbackReplicationConfigurationRequest updateFailbackReplicationConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to update the failback replication configuration of a Recovery Instance by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateFailbackReplicationConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateFailbackReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateFailbackReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFailbackReplicationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateFailbackReplicationConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UpdateFailbackReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateFailbackReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFailbackReplicationConfigurationResponse updateFailbackReplicationConfiguration(
            Consumer<UpdateFailbackReplicationConfigurationRequest.Builder> updateFailbackReplicationConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return updateFailbackReplicationConfiguration(UpdateFailbackReplicationConfigurationRequest.builder()
                .applyMutation(updateFailbackReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a LaunchConfiguration by Source Server ID.
     * </p>
     *
     * @param updateLaunchConfigurationRequest
     * @return Result of the UpdateLaunchConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UpdateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLaunchConfigurationResponse updateLaunchConfiguration(
            UpdateLaunchConfigurationRequest updateLaunchConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, UninitializedAccountException,
            AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a LaunchConfiguration by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLaunchConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLaunchConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLaunchConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UpdateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLaunchConfigurationResponse updateLaunchConfiguration(
            Consumer<UpdateLaunchConfigurationRequest.Builder> updateLaunchConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return updateLaunchConfiguration(UpdateLaunchConfigurationRequest.builder()
                .applyMutation(updateLaunchConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing Launch Configuration Template by ID.
     * </p>
     *
     * @param updateLaunchConfigurationTemplateRequest
     * @return Result of the UpdateLaunchConfigurationTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UpdateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLaunchConfigurationTemplateResponse updateLaunchConfigurationTemplate(
            UpdateLaunchConfigurationTemplateRequest updateLaunchConfigurationTemplateRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Launch Configuration Template by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLaunchConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLaunchConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param updateLaunchConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLaunchConfigurationTemplateRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateLaunchConfigurationTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UpdateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLaunchConfigurationTemplateResponse updateLaunchConfigurationTemplate(
            Consumer<UpdateLaunchConfigurationTemplateRequest.Builder> updateLaunchConfigurationTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return updateLaunchConfigurationTemplate(UpdateLaunchConfigurationTemplateRequest.builder()
                .applyMutation(updateLaunchConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Allows you to update a ReplicationConfiguration by Source Server ID.
     * </p>
     *
     * @param updateReplicationConfigurationRequest
     * @return Result of the UpdateReplicationConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UpdateReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateReplicationConfigurationResponse updateReplicationConfiguration(
            UpdateReplicationConfigurationRequest updateReplicationConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, AccessDeniedException, ValidationException,
            UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to update a ReplicationConfiguration by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReplicationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateReplicationConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UpdateReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateReplicationConfigurationResponse updateReplicationConfiguration(
            Consumer<UpdateReplicationConfigurationRequest.Builder> updateReplicationConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            AccessDeniedException, ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException,
            DrsException {
        return updateReplicationConfiguration(UpdateReplicationConfigurationRequest.builder()
                .applyMutation(updateReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a ReplicationConfigurationTemplate by ID.
     * </p>
     *
     * @param updateReplicationConfigurationTemplateRequest
     * @return Result of the UpdateReplicationConfigurationTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UpdateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateReplicationConfigurationTemplateResponse updateReplicationConfigurationTemplate(
            UpdateReplicationConfigurationTemplateRequest updateReplicationConfigurationTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a ReplicationConfigurationTemplate by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param updateReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateReplicationConfigurationTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource for this operation was not found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the AWS service.
     * @throws UninitializedAccountException
     *         The account performing the request has not been initialized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DrsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DrsClient.UpdateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/UpdateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateReplicationConfigurationTemplateResponse updateReplicationConfigurationTemplate(
            Consumer<UpdateReplicationConfigurationTemplateRequest.Builder> updateReplicationConfigurationTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            ValidationException, UninitializedAccountException, AwsServiceException, SdkClientException, DrsException {
        return updateReplicationConfigurationTemplate(UpdateReplicationConfigurationTemplateRequest.builder()
                .applyMutation(updateReplicationConfigurationTemplateRequest).build());
    }

    /**
     * Create a {@link DrsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DrsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DrsClient}.
     */
    static DrsClientBuilder builder() {
        return new DefaultDrsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default DrsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
