/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the Source Server to recover.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRecoveryRequestSourceServer implements SdkPojo, Serializable,
        ToCopyableBuilder<StartRecoveryRequestSourceServer.Builder, StartRecoveryRequestSourceServer> {
    private static final SdkField<String> RECOVERY_SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoverySnapshotID").getter(getter(StartRecoveryRequestSourceServer::recoverySnapshotID))
            .setter(setter(Builder::recoverySnapshotID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoverySnapshotID").build())
            .build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(StartRecoveryRequestSourceServer::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_SNAPSHOT_ID_FIELD,
            SOURCE_SERVER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recoverySnapshotID;

    private final String sourceServerID;

    private StartRecoveryRequestSourceServer(BuilderImpl builder) {
        this.recoverySnapshotID = builder.recoverySnapshotID;
        this.sourceServerID = builder.sourceServerID;
    }

    /**
     * <p>
     * The ID of a Recovery Snapshot we want to recover from. Omit this field to launch from the latest data by taking
     * an on-demand snapshot.
     * </p>
     * 
     * @return The ID of a Recovery Snapshot we want to recover from. Omit this field to launch from the latest data by
     *         taking an on-demand snapshot.
     */
    public final String recoverySnapshotID() {
        return recoverySnapshotID;
    }

    /**
     * <p>
     * The ID of the Source Server you want to recover.
     * </p>
     * 
     * @return The ID of the Source Server you want to recover.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recoverySnapshotID());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRecoveryRequestSourceServer)) {
            return false;
        }
        StartRecoveryRequestSourceServer other = (StartRecoveryRequestSourceServer) obj;
        return Objects.equals(recoverySnapshotID(), other.recoverySnapshotID())
                && Objects.equals(sourceServerID(), other.sourceServerID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRecoveryRequestSourceServer").add("RecoverySnapshotID", recoverySnapshotID())
                .add("SourceServerID", sourceServerID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recoverySnapshotID":
            return Optional.ofNullable(clazz.cast(recoverySnapshotID()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartRecoveryRequestSourceServer, T> g) {
        return obj -> g.apply((StartRecoveryRequestSourceServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartRecoveryRequestSourceServer> {
        /**
         * <p>
         * The ID of a Recovery Snapshot we want to recover from. Omit this field to launch from the latest data by
         * taking an on-demand snapshot.
         * </p>
         * 
         * @param recoverySnapshotID
         *        The ID of a Recovery Snapshot we want to recover from. Omit this field to launch from the latest data
         *        by taking an on-demand snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoverySnapshotID(String recoverySnapshotID);

        /**
         * <p>
         * The ID of the Source Server you want to recover.
         * </p>
         * 
         * @param sourceServerID
         *        The ID of the Source Server you want to recover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);
    }

    static final class BuilderImpl implements Builder {
        private String recoverySnapshotID;

        private String sourceServerID;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRecoveryRequestSourceServer model) {
            recoverySnapshotID(model.recoverySnapshotID);
            sourceServerID(model.sourceServerID);
        }

        public final String getRecoverySnapshotID() {
            return recoverySnapshotID;
        }

        public final void setRecoverySnapshotID(String recoverySnapshotID) {
            this.recoverySnapshotID = recoverySnapshotID;
        }

        @Override
        public final Builder recoverySnapshotID(String recoverySnapshotID) {
            this.recoverySnapshotID = recoverySnapshotID;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        @Override
        public StartRecoveryRequestSourceServer build() {
            return new StartRecoveryRequestSourceServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
