/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.drs.DefaultDrsBaseClientBuilder;
import software.amazon.awssdk.services.drs.DefaultDrsClient;
import software.amazon.awssdk.services.drs.DrsClient;
import software.amazon.awssdk.services.drs.DrsClientBuilder;
import software.amazon.awssdk.services.drs.DrsServiceClientConfiguration;
import software.amazon.awssdk.services.drs.endpoints.DrsEndpointProvider;

@SdkInternalApi
final class DefaultDrsClientBuilder
extends DefaultDrsBaseClientBuilder<DrsClientBuilder, DrsClient>
implements DrsClientBuilder {
    DefaultDrsClientBuilder() {
    }

    @Override
    public DefaultDrsClientBuilder endpointProvider(DrsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DrsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDrsClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        DrsServiceClientConfiguration serviceClientConfiguration = DrsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultDrsClient(serviceClientConfiguration, clientConfiguration);
    }
}

