/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class LaunchActionParametersCopier {
    static Map<String, LaunchActionParameter> copy(Map<String, ? extends LaunchActionParameter> launchActionParametersParam) {
        Map<String, LaunchActionParameter> map;
        if (launchActionParametersParam == null || launchActionParametersParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LaunchActionParameter> modifiableMap = new LinkedHashMap<>();
            launchActionParametersParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, LaunchActionParameter> copyFromBuilder(
            Map<String, ? extends LaunchActionParameter.Builder> launchActionParametersParam) {
        Map<String, LaunchActionParameter> map;
        if (launchActionParametersParam == null || launchActionParametersParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LaunchActionParameter> modifiableMap = new LinkedHashMap<>();
            launchActionParametersParam.forEach((key, value) -> {
                LaunchActionParameter member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, LaunchActionParameter.Builder> copyToBuilder(
            Map<String, ? extends LaunchActionParameter> launchActionParametersParam) {
        Map<String, LaunchActionParameter.Builder> map;
        if (launchActionParametersParam == null || launchActionParametersParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LaunchActionParameter.Builder> modifiableMap = new LinkedHashMap<>();
            launchActionParametersParam.forEach((key, value) -> {
                LaunchActionParameter.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
