/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLaunchActionsRequest extends DrsRequest implements
        ToCopyableBuilder<ListLaunchActionsRequest.Builder, ListLaunchActionsRequest> {
    private static final SdkField<LaunchActionsRequestFilters> FILTERS_FIELD = SdkField
            .<LaunchActionsRequestFilters> builder(MarshallingType.SDK_POJO).memberName("filters")
            .getter(getter(ListLaunchActionsRequest::filters)).setter(setter(Builder::filters))
            .constructor(LaunchActionsRequestFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListLaunchActionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLaunchActionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(ListLaunchActionsRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, RESOURCE_ID_FIELD));

    private final LaunchActionsRequestFilters filters;

    private final Integer maxResults;

    private final String nextToken;

    private final String resourceId;

    private ListLaunchActionsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * Filters to apply when listing resource launch actions.
     * </p>
     * 
     * @return Filters to apply when listing resource launch actions.
     */
    public final LaunchActionsRequestFilters filters() {
        return filters;
    }

    /**
     * <p>
     * Maximum amount of items to return when listing resource launch actions.
     * </p>
     * 
     * @return Maximum amount of items to return when listing resource launch actions.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Next token to use when listing resource launch actions.
     * </p>
     * 
     * @return Next token to use when listing resource launch actions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the ResourceId property for this object.
     * 
     * @return The value of the ResourceId property for this object.
     */
    public final String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLaunchActionsRequest)) {
            return false;
        }
        ListLaunchActionsRequest other = (ListLaunchActionsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(resourceId(), other.resourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLaunchActionsRequest").add("Filters", filters()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("ResourceId", resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLaunchActionsRequest, T> g) {
        return obj -> g.apply((ListLaunchActionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLaunchActionsRequest> {
        /**
         * <p>
         * Filters to apply when listing resource launch actions.
         * </p>
         * 
         * @param filters
         *        Filters to apply when listing resource launch actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(LaunchActionsRequestFilters filters);

        /**
         * <p>
         * Filters to apply when listing resource launch actions.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchActionsRequestFilters.Builder}
         * avoiding the need to create one manually via {@link LaunchActionsRequestFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchActionsRequestFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(LaunchActionsRequestFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link LaunchActionsRequestFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(LaunchActionsRequestFilters)
         */
        default Builder filters(Consumer<LaunchActionsRequestFilters.Builder> filters) {
            return filters(LaunchActionsRequestFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Maximum amount of items to return when listing resource launch actions.
         * </p>
         * 
         * @param maxResults
         *        Maximum amount of items to return when listing resource launch actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Next token to use when listing resource launch actions.
         * </p>
         * 
         * @param nextToken
         *        Next token to use when listing resource launch actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the ResourceId property for this object.
         *
         * @param resourceId
         *        The new value for the ResourceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DrsRequest.BuilderImpl implements Builder {
        private LaunchActionsRequestFilters filters;

        private Integer maxResults;

        private String nextToken;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLaunchActionsRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            resourceId(model.resourceId);
        }

        public final LaunchActionsRequestFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(LaunchActionsRequestFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(LaunchActionsRequestFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLaunchActionsRequest build() {
            return new ListLaunchActionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
