/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceServer implements SdkPojo, Serializable, ToCopyableBuilder<SourceServer.Builder, SourceServer> {
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(SourceServer::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SourceServer::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<DataReplicationInfo> DATA_REPLICATION_INFO_FIELD = SdkField
            .<DataReplicationInfo> builder(MarshallingType.SDK_POJO).memberName("dataReplicationInfo")
            .getter(getter(SourceServer::dataReplicationInfo)).setter(setter(Builder::dataReplicationInfo))
            .constructor(DataReplicationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInfo").build())
            .build();

    private static final SdkField<String> LAST_LAUNCH_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastLaunchResult").getter(getter(SourceServer::lastLaunchResultAsString))
            .setter(setter(Builder::lastLaunchResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastLaunchResult").build()).build();

    private static final SdkField<LifeCycle> LIFE_CYCLE_FIELD = SdkField.<LifeCycle> builder(MarshallingType.SDK_POJO)
            .memberName("lifeCycle").getter(getter(SourceServer::lifeCycle)).setter(setter(Builder::lifeCycle))
            .constructor(LifeCycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifeCycle").build()).build();

    private static final SdkField<String> RECOVERY_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryInstanceId").getter(getter(SourceServer::recoveryInstanceId))
            .setter(setter(Builder::recoveryInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceId").build())
            .build();

    private static final SdkField<String> REPLICATION_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationDirection").getter(getter(SourceServer::replicationDirectionAsString))
            .setter(setter(Builder::replicationDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationDirection").build())
            .build();

    private static final SdkField<String> REVERSED_DIRECTION_SOURCE_SERVER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("reversedDirectionSourceServerArn")
            .getter(getter(SourceServer::reversedDirectionSourceServerArn))
            .setter(setter(Builder::reversedDirectionSourceServerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reversedDirectionSourceServerArn")
                    .build()).build();

    private static final SdkField<SourceCloudProperties> SOURCE_CLOUD_PROPERTIES_FIELD = SdkField
            .<SourceCloudProperties> builder(MarshallingType.SDK_POJO).memberName("sourceCloudProperties")
            .getter(getter(SourceServer::sourceCloudProperties)).setter(setter(Builder::sourceCloudProperties))
            .constructor(SourceCloudProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCloudProperties").build())
            .build();

    private static final SdkField<String> SOURCE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceNetworkID").getter(getter(SourceServer::sourceNetworkID)).setter(setter(Builder::sourceNetworkID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkID").build()).build();

    private static final SdkField<SourceProperties> SOURCE_PROPERTIES_FIELD = SdkField
            .<SourceProperties> builder(MarshallingType.SDK_POJO).memberName("sourceProperties")
            .getter(getter(SourceServer::sourceProperties)).setter(setter(Builder::sourceProperties))
            .constructor(SourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceProperties").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(SourceServer::sourceServerID)).setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final SdkField<StagingArea> STAGING_AREA_FIELD = SdkField.<StagingArea> builder(MarshallingType.SDK_POJO)
            .memberName("stagingArea").getter(getter(SourceServer::stagingArea)).setter(setter(Builder::stagingArea))
            .constructor(StagingArea::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingArea").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SourceServer::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSION_FIELD,
            ARN_FIELD, DATA_REPLICATION_INFO_FIELD, LAST_LAUNCH_RESULT_FIELD, LIFE_CYCLE_FIELD, RECOVERY_INSTANCE_ID_FIELD,
            REPLICATION_DIRECTION_FIELD, REVERSED_DIRECTION_SOURCE_SERVER_ARN_FIELD, SOURCE_CLOUD_PROPERTIES_FIELD,
            SOURCE_NETWORK_ID_FIELD, SOURCE_PROPERTIES_FIELD, SOURCE_SERVER_ID_FIELD, STAGING_AREA_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentVersion;

    private final String arn;

    private final DataReplicationInfo dataReplicationInfo;

    private final String lastLaunchResult;

    private final LifeCycle lifeCycle;

    private final String recoveryInstanceId;

    private final String replicationDirection;

    private final String reversedDirectionSourceServerArn;

    private final SourceCloudProperties sourceCloudProperties;

    private final String sourceNetworkID;

    private final SourceProperties sourceProperties;

    private final String sourceServerID;

    private final StagingArea stagingArea;

    private final Map<String, String> tags;

    private SourceServer(BuilderImpl builder) {
        this.agentVersion = builder.agentVersion;
        this.arn = builder.arn;
        this.dataReplicationInfo = builder.dataReplicationInfo;
        this.lastLaunchResult = builder.lastLaunchResult;
        this.lifeCycle = builder.lifeCycle;
        this.recoveryInstanceId = builder.recoveryInstanceId;
        this.replicationDirection = builder.replicationDirection;
        this.reversedDirectionSourceServerArn = builder.reversedDirectionSourceServerArn;
        this.sourceCloudProperties = builder.sourceCloudProperties;
        this.sourceNetworkID = builder.sourceNetworkID;
        this.sourceProperties = builder.sourceProperties;
        this.sourceServerID = builder.sourceServerID;
        this.stagingArea = builder.stagingArea;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The version of the DRS agent installed on the source server
     * </p>
     * 
     * @return The version of the DRS agent installed on the source server
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * The ARN of the Source Server.
     * </p>
     * 
     * @return The ARN of the Source Server.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Data Replication Info of the Source Server.
     * </p>
     * 
     * @return The Data Replication Info of the Source Server.
     */
    public final DataReplicationInfo dataReplicationInfo() {
        return dataReplicationInfo;
    }

    /**
     * <p>
     * The status of the last recovery launch of this Source Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastLaunchResult}
     * will return {@link LastLaunchResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastLaunchResultAsString}.
     * </p>
     * 
     * @return The status of the last recovery launch of this Source Server.
     * @see LastLaunchResult
     */
    public final LastLaunchResult lastLaunchResult() {
        return LastLaunchResult.fromValue(lastLaunchResult);
    }

    /**
     * <p>
     * The status of the last recovery launch of this Source Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastLaunchResult}
     * will return {@link LastLaunchResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastLaunchResultAsString}.
     * </p>
     * 
     * @return The status of the last recovery launch of this Source Server.
     * @see LastLaunchResult
     */
    public final String lastLaunchResultAsString() {
        return lastLaunchResult;
    }

    /**
     * <p>
     * The lifecycle information of this Source Server.
     * </p>
     * 
     * @return The lifecycle information of this Source Server.
     */
    public final LifeCycle lifeCycle() {
        return lifeCycle;
    }

    /**
     * <p>
     * The ID of the Recovery Instance associated with this Source Server.
     * </p>
     * 
     * @return The ID of the Recovery Instance associated with this Source Server.
     */
    public final String recoveryInstanceId() {
        return recoveryInstanceId;
    }

    /**
     * <p>
     * Replication direction of the Source Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationDirection} will return {@link ReplicationDirection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #replicationDirectionAsString}.
     * </p>
     * 
     * @return Replication direction of the Source Server.
     * @see ReplicationDirection
     */
    public final ReplicationDirection replicationDirection() {
        return ReplicationDirection.fromValue(replicationDirection);
    }

    /**
     * <p>
     * Replication direction of the Source Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationDirection} will return {@link ReplicationDirection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #replicationDirectionAsString}.
     * </p>
     * 
     * @return Replication direction of the Source Server.
     * @see ReplicationDirection
     */
    public final String replicationDirectionAsString() {
        return replicationDirection;
    }

    /**
     * <p>
     * For EC2-originated Source Servers which have been failed over and then failed back, this value will mean the ARN
     * of the Source Server on the opposite replication direction.
     * </p>
     * 
     * @return For EC2-originated Source Servers which have been failed over and then failed back, this value will mean
     *         the ARN of the Source Server on the opposite replication direction.
     */
    public final String reversedDirectionSourceServerArn() {
        return reversedDirectionSourceServerArn;
    }

    /**
     * <p>
     * Source cloud properties of the Source Server.
     * </p>
     * 
     * @return Source cloud properties of the Source Server.
     */
    public final SourceCloudProperties sourceCloudProperties() {
        return sourceCloudProperties;
    }

    /**
     * <p>
     * ID of the Source Network which is protecting this Source Server's network.
     * </p>
     * 
     * @return ID of the Source Network which is protecting this Source Server's network.
     */
    public final String sourceNetworkID() {
        return sourceNetworkID;
    }

    /**
     * <p>
     * The source properties of the Source Server.
     * </p>
     * 
     * @return The source properties of the Source Server.
     */
    public final SourceProperties sourceProperties() {
        return sourceProperties;
    }

    /**
     * <p>
     * The ID of the Source Server.
     * </p>
     * 
     * @return The ID of the Source Server.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    /**
     * <p>
     * The staging area of the source server.
     * </p>
     * 
     * @return The staging area of the source server.
     */
    public final StagingArea stagingArea() {
        return stagingArea;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the Source Server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the Source Server.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(lastLaunchResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reversedDirectionSourceServerArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCloudProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sourceNetworkID());
        hashCode = 31 * hashCode + Objects.hashCode(sourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(stagingArea());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceServer)) {
            return false;
        }
        SourceServer other = (SourceServer) obj;
        return Objects.equals(agentVersion(), other.agentVersion()) && Objects.equals(arn(), other.arn())
                && Objects.equals(dataReplicationInfo(), other.dataReplicationInfo())
                && Objects.equals(lastLaunchResultAsString(), other.lastLaunchResultAsString())
                && Objects.equals(lifeCycle(), other.lifeCycle())
                && Objects.equals(recoveryInstanceId(), other.recoveryInstanceId())
                && Objects.equals(replicationDirectionAsString(), other.replicationDirectionAsString())
                && Objects.equals(reversedDirectionSourceServerArn(), other.reversedDirectionSourceServerArn())
                && Objects.equals(sourceCloudProperties(), other.sourceCloudProperties())
                && Objects.equals(sourceNetworkID(), other.sourceNetworkID())
                && Objects.equals(sourceProperties(), other.sourceProperties())
                && Objects.equals(sourceServerID(), other.sourceServerID()) && Objects.equals(stagingArea(), other.stagingArea())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceServer").add("AgentVersion", agentVersion()).add("Arn", arn())
                .add("DataReplicationInfo", dataReplicationInfo()).add("LastLaunchResult", lastLaunchResultAsString())
                .add("LifeCycle", lifeCycle()).add("RecoveryInstanceId", recoveryInstanceId())
                .add("ReplicationDirection", replicationDirectionAsString())
                .add("ReversedDirectionSourceServerArn", reversedDirectionSourceServerArn())
                .add("SourceCloudProperties", sourceCloudProperties()).add("SourceNetworkID", sourceNetworkID())
                .add("SourceProperties", sourceProperties()).add("SourceServerID", sourceServerID())
                .add("StagingArea", stagingArea()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "dataReplicationInfo":
            return Optional.ofNullable(clazz.cast(dataReplicationInfo()));
        case "lastLaunchResult":
            return Optional.ofNullable(clazz.cast(lastLaunchResultAsString()));
        case "lifeCycle":
            return Optional.ofNullable(clazz.cast(lifeCycle()));
        case "recoveryInstanceId":
            return Optional.ofNullable(clazz.cast(recoveryInstanceId()));
        case "replicationDirection":
            return Optional.ofNullable(clazz.cast(replicationDirectionAsString()));
        case "reversedDirectionSourceServerArn":
            return Optional.ofNullable(clazz.cast(reversedDirectionSourceServerArn()));
        case "sourceCloudProperties":
            return Optional.ofNullable(clazz.cast(sourceCloudProperties()));
        case "sourceNetworkID":
            return Optional.ofNullable(clazz.cast(sourceNetworkID()));
        case "sourceProperties":
            return Optional.ofNullable(clazz.cast(sourceProperties()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        case "stagingArea":
            return Optional.ofNullable(clazz.cast(stagingArea()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceServer, T> g) {
        return obj -> g.apply((SourceServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceServer> {
        /**
         * <p>
         * The version of the DRS agent installed on the source server
         * </p>
         * 
         * @param agentVersion
         *        The version of the DRS agent installed on the source server
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The ARN of the Source Server.
         * </p>
         * 
         * @param arn
         *        The ARN of the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Data Replication Info of the Source Server.
         * </p>
         * 
         * @param dataReplicationInfo
         *        The Data Replication Info of the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationInfo(DataReplicationInfo dataReplicationInfo);

        /**
         * <p>
         * The Data Replication Info of the Source Server.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataReplicationInfo.Builder} avoiding the
         * need to create one manually via {@link DataReplicationInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataReplicationInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #dataReplicationInfo(DataReplicationInfo)}.
         * 
         * @param dataReplicationInfo
         *        a consumer that will call methods on {@link DataReplicationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationInfo(DataReplicationInfo)
         */
        default Builder dataReplicationInfo(Consumer<DataReplicationInfo.Builder> dataReplicationInfo) {
            return dataReplicationInfo(DataReplicationInfo.builder().applyMutation(dataReplicationInfo).build());
        }

        /**
         * <p>
         * The status of the last recovery launch of this Source Server.
         * </p>
         * 
         * @param lastLaunchResult
         *        The status of the last recovery launch of this Source Server.
         * @see LastLaunchResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastLaunchResult
         */
        Builder lastLaunchResult(String lastLaunchResult);

        /**
         * <p>
         * The status of the last recovery launch of this Source Server.
         * </p>
         * 
         * @param lastLaunchResult
         *        The status of the last recovery launch of this Source Server.
         * @see LastLaunchResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastLaunchResult
         */
        Builder lastLaunchResult(LastLaunchResult lastLaunchResult);

        /**
         * <p>
         * The lifecycle information of this Source Server.
         * </p>
         * 
         * @param lifeCycle
         *        The lifecycle information of this Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycle(LifeCycle lifeCycle);

        /**
         * <p>
         * The lifecycle information of this Source Server.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycle.Builder} avoiding the need to
         * create one manually via {@link LifeCycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifeCycle.Builder#build()} is called immediately and its result
         * is passed to {@link #lifeCycle(LifeCycle)}.
         * 
         * @param lifeCycle
         *        a consumer that will call methods on {@link LifeCycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifeCycle(LifeCycle)
         */
        default Builder lifeCycle(Consumer<LifeCycle.Builder> lifeCycle) {
            return lifeCycle(LifeCycle.builder().applyMutation(lifeCycle).build());
        }

        /**
         * <p>
         * The ID of the Recovery Instance associated with this Source Server.
         * </p>
         * 
         * @param recoveryInstanceId
         *        The ID of the Recovery Instance associated with this Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryInstanceId(String recoveryInstanceId);

        /**
         * <p>
         * Replication direction of the Source Server.
         * </p>
         * 
         * @param replicationDirection
         *        Replication direction of the Source Server.
         * @see ReplicationDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationDirection
         */
        Builder replicationDirection(String replicationDirection);

        /**
         * <p>
         * Replication direction of the Source Server.
         * </p>
         * 
         * @param replicationDirection
         *        Replication direction of the Source Server.
         * @see ReplicationDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationDirection
         */
        Builder replicationDirection(ReplicationDirection replicationDirection);

        /**
         * <p>
         * For EC2-originated Source Servers which have been failed over and then failed back, this value will mean the
         * ARN of the Source Server on the opposite replication direction.
         * </p>
         * 
         * @param reversedDirectionSourceServerArn
         *        For EC2-originated Source Servers which have been failed over and then failed back, this value will
         *        mean the ARN of the Source Server on the opposite replication direction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reversedDirectionSourceServerArn(String reversedDirectionSourceServerArn);

        /**
         * <p>
         * Source cloud properties of the Source Server.
         * </p>
         * 
         * @param sourceCloudProperties
         *        Source cloud properties of the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCloudProperties(SourceCloudProperties sourceCloudProperties);

        /**
         * <p>
         * Source cloud properties of the Source Server.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceCloudProperties.Builder} avoiding
         * the need to create one manually via {@link SourceCloudProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceCloudProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceCloudProperties(SourceCloudProperties)}.
         * 
         * @param sourceCloudProperties
         *        a consumer that will call methods on {@link SourceCloudProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceCloudProperties(SourceCloudProperties)
         */
        default Builder sourceCloudProperties(Consumer<SourceCloudProperties.Builder> sourceCloudProperties) {
            return sourceCloudProperties(SourceCloudProperties.builder().applyMutation(sourceCloudProperties).build());
        }

        /**
         * <p>
         * ID of the Source Network which is protecting this Source Server's network.
         * </p>
         * 
         * @param sourceNetworkID
         *        ID of the Source Network which is protecting this Source Server's network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNetworkID(String sourceNetworkID);

        /**
         * <p>
         * The source properties of the Source Server.
         * </p>
         * 
         * @param sourceProperties
         *        The source properties of the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProperties(SourceProperties sourceProperties);

        /**
         * <p>
         * The source properties of the Source Server.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceProperties.Builder} avoiding the
         * need to create one manually via {@link SourceProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceProperties(SourceProperties)}.
         * 
         * @param sourceProperties
         *        a consumer that will call methods on {@link SourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceProperties(SourceProperties)
         */
        default Builder sourceProperties(Consumer<SourceProperties.Builder> sourceProperties) {
            return sourceProperties(SourceProperties.builder().applyMutation(sourceProperties).build());
        }

        /**
         * <p>
         * The ID of the Source Server.
         * </p>
         * 
         * @param sourceServerID
         *        The ID of the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        /**
         * <p>
         * The staging area of the source server.
         * </p>
         * 
         * @param stagingArea
         *        The staging area of the source server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingArea(StagingArea stagingArea);

        /**
         * <p>
         * The staging area of the source server.
         * </p>
         * This is a convenience method that creates an instance of the {@link StagingArea.Builder} avoiding the need to
         * create one manually via {@link StagingArea#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StagingArea.Builder#build()} is called immediately and its result
         * is passed to {@link #stagingArea(StagingArea)}.
         * 
         * @param stagingArea
         *        a consumer that will call methods on {@link StagingArea.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stagingArea(StagingArea)
         */
        default Builder stagingArea(Consumer<StagingArea.Builder> stagingArea) {
            return stagingArea(StagingArea.builder().applyMutation(stagingArea).build());
        }

        /**
         * <p>
         * The tags associated with the Source Server.
         * </p>
         * 
         * @param tags
         *        The tags associated with the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String agentVersion;

        private String arn;

        private DataReplicationInfo dataReplicationInfo;

        private String lastLaunchResult;

        private LifeCycle lifeCycle;

        private String recoveryInstanceId;

        private String replicationDirection;

        private String reversedDirectionSourceServerArn;

        private SourceCloudProperties sourceCloudProperties;

        private String sourceNetworkID;

        private SourceProperties sourceProperties;

        private String sourceServerID;

        private StagingArea stagingArea;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceServer model) {
            agentVersion(model.agentVersion);
            arn(model.arn);
            dataReplicationInfo(model.dataReplicationInfo);
            lastLaunchResult(model.lastLaunchResult);
            lifeCycle(model.lifeCycle);
            recoveryInstanceId(model.recoveryInstanceId);
            replicationDirection(model.replicationDirection);
            reversedDirectionSourceServerArn(model.reversedDirectionSourceServerArn);
            sourceCloudProperties(model.sourceCloudProperties);
            sourceNetworkID(model.sourceNetworkID);
            sourceProperties(model.sourceProperties);
            sourceServerID(model.sourceServerID);
            stagingArea(model.stagingArea);
            tags(model.tags);
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final DataReplicationInfo.Builder getDataReplicationInfo() {
            return dataReplicationInfo != null ? dataReplicationInfo.toBuilder() : null;
        }

        public final void setDataReplicationInfo(DataReplicationInfo.BuilderImpl dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo != null ? dataReplicationInfo.build() : null;
        }

        @Override
        public final Builder dataReplicationInfo(DataReplicationInfo dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo;
            return this;
        }

        public final String getLastLaunchResult() {
            return lastLaunchResult;
        }

        public final void setLastLaunchResult(String lastLaunchResult) {
            this.lastLaunchResult = lastLaunchResult;
        }

        @Override
        public final Builder lastLaunchResult(String lastLaunchResult) {
            this.lastLaunchResult = lastLaunchResult;
            return this;
        }

        @Override
        public final Builder lastLaunchResult(LastLaunchResult lastLaunchResult) {
            this.lastLaunchResult(lastLaunchResult == null ? null : lastLaunchResult.toString());
            return this;
        }

        public final LifeCycle.Builder getLifeCycle() {
            return lifeCycle != null ? lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(LifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final String getRecoveryInstanceId() {
            return recoveryInstanceId;
        }

        public final void setRecoveryInstanceId(String recoveryInstanceId) {
            this.recoveryInstanceId = recoveryInstanceId;
        }

        @Override
        public final Builder recoveryInstanceId(String recoveryInstanceId) {
            this.recoveryInstanceId = recoveryInstanceId;
            return this;
        }

        public final String getReplicationDirection() {
            return replicationDirection;
        }

        public final void setReplicationDirection(String replicationDirection) {
            this.replicationDirection = replicationDirection;
        }

        @Override
        public final Builder replicationDirection(String replicationDirection) {
            this.replicationDirection = replicationDirection;
            return this;
        }

        @Override
        public final Builder replicationDirection(ReplicationDirection replicationDirection) {
            this.replicationDirection(replicationDirection == null ? null : replicationDirection.toString());
            return this;
        }

        public final String getReversedDirectionSourceServerArn() {
            return reversedDirectionSourceServerArn;
        }

        public final void setReversedDirectionSourceServerArn(String reversedDirectionSourceServerArn) {
            this.reversedDirectionSourceServerArn = reversedDirectionSourceServerArn;
        }

        @Override
        public final Builder reversedDirectionSourceServerArn(String reversedDirectionSourceServerArn) {
            this.reversedDirectionSourceServerArn = reversedDirectionSourceServerArn;
            return this;
        }

        public final SourceCloudProperties.Builder getSourceCloudProperties() {
            return sourceCloudProperties != null ? sourceCloudProperties.toBuilder() : null;
        }

        public final void setSourceCloudProperties(SourceCloudProperties.BuilderImpl sourceCloudProperties) {
            this.sourceCloudProperties = sourceCloudProperties != null ? sourceCloudProperties.build() : null;
        }

        @Override
        public final Builder sourceCloudProperties(SourceCloudProperties sourceCloudProperties) {
            this.sourceCloudProperties = sourceCloudProperties;
            return this;
        }

        public final String getSourceNetworkID() {
            return sourceNetworkID;
        }

        public final void setSourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
        }

        @Override
        public final Builder sourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
            return this;
        }

        public final SourceProperties.Builder getSourceProperties() {
            return sourceProperties != null ? sourceProperties.toBuilder() : null;
        }

        public final void setSourceProperties(SourceProperties.BuilderImpl sourceProperties) {
            this.sourceProperties = sourceProperties != null ? sourceProperties.build() : null;
        }

        @Override
        public final Builder sourceProperties(SourceProperties sourceProperties) {
            this.sourceProperties = sourceProperties;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final StagingArea.Builder getStagingArea() {
            return stagingArea != null ? stagingArea.toBuilder() : null;
        }

        public final void setStagingArea(StagingArea.BuilderImpl stagingArea) {
            this.stagingArea = stagingArea != null ? stagingArea.build() : null;
        }

        @Override
        public final Builder stagingArea(StagingArea stagingArea) {
            this.stagingArea = stagingArea;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public SourceServer build() {
            return new SourceServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
