/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties of a conversion job
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversionProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversionProperties.Builder, ConversionProperties> {
    private static final SdkField<String> DATA_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataTimestamp").getter(getter(ConversionProperties::dataTimestamp))
            .setter(setter(Builder::dataTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTimestamp").build()).build();

    private static final SdkField<Boolean> FORCE_UEFI_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceUefi").getter(getter(ConversionProperties::forceUefi)).setter(setter(Builder::forceUefi))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceUefi").build()).build();

    private static final SdkField<String> ROOT_VOLUME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rootVolumeName").getter(getter(ConversionProperties::rootVolumeName))
            .setter(setter(Builder::rootVolumeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootVolumeName").build()).build();

    private static final SdkField<Map<String, Map<String, String>>> VOLUME_TO_CONVERSION_MAP_FIELD = SdkField
            .<Map<String, Map<String, String>>> builder(MarshallingType.MAP)
            .memberName("volumeToConversionMap")
            .getter(getter(ConversionProperties::volumeToConversionMap))
            .setter(setter(Builder::volumeToConversionMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeToConversionMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, List<ProductCode>>> VOLUME_TO_PRODUCT_CODES_FIELD = SdkField
            .<Map<String, List<ProductCode>>> builder(MarshallingType.MAP)
            .memberName("volumeToProductCodes")
            .getter(getter(ConversionProperties::volumeToProductCodes))
            .setter(setter(Builder::volumeToProductCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeToProductCodes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<ProductCode>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(ProductCode::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, Long>> VOLUME_TO_VOLUME_SIZE_FIELD = SdkField
            .<Map<String, Long>> builder(MarshallingType.MAP)
            .memberName("volumeToVolumeSize")
            .getter(getter(ConversionProperties::volumeToVolumeSize))
            .setter(setter(Builder::volumeToVolumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeToVolumeSize").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TIMESTAMP_FIELD,
            FORCE_UEFI_FIELD, ROOT_VOLUME_NAME_FIELD, VOLUME_TO_CONVERSION_MAP_FIELD, VOLUME_TO_PRODUCT_CODES_FIELD,
            VOLUME_TO_VOLUME_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataTimestamp;

    private final Boolean forceUefi;

    private final String rootVolumeName;

    private final Map<String, Map<String, String>> volumeToConversionMap;

    private final Map<String, List<ProductCode>> volumeToProductCodes;

    private final Map<String, Long> volumeToVolumeSize;

    private ConversionProperties(BuilderImpl builder) {
        this.dataTimestamp = builder.dataTimestamp;
        this.forceUefi = builder.forceUefi;
        this.rootVolumeName = builder.rootVolumeName;
        this.volumeToConversionMap = builder.volumeToConversionMap;
        this.volumeToProductCodes = builder.volumeToProductCodes;
        this.volumeToVolumeSize = builder.volumeToVolumeSize;
    }

    /**
     * <p>
     * The timestamp of when the snapshot being converted was taken
     * </p>
     * 
     * @return The timestamp of when the snapshot being converted was taken
     */
    public final String dataTimestamp() {
        return dataTimestamp;
    }

    /**
     * <p>
     * Whether the volume being converted uses UEFI or not
     * </p>
     * 
     * @return Whether the volume being converted uses UEFI or not
     */
    public final Boolean forceUefi() {
        return forceUefi;
    }

    /**
     * <p>
     * The root volume name of a conversion job
     * </p>
     * 
     * @return The root volume name of a conversion job
     */
    public final String rootVolumeName() {
        return rootVolumeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeToConversionMap property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVolumeToConversionMap() {
        return volumeToConversionMap != null && !(volumeToConversionMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping between the volumes being converted and the converted snapshot ids
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeToConversionMap} method.
     * </p>
     * 
     * @return A mapping between the volumes being converted and the converted snapshot ids
     */
    public final Map<String, Map<String, String>> volumeToConversionMap() {
        return volumeToConversionMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeToProductCodes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVolumeToProductCodes() {
        return volumeToProductCodes != null && !(volumeToProductCodes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping between the volumes being converted and the product codes associated with them
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeToProductCodes} method.
     * </p>
     * 
     * @return A mapping between the volumes being converted and the product codes associated with them
     */
    public final Map<String, List<ProductCode>> volumeToProductCodes() {
        return volumeToProductCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeToVolumeSize property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVolumeToVolumeSize() {
        return volumeToVolumeSize != null && !(volumeToVolumeSize instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping between the volumes and their sizes
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeToVolumeSize} method.
     * </p>
     * 
     * @return A mapping between the volumes and their sizes
     */
    public final Map<String, Long> volumeToVolumeSize() {
        return volumeToVolumeSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(forceUefi());
        hashCode = 31 * hashCode + Objects.hashCode(rootVolumeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeToConversionMap() ? volumeToConversionMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeToProductCodes() ? volumeToProductCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeToVolumeSize() ? volumeToVolumeSize() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionProperties)) {
            return false;
        }
        ConversionProperties other = (ConversionProperties) obj;
        return Objects.equals(dataTimestamp(), other.dataTimestamp()) && Objects.equals(forceUefi(), other.forceUefi())
                && Objects.equals(rootVolumeName(), other.rootVolumeName())
                && hasVolumeToConversionMap() == other.hasVolumeToConversionMap()
                && Objects.equals(volumeToConversionMap(), other.volumeToConversionMap())
                && hasVolumeToProductCodes() == other.hasVolumeToProductCodes()
                && Objects.equals(volumeToProductCodes(), other.volumeToProductCodes())
                && hasVolumeToVolumeSize() == other.hasVolumeToVolumeSize()
                && Objects.equals(volumeToVolumeSize(), other.volumeToVolumeSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversionProperties").add("DataTimestamp", dataTimestamp()).add("ForceUefi", forceUefi())
                .add("RootVolumeName", rootVolumeName())
                .add("VolumeToConversionMap", hasVolumeToConversionMap() ? volumeToConversionMap() : null)
                .add("VolumeToProductCodes", hasVolumeToProductCodes() ? volumeToProductCodes() : null)
                .add("VolumeToVolumeSize", hasVolumeToVolumeSize() ? volumeToVolumeSize() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataTimestamp":
            return Optional.ofNullable(clazz.cast(dataTimestamp()));
        case "forceUefi":
            return Optional.ofNullable(clazz.cast(forceUefi()));
        case "rootVolumeName":
            return Optional.ofNullable(clazz.cast(rootVolumeName()));
        case "volumeToConversionMap":
            return Optional.ofNullable(clazz.cast(volumeToConversionMap()));
        case "volumeToProductCodes":
            return Optional.ofNullable(clazz.cast(volumeToProductCodes()));
        case "volumeToVolumeSize":
            return Optional.ofNullable(clazz.cast(volumeToVolumeSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversionProperties, T> g) {
        return obj -> g.apply((ConversionProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversionProperties> {
        /**
         * <p>
         * The timestamp of when the snapshot being converted was taken
         * </p>
         * 
         * @param dataTimestamp
         *        The timestamp of when the snapshot being converted was taken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTimestamp(String dataTimestamp);

        /**
         * <p>
         * Whether the volume being converted uses UEFI or not
         * </p>
         * 
         * @param forceUefi
         *        Whether the volume being converted uses UEFI or not
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceUefi(Boolean forceUefi);

        /**
         * <p>
         * The root volume name of a conversion job
         * </p>
         * 
         * @param rootVolumeName
         *        The root volume name of a conversion job
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootVolumeName(String rootVolumeName);

        /**
         * <p>
         * A mapping between the volumes being converted and the converted snapshot ids
         * </p>
         * 
         * @param volumeToConversionMap
         *        A mapping between the volumes being converted and the converted snapshot ids
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeToConversionMap(Map<String, ? extends Map<String, String>> volumeToConversionMap);

        /**
         * <p>
         * A mapping between the volumes being converted and the product codes associated with them
         * </p>
         * 
         * @param volumeToProductCodes
         *        A mapping between the volumes being converted and the product codes associated with them
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeToProductCodes(Map<String, ? extends Collection<ProductCode>> volumeToProductCodes);

        /**
         * <p>
         * A mapping between the volumes and their sizes
         * </p>
         * 
         * @param volumeToVolumeSize
         *        A mapping between the volumes and their sizes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeToVolumeSize(Map<String, Long> volumeToVolumeSize);
    }

    static final class BuilderImpl implements Builder {
        private String dataTimestamp;

        private Boolean forceUefi;

        private String rootVolumeName;

        private Map<String, Map<String, String>> volumeToConversionMap = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<ProductCode>> volumeToProductCodes = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Long> volumeToVolumeSize = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConversionProperties model) {
            dataTimestamp(model.dataTimestamp);
            forceUefi(model.forceUefi);
            rootVolumeName(model.rootVolumeName);
            volumeToConversionMap(model.volumeToConversionMap);
            volumeToProductCodes(model.volumeToProductCodes);
            volumeToVolumeSize(model.volumeToVolumeSize);
        }

        public final String getDataTimestamp() {
            return dataTimestamp;
        }

        public final void setDataTimestamp(String dataTimestamp) {
            this.dataTimestamp = dataTimestamp;
        }

        @Override
        public final Builder dataTimestamp(String dataTimestamp) {
            this.dataTimestamp = dataTimestamp;
            return this;
        }

        public final Boolean getForceUefi() {
            return forceUefi;
        }

        public final void setForceUefi(Boolean forceUefi) {
            this.forceUefi = forceUefi;
        }

        @Override
        public final Builder forceUefi(Boolean forceUefi) {
            this.forceUefi = forceUefi;
            return this;
        }

        public final String getRootVolumeName() {
            return rootVolumeName;
        }

        public final void setRootVolumeName(String rootVolumeName) {
            this.rootVolumeName = rootVolumeName;
        }

        @Override
        public final Builder rootVolumeName(String rootVolumeName) {
            this.rootVolumeName = rootVolumeName;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getVolumeToConversionMap() {
            if (volumeToConversionMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return volumeToConversionMap;
        }

        public final void setVolumeToConversionMap(Map<String, ? extends Map<String, String>> volumeToConversionMap) {
            this.volumeToConversionMap = VolumeToConversionMapCopier.copy(volumeToConversionMap);
        }

        @Override
        public final Builder volumeToConversionMap(Map<String, ? extends Map<String, String>> volumeToConversionMap) {
            this.volumeToConversionMap = VolumeToConversionMapCopier.copy(volumeToConversionMap);
            return this;
        }

        public final Map<String, List<ProductCode.Builder>> getVolumeToProductCodes() {
            Map<String, List<ProductCode.Builder>> result = VolumeToProductCodesCopier.copyToBuilder(this.volumeToProductCodes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setVolumeToProductCodes(Map<String, ? extends Collection<ProductCode.BuilderImpl>> volumeToProductCodes) {
            this.volumeToProductCodes = VolumeToProductCodesCopier.copyFromBuilder(volumeToProductCodes);
        }

        @Override
        public final Builder volumeToProductCodes(Map<String, ? extends Collection<ProductCode>> volumeToProductCodes) {
            this.volumeToProductCodes = VolumeToProductCodesCopier.copy(volumeToProductCodes);
            return this;
        }

        public final Map<String, Long> getVolumeToVolumeSize() {
            if (volumeToVolumeSize instanceof SdkAutoConstructMap) {
                return null;
            }
            return volumeToVolumeSize;
        }

        public final void setVolumeToVolumeSize(Map<String, Long> volumeToVolumeSize) {
            this.volumeToVolumeSize = VolumeToSizeMapCopier.copy(volumeToVolumeSize);
        }

        @Override
        public final Builder volumeToVolumeSize(Map<String, Long> volumeToVolumeSize) {
            this.volumeToVolumeSize = VolumeToSizeMapCopier.copy(volumeToVolumeSize);
            return this;
        }

        @Override
        public ConversionProperties build() {
            return new ConversionProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
