/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationConfigurationTemplateRequest extends DrsRequest implements
        ToCopyableBuilder<CreateReplicationConfigurationTemplateRequest.Builder, CreateReplicationConfigurationTemplateRequest> {
    private static final SdkField<Boolean> ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("associateDefaultSecurityGroup")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::associateDefaultSecurityGroup))
            .setter(setter(Builder::associateDefaultSecurityGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associateDefaultSecurityGroup")
                    .build()).build();

    private static final SdkField<Boolean> AUTO_REPLICATE_NEW_DISKS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoReplicateNewDisks")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::autoReplicateNewDisks))
            .setter(setter(Builder::autoReplicateNewDisks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoReplicateNewDisks").build())
            .build();

    private static final SdkField<Long> BANDWIDTH_THROTTLING_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("bandwidthThrottling").getter(getter(CreateReplicationConfigurationTemplateRequest::bandwidthThrottling))
            .setter(setter(Builder::bandwidthThrottling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthThrottling").build())
            .build();

    private static final SdkField<Boolean> CREATE_PUBLIC_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("createPublicIP").getter(getter(CreateReplicationConfigurationTemplateRequest::createPublicIP))
            .setter(setter(Builder::createPublicIP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createPublicIP").build()).build();

    private static final SdkField<String> DATA_PLANE_ROUTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataPlaneRouting")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::dataPlaneRoutingAsString))
            .setter(setter(Builder::dataPlaneRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPlaneRouting").build()).build();

    private static final SdkField<String> DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("defaultLargeStagingDiskType")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::defaultLargeStagingDiskTypeAsString))
            .setter(setter(Builder::defaultLargeStagingDiskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLargeStagingDiskType")
                    .build()).build();

    private static final SdkField<String> EBS_ENCRYPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ebsEncryption").getter(getter(CreateReplicationConfigurationTemplateRequest::ebsEncryptionAsString))
            .setter(setter(Builder::ebsEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryption").build()).build();

    private static final SdkField<String> EBS_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ebsEncryptionKeyArn").getter(getter(CreateReplicationConfigurationTemplateRequest::ebsEncryptionKeyArn))
            .setter(setter(Builder::ebsEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryptionKeyArn").build())
            .build();

    private static final SdkField<List<PITPolicyRule>> PIT_POLICY_FIELD = SdkField
            .<List<PITPolicyRule>> builder(MarshallingType.LIST)
            .memberName("pitPolicy")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::pitPolicy))
            .setter(setter(Builder::pitPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pitPolicy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PITPolicyRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(PITPolicyRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPLICATION_SERVER_INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("replicationServerInstanceType")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::replicationServerInstanceType))
            .setter(setter(Builder::replicationServerInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationServerInstanceType")
                    .build()).build();

    private static final SdkField<List<String>> REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("replicationServersSecurityGroupsIDs")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::replicationServersSecurityGroupsIDs))
            .setter(setter(Builder::replicationServersSecurityGroupsIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("replicationServersSecurityGroupsIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STAGING_AREA_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stagingAreaSubnetId").getter(getter(CreateReplicationConfigurationTemplateRequest::stagingAreaSubnetId))
            .setter(setter(Builder::stagingAreaSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaSubnetId").build())
            .build();

    private static final SdkField<Map<String, String>> STAGING_AREA_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("stagingAreaTags")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::stagingAreaTags))
            .setter(setter(Builder::stagingAreaTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> USE_DEDICATED_REPLICATION_SERVER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useDedicatedReplicationServer")
            .getter(getter(CreateReplicationConfigurationTemplateRequest::useDedicatedReplicationServer))
            .setter(setter(Builder::useDedicatedReplicationServer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDedicatedReplicationServer")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD, AUTO_REPLICATE_NEW_DISKS_FIELD, BANDWIDTH_THROTTLING_FIELD,
            CREATE_PUBLIC_IP_FIELD, DATA_PLANE_ROUTING_FIELD, DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD, EBS_ENCRYPTION_FIELD,
            EBS_ENCRYPTION_KEY_ARN_FIELD, PIT_POLICY_FIELD, REPLICATION_SERVER_INSTANCE_TYPE_FIELD,
            REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD, STAGING_AREA_SUBNET_ID_FIELD, STAGING_AREA_TAGS_FIELD, TAGS_FIELD,
            USE_DEDICATED_REPLICATION_SERVER_FIELD));

    private final Boolean associateDefaultSecurityGroup;

    private final Boolean autoReplicateNewDisks;

    private final Long bandwidthThrottling;

    private final Boolean createPublicIP;

    private final String dataPlaneRouting;

    private final String defaultLargeStagingDiskType;

    private final String ebsEncryption;

    private final String ebsEncryptionKeyArn;

    private final List<PITPolicyRule> pitPolicy;

    private final String replicationServerInstanceType;

    private final List<String> replicationServersSecurityGroupsIDs;

    private final String stagingAreaSubnetId;

    private final Map<String, String> stagingAreaTags;

    private final Map<String, String> tags;

    private final Boolean useDedicatedReplicationServer;

    private CreateReplicationConfigurationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.associateDefaultSecurityGroup = builder.associateDefaultSecurityGroup;
        this.autoReplicateNewDisks = builder.autoReplicateNewDisks;
        this.bandwidthThrottling = builder.bandwidthThrottling;
        this.createPublicIP = builder.createPublicIP;
        this.dataPlaneRouting = builder.dataPlaneRouting;
        this.defaultLargeStagingDiskType = builder.defaultLargeStagingDiskType;
        this.ebsEncryption = builder.ebsEncryption;
        this.ebsEncryptionKeyArn = builder.ebsEncryptionKeyArn;
        this.pitPolicy = builder.pitPolicy;
        this.replicationServerInstanceType = builder.replicationServerInstanceType;
        this.replicationServersSecurityGroupsIDs = builder.replicationServersSecurityGroupsIDs;
        this.stagingAreaSubnetId = builder.stagingAreaSubnetId;
        this.stagingAreaTags = builder.stagingAreaTags;
        this.tags = builder.tags;
        this.useDedicatedReplicationServer = builder.useDedicatedReplicationServer;
    }

    /**
     * <p>
     * Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration
     * Template.
     * </p>
     * 
     * @return Whether to associate the default Elastic Disaster Recovery Security group with the Replication
     *         Configuration Template.
     */
    public final Boolean associateDefaultSecurityGroup() {
        return associateDefaultSecurityGroup;
    }

    /**
     * <p>
     * Whether to allow the AWS replication agent to automatically replicate newly added disks.
     * </p>
     * 
     * @return Whether to allow the AWS replication agent to automatically replicate newly added disks.
     */
    public final Boolean autoReplicateNewDisks() {
        return autoReplicateNewDisks;
    }

    /**
     * <p>
     * Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
     * </p>
     * 
     * @return Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
     */
    public final Long bandwidthThrottling() {
        return bandwidthThrottling;
    }

    /**
     * <p>
     * Whether to create a Public IP for the Recovery Instance by default.
     * </p>
     * 
     * @return Whether to create a Public IP for the Recovery Instance by default.
     */
    public final Boolean createPublicIP() {
        return createPublicIP;
    }

    /**
     * <p>
     * The data plane routing mechanism that will be used for replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataPlaneRouting}
     * will return {@link ReplicationConfigurationDataPlaneRouting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #dataPlaneRoutingAsString}.
     * </p>
     * 
     * @return The data plane routing mechanism that will be used for replication.
     * @see ReplicationConfigurationDataPlaneRouting
     */
    public final ReplicationConfigurationDataPlaneRouting dataPlaneRouting() {
        return ReplicationConfigurationDataPlaneRouting.fromValue(dataPlaneRouting);
    }

    /**
     * <p>
     * The data plane routing mechanism that will be used for replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataPlaneRouting}
     * will return {@link ReplicationConfigurationDataPlaneRouting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #dataPlaneRoutingAsString}.
     * </p>
     * 
     * @return The data plane routing mechanism that will be used for replication.
     * @see ReplicationConfigurationDataPlaneRouting
     */
    public final String dataPlaneRoutingAsString() {
        return dataPlaneRouting;
    }

    /**
     * <p>
     * The Staging Disk EBS volume type to be used during replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultLargeStagingDiskType} will return
     * {@link ReplicationConfigurationDefaultLargeStagingDiskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultLargeStagingDiskTypeAsString}.
     * </p>
     * 
     * @return The Staging Disk EBS volume type to be used during replication.
     * @see ReplicationConfigurationDefaultLargeStagingDiskType
     */
    public final ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType() {
        return ReplicationConfigurationDefaultLargeStagingDiskType.fromValue(defaultLargeStagingDiskType);
    }

    /**
     * <p>
     * The Staging Disk EBS volume type to be used during replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultLargeStagingDiskType} will return
     * {@link ReplicationConfigurationDefaultLargeStagingDiskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultLargeStagingDiskTypeAsString}.
     * </p>
     * 
     * @return The Staging Disk EBS volume type to be used during replication.
     * @see ReplicationConfigurationDefaultLargeStagingDiskType
     */
    public final String defaultLargeStagingDiskTypeAsString() {
        return defaultLargeStagingDiskType;
    }

    /**
     * <p>
     * The type of EBS encryption to be used during replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebsEncryption}
     * will return {@link ReplicationConfigurationEbsEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #ebsEncryptionAsString}.
     * </p>
     * 
     * @return The type of EBS encryption to be used during replication.
     * @see ReplicationConfigurationEbsEncryption
     */
    public final ReplicationConfigurationEbsEncryption ebsEncryption() {
        return ReplicationConfigurationEbsEncryption.fromValue(ebsEncryption);
    }

    /**
     * <p>
     * The type of EBS encryption to be used during replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebsEncryption}
     * will return {@link ReplicationConfigurationEbsEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #ebsEncryptionAsString}.
     * </p>
     * 
     * @return The type of EBS encryption to be used during replication.
     * @see ReplicationConfigurationEbsEncryption
     */
    public final String ebsEncryptionAsString() {
        return ebsEncryption;
    }

    /**
     * <p>
     * The ARN of the EBS encryption key to be used during replication.
     * </p>
     * 
     * @return The ARN of the EBS encryption key to be used during replication.
     */
    public final String ebsEncryptionKeyArn() {
        return ebsEncryptionKeyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the PitPolicy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPitPolicy() {
        return pitPolicy != null && !(pitPolicy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Point in time (PIT) policy to manage snapshots taken during replication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPitPolicy} method.
     * </p>
     * 
     * @return The Point in time (PIT) policy to manage snapshots taken during replication.
     */
    public final List<PITPolicyRule> pitPolicy() {
        return pitPolicy;
    }

    /**
     * <p>
     * The instance type to be used for the replication server.
     * </p>
     * 
     * @return The instance type to be used for the replication server.
     */
    public final String replicationServerInstanceType() {
        return replicationServerInstanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationServersSecurityGroupsIDs
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReplicationServersSecurityGroupsIDs() {
        return replicationServersSecurityGroupsIDs != null
                && !(replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group IDs that will be used by the replication server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationServersSecurityGroupsIDs}
     * method.
     * </p>
     * 
     * @return The security group IDs that will be used by the replication server.
     */
    public final List<String> replicationServersSecurityGroupsIDs() {
        return replicationServersSecurityGroupsIDs;
    }

    /**
     * <p>
     * The subnet to be used by the replication staging area.
     * </p>
     * 
     * @return The subnet to be used by the replication staging area.
     */
    public final String stagingAreaSubnetId() {
        return stagingAreaSubnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the StagingAreaTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStagingAreaTags() {
        return stagingAreaTags != null && !(stagingAreaTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of tags to be associated with all resources created in the replication staging area: EC2 replication
     * server, EBS volumes, EBS snapshots, etc.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStagingAreaTags} method.
     * </p>
     * 
     * @return A set of tags to be associated with all resources created in the replication staging area: EC2
     *         replication server, EBS volumes, EBS snapshots, etc.
     */
    public final Map<String, String> stagingAreaTags() {
        return stagingAreaTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of tags to be associated with the Replication Configuration Template resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of tags to be associated with the Replication Configuration Template resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Whether to use a dedicated Replication Server in the replication staging area.
     * </p>
     * 
     * @return Whether to use a dedicated Replication Server in the replication staging area.
     */
    public final Boolean useDedicatedReplicationServer() {
        return useDedicatedReplicationServer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associateDefaultSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(autoReplicateNewDisks());
        hashCode = 31 * hashCode + Objects.hashCode(bandwidthThrottling());
        hashCode = 31 * hashCode + Objects.hashCode(createPublicIP());
        hashCode = 31 * hashCode + Objects.hashCode(dataPlaneRoutingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultLargeStagingDiskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ebsEncryptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ebsEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPitPolicy() ? pitPolicy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicationServerInstanceType());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplicationServersSecurityGroupsIDs() ? replicationServersSecurityGroupsIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stagingAreaSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasStagingAreaTags() ? stagingAreaTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useDedicatedReplicationServer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationConfigurationTemplateRequest)) {
            return false;
        }
        CreateReplicationConfigurationTemplateRequest other = (CreateReplicationConfigurationTemplateRequest) obj;
        return Objects.equals(associateDefaultSecurityGroup(), other.associateDefaultSecurityGroup())
                && Objects.equals(autoReplicateNewDisks(), other.autoReplicateNewDisks())
                && Objects.equals(bandwidthThrottling(), other.bandwidthThrottling())
                && Objects.equals(createPublicIP(), other.createPublicIP())
                && Objects.equals(dataPlaneRoutingAsString(), other.dataPlaneRoutingAsString())
                && Objects.equals(defaultLargeStagingDiskTypeAsString(), other.defaultLargeStagingDiskTypeAsString())
                && Objects.equals(ebsEncryptionAsString(), other.ebsEncryptionAsString())
                && Objects.equals(ebsEncryptionKeyArn(), other.ebsEncryptionKeyArn()) && hasPitPolicy() == other.hasPitPolicy()
                && Objects.equals(pitPolicy(), other.pitPolicy())
                && Objects.equals(replicationServerInstanceType(), other.replicationServerInstanceType())
                && hasReplicationServersSecurityGroupsIDs() == other.hasReplicationServersSecurityGroupsIDs()
                && Objects.equals(replicationServersSecurityGroupsIDs(), other.replicationServersSecurityGroupsIDs())
                && Objects.equals(stagingAreaSubnetId(), other.stagingAreaSubnetId())
                && hasStagingAreaTags() == other.hasStagingAreaTags()
                && Objects.equals(stagingAreaTags(), other.stagingAreaTags()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(useDedicatedReplicationServer(), other.useDedicatedReplicationServer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateReplicationConfigurationTemplateRequest")
                .add("AssociateDefaultSecurityGroup", associateDefaultSecurityGroup())
                .add("AutoReplicateNewDisks", autoReplicateNewDisks())
                .add("BandwidthThrottling", bandwidthThrottling())
                .add("CreatePublicIP", createPublicIP())
                .add("DataPlaneRouting", dataPlaneRoutingAsString())
                .add("DefaultLargeStagingDiskType", defaultLargeStagingDiskTypeAsString())
                .add("EbsEncryption", ebsEncryptionAsString())
                .add("EbsEncryptionKeyArn", ebsEncryptionKeyArn())
                .add("PitPolicy", hasPitPolicy() ? pitPolicy() : null)
                .add("ReplicationServerInstanceType", replicationServerInstanceType())
                .add("ReplicationServersSecurityGroupsIDs",
                        hasReplicationServersSecurityGroupsIDs() ? replicationServersSecurityGroupsIDs() : null)
                .add("StagingAreaSubnetId", stagingAreaSubnetId())
                .add("StagingAreaTags", stagingAreaTags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UseDedicatedReplicationServer", useDedicatedReplicationServer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associateDefaultSecurityGroup":
            return Optional.ofNullable(clazz.cast(associateDefaultSecurityGroup()));
        case "autoReplicateNewDisks":
            return Optional.ofNullable(clazz.cast(autoReplicateNewDisks()));
        case "bandwidthThrottling":
            return Optional.ofNullable(clazz.cast(bandwidthThrottling()));
        case "createPublicIP":
            return Optional.ofNullable(clazz.cast(createPublicIP()));
        case "dataPlaneRouting":
            return Optional.ofNullable(clazz.cast(dataPlaneRoutingAsString()));
        case "defaultLargeStagingDiskType":
            return Optional.ofNullable(clazz.cast(defaultLargeStagingDiskTypeAsString()));
        case "ebsEncryption":
            return Optional.ofNullable(clazz.cast(ebsEncryptionAsString()));
        case "ebsEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(ebsEncryptionKeyArn()));
        case "pitPolicy":
            return Optional.ofNullable(clazz.cast(pitPolicy()));
        case "replicationServerInstanceType":
            return Optional.ofNullable(clazz.cast(replicationServerInstanceType()));
        case "replicationServersSecurityGroupsIDs":
            return Optional.ofNullable(clazz.cast(replicationServersSecurityGroupsIDs()));
        case "stagingAreaSubnetId":
            return Optional.ofNullable(clazz.cast(stagingAreaSubnetId()));
        case "stagingAreaTags":
            return Optional.ofNullable(clazz.cast(stagingAreaTags()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "useDedicatedReplicationServer":
            return Optional.ofNullable(clazz.cast(useDedicatedReplicationServer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationConfigurationTemplateRequest, T> g) {
        return obj -> g.apply((CreateReplicationConfigurationTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateReplicationConfigurationTemplateRequest> {
        /**
         * <p>
         * Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration
         * Template.
         * </p>
         * 
         * @param associateDefaultSecurityGroup
         *        Whether to associate the default Elastic Disaster Recovery Security group with the Replication
         *        Configuration Template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup);

        /**
         * <p>
         * Whether to allow the AWS replication agent to automatically replicate newly added disks.
         * </p>
         * 
         * @param autoReplicateNewDisks
         *        Whether to allow the AWS replication agent to automatically replicate newly added disks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoReplicateNewDisks(Boolean autoReplicateNewDisks);

        /**
         * <p>
         * Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
         * </p>
         * 
         * @param bandwidthThrottling
         *        Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthThrottling(Long bandwidthThrottling);

        /**
         * <p>
         * Whether to create a Public IP for the Recovery Instance by default.
         * </p>
         * 
         * @param createPublicIP
         *        Whether to create a Public IP for the Recovery Instance by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createPublicIP(Boolean createPublicIP);

        /**
         * <p>
         * The data plane routing mechanism that will be used for replication.
         * </p>
         * 
         * @param dataPlaneRouting
         *        The data plane routing mechanism that will be used for replication.
         * @see ReplicationConfigurationDataPlaneRouting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDataPlaneRouting
         */
        Builder dataPlaneRouting(String dataPlaneRouting);

        /**
         * <p>
         * The data plane routing mechanism that will be used for replication.
         * </p>
         * 
         * @param dataPlaneRouting
         *        The data plane routing mechanism that will be used for replication.
         * @see ReplicationConfigurationDataPlaneRouting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDataPlaneRouting
         */
        Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting dataPlaneRouting);

        /**
         * <p>
         * The Staging Disk EBS volume type to be used during replication.
         * </p>
         * 
         * @param defaultLargeStagingDiskType
         *        The Staging Disk EBS volume type to be used during replication.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         */
        Builder defaultLargeStagingDiskType(String defaultLargeStagingDiskType);

        /**
         * <p>
         * The Staging Disk EBS volume type to be used during replication.
         * </p>
         * 
         * @param defaultLargeStagingDiskType
         *        The Staging Disk EBS volume type to be used during replication.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationDefaultLargeStagingDiskType
         */
        Builder defaultLargeStagingDiskType(ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType);

        /**
         * <p>
         * The type of EBS encryption to be used during replication.
         * </p>
         * 
         * @param ebsEncryption
         *        The type of EBS encryption to be used during replication.
         * @see ReplicationConfigurationEbsEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationEbsEncryption
         */
        Builder ebsEncryption(String ebsEncryption);

        /**
         * <p>
         * The type of EBS encryption to be used during replication.
         * </p>
         * 
         * @param ebsEncryption
         *        The type of EBS encryption to be used during replication.
         * @see ReplicationConfigurationEbsEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationConfigurationEbsEncryption
         */
        Builder ebsEncryption(ReplicationConfigurationEbsEncryption ebsEncryption);

        /**
         * <p>
         * The ARN of the EBS encryption key to be used during replication.
         * </p>
         * 
         * @param ebsEncryptionKeyArn
         *        The ARN of the EBS encryption key to be used during replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsEncryptionKeyArn(String ebsEncryptionKeyArn);

        /**
         * <p>
         * The Point in time (PIT) policy to manage snapshots taken during replication.
         * </p>
         * 
         * @param pitPolicy
         *        The Point in time (PIT) policy to manage snapshots taken during replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pitPolicy(Collection<PITPolicyRule> pitPolicy);

        /**
         * <p>
         * The Point in time (PIT) policy to manage snapshots taken during replication.
         * </p>
         * 
         * @param pitPolicy
         *        The Point in time (PIT) policy to manage snapshots taken during replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pitPolicy(PITPolicyRule... pitPolicy);

        /**
         * <p>
         * The Point in time (PIT) policy to manage snapshots taken during replication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.drs.model.PITPolicyRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.drs.model.PITPolicyRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.drs.model.PITPolicyRule.Builder#build()} is called immediately and its
         * result is passed to {@link #pitPolicy(List<PITPolicyRule>)}.
         * 
         * @param pitPolicy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.drs.model.PITPolicyRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pitPolicy(java.util.Collection<PITPolicyRule>)
         */
        Builder pitPolicy(Consumer<PITPolicyRule.Builder>... pitPolicy);

        /**
         * <p>
         * The instance type to be used for the replication server.
         * </p>
         * 
         * @param replicationServerInstanceType
         *        The instance type to be used for the replication server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationServerInstanceType(String replicationServerInstanceType);

        /**
         * <p>
         * The security group IDs that will be used by the replication server.
         * </p>
         * 
         * @param replicationServersSecurityGroupsIDs
         *        The security group IDs that will be used by the replication server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs);

        /**
         * <p>
         * The security group IDs that will be used by the replication server.
         * </p>
         * 
         * @param replicationServersSecurityGroupsIDs
         *        The security group IDs that will be used by the replication server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationServersSecurityGroupsIDs(String... replicationServersSecurityGroupsIDs);

        /**
         * <p>
         * The subnet to be used by the replication staging area.
         * </p>
         * 
         * @param stagingAreaSubnetId
         *        The subnet to be used by the replication staging area.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingAreaSubnetId(String stagingAreaSubnetId);

        /**
         * <p>
         * A set of tags to be associated with all resources created in the replication staging area: EC2 replication
         * server, EBS volumes, EBS snapshots, etc.
         * </p>
         * 
         * @param stagingAreaTags
         *        A set of tags to be associated with all resources created in the replication staging area: EC2
         *        replication server, EBS volumes, EBS snapshots, etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingAreaTags(Map<String, String> stagingAreaTags);

        /**
         * <p>
         * A set of tags to be associated with the Replication Configuration Template resource.
         * </p>
         * 
         * @param tags
         *        A set of tags to be associated with the Replication Configuration Template resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Whether to use a dedicated Replication Server in the replication staging area.
         * </p>
         * 
         * @param useDedicatedReplicationServer
         *        Whether to use a dedicated Replication Server in the replication staging area.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDedicatedReplicationServer(Boolean useDedicatedReplicationServer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DrsRequest.BuilderImpl implements Builder {
        private Boolean associateDefaultSecurityGroup;

        private Boolean autoReplicateNewDisks;

        private Long bandwidthThrottling;

        private Boolean createPublicIP;

        private String dataPlaneRouting;

        private String defaultLargeStagingDiskType;

        private String ebsEncryption;

        private String ebsEncryptionKeyArn;

        private List<PITPolicyRule> pitPolicy = DefaultSdkAutoConstructList.getInstance();

        private String replicationServerInstanceType;

        private List<String> replicationServersSecurityGroupsIDs = DefaultSdkAutoConstructList.getInstance();

        private String stagingAreaSubnetId;

        private Map<String, String> stagingAreaTags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Boolean useDedicatedReplicationServer;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationConfigurationTemplateRequest model) {
            super(model);
            associateDefaultSecurityGroup(model.associateDefaultSecurityGroup);
            autoReplicateNewDisks(model.autoReplicateNewDisks);
            bandwidthThrottling(model.bandwidthThrottling);
            createPublicIP(model.createPublicIP);
            dataPlaneRouting(model.dataPlaneRouting);
            defaultLargeStagingDiskType(model.defaultLargeStagingDiskType);
            ebsEncryption(model.ebsEncryption);
            ebsEncryptionKeyArn(model.ebsEncryptionKeyArn);
            pitPolicy(model.pitPolicy);
            replicationServerInstanceType(model.replicationServerInstanceType);
            replicationServersSecurityGroupsIDs(model.replicationServersSecurityGroupsIDs);
            stagingAreaSubnetId(model.stagingAreaSubnetId);
            stagingAreaTags(model.stagingAreaTags);
            tags(model.tags);
            useDedicatedReplicationServer(model.useDedicatedReplicationServer);
        }

        public final Boolean getAssociateDefaultSecurityGroup() {
            return associateDefaultSecurityGroup;
        }

        public final void setAssociateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
        }

        @Override
        public final Builder associateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
            return this;
        }

        public final Boolean getAutoReplicateNewDisks() {
            return autoReplicateNewDisks;
        }

        public final void setAutoReplicateNewDisks(Boolean autoReplicateNewDisks) {
            this.autoReplicateNewDisks = autoReplicateNewDisks;
        }

        @Override
        public final Builder autoReplicateNewDisks(Boolean autoReplicateNewDisks) {
            this.autoReplicateNewDisks = autoReplicateNewDisks;
            return this;
        }

        public final Long getBandwidthThrottling() {
            return bandwidthThrottling;
        }

        public final void setBandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
        }

        @Override
        public final Builder bandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
            return this;
        }

        public final Boolean getCreatePublicIP() {
            return createPublicIP;
        }

        public final void setCreatePublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
        }

        @Override
        public final Builder createPublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
            return this;
        }

        public final String getDataPlaneRouting() {
            return dataPlaneRouting;
        }

        public final void setDataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
        }

        @Override
        public final Builder dataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
            return this;
        }

        @Override
        public final Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting dataPlaneRouting) {
            this.dataPlaneRouting(dataPlaneRouting == null ? null : dataPlaneRouting.toString());
            return this;
        }

        public final String getDefaultLargeStagingDiskType() {
            return defaultLargeStagingDiskType;
        }

        public final void setDefaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
            return this;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(
                ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType(defaultLargeStagingDiskType == null ? null : defaultLargeStagingDiskType.toString());
            return this;
        }

        public final String getEbsEncryption() {
            return ebsEncryption;
        }

        public final void setEbsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
        }

        @Override
        public final Builder ebsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
            return this;
        }

        @Override
        public final Builder ebsEncryption(ReplicationConfigurationEbsEncryption ebsEncryption) {
            this.ebsEncryption(ebsEncryption == null ? null : ebsEncryption.toString());
            return this;
        }

        public final String getEbsEncryptionKeyArn() {
            return ebsEncryptionKeyArn;
        }

        public final void setEbsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
        }

        @Override
        public final Builder ebsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
            return this;
        }

        public final List<PITPolicyRule.Builder> getPitPolicy() {
            List<PITPolicyRule.Builder> result = PITPolicyCopier.copyToBuilder(this.pitPolicy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPitPolicy(Collection<PITPolicyRule.BuilderImpl> pitPolicy) {
            this.pitPolicy = PITPolicyCopier.copyFromBuilder(pitPolicy);
        }

        @Override
        public final Builder pitPolicy(Collection<PITPolicyRule> pitPolicy) {
            this.pitPolicy = PITPolicyCopier.copy(pitPolicy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pitPolicy(PITPolicyRule... pitPolicy) {
            pitPolicy(Arrays.asList(pitPolicy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pitPolicy(Consumer<PITPolicyRule.Builder>... pitPolicy) {
            pitPolicy(Stream.of(pitPolicy).map(c -> PITPolicyRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReplicationServerInstanceType() {
            return replicationServerInstanceType;
        }

        public final void setReplicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
        }

        @Override
        public final Builder replicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
            return this;
        }

        public final Collection<String> getReplicationServersSecurityGroupsIDs() {
            if (replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationServersSecurityGroupsIDs;
        }

        public final void setReplicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier
                    .copy(replicationServersSecurityGroupsIDs);
        }

        @Override
        public final Builder replicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier
                    .copy(replicationServersSecurityGroupsIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationServersSecurityGroupsIDs(String... replicationServersSecurityGroupsIDs) {
            replicationServersSecurityGroupsIDs(Arrays.asList(replicationServersSecurityGroupsIDs));
            return this;
        }

        public final String getStagingAreaSubnetId() {
            return stagingAreaSubnetId;
        }

        public final void setStagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
        }

        @Override
        public final Builder stagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
            return this;
        }

        public final Map<String, String> getStagingAreaTags() {
            if (stagingAreaTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return stagingAreaTags;
        }

        public final void setStagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
        }

        @Override
        public final Builder stagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final Boolean getUseDedicatedReplicationServer() {
            return useDedicatedReplicationServer;
        }

        public final void setUseDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
        }

        @Override
        public final Builder useDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationConfigurationTemplateRequest build() {
            return new CreateReplicationConfigurationTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
