/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSourceNetworkRequest extends DrsRequest implements
        ToCopyableBuilder<CreateSourceNetworkRequest.Builder, CreateSourceNetworkRequest> {
    private static final SdkField<String> ORIGIN_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originAccountID").getter(getter(CreateSourceNetworkRequest::originAccountID))
            .setter(setter(Builder::originAccountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originAccountID").build()).build();

    private static final SdkField<String> ORIGIN_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originRegion").getter(getter(CreateSourceNetworkRequest::originRegion))
            .setter(setter(Builder::originRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originRegion").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSourceNetworkRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpcID")
            .getter(getter(CreateSourceNetworkRequest::vpcID)).setter(setter(Builder::vpcID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCOUNT_ID_FIELD,
            ORIGIN_REGION_FIELD, TAGS_FIELD, VPC_ID_FIELD));

    private final String originAccountID;

    private final String originRegion;

    private final Map<String, String> tags;

    private final String vpcID;

    private CreateSourceNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.originAccountID = builder.originAccountID;
        this.originRegion = builder.originRegion;
        this.tags = builder.tags;
        this.vpcID = builder.vpcID;
    }

    /**
     * <p>
     * Account containing the VPC to protect.
     * </p>
     * 
     * @return Account containing the VPC to protect.
     */
    public final String originAccountID() {
        return originAccountID;
    }

    /**
     * <p>
     * Region containing the VPC to protect.
     * </p>
     * 
     * @return Region containing the VPC to protect.
     */
    public final String originRegion() {
        return originRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of tags to be associated with the Source Network resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of tags to be associated with the Source Network resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Which VPC ID to protect.
     * </p>
     * 
     * @return Which VPC ID to protect.
     */
    public final String vpcID() {
        return vpcID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(originAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(originRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSourceNetworkRequest)) {
            return false;
        }
        CreateSourceNetworkRequest other = (CreateSourceNetworkRequest) obj;
        return Objects.equals(originAccountID(), other.originAccountID()) && Objects.equals(originRegion(), other.originRegion())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && Objects.equals(vpcID(), other.vpcID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSourceNetworkRequest").add("OriginAccountID", originAccountID())
                .add("OriginRegion", originRegion()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VpcID", vpcID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "originAccountID":
            return Optional.ofNullable(clazz.cast(originAccountID()));
        case "originRegion":
            return Optional.ofNullable(clazz.cast(originRegion()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vpcID":
            return Optional.ofNullable(clazz.cast(vpcID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSourceNetworkRequest, T> g) {
        return obj -> g.apply((CreateSourceNetworkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSourceNetworkRequest> {
        /**
         * <p>
         * Account containing the VPC to protect.
         * </p>
         * 
         * @param originAccountID
         *        Account containing the VPC to protect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originAccountID(String originAccountID);

        /**
         * <p>
         * Region containing the VPC to protect.
         * </p>
         * 
         * @param originRegion
         *        Region containing the VPC to protect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originRegion(String originRegion);

        /**
         * <p>
         * A set of tags to be associated with the Source Network resource.
         * </p>
         * 
         * @param tags
         *        A set of tags to be associated with the Source Network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Which VPC ID to protect.
         * </p>
         * 
         * @param vpcID
         *        Which VPC ID to protect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcID(String vpcID);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DrsRequest.BuilderImpl implements Builder {
        private String originAccountID;

        private String originRegion;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String vpcID;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSourceNetworkRequest model) {
            super(model);
            originAccountID(model.originAccountID);
            originRegion(model.originRegion);
            tags(model.tags);
            vpcID(model.vpcID);
        }

        public final String getOriginAccountID() {
            return originAccountID;
        }

        public final void setOriginAccountID(String originAccountID) {
            this.originAccountID = originAccountID;
        }

        @Override
        public final Builder originAccountID(String originAccountID) {
            this.originAccountID = originAccountID;
            return this;
        }

        public final String getOriginRegion() {
            return originRegion;
        }

        public final void setOriginRegion(String originRegion) {
            this.originRegion = originRegion;
        }

        @Override
        public final Builder originRegion(String originRegion) {
            this.originRegion = originRegion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getVpcID() {
            return vpcID;
        }

        public final void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        @Override
        public final Builder vpcID(String vpcID) {
            this.vpcID = vpcID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSourceNetworkRequest build() {
            return new CreateSourceNetworkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
