/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Recovery Instance is a replica of a Source Server running on EC2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryInstance.Builder, RecoveryInstance> {
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(RecoveryInstance::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RecoveryInstance::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<RecoveryInstanceDataReplicationInfo> DATA_REPLICATION_INFO_FIELD = SdkField
            .<RecoveryInstanceDataReplicationInfo> builder(MarshallingType.SDK_POJO).memberName("dataReplicationInfo")
            .getter(getter(RecoveryInstance::dataReplicationInfo)).setter(setter(Builder::dataReplicationInfo))
            .constructor(RecoveryInstanceDataReplicationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInfo").build())
            .build();

    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2InstanceID").getter(getter(RecoveryInstance::ec2InstanceID)).setter(setter(Builder::ec2InstanceID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceID").build()).build();

    private static final SdkField<String> EC2_INSTANCE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2InstanceState").getter(getter(RecoveryInstance::ec2InstanceStateAsString))
            .setter(setter(Builder::ec2InstanceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceState").build()).build();

    private static final SdkField<RecoveryInstanceFailback> FAILBACK_FIELD = SdkField
            .<RecoveryInstanceFailback> builder(MarshallingType.SDK_POJO).memberName("failback")
            .getter(getter(RecoveryInstance::failback)).setter(setter(Builder::failback))
            .constructor(RecoveryInstanceFailback::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failback").build()).build();

    private static final SdkField<Boolean> IS_DRILL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isDrill").getter(getter(RecoveryInstance::isDrill)).setter(setter(Builder::isDrill))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDrill").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobID")
            .getter(getter(RecoveryInstance::jobID)).setter(setter(Builder::jobID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()).build();

    private static final SdkField<String> ORIGIN_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originAvailabilityZone").getter(getter(RecoveryInstance::originAvailabilityZone))
            .setter(setter(Builder::originAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originAvailabilityZone").build())
            .build();

    private static final SdkField<String> ORIGIN_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originEnvironment").getter(getter(RecoveryInstance::originEnvironmentAsString))
            .setter(setter(Builder::originEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originEnvironment").build()).build();

    private static final SdkField<String> POINT_IN_TIME_SNAPSHOT_DATE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("pointInTimeSnapshotDateTime")
            .getter(getter(RecoveryInstance::pointInTimeSnapshotDateTime))
            .setter(setter(Builder::pointInTimeSnapshotDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pointInTimeSnapshotDateTime")
                    .build()).build();

    private static final SdkField<String> RECOVERY_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryInstanceID").getter(getter(RecoveryInstance::recoveryInstanceID))
            .setter(setter(Builder::recoveryInstanceID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceID").build())
            .build();

    private static final SdkField<RecoveryInstanceProperties> RECOVERY_INSTANCE_PROPERTIES_FIELD = SdkField
            .<RecoveryInstanceProperties> builder(MarshallingType.SDK_POJO)
            .memberName("recoveryInstanceProperties")
            .getter(getter(RecoveryInstance::recoveryInstanceProperties))
            .setter(setter(Builder::recoveryInstanceProperties))
            .constructor(RecoveryInstanceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceProperties").build())
            .build();

    private static final SdkField<String> SOURCE_OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceOutpostArn").getter(getter(RecoveryInstance::sourceOutpostArn))
            .setter(setter(Builder::sourceOutpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceOutpostArn").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(RecoveryInstance::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(RecoveryInstance::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSION_FIELD,
            ARN_FIELD, DATA_REPLICATION_INFO_FIELD, EC2_INSTANCE_ID_FIELD, EC2_INSTANCE_STATE_FIELD, FAILBACK_FIELD,
            IS_DRILL_FIELD, JOB_ID_FIELD, ORIGIN_AVAILABILITY_ZONE_FIELD, ORIGIN_ENVIRONMENT_FIELD,
            POINT_IN_TIME_SNAPSHOT_DATE_TIME_FIELD, RECOVERY_INSTANCE_ID_FIELD, RECOVERY_INSTANCE_PROPERTIES_FIELD,
            SOURCE_OUTPOST_ARN_FIELD, SOURCE_SERVER_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentVersion;

    private final String arn;

    private final RecoveryInstanceDataReplicationInfo dataReplicationInfo;

    private final String ec2InstanceID;

    private final String ec2InstanceState;

    private final RecoveryInstanceFailback failback;

    private final Boolean isDrill;

    private final String jobID;

    private final String originAvailabilityZone;

    private final String originEnvironment;

    private final String pointInTimeSnapshotDateTime;

    private final String recoveryInstanceID;

    private final RecoveryInstanceProperties recoveryInstanceProperties;

    private final String sourceOutpostArn;

    private final String sourceServerID;

    private final Map<String, String> tags;

    private RecoveryInstance(BuilderImpl builder) {
        this.agentVersion = builder.agentVersion;
        this.arn = builder.arn;
        this.dataReplicationInfo = builder.dataReplicationInfo;
        this.ec2InstanceID = builder.ec2InstanceID;
        this.ec2InstanceState = builder.ec2InstanceState;
        this.failback = builder.failback;
        this.isDrill = builder.isDrill;
        this.jobID = builder.jobID;
        this.originAvailabilityZone = builder.originAvailabilityZone;
        this.originEnvironment = builder.originEnvironment;
        this.pointInTimeSnapshotDateTime = builder.pointInTimeSnapshotDateTime;
        this.recoveryInstanceID = builder.recoveryInstanceID;
        this.recoveryInstanceProperties = builder.recoveryInstanceProperties;
        this.sourceOutpostArn = builder.sourceOutpostArn;
        this.sourceServerID = builder.sourceServerID;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The version of the DRS agent installed on the recovery instance
     * </p>
     * 
     * @return The version of the DRS agent installed on the recovery instance
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * The ARN of the Recovery Instance.
     * </p>
     * 
     * @return The ARN of the Recovery Instance.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Data Replication Info of the Recovery Instance.
     * </p>
     * 
     * @return The Data Replication Info of the Recovery Instance.
     */
    public final RecoveryInstanceDataReplicationInfo dataReplicationInfo() {
        return dataReplicationInfo;
    }

    /**
     * <p>
     * The EC2 instance ID of the Recovery Instance.
     * </p>
     * 
     * @return The EC2 instance ID of the Recovery Instance.
     */
    public final String ec2InstanceID() {
        return ec2InstanceID;
    }

    /**
     * <p>
     * The state of the EC2 instance for this Recovery Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceState}
     * will return {@link EC2InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceStateAsString}.
     * </p>
     * 
     * @return The state of the EC2 instance for this Recovery Instance.
     * @see EC2InstanceState
     */
    public final EC2InstanceState ec2InstanceState() {
        return EC2InstanceState.fromValue(ec2InstanceState);
    }

    /**
     * <p>
     * The state of the EC2 instance for this Recovery Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceState}
     * will return {@link EC2InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceStateAsString}.
     * </p>
     * 
     * @return The state of the EC2 instance for this Recovery Instance.
     * @see EC2InstanceState
     */
    public final String ec2InstanceStateAsString() {
        return ec2InstanceState;
    }

    /**
     * <p>
     * An object representing failback related information of the Recovery Instance.
     * </p>
     * 
     * @return An object representing failback related information of the Recovery Instance.
     */
    public final RecoveryInstanceFailback failback() {
        return failback;
    }

    /**
     * <p>
     * Whether this Recovery Instance was created for a drill or for an actual Recovery event.
     * </p>
     * 
     * @return Whether this Recovery Instance was created for a drill or for an actual Recovery event.
     */
    public final Boolean isDrill() {
        return isDrill;
    }

    /**
     * <p>
     * The ID of the Job that created the Recovery Instance.
     * </p>
     * 
     * @return The ID of the Job that created the Recovery Instance.
     */
    public final String jobID() {
        return jobID;
    }

    /**
     * <p>
     * AWS availability zone associated with the recovery instance.
     * </p>
     * 
     * @return AWS availability zone associated with the recovery instance.
     */
    public final String originAvailabilityZone() {
        return originAvailabilityZone;
    }

    /**
     * <p>
     * Environment (On Premises / AWS) of the instance that the recovery instance originated from.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #originEnvironment}
     * will return {@link OriginEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #originEnvironmentAsString}.
     * </p>
     * 
     * @return Environment (On Premises / AWS) of the instance that the recovery instance originated from.
     * @see OriginEnvironment
     */
    public final OriginEnvironment originEnvironment() {
        return OriginEnvironment.fromValue(originEnvironment);
    }

    /**
     * <p>
     * Environment (On Premises / AWS) of the instance that the recovery instance originated from.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #originEnvironment}
     * will return {@link OriginEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #originEnvironmentAsString}.
     * </p>
     * 
     * @return Environment (On Premises / AWS) of the instance that the recovery instance originated from.
     * @see OriginEnvironment
     */
    public final String originEnvironmentAsString() {
        return originEnvironment;
    }

    /**
     * <p>
     * The date and time of the Point in Time (PIT) snapshot that this Recovery Instance was launched from.
     * </p>
     * 
     * @return The date and time of the Point in Time (PIT) snapshot that this Recovery Instance was launched from.
     */
    public final String pointInTimeSnapshotDateTime() {
        return pointInTimeSnapshotDateTime;
    }

    /**
     * <p>
     * The ID of the Recovery Instance.
     * </p>
     * 
     * @return The ID of the Recovery Instance.
     */
    public final String recoveryInstanceID() {
        return recoveryInstanceID;
    }

    /**
     * <p>
     * Properties of the Recovery Instance machine.
     * </p>
     * 
     * @return Properties of the Recovery Instance machine.
     */
    public final RecoveryInstanceProperties recoveryInstanceProperties() {
        return recoveryInstanceProperties;
    }

    /**
     * <p>
     * The ARN of the source Outpost
     * </p>
     * 
     * @return The ARN of the source Outpost
     */
    public final String sourceOutpostArn() {
        return sourceOutpostArn;
    }

    /**
     * <p>
     * The Source Server ID that this Recovery Instance is associated with.
     * </p>
     * 
     * @return The Source Server ID that this Recovery Instance is associated with.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An array of tags that are associated with the Recovery Instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of tags that are associated with the Recovery Instance.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failback());
        hashCode = 31 * hashCode + Objects.hashCode(isDrill());
        hashCode = 31 * hashCode + Objects.hashCode(jobID());
        hashCode = 31 * hashCode + Objects.hashCode(originAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(originEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pointInTimeSnapshotDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryInstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryInstanceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sourceOutpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryInstance)) {
            return false;
        }
        RecoveryInstance other = (RecoveryInstance) obj;
        return Objects.equals(agentVersion(), other.agentVersion()) && Objects.equals(arn(), other.arn())
                && Objects.equals(dataReplicationInfo(), other.dataReplicationInfo())
                && Objects.equals(ec2InstanceID(), other.ec2InstanceID())
                && Objects.equals(ec2InstanceStateAsString(), other.ec2InstanceStateAsString())
                && Objects.equals(failback(), other.failback()) && Objects.equals(isDrill(), other.isDrill())
                && Objects.equals(jobID(), other.jobID())
                && Objects.equals(originAvailabilityZone(), other.originAvailabilityZone())
                && Objects.equals(originEnvironmentAsString(), other.originEnvironmentAsString())
                && Objects.equals(pointInTimeSnapshotDateTime(), other.pointInTimeSnapshotDateTime())
                && Objects.equals(recoveryInstanceID(), other.recoveryInstanceID())
                && Objects.equals(recoveryInstanceProperties(), other.recoveryInstanceProperties())
                && Objects.equals(sourceOutpostArn(), other.sourceOutpostArn())
                && Objects.equals(sourceServerID(), other.sourceServerID()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryInstance").add("AgentVersion", agentVersion()).add("Arn", arn())
                .add("DataReplicationInfo", dataReplicationInfo()).add("Ec2InstanceID", ec2InstanceID())
                .add("Ec2InstanceState", ec2InstanceStateAsString()).add("Failback", failback()).add("IsDrill", isDrill())
                .add("JobID", jobID()).add("OriginAvailabilityZone", originAvailabilityZone())
                .add("OriginEnvironment", originEnvironmentAsString())
                .add("PointInTimeSnapshotDateTime", pointInTimeSnapshotDateTime())
                .add("RecoveryInstanceID", recoveryInstanceID()).add("RecoveryInstanceProperties", recoveryInstanceProperties())
                .add("SourceOutpostArn", sourceOutpostArn()).add("SourceServerID", sourceServerID())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "dataReplicationInfo":
            return Optional.ofNullable(clazz.cast(dataReplicationInfo()));
        case "ec2InstanceID":
            return Optional.ofNullable(clazz.cast(ec2InstanceID()));
        case "ec2InstanceState":
            return Optional.ofNullable(clazz.cast(ec2InstanceStateAsString()));
        case "failback":
            return Optional.ofNullable(clazz.cast(failback()));
        case "isDrill":
            return Optional.ofNullable(clazz.cast(isDrill()));
        case "jobID":
            return Optional.ofNullable(clazz.cast(jobID()));
        case "originAvailabilityZone":
            return Optional.ofNullable(clazz.cast(originAvailabilityZone()));
        case "originEnvironment":
            return Optional.ofNullable(clazz.cast(originEnvironmentAsString()));
        case "pointInTimeSnapshotDateTime":
            return Optional.ofNullable(clazz.cast(pointInTimeSnapshotDateTime()));
        case "recoveryInstanceID":
            return Optional.ofNullable(clazz.cast(recoveryInstanceID()));
        case "recoveryInstanceProperties":
            return Optional.ofNullable(clazz.cast(recoveryInstanceProperties()));
        case "sourceOutpostArn":
            return Optional.ofNullable(clazz.cast(sourceOutpostArn()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryInstance, T> g) {
        return obj -> g.apply((RecoveryInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryInstance> {
        /**
         * <p>
         * The version of the DRS agent installed on the recovery instance
         * </p>
         * 
         * @param agentVersion
         *        The version of the DRS agent installed on the recovery instance
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The ARN of the Recovery Instance.
         * </p>
         * 
         * @param arn
         *        The ARN of the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Data Replication Info of the Recovery Instance.
         * </p>
         * 
         * @param dataReplicationInfo
         *        The Data Replication Info of the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationInfo(RecoveryInstanceDataReplicationInfo dataReplicationInfo);

        /**
         * <p>
         * The Data Replication Info of the Recovery Instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RecoveryInstanceDataReplicationInfo.Builder} avoiding the need to create one manually via
         * {@link RecoveryInstanceDataReplicationInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecoveryInstanceDataReplicationInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #dataReplicationInfo(RecoveryInstanceDataReplicationInfo)}.
         * 
         * @param dataReplicationInfo
         *        a consumer that will call methods on {@link RecoveryInstanceDataReplicationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationInfo(RecoveryInstanceDataReplicationInfo)
         */
        default Builder dataReplicationInfo(Consumer<RecoveryInstanceDataReplicationInfo.Builder> dataReplicationInfo) {
            return dataReplicationInfo(RecoveryInstanceDataReplicationInfo.builder().applyMutation(dataReplicationInfo).build());
        }

        /**
         * <p>
         * The EC2 instance ID of the Recovery Instance.
         * </p>
         * 
         * @param ec2InstanceID
         *        The EC2 instance ID of the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceID(String ec2InstanceID);

        /**
         * <p>
         * The state of the EC2 instance for this Recovery Instance.
         * </p>
         * 
         * @param ec2InstanceState
         *        The state of the EC2 instance for this Recovery Instance.
         * @see EC2InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceState
         */
        Builder ec2InstanceState(String ec2InstanceState);

        /**
         * <p>
         * The state of the EC2 instance for this Recovery Instance.
         * </p>
         * 
         * @param ec2InstanceState
         *        The state of the EC2 instance for this Recovery Instance.
         * @see EC2InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceState
         */
        Builder ec2InstanceState(EC2InstanceState ec2InstanceState);

        /**
         * <p>
         * An object representing failback related information of the Recovery Instance.
         * </p>
         * 
         * @param failback
         *        An object representing failback related information of the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failback(RecoveryInstanceFailback failback);

        /**
         * <p>
         * An object representing failback related information of the Recovery Instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecoveryInstanceFailback.Builder}
         * avoiding the need to create one manually via {@link RecoveryInstanceFailback#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecoveryInstanceFailback.Builder#build()} is called immediately
         * and its result is passed to {@link #failback(RecoveryInstanceFailback)}.
         * 
         * @param failback
         *        a consumer that will call methods on {@link RecoveryInstanceFailback.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failback(RecoveryInstanceFailback)
         */
        default Builder failback(Consumer<RecoveryInstanceFailback.Builder> failback) {
            return failback(RecoveryInstanceFailback.builder().applyMutation(failback).build());
        }

        /**
         * <p>
         * Whether this Recovery Instance was created for a drill or for an actual Recovery event.
         * </p>
         * 
         * @param isDrill
         *        Whether this Recovery Instance was created for a drill or for an actual Recovery event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDrill(Boolean isDrill);

        /**
         * <p>
         * The ID of the Job that created the Recovery Instance.
         * </p>
         * 
         * @param jobID
         *        The ID of the Job that created the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobID(String jobID);

        /**
         * <p>
         * AWS availability zone associated with the recovery instance.
         * </p>
         * 
         * @param originAvailabilityZone
         *        AWS availability zone associated with the recovery instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originAvailabilityZone(String originAvailabilityZone);

        /**
         * <p>
         * Environment (On Premises / AWS) of the instance that the recovery instance originated from.
         * </p>
         * 
         * @param originEnvironment
         *        Environment (On Premises / AWS) of the instance that the recovery instance originated from.
         * @see OriginEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginEnvironment
         */
        Builder originEnvironment(String originEnvironment);

        /**
         * <p>
         * Environment (On Premises / AWS) of the instance that the recovery instance originated from.
         * </p>
         * 
         * @param originEnvironment
         *        Environment (On Premises / AWS) of the instance that the recovery instance originated from.
         * @see OriginEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginEnvironment
         */
        Builder originEnvironment(OriginEnvironment originEnvironment);

        /**
         * <p>
         * The date and time of the Point in Time (PIT) snapshot that this Recovery Instance was launched from.
         * </p>
         * 
         * @param pointInTimeSnapshotDateTime
         *        The date and time of the Point in Time (PIT) snapshot that this Recovery Instance was launched from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointInTimeSnapshotDateTime(String pointInTimeSnapshotDateTime);

        /**
         * <p>
         * The ID of the Recovery Instance.
         * </p>
         * 
         * @param recoveryInstanceID
         *        The ID of the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryInstanceID(String recoveryInstanceID);

        /**
         * <p>
         * Properties of the Recovery Instance machine.
         * </p>
         * 
         * @param recoveryInstanceProperties
         *        Properties of the Recovery Instance machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryInstanceProperties(RecoveryInstanceProperties recoveryInstanceProperties);

        /**
         * <p>
         * Properties of the Recovery Instance machine.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecoveryInstanceProperties.Builder}
         * avoiding the need to create one manually via {@link RecoveryInstanceProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecoveryInstanceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #recoveryInstanceProperties(RecoveryInstanceProperties)}.
         * 
         * @param recoveryInstanceProperties
         *        a consumer that will call methods on {@link RecoveryInstanceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recoveryInstanceProperties(RecoveryInstanceProperties)
         */
        default Builder recoveryInstanceProperties(Consumer<RecoveryInstanceProperties.Builder> recoveryInstanceProperties) {
            return recoveryInstanceProperties(RecoveryInstanceProperties.builder().applyMutation(recoveryInstanceProperties)
                    .build());
        }

        /**
         * <p>
         * The ARN of the source Outpost
         * </p>
         * 
         * @param sourceOutpostArn
         *        The ARN of the source Outpost
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceOutpostArn(String sourceOutpostArn);

        /**
         * <p>
         * The Source Server ID that this Recovery Instance is associated with.
         * </p>
         * 
         * @param sourceServerID
         *        The Source Server ID that this Recovery Instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        /**
         * <p>
         * An array of tags that are associated with the Recovery Instance.
         * </p>
         * 
         * @param tags
         *        An array of tags that are associated with the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String agentVersion;

        private String arn;

        private RecoveryInstanceDataReplicationInfo dataReplicationInfo;

        private String ec2InstanceID;

        private String ec2InstanceState;

        private RecoveryInstanceFailback failback;

        private Boolean isDrill;

        private String jobID;

        private String originAvailabilityZone;

        private String originEnvironment;

        private String pointInTimeSnapshotDateTime;

        private String recoveryInstanceID;

        private RecoveryInstanceProperties recoveryInstanceProperties;

        private String sourceOutpostArn;

        private String sourceServerID;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryInstance model) {
            agentVersion(model.agentVersion);
            arn(model.arn);
            dataReplicationInfo(model.dataReplicationInfo);
            ec2InstanceID(model.ec2InstanceID);
            ec2InstanceState(model.ec2InstanceState);
            failback(model.failback);
            isDrill(model.isDrill);
            jobID(model.jobID);
            originAvailabilityZone(model.originAvailabilityZone);
            originEnvironment(model.originEnvironment);
            pointInTimeSnapshotDateTime(model.pointInTimeSnapshotDateTime);
            recoveryInstanceID(model.recoveryInstanceID);
            recoveryInstanceProperties(model.recoveryInstanceProperties);
            sourceOutpostArn(model.sourceOutpostArn);
            sourceServerID(model.sourceServerID);
            tags(model.tags);
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final RecoveryInstanceDataReplicationInfo.Builder getDataReplicationInfo() {
            return dataReplicationInfo != null ? dataReplicationInfo.toBuilder() : null;
        }

        public final void setDataReplicationInfo(RecoveryInstanceDataReplicationInfo.BuilderImpl dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo != null ? dataReplicationInfo.build() : null;
        }

        @Override
        public final Builder dataReplicationInfo(RecoveryInstanceDataReplicationInfo dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo;
            return this;
        }

        public final String getEc2InstanceID() {
            return ec2InstanceID;
        }

        public final void setEc2InstanceID(String ec2InstanceID) {
            this.ec2InstanceID = ec2InstanceID;
        }

        @Override
        public final Builder ec2InstanceID(String ec2InstanceID) {
            this.ec2InstanceID = ec2InstanceID;
            return this;
        }

        public final String getEc2InstanceState() {
            return ec2InstanceState;
        }

        public final void setEc2InstanceState(String ec2InstanceState) {
            this.ec2InstanceState = ec2InstanceState;
        }

        @Override
        public final Builder ec2InstanceState(String ec2InstanceState) {
            this.ec2InstanceState = ec2InstanceState;
            return this;
        }

        @Override
        public final Builder ec2InstanceState(EC2InstanceState ec2InstanceState) {
            this.ec2InstanceState(ec2InstanceState == null ? null : ec2InstanceState.toString());
            return this;
        }

        public final RecoveryInstanceFailback.Builder getFailback() {
            return failback != null ? failback.toBuilder() : null;
        }

        public final void setFailback(RecoveryInstanceFailback.BuilderImpl failback) {
            this.failback = failback != null ? failback.build() : null;
        }

        @Override
        public final Builder failback(RecoveryInstanceFailback failback) {
            this.failback = failback;
            return this;
        }

        public final Boolean getIsDrill() {
            return isDrill;
        }

        public final void setIsDrill(Boolean isDrill) {
            this.isDrill = isDrill;
        }

        @Override
        public final Builder isDrill(Boolean isDrill) {
            this.isDrill = isDrill;
            return this;
        }

        public final String getJobID() {
            return jobID;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @Override
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        public final String getOriginAvailabilityZone() {
            return originAvailabilityZone;
        }

        public final void setOriginAvailabilityZone(String originAvailabilityZone) {
            this.originAvailabilityZone = originAvailabilityZone;
        }

        @Override
        public final Builder originAvailabilityZone(String originAvailabilityZone) {
            this.originAvailabilityZone = originAvailabilityZone;
            return this;
        }

        public final String getOriginEnvironment() {
            return originEnvironment;
        }

        public final void setOriginEnvironment(String originEnvironment) {
            this.originEnvironment = originEnvironment;
        }

        @Override
        public final Builder originEnvironment(String originEnvironment) {
            this.originEnvironment = originEnvironment;
            return this;
        }

        @Override
        public final Builder originEnvironment(OriginEnvironment originEnvironment) {
            this.originEnvironment(originEnvironment == null ? null : originEnvironment.toString());
            return this;
        }

        public final String getPointInTimeSnapshotDateTime() {
            return pointInTimeSnapshotDateTime;
        }

        public final void setPointInTimeSnapshotDateTime(String pointInTimeSnapshotDateTime) {
            this.pointInTimeSnapshotDateTime = pointInTimeSnapshotDateTime;
        }

        @Override
        public final Builder pointInTimeSnapshotDateTime(String pointInTimeSnapshotDateTime) {
            this.pointInTimeSnapshotDateTime = pointInTimeSnapshotDateTime;
            return this;
        }

        public final String getRecoveryInstanceID() {
            return recoveryInstanceID;
        }

        public final void setRecoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
        }

        @Override
        public final Builder recoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
            return this;
        }

        public final RecoveryInstanceProperties.Builder getRecoveryInstanceProperties() {
            return recoveryInstanceProperties != null ? recoveryInstanceProperties.toBuilder() : null;
        }

        public final void setRecoveryInstanceProperties(RecoveryInstanceProperties.BuilderImpl recoveryInstanceProperties) {
            this.recoveryInstanceProperties = recoveryInstanceProperties != null ? recoveryInstanceProperties.build() : null;
        }

        @Override
        public final Builder recoveryInstanceProperties(RecoveryInstanceProperties recoveryInstanceProperties) {
            this.recoveryInstanceProperties = recoveryInstanceProperties;
            return this;
        }

        public final String getSourceOutpostArn() {
            return sourceOutpostArn;
        }

        public final void setSourceOutpostArn(String sourceOutpostArn) {
            this.sourceOutpostArn = sourceOutpostArn;
        }

        @Override
        public final Builder sourceOutpostArn(String sourceOutpostArn) {
            this.sourceOutpostArn = sourceOutpostArn;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public RecoveryInstance build() {
            return new RecoveryInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
