/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A disk that should be replicated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataReplicationInfoReplicatedDisk implements SdkPojo, Serializable,
        ToCopyableBuilder<DataReplicationInfoReplicatedDisk.Builder, DataReplicationInfoReplicatedDisk> {
    private static final SdkField<Long> BACKLOGGED_STORAGE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("backloggedStorageBytes").getter(getter(DataReplicationInfoReplicatedDisk::backloggedStorageBytes))
            .setter(setter(Builder::backloggedStorageBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backloggedStorageBytes").build())
            .build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceName").getter(getter(DataReplicationInfoReplicatedDisk::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()).build();

    private static final SdkField<Long> REPLICATED_STORAGE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("replicatedStorageBytes").getter(getter(DataReplicationInfoReplicatedDisk::replicatedStorageBytes))
            .setter(setter(Builder::replicatedStorageBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatedStorageBytes").build())
            .build();

    private static final SdkField<Long> RESCANNED_STORAGE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("rescannedStorageBytes").getter(getter(DataReplicationInfoReplicatedDisk::rescannedStorageBytes))
            .setter(setter(Builder::rescannedStorageBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rescannedStorageBytes").build())
            .build();

    private static final SdkField<Long> TOTAL_STORAGE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalStorageBytes").getter(getter(DataReplicationInfoReplicatedDisk::totalStorageBytes))
            .setter(setter(Builder::totalStorageBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalStorageBytes").build()).build();

    private static final SdkField<String> VOLUME_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeStatus").getter(getter(DataReplicationInfoReplicatedDisk::volumeStatusAsString))
            .setter(setter(Builder::volumeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BACKLOGGED_STORAGE_BYTES_FIELD, DEVICE_NAME_FIELD, REPLICATED_STORAGE_BYTES_FIELD, RESCANNED_STORAGE_BYTES_FIELD,
            TOTAL_STORAGE_BYTES_FIELD, VOLUME_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long backloggedStorageBytes;

    private final String deviceName;

    private final Long replicatedStorageBytes;

    private final Long rescannedStorageBytes;

    private final Long totalStorageBytes;

    private final String volumeStatus;

    private DataReplicationInfoReplicatedDisk(BuilderImpl builder) {
        this.backloggedStorageBytes = builder.backloggedStorageBytes;
        this.deviceName = builder.deviceName;
        this.replicatedStorageBytes = builder.replicatedStorageBytes;
        this.rescannedStorageBytes = builder.rescannedStorageBytes;
        this.totalStorageBytes = builder.totalStorageBytes;
        this.volumeStatus = builder.volumeStatus;
    }

    /**
     * <p>
     * The size of the replication backlog in bytes.
     * </p>
     * 
     * @return The size of the replication backlog in bytes.
     */
    public final Long backloggedStorageBytes() {
        return backloggedStorageBytes;
    }

    /**
     * <p>
     * The name of the device.
     * </p>
     * 
     * @return The name of the device.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The amount of data replicated so far in bytes.
     * </p>
     * 
     * @return The amount of data replicated so far in bytes.
     */
    public final Long replicatedStorageBytes() {
        return replicatedStorageBytes;
    }

    /**
     * <p>
     * The amount of data to be rescanned in bytes.
     * </p>
     * 
     * @return The amount of data to be rescanned in bytes.
     */
    public final Long rescannedStorageBytes() {
        return rescannedStorageBytes;
    }

    /**
     * <p>
     * The total amount of data to be replicated in bytes.
     * </p>
     * 
     * @return The total amount of data to be replicated in bytes.
     */
    public final Long totalStorageBytes() {
        return totalStorageBytes;
    }

    /**
     * <p>
     * The status of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeStatus} will
     * return {@link VolumeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeStatusAsString}.
     * </p>
     * 
     * @return The status of the volume.
     * @see VolumeStatus
     */
    public final VolumeStatus volumeStatus() {
        return VolumeStatus.fromValue(volumeStatus);
    }

    /**
     * <p>
     * The status of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeStatus} will
     * return {@link VolumeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeStatusAsString}.
     * </p>
     * 
     * @return The status of the volume.
     * @see VolumeStatus
     */
    public final String volumeStatusAsString() {
        return volumeStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backloggedStorageBytes());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(replicatedStorageBytes());
        hashCode = 31 * hashCode + Objects.hashCode(rescannedStorageBytes());
        hashCode = 31 * hashCode + Objects.hashCode(totalStorageBytes());
        hashCode = 31 * hashCode + Objects.hashCode(volumeStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataReplicationInfoReplicatedDisk)) {
            return false;
        }
        DataReplicationInfoReplicatedDisk other = (DataReplicationInfoReplicatedDisk) obj;
        return Objects.equals(backloggedStorageBytes(), other.backloggedStorageBytes())
                && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(replicatedStorageBytes(), other.replicatedStorageBytes())
                && Objects.equals(rescannedStorageBytes(), other.rescannedStorageBytes())
                && Objects.equals(totalStorageBytes(), other.totalStorageBytes())
                && Objects.equals(volumeStatusAsString(), other.volumeStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataReplicationInfoReplicatedDisk").add("BackloggedStorageBytes", backloggedStorageBytes())
                .add("DeviceName", deviceName()).add("ReplicatedStorageBytes", replicatedStorageBytes())
                .add("RescannedStorageBytes", rescannedStorageBytes()).add("TotalStorageBytes", totalStorageBytes())
                .add("VolumeStatus", volumeStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "backloggedStorageBytes":
            return Optional.ofNullable(clazz.cast(backloggedStorageBytes()));
        case "deviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "replicatedStorageBytes":
            return Optional.ofNullable(clazz.cast(replicatedStorageBytes()));
        case "rescannedStorageBytes":
            return Optional.ofNullable(clazz.cast(rescannedStorageBytes()));
        case "totalStorageBytes":
            return Optional.ofNullable(clazz.cast(totalStorageBytes()));
        case "volumeStatus":
            return Optional.ofNullable(clazz.cast(volumeStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataReplicationInfoReplicatedDisk, T> g) {
        return obj -> g.apply((DataReplicationInfoReplicatedDisk) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataReplicationInfoReplicatedDisk> {
        /**
         * <p>
         * The size of the replication backlog in bytes.
         * </p>
         * 
         * @param backloggedStorageBytes
         *        The size of the replication backlog in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backloggedStorageBytes(Long backloggedStorageBytes);

        /**
         * <p>
         * The name of the device.
         * </p>
         * 
         * @param deviceName
         *        The name of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The amount of data replicated so far in bytes.
         * </p>
         * 
         * @param replicatedStorageBytes
         *        The amount of data replicated so far in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatedStorageBytes(Long replicatedStorageBytes);

        /**
         * <p>
         * The amount of data to be rescanned in bytes.
         * </p>
         * 
         * @param rescannedStorageBytes
         *        The amount of data to be rescanned in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rescannedStorageBytes(Long rescannedStorageBytes);

        /**
         * <p>
         * The total amount of data to be replicated in bytes.
         * </p>
         * 
         * @param totalStorageBytes
         *        The total amount of data to be replicated in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalStorageBytes(Long totalStorageBytes);

        /**
         * <p>
         * The status of the volume.
         * </p>
         * 
         * @param volumeStatus
         *        The status of the volume.
         * @see VolumeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatus
         */
        Builder volumeStatus(String volumeStatus);

        /**
         * <p>
         * The status of the volume.
         * </p>
         * 
         * @param volumeStatus
         *        The status of the volume.
         * @see VolumeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatus
         */
        Builder volumeStatus(VolumeStatus volumeStatus);
    }

    static final class BuilderImpl implements Builder {
        private Long backloggedStorageBytes;

        private String deviceName;

        private Long replicatedStorageBytes;

        private Long rescannedStorageBytes;

        private Long totalStorageBytes;

        private String volumeStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DataReplicationInfoReplicatedDisk model) {
            backloggedStorageBytes(model.backloggedStorageBytes);
            deviceName(model.deviceName);
            replicatedStorageBytes(model.replicatedStorageBytes);
            rescannedStorageBytes(model.rescannedStorageBytes);
            totalStorageBytes(model.totalStorageBytes);
            volumeStatus(model.volumeStatus);
        }

        public final Long getBackloggedStorageBytes() {
            return backloggedStorageBytes;
        }

        public final void setBackloggedStorageBytes(Long backloggedStorageBytes) {
            this.backloggedStorageBytes = backloggedStorageBytes;
        }

        @Override
        public final Builder backloggedStorageBytes(Long backloggedStorageBytes) {
            this.backloggedStorageBytes = backloggedStorageBytes;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final Long getReplicatedStorageBytes() {
            return replicatedStorageBytes;
        }

        public final void setReplicatedStorageBytes(Long replicatedStorageBytes) {
            this.replicatedStorageBytes = replicatedStorageBytes;
        }

        @Override
        public final Builder replicatedStorageBytes(Long replicatedStorageBytes) {
            this.replicatedStorageBytes = replicatedStorageBytes;
            return this;
        }

        public final Long getRescannedStorageBytes() {
            return rescannedStorageBytes;
        }

        public final void setRescannedStorageBytes(Long rescannedStorageBytes) {
            this.rescannedStorageBytes = rescannedStorageBytes;
        }

        @Override
        public final Builder rescannedStorageBytes(Long rescannedStorageBytes) {
            this.rescannedStorageBytes = rescannedStorageBytes;
            return this;
        }

        public final Long getTotalStorageBytes() {
            return totalStorageBytes;
        }

        public final void setTotalStorageBytes(Long totalStorageBytes) {
            this.totalStorageBytes = totalStorageBytes;
        }

        @Override
        public final Builder totalStorageBytes(Long totalStorageBytes) {
            this.totalStorageBytes = totalStorageBytes;
            return this;
        }

        public final String getVolumeStatus() {
            return volumeStatus;
        }

        public final void setVolumeStatus(String volumeStatus) {
            this.volumeStatus = volumeStatus;
        }

        @Override
        public final Builder volumeStatus(String volumeStatus) {
            this.volumeStatus = volumeStatus;
            return this;
        }

        @Override
        public final Builder volumeStatus(VolumeStatus volumeStatus) {
            this.volumeStatus(volumeStatus == null ? null : volumeStatus.toString());
            return this;
        }

        @Override
        public DataReplicationInfoReplicatedDisk build() {
            return new DataReplicationInfoReplicatedDisk(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
