/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class VolumeToProductCodesCopier {
    static Map<String, List<ProductCode>> copy(Map<String, ? extends Collection<? extends ProductCode>> volumeToProductCodesParam) {
        Map<String, List<ProductCode>> map;
        if (volumeToProductCodesParam == null || volumeToProductCodesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<ProductCode>> modifiableMap = new LinkedHashMap<>(volumeToProductCodesParam.size());
            volumeToProductCodesParam.forEach((key, value) -> {
                List<ProductCode> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<ProductCode> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<ProductCode>> copyFromBuilder(
            Map<String, ? extends Collection<? extends ProductCode.Builder>> volumeToProductCodesParam) {
        Map<String, List<ProductCode>> map;
        if (volumeToProductCodesParam == null || volumeToProductCodesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<ProductCode>> modifiableMap = new LinkedHashMap<>(volumeToProductCodesParam.size());
            volumeToProductCodesParam.forEach((key, value) -> {
                List<ProductCode> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<ProductCode> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        ProductCode member = entry == null ? null : entry.build();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<ProductCode.Builder>> copyToBuilder(
            Map<String, ? extends Collection<? extends ProductCode>> volumeToProductCodesParam) {
        Map<String, List<ProductCode.Builder>> map;
        if (volumeToProductCodesParam == null || volumeToProductCodesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<ProductCode.Builder>> modifiableMap = new LinkedHashMap<>(volumeToProductCodesParam.size());
            volumeToProductCodesParam.forEach((key, value) -> {
                List<ProductCode.Builder> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<ProductCode.Builder> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        ProductCode.Builder member = entry == null ? null : entry.toBuilder();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
