/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of filters by which to return Recovery Snapshots.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecoverySnapshotsRequestFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeRecoverySnapshotsRequestFilters.Builder, DescribeRecoverySnapshotsRequestFilters> {
    private static final SdkField<String> FROM_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fromDateTime").getter(getter(DescribeRecoverySnapshotsRequestFilters::fromDateTime))
            .setter(setter(Builder::fromDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromDateTime").build()).build();

    private static final SdkField<String> TO_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toDateTime").getter(getter(DescribeRecoverySnapshotsRequestFilters::toDateTime))
            .setter(setter(Builder::toDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_DATE_TIME_FIELD,
            TO_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fromDateTime;

    private final String toDateTime;

    private DescribeRecoverySnapshotsRequestFilters(BuilderImpl builder) {
        this.fromDateTime = builder.fromDateTime;
        this.toDateTime = builder.toDateTime;
    }

    /**
     * <p>
     * The start date in a date range query.
     * </p>
     * 
     * @return The start date in a date range query.
     */
    public final String fromDateTime() {
        return fromDateTime;
    }

    /**
     * <p>
     * The end date in a date range query.
     * </p>
     * 
     * @return The end date in a date range query.
     */
    public final String toDateTime() {
        return toDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(toDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecoverySnapshotsRequestFilters)) {
            return false;
        }
        DescribeRecoverySnapshotsRequestFilters other = (DescribeRecoverySnapshotsRequestFilters) obj;
        return Objects.equals(fromDateTime(), other.fromDateTime()) && Objects.equals(toDateTime(), other.toDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecoverySnapshotsRequestFilters").add("FromDateTime", fromDateTime())
                .add("ToDateTime", toDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fromDateTime":
            return Optional.ofNullable(clazz.cast(fromDateTime()));
        case "toDateTime":
            return Optional.ofNullable(clazz.cast(toDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fromDateTime", FROM_DATE_TIME_FIELD);
        map.put("toDateTime", TO_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecoverySnapshotsRequestFilters, T> g) {
        return obj -> g.apply((DescribeRecoverySnapshotsRequestFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeRecoverySnapshotsRequestFilters> {
        /**
         * <p>
         * The start date in a date range query.
         * </p>
         * 
         * @param fromDateTime
         *        The start date in a date range query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDateTime(String fromDateTime);

        /**
         * <p>
         * The end date in a date range query.
         * </p>
         * 
         * @param toDateTime
         *        The end date in a date range query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toDateTime(String toDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String fromDateTime;

        private String toDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecoverySnapshotsRequestFilters model) {
            fromDateTime(model.fromDateTime);
            toDateTime(model.toDateTime);
        }

        public final String getFromDateTime() {
            return fromDateTime;
        }

        public final void setFromDateTime(String fromDateTime) {
            this.fromDateTime = fromDateTime;
        }

        @Override
        public final Builder fromDateTime(String fromDateTime) {
            this.fromDateTime = fromDateTime;
            return this;
        }

        public final String getToDateTime() {
            return toDateTime;
        }

        public final void setToDateTime(String toDateTime) {
            this.toDateTime = toDateTime;
        }

        @Override
        public final Builder toDateTime(String toDateTime) {
            this.toDateTime = toDateTime;
            return this;
        }

        @Override
        public DescribeRecoverySnapshotsRequestFilters build() {
            return new DescribeRecoverySnapshotsRequestFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
