/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportSourceNetworkCfnTemplateResponse extends DrsResponse implements
        ToCopyableBuilder<ExportSourceNetworkCfnTemplateResponse.Builder, ExportSourceNetworkCfnTemplateResponse> {
    private static final SdkField<String> S3_DESTINATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3DestinationUrl").getter(getter(ExportSourceNetworkCfnTemplateResponse::s3DestinationUrl))
            .setter(setter(Builder::s3DestinationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DestinationUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DESTINATION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String s3DestinationUrl;

    private ExportSourceNetworkCfnTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.s3DestinationUrl = builder.s3DestinationUrl;
    }

    /**
     * <p>
     * S3 bucket URL where the Source Network CloudFormation template was exported to.
     * </p>
     * 
     * @return S3 bucket URL where the Source Network CloudFormation template was exported to.
     */
    public final String s3DestinationUrl() {
        return s3DestinationUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSourceNetworkCfnTemplateResponse)) {
            return false;
        }
        ExportSourceNetworkCfnTemplateResponse other = (ExportSourceNetworkCfnTemplateResponse) obj;
        return Objects.equals(s3DestinationUrl(), other.s3DestinationUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportSourceNetworkCfnTemplateResponse").add("S3DestinationUrl", s3DestinationUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3DestinationUrl":
            return Optional.ofNullable(clazz.cast(s3DestinationUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3DestinationUrl", S3_DESTINATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportSourceNetworkCfnTemplateResponse, T> g) {
        return obj -> g.apply((ExportSourceNetworkCfnTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportSourceNetworkCfnTemplateResponse> {
        /**
         * <p>
         * S3 bucket URL where the Source Network CloudFormation template was exported to.
         * </p>
         * 
         * @param s3DestinationUrl
         *        S3 bucket URL where the Source Network CloudFormation template was exported to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationUrl(String s3DestinationUrl);
    }

    static final class BuilderImpl extends DrsResponse.BuilderImpl implements Builder {
        private String s3DestinationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSourceNetworkCfnTemplateResponse model) {
            super(model);
            s3DestinationUrl(model.s3DestinationUrl);
        }

        public final String getS3DestinationUrl() {
            return s3DestinationUrl;
        }

        public final void setS3DestinationUrl(String s3DestinationUrl) {
            this.s3DestinationUrl = s3DestinationUrl;
        }

        @Override
        public final Builder s3DestinationUrl(String s3DestinationUrl) {
            this.s3DestinationUrl = s3DestinationUrl;
            return this;
        }

        @Override
        public ExportSourceNetworkCfnTemplateResponse build() {
            return new ExportSourceNetworkCfnTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
