/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Hints used to uniquely identify a machine.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentificationHints implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentificationHints.Builder, IdentificationHints> {
    private static final SdkField<String> AWS_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsInstanceID").getter(getter(IdentificationHints::awsInstanceID))
            .setter(setter(Builder::awsInstanceID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsInstanceID").build()).build();

    private static final SdkField<String> FQDN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fqdn")
            .getter(getter(IdentificationHints::fqdn)).setter(setter(Builder::fqdn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fqdn").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostname").getter(getter(IdentificationHints::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<String> VM_WARE_UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vmWareUuid").getter(getter(IdentificationHints::vmWareUuid)).setter(setter(Builder::vmWareUuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmWareUuid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_INSTANCE_ID_FIELD,
            FQDN_FIELD, HOSTNAME_FIELD, VM_WARE_UUID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsInstanceID;

    private final String fqdn;

    private final String hostname;

    private final String vmWareUuid;

    private IdentificationHints(BuilderImpl builder) {
        this.awsInstanceID = builder.awsInstanceID;
        this.fqdn = builder.fqdn;
        this.hostname = builder.hostname;
        this.vmWareUuid = builder.vmWareUuid;
    }

    /**
     * <p>
     * AWS Instance ID identification hint.
     * </p>
     * 
     * @return AWS Instance ID identification hint.
     */
    public final String awsInstanceID() {
        return awsInstanceID;
    }

    /**
     * <p>
     * Fully Qualified Domain Name identification hint.
     * </p>
     * 
     * @return Fully Qualified Domain Name identification hint.
     */
    public final String fqdn() {
        return fqdn;
    }

    /**
     * <p>
     * Hostname identification hint.
     * </p>
     * 
     * @return Hostname identification hint.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * vCenter VM path identification hint.
     * </p>
     * 
     * @return vCenter VM path identification hint.
     */
    public final String vmWareUuid() {
        return vmWareUuid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsInstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(fqdn());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(vmWareUuid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentificationHints)) {
            return false;
        }
        IdentificationHints other = (IdentificationHints) obj;
        return Objects.equals(awsInstanceID(), other.awsInstanceID()) && Objects.equals(fqdn(), other.fqdn())
                && Objects.equals(hostname(), other.hostname()) && Objects.equals(vmWareUuid(), other.vmWareUuid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentificationHints").add("AwsInstanceID", awsInstanceID()).add("Fqdn", fqdn())
                .add("Hostname", hostname()).add("VmWareUuid", vmWareUuid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsInstanceID":
            return Optional.ofNullable(clazz.cast(awsInstanceID()));
        case "fqdn":
            return Optional.ofNullable(clazz.cast(fqdn()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "vmWareUuid":
            return Optional.ofNullable(clazz.cast(vmWareUuid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsInstanceID", AWS_INSTANCE_ID_FIELD);
        map.put("fqdn", FQDN_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("vmWareUuid", VM_WARE_UUID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentificationHints, T> g) {
        return obj -> g.apply((IdentificationHints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentificationHints> {
        /**
         * <p>
         * AWS Instance ID identification hint.
         * </p>
         * 
         * @param awsInstanceID
         *        AWS Instance ID identification hint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsInstanceID(String awsInstanceID);

        /**
         * <p>
         * Fully Qualified Domain Name identification hint.
         * </p>
         * 
         * @param fqdn
         *        Fully Qualified Domain Name identification hint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fqdn(String fqdn);

        /**
         * <p>
         * Hostname identification hint.
         * </p>
         * 
         * @param hostname
         *        Hostname identification hint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * vCenter VM path identification hint.
         * </p>
         * 
         * @param vmWareUuid
         *        vCenter VM path identification hint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmWareUuid(String vmWareUuid);
    }

    static final class BuilderImpl implements Builder {
        private String awsInstanceID;

        private String fqdn;

        private String hostname;

        private String vmWareUuid;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentificationHints model) {
            awsInstanceID(model.awsInstanceID);
            fqdn(model.fqdn);
            hostname(model.hostname);
            vmWareUuid(model.vmWareUuid);
        }

        public final String getAwsInstanceID() {
            return awsInstanceID;
        }

        public final void setAwsInstanceID(String awsInstanceID) {
            this.awsInstanceID = awsInstanceID;
        }

        @Override
        public final Builder awsInstanceID(String awsInstanceID) {
            this.awsInstanceID = awsInstanceID;
            return this;
        }

        public final String getFqdn() {
            return fqdn;
        }

        public final void setFqdn(String fqdn) {
            this.fqdn = fqdn;
        }

        @Override
        public final Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getVmWareUuid() {
            return vmWareUuid;
        }

        public final void setVmWareUuid(String vmWareUuid) {
            this.vmWareUuid = vmWareUuid;
        }

        @Override
        public final Builder vmWareUuid(String vmWareUuid) {
            this.vmWareUuid = vmWareUuid;
            return this;
        }

        @Override
        public IdentificationHints build() {
            return new IdentificationHints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
