/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Launch actions status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchActionsStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchActionsStatus.Builder, LaunchActionsStatus> {
    private static final SdkField<List<LaunchActionRun>> RUNS_FIELD = SdkField
            .<List<LaunchActionRun>> builder(MarshallingType.LIST)
            .memberName("runs")
            .getter(getter(LaunchActionsStatus::runs))
            .setter(setter(Builder::runs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LaunchActionRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchActionRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SSM_AGENT_DISCOVERY_DATETIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ssmAgentDiscoveryDatetime").getter(getter(LaunchActionsStatus::ssmAgentDiscoveryDatetime))
            .setter(setter(Builder::ssmAgentDiscoveryDatetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmAgentDiscoveryDatetime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNS_FIELD,
            SSM_AGENT_DISCOVERY_DATETIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<LaunchActionRun> runs;

    private final String ssmAgentDiscoveryDatetime;

    private LaunchActionsStatus(BuilderImpl builder) {
        this.runs = builder.runs;
        this.ssmAgentDiscoveryDatetime = builder.ssmAgentDiscoveryDatetime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Runs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRuns() {
        return runs != null && !(runs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of post launch action status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuns} method.
     * </p>
     * 
     * @return List of post launch action status.
     */
    public final List<LaunchActionRun> runs() {
        return runs;
    }

    /**
     * <p>
     * Time where the AWS Systems Manager was detected as running on the launched instance.
     * </p>
     * 
     * @return Time where the AWS Systems Manager was detected as running on the launched instance.
     */
    public final String ssmAgentDiscoveryDatetime() {
        return ssmAgentDiscoveryDatetime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRuns() ? runs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ssmAgentDiscoveryDatetime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchActionsStatus)) {
            return false;
        }
        LaunchActionsStatus other = (LaunchActionsStatus) obj;
        return hasRuns() == other.hasRuns() && Objects.equals(runs(), other.runs())
                && Objects.equals(ssmAgentDiscoveryDatetime(), other.ssmAgentDiscoveryDatetime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchActionsStatus").add("Runs", hasRuns() ? runs() : null)
                .add("SsmAgentDiscoveryDatetime", ssmAgentDiscoveryDatetime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "runs":
            return Optional.ofNullable(clazz.cast(runs()));
        case "ssmAgentDiscoveryDatetime":
            return Optional.ofNullable(clazz.cast(ssmAgentDiscoveryDatetime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("runs", RUNS_FIELD);
        map.put("ssmAgentDiscoveryDatetime", SSM_AGENT_DISCOVERY_DATETIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchActionsStatus, T> g) {
        return obj -> g.apply((LaunchActionsStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchActionsStatus> {
        /**
         * <p>
         * List of post launch action status.
         * </p>
         * 
         * @param runs
         *        List of post launch action status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runs(Collection<LaunchActionRun> runs);

        /**
         * <p>
         * List of post launch action status.
         * </p>
         * 
         * @param runs
         *        List of post launch action status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runs(LaunchActionRun... runs);

        /**
         * <p>
         * List of post launch action status.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.drs.model.LaunchActionRun.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.drs.model.LaunchActionRun#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.drs.model.LaunchActionRun.Builder#build()} is called immediately and
         * its result is passed to {@link #runs(List<LaunchActionRun>)}.
         * 
         * @param runs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.drs.model.LaunchActionRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runs(java.util.Collection<LaunchActionRun>)
         */
        Builder runs(Consumer<LaunchActionRun.Builder>... runs);

        /**
         * <p>
         * Time where the AWS Systems Manager was detected as running on the launched instance.
         * </p>
         * 
         * @param ssmAgentDiscoveryDatetime
         *        Time where the AWS Systems Manager was detected as running on the launched instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmAgentDiscoveryDatetime(String ssmAgentDiscoveryDatetime);
    }

    static final class BuilderImpl implements Builder {
        private List<LaunchActionRun> runs = DefaultSdkAutoConstructList.getInstance();

        private String ssmAgentDiscoveryDatetime;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchActionsStatus model) {
            runs(model.runs);
            ssmAgentDiscoveryDatetime(model.ssmAgentDiscoveryDatetime);
        }

        public final List<LaunchActionRun.Builder> getRuns() {
            List<LaunchActionRun.Builder> result = LaunchActionRunsCopier.copyToBuilder(this.runs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuns(Collection<LaunchActionRun.BuilderImpl> runs) {
            this.runs = LaunchActionRunsCopier.copyFromBuilder(runs);
        }

        @Override
        public final Builder runs(Collection<LaunchActionRun> runs) {
            this.runs = LaunchActionRunsCopier.copy(runs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(LaunchActionRun... runs) {
            runs(Arrays.asList(runs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(Consumer<LaunchActionRun.Builder>... runs) {
            runs(Stream.of(runs).map(c -> LaunchActionRun.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSsmAgentDiscoveryDatetime() {
            return ssmAgentDiscoveryDatetime;
        }

        public final void setSsmAgentDiscoveryDatetime(String ssmAgentDiscoveryDatetime) {
            this.ssmAgentDiscoveryDatetime = ssmAgentDiscoveryDatetime;
        }

        @Override
        public final Builder ssmAgentDiscoveryDatetime(String ssmAgentDiscoveryDatetime) {
            this.ssmAgentDiscoveryDatetime = ssmAgentDiscoveryDatetime;
            return this;
        }

        @Override
        public LaunchActionsStatus build() {
            return new LaunchActionsStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
