/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule in the Point in Time (PIT) policy representing when to take snapshots and how long to retain them for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PITPolicyRule implements SdkPojo, Serializable, ToCopyableBuilder<PITPolicyRule.Builder, PITPolicyRule> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(PITPolicyRule::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("interval").getter(getter(PITPolicyRule::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interval").build()).build();

    private static final SdkField<Integer> RETENTION_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retentionDuration").getter(getter(PITPolicyRule::retentionDuration))
            .setter(setter(Builder::retentionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionDuration").build()).build();

    private static final SdkField<Long> RULE_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ruleID")
            .getter(getter(PITPolicyRule::ruleID)).setter(setter(Builder::ruleID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleID").build()).build();

    private static final SdkField<String> UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("units")
            .getter(getter(PITPolicyRule::unitsAsString)).setter(setter(Builder::units))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("units").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, INTERVAL_FIELD,
            RETENTION_DURATION_FIELD, RULE_ID_FIELD, UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Integer interval;

    private final Integer retentionDuration;

    private final Long ruleID;

    private final String units;

    private PITPolicyRule(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.interval = builder.interval;
        this.retentionDuration = builder.retentionDuration;
        this.ruleID = builder.ruleID;
        this.units = builder.units;
    }

    /**
     * <p>
     * Whether this rule is enabled or not.
     * </p>
     * 
     * @return Whether this rule is enabled or not.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * How often, in the chosen units, a snapshot should be taken.
     * </p>
     * 
     * @return How often, in the chosen units, a snapshot should be taken.
     */
    public final Integer interval() {
        return interval;
    }

    /**
     * <p>
     * The duration to retain a snapshot for, in the chosen units.
     * </p>
     * 
     * @return The duration to retain a snapshot for, in the chosen units.
     */
    public final Integer retentionDuration() {
        return retentionDuration;
    }

    /**
     * <p>
     * The ID of the rule.
     * </p>
     * 
     * @return The ID of the rule.
     */
    public final Long ruleID() {
        return ruleID;
    }

    /**
     * <p>
     * The units used to measure the interval and retentionDuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #units} will return
     * {@link PITPolicyRuleUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitsAsString}.
     * </p>
     * 
     * @return The units used to measure the interval and retentionDuration.
     * @see PITPolicyRuleUnits
     */
    public final PITPolicyRuleUnits units() {
        return PITPolicyRuleUnits.fromValue(units);
    }

    /**
     * <p>
     * The units used to measure the interval and retentionDuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #units} will return
     * {@link PITPolicyRuleUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitsAsString}.
     * </p>
     * 
     * @return The units used to measure the interval and retentionDuration.
     * @see PITPolicyRuleUnits
     */
    public final String unitsAsString() {
        return units;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(retentionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(ruleID());
        hashCode = 31 * hashCode + Objects.hashCode(unitsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PITPolicyRule)) {
            return false;
        }
        PITPolicyRule other = (PITPolicyRule) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(interval(), other.interval())
                && Objects.equals(retentionDuration(), other.retentionDuration()) && Objects.equals(ruleID(), other.ruleID())
                && Objects.equals(unitsAsString(), other.unitsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PITPolicyRule").add("Enabled", enabled()).add("Interval", interval())
                .add("RetentionDuration", retentionDuration()).add("RuleID", ruleID()).add("Units", unitsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "retentionDuration":
            return Optional.ofNullable(clazz.cast(retentionDuration()));
        case "ruleID":
            return Optional.ofNullable(clazz.cast(ruleID()));
        case "units":
            return Optional.ofNullable(clazz.cast(unitsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("interval", INTERVAL_FIELD);
        map.put("retentionDuration", RETENTION_DURATION_FIELD);
        map.put("ruleID", RULE_ID_FIELD);
        map.put("units", UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PITPolicyRule, T> g) {
        return obj -> g.apply((PITPolicyRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PITPolicyRule> {
        /**
         * <p>
         * Whether this rule is enabled or not.
         * </p>
         * 
         * @param enabled
         *        Whether this rule is enabled or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * How often, in the chosen units, a snapshot should be taken.
         * </p>
         * 
         * @param interval
         *        How often, in the chosen units, a snapshot should be taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The duration to retain a snapshot for, in the chosen units.
         * </p>
         * 
         * @param retentionDuration
         *        The duration to retain a snapshot for, in the chosen units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionDuration(Integer retentionDuration);

        /**
         * <p>
         * The ID of the rule.
         * </p>
         * 
         * @param ruleID
         *        The ID of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleID(Long ruleID);

        /**
         * <p>
         * The units used to measure the interval and retentionDuration.
         * </p>
         * 
         * @param units
         *        The units used to measure the interval and retentionDuration.
         * @see PITPolicyRuleUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PITPolicyRuleUnits
         */
        Builder units(String units);

        /**
         * <p>
         * The units used to measure the interval and retentionDuration.
         * </p>
         * 
         * @param units
         *        The units used to measure the interval and retentionDuration.
         * @see PITPolicyRuleUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PITPolicyRuleUnits
         */
        Builder units(PITPolicyRuleUnits units);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Integer interval;

        private Integer retentionDuration;

        private Long ruleID;

        private String units;

        private BuilderImpl() {
        }

        private BuilderImpl(PITPolicyRule model) {
            enabled(model.enabled);
            interval(model.interval);
            retentionDuration(model.retentionDuration);
            ruleID(model.ruleID);
            units(model.units);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getInterval() {
            return interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final Integer getRetentionDuration() {
            return retentionDuration;
        }

        public final void setRetentionDuration(Integer retentionDuration) {
            this.retentionDuration = retentionDuration;
        }

        @Override
        public final Builder retentionDuration(Integer retentionDuration) {
            this.retentionDuration = retentionDuration;
            return this;
        }

        public final Long getRuleID() {
            return ruleID;
        }

        public final void setRuleID(Long ruleID) {
            this.ruleID = ruleID;
        }

        @Override
        public final Builder ruleID(Long ruleID) {
            this.ruleID = ruleID;
            return this;
        }

        public final String getUnits() {
            return units;
        }

        public final void setUnits(String units) {
            this.units = units;
        }

        @Override
        public final Builder units(String units) {
            this.units = units;
            return this;
        }

        @Override
        public final Builder units(PITPolicyRuleUnits units) {
            this.units(units == null ? null : units.toString());
            return this;
        }

        @Override
        public PITPolicyRule build() {
            return new PITPolicyRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
