/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a server participating in an asynchronous Job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipatingServer implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipatingServer.Builder, ParticipatingServer> {
    private static final SdkField<LaunchActionsStatus> LAUNCH_ACTIONS_STATUS_FIELD = SdkField
            .<LaunchActionsStatus> builder(MarshallingType.SDK_POJO).memberName("launchActionsStatus")
            .getter(getter(ParticipatingServer::launchActionsStatus)).setter(setter(Builder::launchActionsStatus))
            .constructor(LaunchActionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchActionsStatus").build())
            .build();

    private static final SdkField<String> LAUNCH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchStatus").getter(getter(ParticipatingServer::launchStatusAsString))
            .setter(setter(Builder::launchStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatus").build()).build();

    private static final SdkField<String> RECOVERY_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryInstanceID").getter(getter(ParticipatingServer::recoveryInstanceID))
            .setter(setter(Builder::recoveryInstanceID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceID").build())
            .build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(ParticipatingServer::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_ACTIONS_STATUS_FIELD,
            LAUNCH_STATUS_FIELD, RECOVERY_INSTANCE_ID_FIELD, SOURCE_SERVER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LaunchActionsStatus launchActionsStatus;

    private final String launchStatus;

    private final String recoveryInstanceID;

    private final String sourceServerID;

    private ParticipatingServer(BuilderImpl builder) {
        this.launchActionsStatus = builder.launchActionsStatus;
        this.launchStatus = builder.launchStatus;
        this.recoveryInstanceID = builder.recoveryInstanceID;
        this.sourceServerID = builder.sourceServerID;
    }

    /**
     * <p>
     * The post-launch action runs of a participating server.
     * </p>
     * 
     * @return The post-launch action runs of a participating server.
     */
    public final LaunchActionsStatus launchActionsStatus() {
        return launchActionsStatus;
    }

    /**
     * <p>
     * The launch status of a participating server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchStatus} will
     * return {@link LaunchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchStatusAsString}.
     * </p>
     * 
     * @return The launch status of a participating server.
     * @see LaunchStatus
     */
    public final LaunchStatus launchStatus() {
        return LaunchStatus.fromValue(launchStatus);
    }

    /**
     * <p>
     * The launch status of a participating server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchStatus} will
     * return {@link LaunchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchStatusAsString}.
     * </p>
     * 
     * @return The launch status of a participating server.
     * @see LaunchStatus
     */
    public final String launchStatusAsString() {
        return launchStatus;
    }

    /**
     * <p>
     * The Recovery Instance ID of a participating server.
     * </p>
     * 
     * @return The Recovery Instance ID of a participating server.
     */
    public final String recoveryInstanceID() {
        return recoveryInstanceID;
    }

    /**
     * <p>
     * The Source Server ID of a participating server.
     * </p>
     * 
     * @return The Source Server ID of a participating server.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchActionsStatus());
        hashCode = 31 * hashCode + Objects.hashCode(launchStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryInstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingServer)) {
            return false;
        }
        ParticipatingServer other = (ParticipatingServer) obj;
        return Objects.equals(launchActionsStatus(), other.launchActionsStatus())
                && Objects.equals(launchStatusAsString(), other.launchStatusAsString())
                && Objects.equals(recoveryInstanceID(), other.recoveryInstanceID())
                && Objects.equals(sourceServerID(), other.sourceServerID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipatingServer").add("LaunchActionsStatus", launchActionsStatus())
                .add("LaunchStatus", launchStatusAsString()).add("RecoveryInstanceID", recoveryInstanceID())
                .add("SourceServerID", sourceServerID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchActionsStatus":
            return Optional.ofNullable(clazz.cast(launchActionsStatus()));
        case "launchStatus":
            return Optional.ofNullable(clazz.cast(launchStatusAsString()));
        case "recoveryInstanceID":
            return Optional.ofNullable(clazz.cast(recoveryInstanceID()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("launchActionsStatus", LAUNCH_ACTIONS_STATUS_FIELD);
        map.put("launchStatus", LAUNCH_STATUS_FIELD);
        map.put("recoveryInstanceID", RECOVERY_INSTANCE_ID_FIELD);
        map.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipatingServer, T> g) {
        return obj -> g.apply((ParticipatingServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipatingServer> {
        /**
         * <p>
         * The post-launch action runs of a participating server.
         * </p>
         * 
         * @param launchActionsStatus
         *        The post-launch action runs of a participating server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchActionsStatus(LaunchActionsStatus launchActionsStatus);

        /**
         * <p>
         * The post-launch action runs of a participating server.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchActionsStatus.Builder} avoiding the
         * need to create one manually via {@link LaunchActionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchActionsStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #launchActionsStatus(LaunchActionsStatus)}.
         * 
         * @param launchActionsStatus
         *        a consumer that will call methods on {@link LaunchActionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchActionsStatus(LaunchActionsStatus)
         */
        default Builder launchActionsStatus(Consumer<LaunchActionsStatus.Builder> launchActionsStatus) {
            return launchActionsStatus(LaunchActionsStatus.builder().applyMutation(launchActionsStatus).build());
        }

        /**
         * <p>
         * The launch status of a participating server.
         * </p>
         * 
         * @param launchStatus
         *        The launch status of a participating server.
         * @see LaunchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchStatus
         */
        Builder launchStatus(String launchStatus);

        /**
         * <p>
         * The launch status of a participating server.
         * </p>
         * 
         * @param launchStatus
         *        The launch status of a participating server.
         * @see LaunchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchStatus
         */
        Builder launchStatus(LaunchStatus launchStatus);

        /**
         * <p>
         * The Recovery Instance ID of a participating server.
         * </p>
         * 
         * @param recoveryInstanceID
         *        The Recovery Instance ID of a participating server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryInstanceID(String recoveryInstanceID);

        /**
         * <p>
         * The Source Server ID of a participating server.
         * </p>
         * 
         * @param sourceServerID
         *        The Source Server ID of a participating server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);
    }

    static final class BuilderImpl implements Builder {
        private LaunchActionsStatus launchActionsStatus;

        private String launchStatus;

        private String recoveryInstanceID;

        private String sourceServerID;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipatingServer model) {
            launchActionsStatus(model.launchActionsStatus);
            launchStatus(model.launchStatus);
            recoveryInstanceID(model.recoveryInstanceID);
            sourceServerID(model.sourceServerID);
        }

        public final LaunchActionsStatus.Builder getLaunchActionsStatus() {
            return launchActionsStatus != null ? launchActionsStatus.toBuilder() : null;
        }

        public final void setLaunchActionsStatus(LaunchActionsStatus.BuilderImpl launchActionsStatus) {
            this.launchActionsStatus = launchActionsStatus != null ? launchActionsStatus.build() : null;
        }

        @Override
        public final Builder launchActionsStatus(LaunchActionsStatus launchActionsStatus) {
            this.launchActionsStatus = launchActionsStatus;
            return this;
        }

        public final String getLaunchStatus() {
            return launchStatus;
        }

        public final void setLaunchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
        }

        @Override
        public final Builder launchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
            return this;
        }

        @Override
        public final Builder launchStatus(LaunchStatus launchStatus) {
            this.launchStatus(launchStatus == null ? null : launchStatus.toString());
            return this;
        }

        public final String getRecoveryInstanceID() {
            return recoveryInstanceID;
        }

        public final void setRecoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
        }

        @Override
        public final Builder recoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        @Override
        public ParticipatingServer build() {
            return new ParticipatingServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
