/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error in data replication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryInstanceDataReplicationError implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryInstanceDataReplicationError.Builder, RecoveryInstanceDataReplicationError> {
    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(RecoveryInstanceDataReplicationError::errorAsString)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> RAW_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rawError").getter(getter(RecoveryInstanceDataReplicationError::rawError))
            .setter(setter(Builder::rawError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawError").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, RAW_ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String error;

    private final String rawError;

    private RecoveryInstanceDataReplicationError(BuilderImpl builder) {
        this.error = builder.error;
        this.rawError = builder.rawError;
    }

    /**
     * <p>
     * Error in data replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #error} will return
     * {@link FailbackReplicationError#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorAsString}.
     * </p>
     * 
     * @return Error in data replication.
     * @see FailbackReplicationError
     */
    public final FailbackReplicationError error() {
        return FailbackReplicationError.fromValue(error);
    }

    /**
     * <p>
     * Error in data replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #error} will return
     * {@link FailbackReplicationError#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorAsString}.
     * </p>
     * 
     * @return Error in data replication.
     * @see FailbackReplicationError
     */
    public final String errorAsString() {
        return error;
    }

    /**
     * <p>
     * Error in data replication.
     * </p>
     * 
     * @return Error in data replication.
     */
    public final String rawError() {
        return rawError;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rawError());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryInstanceDataReplicationError)) {
            return false;
        }
        RecoveryInstanceDataReplicationError other = (RecoveryInstanceDataReplicationError) obj;
        return Objects.equals(errorAsString(), other.errorAsString()) && Objects.equals(rawError(), other.rawError());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryInstanceDataReplicationError").add("Error", errorAsString()).add("RawError", rawError())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "error":
            return Optional.ofNullable(clazz.cast(errorAsString()));
        case "rawError":
            return Optional.ofNullable(clazz.cast(rawError()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("error", ERROR_FIELD);
        map.put("rawError", RAW_ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecoveryInstanceDataReplicationError, T> g) {
        return obj -> g.apply((RecoveryInstanceDataReplicationError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryInstanceDataReplicationError> {
        /**
         * <p>
         * Error in data replication.
         * </p>
         * 
         * @param error
         *        Error in data replication.
         * @see FailbackReplicationError
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailbackReplicationError
         */
        Builder error(String error);

        /**
         * <p>
         * Error in data replication.
         * </p>
         * 
         * @param error
         *        Error in data replication.
         * @see FailbackReplicationError
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailbackReplicationError
         */
        Builder error(FailbackReplicationError error);

        /**
         * <p>
         * Error in data replication.
         * </p>
         * 
         * @param rawError
         *        Error in data replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawError(String rawError);
    }

    static final class BuilderImpl implements Builder {
        private String error;

        private String rawError;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryInstanceDataReplicationError model) {
            error(model.error);
            rawError(model.rawError);
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public final Builder error(FailbackReplicationError error) {
            this.error(error == null ? null : error.toString());
            return this;
        }

        public final String getRawError() {
            return rawError;
        }

        public final void setRawError(String rawError) {
            this.rawError = rawError;
        }

        @Override
        public final Builder rawError(String rawError) {
            this.rawError = rawError;
            return this;
        }

        @Override
        public RecoveryInstanceDataReplicationError build() {
            return new RecoveryInstanceDataReplicationError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
