/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the Source Network recovery Lifecycle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryLifeCycle implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryLifeCycle.Builder, RecoveryLifeCycle> {
    private static final SdkField<Instant> API_CALL_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("apiCallDateTime")
            .getter(getter(RecoveryLifeCycle::apiCallDateTime))
            .setter(setter(Builder::apiCallDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiCallDateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobID")
            .getter(getter(RecoveryLifeCycle::jobID)).setter(setter(Builder::jobID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()).build();

    private static final SdkField<String> LAST_RECOVERY_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastRecoveryResult").getter(getter(RecoveryLifeCycle::lastRecoveryResultAsString))
            .setter(setter(Builder::lastRecoveryResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRecoveryResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_CALL_DATE_TIME_FIELD,
            JOB_ID_FIELD, LAST_RECOVERY_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant apiCallDateTime;

    private final String jobID;

    private final String lastRecoveryResult;

    private RecoveryLifeCycle(BuilderImpl builder) {
        this.apiCallDateTime = builder.apiCallDateTime;
        this.jobID = builder.jobID;
        this.lastRecoveryResult = builder.lastRecoveryResult;
    }

    /**
     * <p>
     * The date and time the last Source Network recovery was initiated.
     * </p>
     * 
     * @return The date and time the last Source Network recovery was initiated.
     */
    public final Instant apiCallDateTime() {
        return apiCallDateTime;
    }

    /**
     * <p>
     * The ID of the Job that was used to last recover the Source Network.
     * </p>
     * 
     * @return The ID of the Job that was used to last recover the Source Network.
     */
    public final String jobID() {
        return jobID;
    }

    /**
     * <p>
     * The status of the last recovery status of this Source Network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastRecoveryResult} will return {@link RecoveryResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #lastRecoveryResultAsString}.
     * </p>
     * 
     * @return The status of the last recovery status of this Source Network.
     * @see RecoveryResult
     */
    public final RecoveryResult lastRecoveryResult() {
        return RecoveryResult.fromValue(lastRecoveryResult);
    }

    /**
     * <p>
     * The status of the last recovery status of this Source Network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastRecoveryResult} will return {@link RecoveryResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #lastRecoveryResultAsString}.
     * </p>
     * 
     * @return The status of the last recovery status of this Source Network.
     * @see RecoveryResult
     */
    public final String lastRecoveryResultAsString() {
        return lastRecoveryResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiCallDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobID());
        hashCode = 31 * hashCode + Objects.hashCode(lastRecoveryResultAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryLifeCycle)) {
            return false;
        }
        RecoveryLifeCycle other = (RecoveryLifeCycle) obj;
        return Objects.equals(apiCallDateTime(), other.apiCallDateTime()) && Objects.equals(jobID(), other.jobID())
                && Objects.equals(lastRecoveryResultAsString(), other.lastRecoveryResultAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryLifeCycle").add("ApiCallDateTime", apiCallDateTime()).add("JobID", jobID())
                .add("LastRecoveryResult", lastRecoveryResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiCallDateTime":
            return Optional.ofNullable(clazz.cast(apiCallDateTime()));
        case "jobID":
            return Optional.ofNullable(clazz.cast(jobID()));
        case "lastRecoveryResult":
            return Optional.ofNullable(clazz.cast(lastRecoveryResultAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiCallDateTime", API_CALL_DATE_TIME_FIELD);
        map.put("jobID", JOB_ID_FIELD);
        map.put("lastRecoveryResult", LAST_RECOVERY_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecoveryLifeCycle, T> g) {
        return obj -> g.apply((RecoveryLifeCycle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryLifeCycle> {
        /**
         * <p>
         * The date and time the last Source Network recovery was initiated.
         * </p>
         * 
         * @param apiCallDateTime
         *        The date and time the last Source Network recovery was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiCallDateTime(Instant apiCallDateTime);

        /**
         * <p>
         * The ID of the Job that was used to last recover the Source Network.
         * </p>
         * 
         * @param jobID
         *        The ID of the Job that was used to last recover the Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobID(String jobID);

        /**
         * <p>
         * The status of the last recovery status of this Source Network.
         * </p>
         * 
         * @param lastRecoveryResult
         *        The status of the last recovery status of this Source Network.
         * @see RecoveryResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryResult
         */
        Builder lastRecoveryResult(String lastRecoveryResult);

        /**
         * <p>
         * The status of the last recovery status of this Source Network.
         * </p>
         * 
         * @param lastRecoveryResult
         *        The status of the last recovery status of this Source Network.
         * @see RecoveryResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryResult
         */
        Builder lastRecoveryResult(RecoveryResult lastRecoveryResult);
    }

    static final class BuilderImpl implements Builder {
        private Instant apiCallDateTime;

        private String jobID;

        private String lastRecoveryResult;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryLifeCycle model) {
            apiCallDateTime(model.apiCallDateTime);
            jobID(model.jobID);
            lastRecoveryResult(model.lastRecoveryResult);
        }

        public final Instant getApiCallDateTime() {
            return apiCallDateTime;
        }

        public final void setApiCallDateTime(Instant apiCallDateTime) {
            this.apiCallDateTime = apiCallDateTime;
        }

        @Override
        public final Builder apiCallDateTime(Instant apiCallDateTime) {
            this.apiCallDateTime = apiCallDateTime;
            return this;
        }

        public final String getJobID() {
            return jobID;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @Override
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        public final String getLastRecoveryResult() {
            return lastRecoveryResult;
        }

        public final void setLastRecoveryResult(String lastRecoveryResult) {
            this.lastRecoveryResult = lastRecoveryResult;
        }

        @Override
        public final Builder lastRecoveryResult(String lastRecoveryResult) {
            this.lastRecoveryResult = lastRecoveryResult;
            return this;
        }

        @Override
        public final Builder lastRecoveryResult(RecoveryResult lastRecoveryResult) {
            this.lastRecoveryResult(lastRecoveryResult == null ? null : lastRecoveryResult.toString());
            return this;
        }

        @Override
        public RecoveryLifeCycle build() {
            return new RecoveryLifeCycle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
