/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFailbackReplicationConfigurationRequest extends DrsRequest implements
        ToCopyableBuilder<UpdateFailbackReplicationConfigurationRequest.Builder, UpdateFailbackReplicationConfigurationRequest> {
    private static final SdkField<Long> BANDWIDTH_THROTTLING_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("bandwidthThrottling").getter(getter(UpdateFailbackReplicationConfigurationRequest::bandwidthThrottling))
            .setter(setter(Builder::bandwidthThrottling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthThrottling").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateFailbackReplicationConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RECOVERY_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryInstanceID").getter(getter(UpdateFailbackReplicationConfigurationRequest::recoveryInstanceID))
            .setter(setter(Builder::recoveryInstanceID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceID").build())
            .build();

    private static final SdkField<Boolean> USE_PRIVATE_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("usePrivateIP").getter(getter(UpdateFailbackReplicationConfigurationRequest::usePrivateIP))
            .setter(setter(Builder::usePrivateIP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usePrivateIP").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BANDWIDTH_THROTTLING_FIELD,
            NAME_FIELD, RECOVERY_INSTANCE_ID_FIELD, USE_PRIVATE_IP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Long bandwidthThrottling;

    private final String name;

    private final String recoveryInstanceID;

    private final Boolean usePrivateIP;

    private UpdateFailbackReplicationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.bandwidthThrottling = builder.bandwidthThrottling;
        this.name = builder.name;
        this.recoveryInstanceID = builder.recoveryInstanceID;
        this.usePrivateIP = builder.usePrivateIP;
    }

    /**
     * <p>
     * Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.
     * </p>
     * 
     * @return Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.
     */
    public final Long bandwidthThrottling() {
        return bandwidthThrottling;
    }

    /**
     * <p>
     * The name of the Failback Replication Configuration.
     * </p>
     * 
     * @return The name of the Failback Replication Configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the Recovery Instance.
     * </p>
     * 
     * @return The ID of the Recovery Instance.
     */
    public final String recoveryInstanceID() {
        return recoveryInstanceID;
    }

    /**
     * <p>
     * Whether to use Private IP for the failback replication of the Recovery Instance.
     * </p>
     * 
     * @return Whether to use Private IP for the failback replication of the Recovery Instance.
     */
    public final Boolean usePrivateIP() {
        return usePrivateIP;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bandwidthThrottling());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryInstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(usePrivateIP());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFailbackReplicationConfigurationRequest)) {
            return false;
        }
        UpdateFailbackReplicationConfigurationRequest other = (UpdateFailbackReplicationConfigurationRequest) obj;
        return Objects.equals(bandwidthThrottling(), other.bandwidthThrottling()) && Objects.equals(name(), other.name())
                && Objects.equals(recoveryInstanceID(), other.recoveryInstanceID())
                && Objects.equals(usePrivateIP(), other.usePrivateIP());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFailbackReplicationConfigurationRequest")
                .add("BandwidthThrottling", bandwidthThrottling()).add("Name", name())
                .add("RecoveryInstanceID", recoveryInstanceID()).add("UsePrivateIP", usePrivateIP()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bandwidthThrottling":
            return Optional.ofNullable(clazz.cast(bandwidthThrottling()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "recoveryInstanceID":
            return Optional.ofNullable(clazz.cast(recoveryInstanceID()));
        case "usePrivateIP":
            return Optional.ofNullable(clazz.cast(usePrivateIP()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bandwidthThrottling", BANDWIDTH_THROTTLING_FIELD);
        map.put("name", NAME_FIELD);
        map.put("recoveryInstanceID", RECOVERY_INSTANCE_ID_FIELD);
        map.put("usePrivateIP", USE_PRIVATE_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFailbackReplicationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateFailbackReplicationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFailbackReplicationConfigurationRequest> {
        /**
         * <p>
         * Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.
         * </p>
         * 
         * @param bandwidthThrottling
         *        Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthThrottling(Long bandwidthThrottling);

        /**
         * <p>
         * The name of the Failback Replication Configuration.
         * </p>
         * 
         * @param name
         *        The name of the Failback Replication Configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the Recovery Instance.
         * </p>
         * 
         * @param recoveryInstanceID
         *        The ID of the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryInstanceID(String recoveryInstanceID);

        /**
         * <p>
         * Whether to use Private IP for the failback replication of the Recovery Instance.
         * </p>
         * 
         * @param usePrivateIP
         *        Whether to use Private IP for the failback replication of the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usePrivateIP(Boolean usePrivateIP);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DrsRequest.BuilderImpl implements Builder {
        private Long bandwidthThrottling;

        private String name;

        private String recoveryInstanceID;

        private Boolean usePrivateIP;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFailbackReplicationConfigurationRequest model) {
            super(model);
            bandwidthThrottling(model.bandwidthThrottling);
            name(model.name);
            recoveryInstanceID(model.recoveryInstanceID);
            usePrivateIP(model.usePrivateIP);
        }

        public final Long getBandwidthThrottling() {
            return bandwidthThrottling;
        }

        public final void setBandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
        }

        @Override
        public final Builder bandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecoveryInstanceID() {
            return recoveryInstanceID;
        }

        public final void setRecoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
        }

        @Override
        public final Builder recoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
            return this;
        }

        public final Boolean getUsePrivateIP() {
            return usePrivateIP;
        }

        public final void setUsePrivateIP(Boolean usePrivateIP) {
            this.usePrivateIP = usePrivateIP;
        }

        @Override
        public final Builder usePrivateIP(Boolean usePrivateIP) {
            this.usePrivateIP = usePrivateIP;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFailbackReplicationConfigurationRequest build() {
            return new UpdateFailbackReplicationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
