/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMultiRegionClustersResponse extends DsqlResponse implements
        ToCopyableBuilder<CreateMultiRegionClustersResponse.Builder, CreateMultiRegionClustersResponse> {
    private static final SdkField<List<String>> LINKED_CLUSTER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("linkedClusterArns")
            .getter(getter(CreateMultiRegionClustersResponse::linkedClusterArns))
            .setter(setter(Builder::linkedClusterArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedClusterArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_CLUSTER_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> linkedClusterArns;

    private CreateMultiRegionClustersResponse(BuilderImpl builder) {
        super(builder);
        this.linkedClusterArns = builder.linkedClusterArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkedClusterArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLinkedClusterArns() {
        return linkedClusterArns != null && !(linkedClusterArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the ARNs of all linked clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkedClusterArns} method.
     * </p>
     * 
     * @return An array that contains the ARNs of all linked clusters.
     */
    public final List<String> linkedClusterArns() {
        return linkedClusterArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkedClusterArns() ? linkedClusterArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiRegionClustersResponse)) {
            return false;
        }
        CreateMultiRegionClustersResponse other = (CreateMultiRegionClustersResponse) obj;
        return hasLinkedClusterArns() == other.hasLinkedClusterArns()
                && Objects.equals(linkedClusterArns(), other.linkedClusterArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMultiRegionClustersResponse")
                .add("LinkedClusterArns", hasLinkedClusterArns() ? linkedClusterArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "linkedClusterArns":
            return Optional.ofNullable(clazz.cast(linkedClusterArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("linkedClusterArns", LINKED_CLUSTER_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiRegionClustersResponse, T> g) {
        return obj -> g.apply((CreateMultiRegionClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DsqlResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateMultiRegionClustersResponse> {
        /**
         * <p>
         * An array that contains the ARNs of all linked clusters.
         * </p>
         * 
         * @param linkedClusterArns
         *        An array that contains the ARNs of all linked clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedClusterArns(Collection<String> linkedClusterArns);

        /**
         * <p>
         * An array that contains the ARNs of all linked clusters.
         * </p>
         * 
         * @param linkedClusterArns
         *        An array that contains the ARNs of all linked clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedClusterArns(String... linkedClusterArns);
    }

    static final class BuilderImpl extends DsqlResponse.BuilderImpl implements Builder {
        private List<String> linkedClusterArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiRegionClustersResponse model) {
            super(model);
            linkedClusterArns(model.linkedClusterArns);
        }

        public final Collection<String> getLinkedClusterArns() {
            if (linkedClusterArns instanceof SdkAutoConstructList) {
                return null;
            }
            return linkedClusterArns;
        }

        public final void setLinkedClusterArns(Collection<String> linkedClusterArns) {
            this.linkedClusterArns = ClusterArnListCopier.copy(linkedClusterArns);
        }

        @Override
        public final Builder linkedClusterArns(Collection<String> linkedClusterArns) {
            this.linkedClusterArns = ClusterArnListCopier.copy(linkedClusterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedClusterArns(String... linkedClusterArns) {
            linkedClusterArns(Arrays.asList(linkedClusterArns));
            return this;
        }

        @Override
        public CreateMultiRegionClustersResponse build() {
            return new CreateMultiRegionClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
