/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql;

import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4PresignerParams;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dsql.DsqlUtilities;
import software.amazon.awssdk.services.dsql.model.GenerateAuthTokenRequest;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.StringUtils;

@Immutable
@SdkInternalApi
public final class DefaultDsqlUtilities
implements DsqlUtilities {
    private static final Logger log = Logger.loggerFor(DsqlUtilities.class);
    private final Aws4Signer signer = Aws4Signer.create();
    private final Region region;
    private final IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider;
    private final Clock clock;

    public DefaultDsqlUtilities(DefaultBuilder builder) {
        this(builder, Clock.systemUTC());
    }

    @SdkTestInternalApi
    public DefaultDsqlUtilities(DefaultBuilder builder, Clock clock) {
        this.credentialsProvider = builder.credentialsProvider;
        this.region = builder.region;
        this.clock = clock;
    }

    @SdkInternalApi
    static DsqlUtilities create(SdkClientConfiguration clientConfiguration) {
        return new DefaultBuilder().clientConfiguration(clientConfiguration).build();
    }

    @Override
    public String generateDbConnectAuthToken(GenerateAuthTokenRequest request) {
        return this.generateAuthToken(request, false);
    }

    @Override
    public String generateDbConnectAdminAuthToken(GenerateAuthTokenRequest request) {
        return this.generateAuthToken(request, true);
    }

    private String generateAuthToken(GenerateAuthTokenRequest request, boolean isAdmin) {
        String action = isAdmin ? "DbConnectAdmin" : "DbConnect";
        SdkHttpFullRequest httpRequest = SdkHttpFullRequest.builder().method(SdkHttpMethod.GET).protocol("https").host(request.hostname()).encodedPath("/").putRawQueryParameter("Action", action).build();
        Instant expirationTime = Instant.now(this.clock).plus(request.expiresIn());
        Aws4PresignerParams presignRequest = ((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)((Aws4PresignerParams.Builder)Aws4PresignerParams.builder().signingClockOverride(this.clock)).expirationTime(expirationTime).awsCredentials(this.resolveCredentials(request))).signingName("dsql")).signingRegion(this.resolveRegion(request))).build();
        SdkHttpFullRequest fullRequest = this.signer.presign(httpRequest, presignRequest);
        String signedUrl = fullRequest.getUri().toString();
        log.debug(() -> "Generated DSQL authentication token with expiration of " + expirationTime);
        return StringUtils.replacePrefixIgnoreCase((String)signedUrl, (String)"https://", (String)"");
    }

    private Region resolveRegion(GenerateAuthTokenRequest request) {
        if (request.region() != null) {
            return request.region();
        }
        if (this.region != null) {
            return this.region;
        }
        throw new IllegalArgumentException("Region must be provided in GenerateAuthTokenRequest or DsqlUtilities");
    }

    private AwsCredentials resolveCredentials(GenerateAuthTokenRequest request) {
        if (request.credentialsIdentityProvider() != null) {
            return CredentialUtils.toCredentials((AwsCredentialsIdentity)((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)request.credentialsIdentityProvider().resolveIdentity())));
        }
        if (this.credentialsProvider != null) {
            return CredentialUtils.toCredentials((AwsCredentialsIdentity)((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)this.credentialsProvider.resolveIdentity())));
        }
        throw new IllegalArgumentException("CredentialsProvider must be provided in GenerateAuthTokenRequest or DsqlUtilities");
    }

    @SdkInternalApi
    public static final class DefaultBuilder
    implements DsqlUtilities.Builder {
        private Region region;
        private IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider;

        DsqlUtilities.Builder clientConfiguration(SdkClientConfiguration clientConfiguration) {
            this.credentialsProvider = (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER);
            this.region = (Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION);
            return this;
        }

        @Override
        public DsqlUtilities.Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public DsqlUtilities.Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public DsqlUtilities build() {
            return new DefaultDsqlUtilities(this);
        }
    }
}

